/***************************************************************************
                          mytestview.h  -  description
                             -------------------
    begin                : Don Mr  4 17:29:05 CET 2004
    copyright            : (C) 2004 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYTESTVIEW_H
#define MYTESTVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qscrollview.h>

#include <X11/Xlib.h>

class MyTestDoc;

/** The MyTestView class provides the view widget for the document instance connected to it and is displayed
 * as a MDI child window in the main view area of the MyTestApp class instance. The MyTestApp class also has an eventFilter()
 * method that gets installed on every MyTestView instance to control events of the type QEvent::Close.	
 * The document connected to the view instance keeps a list of all view that represent the document contents as there
 * can be more than one view. Views get created in MyTestApp::createClient() and automatically added to the list of views.
 * The MyTestView class inherits QWidget as a base. Another possible inheritance besides specialized widgets could be
 * QMainWindow so that you can easily set up the main area of your view by setting another view
 * as main widget (QMainWindow::setMainWidget() ).
 * NOTE: The close event always has to be empty (DON`T CALL QWidget::closeEvent(e) in closeEvent()) because the installed
 * event filter can only manage a forward implementation. If the QCloseEvent is received by the MyTestView, the overwritten
 * event handler has to do nothing as the eventFilter has set accept() or ignore() already. If QWidget::closeEvent() is called
 * again, the default event handler will accept the close event and the window gets destroyed even if the installed eventFilter
 * has set the event to be ignored.	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 1.3 code generation
 */
class MyTestView : public QScrollView
{
  Q_OBJECT

  friend MyTestDoc;

  public:
    /** Constructor for the view
    	* @param pDoc  your document instance that the view represents. Create a document before calling the constructor
    	* or connect an already existing document to a new MDI child widget.*/
    MyTestView(MyTestDoc* pDoc, QWidget* parent, const char *name, int wflags);
    /** Destructor for the main view */
    ~MyTestView();
		/** returns a pointer to the document connected to the view*/
    MyTestDoc *getDocument() const;
    /** gets called to redraw the document contents if it has been modified */
		void update(MyTestView* pSender = 0, int hint = 0);
    /** contains the implementation for printing functionality and gets called by MyTestApp::slotFilePrint() */
    void print(QPrinter *pPrinter);
		
  protected:
    /** overwritten QWidget::closeEvent() to catch closing views. Does nothing, as the closeEvents for
    * MyTestView's are processed by MyTestApp::eventFilter(), so this overwitten closeEvent is necessary
    * and has to be empty. Don't overwrite this method !
    */
    virtual void closeEvent(QCloseEvent* e);

    virtual void viewportPaintEvent(QPaintEvent *);

    /** The document connected to the view, specified in the constructor */
	  MyTestDoc *doc;
};

#endif // MYTESTVIEW_H
