/***************************************************************************
                          mytestview.cpp  -  description
                             -------------------
    begin                : Don Mr  4 17:29:05 CET 2004
    copyright            : (C) 2004 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qprinter.h>
#include <qpainter.h>
#include <qdir.h>
// include files for KDE

// application specific includes
#include "mytest.h"
#include "mytestview.h"
#include "mytestdoc.h"

MyTestView::MyTestView(MyTestDoc* pDoc, QWidget *parent, const char* name, int wflags)
 : QScrollView(parent, name, wflags)
{
  doc=pDoc;

  viewport()->setBackgroundMode( NoBackground );

  // resize the viewport - this makes the resizeEvent obsolete
  resizeContents(doc->m_sizeDoc.width(), doc->m_sizeDoc.height());
}

MyTestView::~MyTestView()
{
}

MyTestDoc *MyTestView::getDocument() const
{
	return doc;
}

void MyTestView::update(MyTestView* pSender = 0, int hint = 0)
{
	if (pSender != this)
  {
		viewport()->repaint();
    if (hint)
    {
      resizeContents(doc->m_sizeDoc.width(), doc->m_sizeDoc.height());
    }
  }
}

void MyTestView::print(QPrinter *pPrinter)
{
  if (pPrinter->setup(this))
  {
		QPainter p;
		p.begin(pPrinter);
		
		///////////////////////////////
		// TODO: add your printing code here
		///////////////////////////////
		
		p.end();
  }
}

void MyTestView::closeEvent(QCloseEvent* e){

// DO NOT CALL QWidget::closeEvent(e) here !!
// This will accept the closing by QCloseEvent::accept() by default.
// The installed eventFilter() in MyTestApp takes care for closing the widget
// or ignoring the close event
		
}

void MyTestView::viewportPaintEvent( QPaintEvent *e )
{
  extern MyTestApp *myapp;

  QRect rcDisp( e->rect() );
  if (!doc->m_ximage)
  {
    QPainter p( viewport() );
    p.eraseRect(rcDisp);
    return;
  }
  QRect rcDest( 0, 0, contentsWidth(), contentsHeight() );
  if (rcDisp.top() < rcDest.top())
	{
    QPainter p( viewport() );
		int temp = rcDisp.bottom();
    if (temp < rcDest.top())
    {
      p.eraseRect(rcDisp);
      return;
    }
		rcDisp.setBottom( rcDest.top() - 1 );
    p.eraseRect(rcDisp);
		rcDisp.setBottom( temp );
		rcDisp.setTop( rcDest.top() );
	}
	if (rcDisp.bottom() > rcDest.bottom())
	{
    QPainter p( viewport() );
		int temp = rcDisp.top();
    if (temp > rcDest.bottom())
    {
      p.eraseRect(rcDisp);
      return;
    }
		rcDisp.setTop( rcDest.bottom() + 1 );
    p.eraseRect(rcDisp);
		rcDisp.setTop( temp );
		rcDisp.setBottom( rcDest.bottom() );
	}
	if (rcDisp.left() < rcDest.left())
	{
    QPainter p( viewport() );
		int temp = rcDisp.right();
    if (temp < rcDest.left())
    {
      p.eraseRect(rcDisp);
      return;
    }
		rcDisp.setRight( rcDest.left() - 1 );
    p.eraseRect(rcDisp);
		rcDisp.setRight( temp );
    rcDisp.setLeft( rcDest.left() );
	}
	if (rcDisp.right() > rcDest.right())
	{
    QPainter p( viewport() );
    int temp = rcDisp.left();
    if (temp > rcDest.right())
    {
      p.eraseRect(rcDisp);
      return;
    }
		rcDisp.setLeft( rcDest.right() + 1 );
    p.eraseRect(rcDisp);
    rcDisp.setLeft( temp );
    rcDisp.setRight( rcDest.right() );
	}
  Display *my_display = viewport()->x11Display();
  XPutImage(my_display, viewport()->handle(),
            DefaultGC(my_display,viewport()->x11Screen()),
            doc->m_ximage,
            rcDisp.left() + contentsX(),
            rcDisp.top() + contentsY(),
            rcDisp.left(), rcDisp.top(),
            rcDisp.width(), rcDisp.height());

  if (myapp->m_show_blockgrid)
	{
    QPainter p( viewport() );
    p.setPen( darkGray );

		int incr = (doc->m_MCUwidth * doc->m_scale) / doc->m_scale_denom;
		if (incr >= 8)
		{
			int i = rcDest.left() - contentsX();
			do i += incr; while (i < rcDisp.left());
			for (; i <= rcDisp.right(); i += incr)
			{
				p.moveTo(i, rcDisp.top());
				p.lineTo(i, rcDisp.bottom());
			}
		}
		incr = (doc->m_MCUheight * doc->m_scale) / doc->m_scale_denom;
		if (incr >= 8)
		{
			int i = rcDest.top() - contentsY();
			do i += incr; while (i < rcDisp.top());
			for (; i <= rcDisp.bottom(); i += incr)
			{
				p.moveTo(rcDisp.left(), i);
				p.lineTo(rcDisp.right(), i);
			}
		}
	}
}
