/***************************************************************************
                          mytestdoc.h  -  description
                             -------------------
    begin                : Don Mr  4 17:29:05 CET 2004
    copyright            : (C) 2004 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYTESTDOC_H
#define MYTESTDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>

// include files for KDE
#include <kurl.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

// forward declaration of the MyTest classes
class MyTestView;

/**	MyTestDoc provides a document object for a document-view model.
  *
  * The MyTestDoc class provides a document object that can be used in conjunction with the classes
  * MyTestApp and MyTestView to create a document-view model for MDI (Multiple Document Interface)
  * KDE 2 applications based on KApplication and KTMainWindow as main classes and QWorkspace as MDI manager widget.
  * Thereby, the document object is created by the MyTestApp instance (and kept in a document list) and contains
  * the document structure with the according methods for manipulating the document
  * data by MyTestView objects. Also, MyTestDoc contains the methods for serialization of the document data
  * from and to files.
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 1.3 code generation
  */
class MyTestDoc : public QObject
{
  Q_OBJECT

  friend MyTestView;

  public:
    /** Constructor for the fileclass of the application */
    MyTestDoc();
    /** Destructor for the fileclass of the application */
    ~MyTestDoc();

    /** adds a view to the document which represents the document contents. Usually this is your main view. */
    void addView(MyTestView *view);
    /** removes a view from the list of currently connected views */
    void removeView(MyTestView *view);
		/** gets called if a view is removed or added */
		void changedViewList();
    /** returns the first view instance */
		MyTestView* firstView(){ return pViewList->first(); };
		MyTestView* nextView(){ return pViewList->next(); };
		/** returns true, if the requested view is the last view of the document */
    bool isLastView();
    /** This method gets called when the user is about to close a frame window. It checks, if more than one view
    	* is connected to the document (then the frame can be closed), if pFrame is the last view and the document is
    	* modified, the user gets asked if he wants to save the document.
    	*/
		bool canCloseFrame(MyTestView* pFrame);
    /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
    void setModified(bool _m=true){ modified=_m; };
    /** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
    bool isModified(){ return modified; };
    /** deletes the document's contents */
    void deleteContents();
    /** initializes the document generally */
    bool newDocument();
    /** closes the acutal document */
    void closeDocument();
    /** loads the document by filename and format and emits the updateViews() signal */
    bool openDocument(const KURL &url, const char *format=0);
    /** saves the document under filename and format.*/	
    bool saveDocument(const KURL &url, const char *format=0);
    /** returns the KURL of the document */
    const KURL& URL() const;
    /** sets the URL of the document */
	  void setURL(const KURL& url);

    XImage *getXImage() { return m_ximage; }
    int getImageWidth() { return m_image_width; }
    int getImageHeight() { return m_image_height; }
    int getMCUwidth() { return m_MCUwidth; }
    int getMCUheight() { return m_MCUheight; }
    int getTransform() { return m_transform; }
    int getScale() { return m_scale; };
    int getGrayscale() { return m_force_grayscale; };

    void transformDocument( int transform );    
    void rescaleDocument( int scale );
    void toggleGrayscale();

    void ReplaceXimage( XImage *ximage );

  public slots:
    /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
     * As this view normally repaints itself, it is excluded from the paintEvent.
     */
    void updateAllViews(MyTestView *sender = 0, int hint = 0);
	
  private:
    /** the modified flag of the current document */
    bool modified;
    KURL doc_url;
    /** the list of the views currently connected to the document */
    QList<MyTestView> *pViewList;	

    QSize m_sizeDoc;
    XImage *m_ximage;
    int m_image_width;
    int m_image_height;
    int m_MCUwidth;
    int m_MCUheight;
    int m_crop_xoffset;
    int m_crop_yoffset;
    int m_crop_width;
    int m_crop_height;
    int m_transform;
    int m_scale;
    int m_scale_denom;
    int m_force_grayscale;

    void doTransform();
};

#endif // MYTESTDOC_H
