/***************************************************************************
                          mytestdoc.cpp  -  description
                             -------------------
    begin                : Don Mr  4 17:29:05 CET 2004
    copyright            : (C) 2004 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qfileinfo.h>
#include <qwidget.h>

// include files for KDE
#include <klocale.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kio/job.h>
#include <kio/netaccess.h>

// application specific includes
#include "mytest.h"
#include "mytestview.h"
#include "mytestdoc.h"

#include "jpegimage.h"

MyTestDoc::MyTestDoc()
{
  pViewList = new QList<MyTestView>;
  pViewList->setAutoDelete(false);

  m_sizeDoc=QSize(8,8);
  m_ximage = 0;
  m_image_width = 8;
  m_image_height = 8;
  m_MCUwidth = 8;
  m_MCUheight = 8;
  m_crop_xoffset = 0;
  m_crop_yoffset = 0;
  m_crop_width = 0;
  m_crop_height = 0;
  m_transform = 0;
  m_scale = 0;
  m_scale_denom = 8;
  m_force_grayscale = 0;
}

MyTestDoc::~MyTestDoc()
{
  delete pViewList;
}

void MyTestDoc::addView(MyTestView *view)
{
  pViewList->append(view);
	changedViewList();
}

void MyTestDoc::removeView(MyTestView *view)
{
	  pViewList->remove(view);
	  if(!pViewList->isEmpty())
			changedViewList();
		else
			deleteContents();
}

void MyTestDoc::changedViewList(){	
	
	MyTestView *w;
	if((int)pViewList->count() == 1){
  	w=pViewList->first();
  	w->setCaption(URL().fileName());
	}
	else{	
		int i;
    for( i=1,w=pViewList->first(); w!=0; i++, w=pViewList->next())
  		w->setCaption(QString(URL().fileName()+":%1").arg(i));	
	}
}

bool MyTestDoc::isLastView() {
  return ((int) pViewList->count() == 1);
}


void MyTestDoc::updateAllViews(MyTestView *sender = 0, int hint = 0)
{
  if (hint)
    m_sizeDoc=QSize(m_ximage->width,m_ximage->height);

  for(MyTestView *w=pViewList->first(); w!=0; w=pViewList->next())
  {
    w->update(sender, hint);
  }
}

void MyTestDoc::setURL(const KURL &url)
{
  doc_url=url;
}

const KURL& MyTestDoc::URL() const
{
  return doc_url;
}

void MyTestDoc::closeDocument()
{
  MyTestView *w;
  if(!isLastView())
  {
    for(w=pViewList->first(); w!=0; w=pViewList->next())
    {
   	 	if(!w->close())
 				break;
    }
	}
  if(isLastView())
  {
  	w=pViewList->first();
  	w->close();
  }
}

bool MyTestDoc::newDocument()
{
  /////////////////////////////////////////////////
  // TODO: Add your document initialization code here
  /////////////////////////////////////////////////
  modified=false;
  return true;
}

bool MyTestDoc::openDocument(const KURL &url, const char *format /*=0*/)
{
//  QString tmpfile;
//  KIO::NetAccess::download( url, tmpfile );

  /////////////////////////////////////////////////
//	QFile f( tmpfile );
//	if ( !f.open( IO_ReadOnly ) )
//		return false;
  /////////////////////////////////////////////////
  // TODO: Add your document opening code here
  doc_url=url;

  KApplication::setOverrideCursor(waitCursor);
  m_ximage = Read_JPEG_File(URL().path(), m_scale, m_force_grayscale,
                            &m_image_width, &m_image_height,
                            &m_MCUwidth, &m_MCUheight,
                            &m_scale_denom);
  m_scale = m_scale_denom;
  KApplication::restoreOverrideCursor();
  if (!m_ximage)
    return false;
  m_sizeDoc=QSize(m_ximage->width,m_ximage->height);
  /////////////////////////////////////////////////
//	f.close();

  /////////////////////////////////////////////////
//  KIO::NetAccess::removeTempFile( tmpfile );
	
  modified=false;
  return true;
}

bool MyTestDoc::saveDocument(const KURL &url, const char *format /*=0*/)
{
//	QFile f( filename );
//	if ( !f.open( IO_WriteOnly ) )
//		return false;
//
//  /////////////////////////////////////////////////
//  // TODO: Add your document saving code here
//  /////////////////////////////////////////////////
//
//  f.close();
//
//  modified=false;
//	m_filename=filename;
//	m_title=QFileInfo(f).fileName();
  return true;
}

void MyTestDoc::deleteContents()
{
  if (m_ximage)
  {
    XDestroyImage(m_ximage);
    m_ximage = 0;
  }
}

void MyTestDoc::ReplaceXimage( XImage *ximage )
{
  int i = m_MCUwidth;
  m_MCUwidth = m_MCUheight;
  m_MCUheight = i;
  i = m_image_width;
  m_image_width = m_image_height;
  m_image_height = i;

  deleteContents();

  m_ximage = ximage;
}

void MyTestDoc::rescaleDocument( int scale )
{
  if (scale == m_scale)
    return;
  m_scale = scale;

  deleteContents();
  KApplication::setOverrideCursor(waitCursor);
  m_ximage = Read_JPEG_File(URL().path(), m_scale, m_force_grayscale,
                            &m_image_width, &m_image_height,
                            &m_MCUwidth, &m_MCUheight,
                            &m_scale_denom);
  KApplication::restoreOverrideCursor();
  if (!m_ximage)
    return;
  doTransform();
  updateAllViews(0, 1);
}

void MyTestDoc::toggleGrayscale()
{
  m_force_grayscale ^= 1;

  deleteContents();
  KApplication::setOverrideCursor(waitCursor);
  m_ximage = Read_JPEG_File(URL().path(), m_scale, m_force_grayscale,
                            &m_image_width, &m_image_height,
                            &m_MCUwidth, &m_MCUheight,
                            &m_scale_denom);
  KApplication::restoreOverrideCursor();
  if (!m_ximage)
    return;
  doTransform();
  updateAllViews();
}

bool MyTestDoc::canCloseFrame(MyTestView* pFrame)
{
	if(!isLastView())
		return true;
		
	bool ret=false;
  if(isModified())
  {
		KURL saveURL;
  	switch(KMessageBox::warningYesNoCancel(pFrame, i18n("The current file has been modified.\n"
                          "Do you want to save it?"),URL().fileName()))
    {
			case KMessageBox::Yes:
				if(URL().fileName().contains(i18n("Untitled")))
				{
					saveURL=KFileDialog::getSaveURL(QDir::currentDirPath(),
                      i18n("*|All files"), pFrame, i18n("Save as..."));
          if(saveURL.isEmpty())
          	return false;
				}
				else
						saveURL=URL();
					
				if(!saveDocument(saveURL))
				{
 					switch(KMessageBox::warningYesNo(pFrame,i18n("Could not save the current document !\n"
																												"Close anyway ?"), i18n("I/O Error !")))
 					{
 						case KMessageBox::Yes:
 							ret=true;
 						case KMessageBox::No:
 							ret=false;
 					}	        			
				}
				else
					ret=true;
				break;
			case KMessageBox::No:
				ret=true;
				break;
			case KMessageBox::Cancel:
			default:
				ret=false; 				
				break;
		}
	}
	else
		ret=true;
		
	return ret;
}
