/***************************************************************************
                          mytest.cpp  -  description
                             -------------------
    begin                : Don Mr  4 17:29:05 CET 2004
    copyright            : (C) 2004 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for QT
#include <qdir.h>
#include <qprinter.h>
#include <qvbox.h>
#include <qwhatsthis.h>
#include <qtooltip.h>
#include <qtoolbutton.h>
#include <qstring.h>
#include <qradiobutton.h>
#include <qcheckbox.h>

// include files for KDE
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstdaction.h>
#include <kstatusbar.h>
#include <kpopupmenu.h>

// application specific includes
#include "mytest.h"
#include "mytestview.h"
#include "mytestdoc.h"
#include "preferences.h"

MySlider::MySlider(int minValue, int maxValue, int pageStep, int value, Orientation orientation,
  QWidget * parent, const char * name = 0)
  : QSlider(minValue, maxValue, pageStep, value, orientation, parent, name)
{
}

void MySlider::mousePressEvent(QMouseEvent *e)
{
  if (e->button() == LeftButton)
  {
    QSlider::mousePressEvent(e);
  }
  else
  {
    int i = 1;
    while (e->x() > tic[i-1] && i < 16) i++;
    setValue(i);
  }
}


MyTestApp *myapp;

MyTestApp::MyTestApp():KMainWindow(0,"MyTest")
{
  myapp = this;
    
  config = kapp->config();
  printer = new QPrinter;
  untitledCount=0;
  pDocList = new QList<MyTestDoc>();
  pDocList->setAutoDelete(true);

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initStatusBar();
  initView();
  initActions();

  ///////////////////////////////////////////////////////////////////
  // disable actions at startup
  fileSave->setEnabled(false);
  fileSaveAs->setEnabled(false);
  filePrint->setEnabled(false);
  filePrintPreview->setEnabled(false);
  editCut->setEnabled(false);
  editCopy->setEnabled(false);
  editPaste->setEnabled(false);

  m_show_blockgrid = 0;
  m_show_cropmask = 0;
  m_endpoint_snap = 1;
  m_trim = 0;
  m_optimize_coding = 0;
  m_copyoption = 2;
  m_dither = 1;
  m_processing_mode = 0;
  m_copyfiletime = 1;
  m_progressive = 0;
  m_width = 208;
  m_height = 208;
  m_xoffset = -1;
  m_yoffset = -1;
  m_cropspec = 0;
  m_actual = 0;

  m_show_fullscreen = 0;
  m_show_scrollbars = 1;

  readOptions();
}

MyTestApp::~MyTestApp()
{
  delete printer;
}

void MyTestApp::initActions()
{
  fileNew = KStdAction::openNew(this, SLOT(slotFileNew()), actionCollection());
  fileOpen = KStdAction::open(this, SLOT(slotFileOpen()), actionCollection());
  fileOpenRecent = KStdAction::openRecent(this, SLOT(slotFileOpenRecent(const KURL&)), actionCollection());
  fileSave = KStdAction::save(this, SLOT(slotFileSave()), actionCollection());
  fileSaveAs = KStdAction::saveAs(this, SLOT(slotFileSaveAs()), actionCollection());
  fileClose = KStdAction::close(this, SLOT(slotFileClose()), actionCollection());
  filePrint = KStdAction::print(this, SLOT(slotFilePrint()), actionCollection());
  filePrintPreview = KStdAction::printPreview(this, SLOT(slotFilePrintPreview()), actionCollection());
  fileQuit = KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection());
  editCut = KStdAction::cut(this, SLOT(slotEditCut()), actionCollection());
  editCopy = KStdAction::copy(this, SLOT(slotEditCopy()), actionCollection());
  editPaste = KStdAction::paste(this, SLOT(slotEditPaste()), actionCollection());
  viewToolBar = KStdAction::showToolbar(this, SLOT(slotViewToolBar()), actionCollection());
  viewStatusBar = KStdAction::showStatusbar(this, SLOT(slotViewStatusBar()), actionCollection());
  preferences = KStdAction::preferences(this, SLOT(slotPreferences()), actionCollection());

  windowNewWindow = new KAction(i18n("New &Window"), 0, this, SLOT(slotWindowNewWindow()), actionCollection(),"window_new_window");
  windowTile = new KAction(i18n("&Tile"), 0, this, SLOT(slotWindowTile()), actionCollection(),"window_tile");
  windowCascade = new KAction(i18n("&Cascade"), 0, this, SLOT(slotWindowCascade()), actionCollection(),"window_cascade");

  fileNew->setStatusText(i18n("Creates a new document"));
  fileOpen->setStatusText(i18n("Opens an existing document"));
  fileOpenRecent->setStatusText(i18n("Opens a recently used file"));
  fileSave->setStatusText(i18n("Saves the actual document"));
  fileSaveAs->setStatusText(i18n("Saves the actual document as..."));
  fileClose->setStatusText(i18n("Closes the actual document"));
  filePrint->setStatusText(i18n("Prints out the actual document"));
  filePrintPreview->setStatusText(i18n("Print preview the actual document"));
  fileQuit->setStatusText(i18n("Quits the application"));

  editCut->setStatusText(i18n("Cuts the selected section and puts it to the clipboard"));
  editCopy->setStatusText(i18n("Copies the selected section to the clipboard"));
  editPaste->setStatusText(i18n("Pastes the clipboard contents to actual position"));

  viewToolBar->setStatusText(i18n("Enables/disables the toolbar"));
  viewStatusBar->setStatusText(i18n("Enables/disables the statusbar"));

  optionsMenu = new KActionMenu(i18n("&Options"), actionCollection());
  optionsMenu->popupMenu()->insertItem("&Grayscale Reduction", this, SLOT(slotOptionsGrayscale()));
  connect(optionsMenu->popupMenu(), SIGNAL(aboutToShow()), this, SLOT(optionsMenuAboutToShow()));

  transformMenu = new KActionMenu(i18n("&Transform"), actionCollection());
  transformMenu->popupMenu()->setItemParameter( transformMenu->popupMenu()->insertItem("Rotate 90 &Clockwise", this, SLOT( transformMenuActivated( int ) ) ), 5 );
  transformMenu->popupMenu()->setItemParameter( transformMenu->popupMenu()->insertItem("Rotate 90 C&ounterclockwise", this, SLOT( transformMenuActivated( int ) ) ), 7 );
  transformMenu->popupMenu()->setItemParameter( transformMenu->popupMenu()->insertItem("Flip &Horizontal", this, SLOT( transformMenuActivated( int ) ) ), 1 );
  transformMenu->popupMenu()->setItemParameter( transformMenu->popupMenu()->insertItem("Flip &Vertical", this, SLOT( transformMenuActivated( int ) ) ), 2 );
  transformMenu->popupMenu()->setItemParameter( transformMenu->popupMenu()->insertItem("Rotate &180", this, SLOT( transformMenuActivated( int ) ) ), 6 );
  transformMenu->popupMenu()->setItemParameter( transformMenu->popupMenu()->insertItem("&Transpose", this, SLOT( transformMenuActivated( int ) ) ), 3 );
  transformMenu->popupMenu()->setItemParameter( transformMenu->popupMenu()->insertItem("T&ransverse Transpose", this, SLOT( transformMenuActivated( int ) ) ), 4 );
  transformMenu->popupMenu()->setItemParameter( transformMenu->popupMenu()->insertItem("&Original", this, SLOT( transformMenuActivated( int ) ) ), 0 );
  transformMenu->popupMenu()->setItemChecked( transformMenu->popupMenu()->idAt( 7 ), TRUE );
  connect(transformMenu->popupMenu(), SIGNAL(aboutToShow()), this, SLOT(transformMenuAboutToShow()));

  viewMenu = new KActionMenu(i18n("&View"), actionCollection());
  viewMenu->popupMenu()->insertItem("&Block Grid", this, SLOT(slotViewBlockGrid()));
  viewMenu->popupMenu()->insertItem("&Full Screen", this, SLOT(slotViewFullScreen()));
  viewMenu->popupMenu()->insertItem("&Scroll Bars", this, SLOT(slotViewScrollBars()));
  connect(viewMenu->popupMenu(), SIGNAL(aboutToShow()), this, SLOT(viewMenuAboutToShow()));
  
  zoomMenu = new KActionMenu(i18n("&Zoom"), actionCollection());
  zoomMenu->popupMenu()->setItemParameter( zoomMenu->popupMenu()->insertItem("12.5 %", this, SLOT( zoomMenuActivated( int ) ) ), 1 );
  zoomMenu->popupMenu()->setItemParameter( zoomMenu->popupMenu()->insertItem("25 %", this, SLOT( zoomMenuActivated( int ) ) ), 2 );
  zoomMenu->popupMenu()->setItemParameter( zoomMenu->popupMenu()->insertItem("37.5 %", this, SLOT( zoomMenuActivated( int ) ) ), 3 );
  zoomMenu->popupMenu()->setItemParameter( zoomMenu->popupMenu()->insertItem("50 %", this, SLOT( zoomMenuActivated( int ) ) ), 4 );
  zoomMenu->popupMenu()->setItemParameter( zoomMenu->popupMenu()->insertItem("62.5 %", this, SLOT( zoomMenuActivated( int ) ) ), 5 );
  zoomMenu->popupMenu()->setItemParameter( zoomMenu->popupMenu()->insertItem("75 %", this, SLOT( zoomMenuActivated( int ) ) ), 6 );
  zoomMenu->popupMenu()->setItemParameter( zoomMenu->popupMenu()->insertItem("87.5 %", this, SLOT( zoomMenuActivated( int ) ) ), 7 );
  zoomMenu->popupMenu()->insertSeparator();
  zoomMenu->popupMenu()->setItemParameter( zoomMenu->popupMenu()->insertItem("100 %", this, SLOT( zoomMenuActivated( int ) ) ), 8 );
  zoomMenu->popupMenu()->insertSeparator();
  zoomMenu->popupMenu()->setItemParameter( zoomMenu->popupMenu()->insertItem("112.5 %", this, SLOT( zoomMenuActivated( int ) ) ), 9 );
  zoomMenu->popupMenu()->setItemParameter( zoomMenu->popupMenu()->insertItem("125 %", this, SLOT( zoomMenuActivated( int ) ) ), 10 );
  zoomMenu->popupMenu()->setItemParameter( zoomMenu->popupMenu()->insertItem("137.5 %", this, SLOT( zoomMenuActivated( int ) ) ), 11 );
  zoomMenu->popupMenu()->setItemParameter( zoomMenu->popupMenu()->insertItem("150 %", this, SLOT( zoomMenuActivated( int ) ) ), 12 );
  zoomMenu->popupMenu()->setItemParameter( zoomMenu->popupMenu()->insertItem("162.5 %", this, SLOT( zoomMenuActivated( int ) ) ), 13 );
  zoomMenu->popupMenu()->setItemParameter( zoomMenu->popupMenu()->insertItem("175 %", this, SLOT( zoomMenuActivated( int ) ) ), 14 );
  zoomMenu->popupMenu()->setItemParameter( zoomMenu->popupMenu()->insertItem("187.5 %", this, SLOT( zoomMenuActivated( int ) ) ), 15 );
  zoomMenu->popupMenu()->setItemParameter( zoomMenu->popupMenu()->insertItem("200 %", this, SLOT( zoomMenuActivated( int ) ) ), 16 );
  zoomMenu->popupMenu()->setItemChecked( zoomMenu->popupMenu()->idAt( 8 ), TRUE );
  connect(zoomMenu->popupMenu(), SIGNAL(aboutToShow()), this, SLOT(zoomMenuAboutToShow()));

  windowMenu = new KActionMenu(i18n("&Window"), actionCollection(), "window_menu");
  connect(windowMenu->popupMenu(), SIGNAL(aboutToShow()), this, SLOT(windowMenuAboutToShow()));
  
  createGUI();

  menuBar()->insertItem(tr("&Options"), optionsMenu->popupMenu());
  menuBar()->insertItem(tr("&Transform"), transformMenu->popupMenu());
  menuBar()->insertItem(tr("&View"), viewMenu->popupMenu());
  menuBar()->insertItem(tr("&Zoom"), zoomMenu->popupMenu());
  menuBar()->insertItem(tr("&Window"), windowMenu->popupMenu());

  m_pZoomSlider = new MySlider(1, 16, 1, 8, Horizontal, toolBar());
  m_pZoomSlider->setTickmarks((QSlider::TickSetting)1);
  m_pZoomSlider->setFixedWidth(160);
  /* Adjust slider width for uniform tic grid with distance 10 */
  int i;
  QRect rect;
  m_pZoomSlider->setValue(1);
  rect = m_pZoomSlider->sliderRect();
  m_pZoomSlider->tic[0] = (rect.right() + rect.left()) >> 1;
  m_pZoomSlider->setValue(16);
  rect = m_pZoomSlider->sliderRect();
  m_pZoomSlider->tic[15] = (rect.right() + rect.left()) >> 1;
  if (m_pZoomSlider->tic[15] - m_pZoomSlider->tic[0] != 15 * 10)
  {
    m_pZoomSlider->setFixedWidth(160 + 15 * 10 - (m_pZoomSlider->tic[15] - m_pZoomSlider->tic[0]));
  }
  for (i = 1; i <= 16; i++)
  {
    m_pZoomSlider->setValue(i);
    rect = m_pZoomSlider->sliderRect();
    m_pZoomSlider->tic[i - 1] = (rect.right() + rect.left()) >> 1;
  }
  for (i = 0; i < 15; i++)
  {
    m_pZoomSlider->tic[i] = (m_pZoomSlider->tic[i] + m_pZoomSlider->tic[i+1]) >> 1;
  }
  m_pZoomSlider->setValue(8);
  connect(m_pZoomSlider, SIGNAL(valueChanged( int )), this, SLOT(zoomSliderChanged( int )));

  m_pZoomLabel = new QLabel("100 %", toolBar());
  m_pZoomLabel->setFixedWidth(56);
}


void MyTestApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
  // TODO: add your own items you need for displaying current application status.
  statusBar()->insertItem(i18n("Ready."),1);
}


void MyTestApp::initView()
{
  ////////////////////////////////////////////////////////////////////
  // here the main view of the KMainWindow is created by a background box and
  // the QWorkspace instance for MDI view.
  QVBox* view_back = new QVBox( this );
  view_back->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
  pWorkspace = new QWorkspace( view_back );
  setCentralWidget(view_back);
  connect(pWorkspace, SIGNAL(windowActivated( QWidget * )), this, SLOT(wsWindowActivated( QWidget * )));
}


void MyTestApp::createClient(MyTestDoc* doc)
{
  MyTestView* w = new MyTestView(doc, pWorkspace,0,WDestructiveClose);
  w->installEventFilter(this);
  doc->addView(w);
  w->setIcon(kapp->miniIcon());
//  if ( pWorkspace->windowList().isEmpty() ) // show the very first window in maximized mode
//    w->showMaximized();
//  else
    w->show();
}

void MyTestApp::openDocumentFile(const KURL& url)
{
  slotStatusMsg(i18n("Opening file..."));
  MyTestDoc* doc;
	// check, if document already open. If yes, set the focus to the first view
  for(doc=pDocList->first(); doc > 0; doc=pDocList->next())
  {
    if(doc->URL()==url)
    {
      MyTestView* view=doc->firstView();
      view->setFocus();
      return;
    }
  }
  doc = new MyTestDoc();
  pDocList->append(doc);
  doc->newDocument();
  // Creates an untitled window if file is 0	
  if(url.isEmpty())
  {
    untitledCount+=1;
    QString fileName=QString(i18n("Untitled%1")).arg(untitledCount);
    KURL url;
    url.setFileName(fileName);
    doc->setURL(url);
  }
  // Open the file
  else
  {
    if(!doc->openDocument(url))
    {
      KMessageBox::error (this,i18n("Could not open document !"), i18n("Error !"));
      delete doc;
      return;	
    }
	  fileOpenRecent->addURL(url);
  }
  // create the window
  createClient(doc);

  slotStatusMsg(i18n("Ready."));
}


void MyTestApp::saveOptions()
{	
  config->setGroup("General Options");
  config->writeEntry("Geometry", size());
  config->writeEntry("Show Toolbar", toolBar()->isVisible());
  config->writeEntry("Show Statusbar",statusBar()->isVisible());
  config->writeEntry("ToolBarPos", (int) toolBar("mainToolBar")->barPos());
  
  fileOpenRecent->saveEntries(config,"Recent Files");

  saveProperties(config);
}


void MyTestApp::readOptions()
{
	
  config->setGroup("General Options");

  // bar status settings
  bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
  viewToolBar->setChecked(bViewToolbar);
  slotViewToolBar();

  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
  viewStatusBar->setChecked(bViewStatusbar);
  slotViewStatusBar();

  // bar position settings
  KToolBar::BarPosition toolBarPos;
  toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos", KToolBar::Top);
  toolBar("mainToolBar")->setBarPos(toolBarPos);

  // initialize the recent file list
  fileOpenRecent->loadEntries(config,"Recent Files");

  QSize size=config->readSizeEntry("Geometry");
  if(!size.isEmpty())
  {
    resize(size);
  }

  readProperties(config);
}

void MyTestApp::saveProperties(KConfig *_cfg)
{
  _cfg->setGroup("General Options");
  _cfg->writeEntry("OptimizeCoding", m_optimize_coding);
  _cfg->writeEntry("CopyOption", m_copyoption);
  _cfg->writeEntry("Dither", m_dither);
  _cfg->writeEntry("ProcessingMode", m_processing_mode);
  _cfg->writeEntry("CopyFileTime", m_copyfiletime);
  _cfg->writeEntry("Progressive", m_progressive);
}

void MyTestApp::readProperties(KConfig* _cfg)
{
  _cfg->setGroup("General Options");
  m_optimize_coding = _cfg->readNumEntry("OptimizeCoding", 0);
  if (m_optimize_coding < 0 || m_optimize_coding > 2)
      m_optimize_coding = 0;
  m_copyoption = _cfg->readNumEntry("CopyOption", 2);
  if (m_copyoption < 0 || m_copyoption > 2)
      m_copyoption = 2;
  m_dither = _cfg->readNumEntry("Dither", 1);
  if (m_dither < 0 || m_dither > 1)
      m_dither = 1;
  m_processing_mode = _cfg->readNumEntry("ProcessingMode", 0);
  if (m_processing_mode < 0 || m_processing_mode > 1)
      m_processing_mode = 0;
  m_copyfiletime = _cfg->readNumEntry("CopyFileTime", 1);
  if (m_copyfiletime < 0 || m_copyfiletime > 1)
      m_copyfiletime = 1;
  m_progressive = _cfg->readNumEntry("Progressive", 0);
  if (m_progressive < 0 || m_progressive > 1)
      m_progressive = 0;
}

bool MyTestApp::queryClose()
{

  QStringList saveFiles;
  MyTestDoc* doc;
  if(pDocList->isEmpty())
    return true;

  for(doc=pDocList->first(); doc!=0;doc=pDocList->next())
  {
    if(doc->isModified())
      saveFiles.append(doc->URL().fileName());
  }
  if(saveFiles.isEmpty())
    return true;

  switch (KMessageBox::questionYesNoList(this,
          i18n("One or more documents have been modified.\nSave changes before exiting?"),saveFiles))
  {
  case KMessageBox::Yes:
    for(doc=pDocList->first(); doc!=0;doc=pDocList->next())
    {
      if(doc->URL().fileName().contains(i18n("Untitled")))
        slotFileSaveAs();
      else
      {
        if(!doc->saveDocument(doc->URL()))
        {
          KMessageBox::error (this,i18n("Could not save the current document !"), i18n("I/O Error !"));
          return false;
         }
       }
     }
     return true;
  case KMessageBox::No:
  default:
  return true;
  }
}

bool MyTestApp::queryExit()
{
  saveOptions();
  return true;
}

bool MyTestApp::eventFilter(QObject* object, QEvent* event)
{
  if((event->type() == QEvent::Close)&&((MyTestApp*)object!=this))
  {
    QCloseEvent* e=(QCloseEvent*)event;

    MyTestView* pView=(MyTestView*)object;
    MyTestDoc* pDoc=pView->getDocument();
    if(pDoc->canCloseFrame(pView))
    {
      pDoc->removeView(pView);
      if(!pDoc->firstView())
        pDocList->remove(pDoc);
      e->accept();
    }
    else
      e->ignore();
  }
  return QWidget::eventFilter( object, event );    // standard event processing
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////


void MyTestApp::slotFileNew()
{
  slotStatusMsg(i18n("Creating new document..."));

  openDocumentFile();

  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::slotFileOpen()
{
  slotStatusMsg(i18n("Opening file..."));
	
  KURL url=KFileDialog::getOpenURL(QString::null,
      i18n("*.jpg|JPEG Files (*.jpg)\n*|All Files (*)"), this, i18n("Open File..."));
  if(!url.isEmpty())
  {
    openDocumentFile(url);
    fileOpenRecent->addURL( url );
  }

  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::slotFileOpenRecent(const KURL& url)
{
  slotStatusMsg(i18n("Opening file..."));
  	
  openDocumentFile(url);
	
  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::slotFileSave()
{
  slotStatusMsg(i18n("Saving file..."));

  MyTestView* m = (MyTestView*)pWorkspace->activeWindow();
  if( m )
  {
    MyTestDoc* doc = m->getDocument();
    if(doc->URL().fileName().contains(i18n("Untitled")))
      slotFileSaveAs();
    else
      if(!doc->saveDocument(doc->URL()))
    KMessageBox::error (this,i18n("Could not save the current document !"), i18n("I/O Error !"));
  }

  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::slotFileSaveAs()
{
  slotStatusMsg(i18n("Saving file with a new filename..."));

  KURL url=KFileDialog::getSaveURL(QDir::currentDirPath(),
        i18n("*|All files"), this, i18n("Save as..."));
  if(!url.isEmpty())
  {
    MyTestView* m = (MyTestView*)pWorkspace->activeWindow();
    if( m )
    {
      MyTestDoc* doc =	m->getDocument();
      if(!doc->saveDocument(url))
      {
        KMessageBox::error (this,i18n("Could not save the current document !"), i18n("I/O Error !"));
        return;
      }
      doc->changedViewList();
//      setWndTitle(m);
	    fileOpenRecent->addURL(url);
    }	
  }

  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::slotFileClose()
{
  slotStatusMsg(i18n("Closing file..."));
  MyTestView* m = (MyTestView*)pWorkspace->activeWindow();
  if( m )
  {
    MyTestDoc* doc=m->getDocument();
    doc->closeDocument();
  }
	
  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));
	
  MyTestView* m = (MyTestView*) pWorkspace->activeWindow();
  if ( m )
    m->print( printer );

  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::slotFilePrintPreview()
{
  slotStatusMsg(i18n("Preview printing..."));

  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::slotFileQuit()
{
  slotStatusMsg(i18n("Exiting..."));
  saveOptions();
  // close the first window, the list makes the next one the first again.
  // This ensures that queryClose() is called on each window to ask for closing
  KMainWindow* w;
  if(memberList)
  {
    for(w=memberList->first(); w!=0; w=memberList->first())
    {
      // only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
      // the window and the application stay open.
      if(!w->close())
        break;
    }
  }	
  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::slotEditUndo()
{
  slotStatusMsg(i18n("Reverting last action..."));
	
  MyTestView* m = (MyTestView*) pWorkspace->activeWindow();
  if ( m )
//  m->undo();

  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::slotEditCut()
{
  slotStatusMsg(i18n("Cutting selection..."));
	
  MyTestView* m = (MyTestView*) pWorkspace->activeWindow();
  if ( m )
//    m->cut();	

  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::slotEditCopy()
{
  slotStatusMsg(i18n("Copying selection to clipboard..."));
	
  MyTestView* m = (MyTestView*) pWorkspace->activeWindow();
  if ( m )
//    m->copy();
		
  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::slotEditPaste()
{
  slotStatusMsg(i18n("Inserting clipboard contents..."));
	
  MyTestView* m = (MyTestView*) pWorkspace->activeWindow();
  if ( m )
//    m->paste();
		
  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::slotViewToolBar()
{
  slotStatusMsg(i18n("Toggle the toolbar..."));
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  if(!viewToolBar->isChecked())
  {
    toolBar("mainToolBar")->hide();
  }
  else
  {
    toolBar("mainToolBar")->show();
  }		

  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::slotViewStatusBar()
{
  slotStatusMsg(i18n("Toggle the statusbar..."));
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  if(!viewStatusBar->isChecked())
  {
    statusBar()->hide();
  }
  else
  {
    statusBar()->show();
  }

  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::slotWindowNewWindow()
{
  slotStatusMsg(i18n("Opening a new application window..."));

  MyTestView* m = (MyTestView*) pWorkspace->activeWindow();
  if ( m )
  {
    MyTestDoc* doc = m->getDocument();
    createClient(doc);
  }

  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::slotWindowTile()
{
  pWorkspace->tile();
}

void MyTestApp::slotWindowCascade()
{
  pWorkspace->cascade();
}

void MyTestApp::slotPreferences()
{
  Preferences *prefs = new Preferences( this, "preferences", TRUE );

  prefs->radioButton1->setChecked( FALSE );
  prefs->radioButton2->setChecked( FALSE );
  prefs->radioButton3->setChecked( FALSE );
  switch (m_optimize_coding)
  {
    case 0: prefs->radioButton1->setChecked( TRUE ); break;
    case 1: prefs->radioButton2->setChecked( TRUE ); break;
    case 2: prefs->radioButton3->setChecked( TRUE ); break;
  }
  prefs->radioButton4->setChecked( FALSE );
  prefs->radioButton5->setChecked( FALSE );
  prefs->radioButton6->setChecked( FALSE );
  switch (m_copyoption)
  {
    case 0: prefs->radioButton4->setChecked( TRUE ); break;
    case 1: prefs->radioButton5->setChecked( TRUE ); break;
    case 2: prefs->radioButton6->setChecked( TRUE ); break;
  }
  prefs->radioButton7->setChecked( FALSE );
  prefs->radioButton8->setChecked( FALSE );
  switch (m_processing_mode)
  {
    case 0: prefs->radioButton7->setChecked( TRUE ); break;
    case 1: prefs->radioButton8->setChecked( TRUE ); break;
  }
  prefs->checkBox1->setChecked( m_progressive ? TRUE : FALSE );
  prefs->checkBox2->setChecked( m_copyfiletime ? TRUE : FALSE );
  prefs->checkBox3->setChecked( m_dither ? TRUE : FALSE );
  if (prefs->exec())
  {
         if (prefs->radioButton1->isChecked()) m_optimize_coding = 0;
    else if (prefs->radioButton2->isChecked()) m_optimize_coding = 1;
    else if (prefs->radioButton3->isChecked()) m_optimize_coding = 2;
         if (prefs->radioButton4->isChecked()) m_copyoption = 0;
    else if (prefs->radioButton5->isChecked()) m_copyoption = 1;
    else if (prefs->radioButton6->isChecked()) m_copyoption = 2;
         if (prefs->radioButton7->isChecked()) m_processing_mode = 0;
    else if (prefs->radioButton8->isChecked()) m_processing_mode = 1;
    m_progressive = prefs->checkBox1->isChecked() ? 1 : 0;
    m_copyfiletime = prefs->checkBox2->isChecked() ? 1 : 0;
    m_dither = prefs->checkBox3->isChecked() ? 1 : 0;
  }
}

void MyTestApp::slotStatusMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text,1);
}

void MyTestApp::optionsMenuAboutToShow()
{
  MyTestView* m = (MyTestView*) pWorkspace->activeWindow();
  int id = optionsMenu->popupMenu()->idAt( 0 );
  int grayscale = 0;
  if ( m )
  {
    grayscale = m->getDocument()->getGrayscale();
  }
  optionsMenu->popupMenu()->setItemEnabled( id, m != 0 );
  optionsMenu->popupMenu()->setItemChecked( id, grayscale != 0 );
}

void MyTestApp::slotOptionsGrayscale()
{
  slotStatusMsg(i18n("Toggle document grayscale mode..."));

  MyTestView* m = (MyTestView*) pWorkspace->activeWindow();
  if ( m )
  {
    m->getDocument()->toggleGrayscale();
  }

  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::viewMenuAboutToShow()
{
  viewMenu->popupMenu()->setItemChecked( viewMenu->popupMenu()->idAt( 0 ), m_show_blockgrid != 0 );
  viewMenu->popupMenu()->setItemChecked( viewMenu->popupMenu()->idAt( 1 ), m_show_fullscreen != 0 );
  viewMenu->popupMenu()->setItemChecked( viewMenu->popupMenu()->idAt( 2 ), m_show_scrollbars != 0 );
}

void MyTestApp::slotViewBlockGrid()
{
  slotStatusMsg(i18n("Toggle Block Grid view mode..."));

  m_show_blockgrid ^= 1;

  for (MyTestDoc* doc=pDocList->first(); doc!=0; doc=pDocList->next())
  {
    doc->updateAllViews();
  }

  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::slotViewFullScreen()
{
  slotStatusMsg(i18n("Toggle Full Screen view mode..."));

  if (m_show_fullscreen ^= 1)
	{ // switch to FullScreen mode
		saveMainWindowSettings( KGlobal::config(), "nonFullScreen MainWindow" );
		showFullScreen();
		applyMainWindowSettings( KGlobal::config(), "FullScreen MainWindow" );
	}
	else
	{ // leave FullScreen mode
		saveMainWindowSettings( KGlobal::config(), "FullScreen MainWindow" );
		showNormal();
		applyMainWindowSettings( KGlobal::config(), "nonFullScreen MainWindow" );
	}

  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::slotViewScrollBars()
{
  slotStatusMsg(i18n("Toggle Scroll Bars view mode..."));

  m_show_scrollbars ^= 1;

  for (MyTestDoc* doc=pDocList->first(); doc!=0; doc=pDocList->next())
  {
    for (MyTestView *w=doc->firstView(); w!=0; w=doc->nextView())
    {
      w->setVScrollBarMode(m_show_scrollbars ? QScrollView::Auto : QScrollView::AlwaysOff);
      w->setHScrollBarMode(m_show_scrollbars ? QScrollView::Auto : QScrollView::AlwaysOff);
    }
  }

  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::transformMenuAboutToShow()
{
  MyTestView* m = (MyTestView*) pWorkspace->activeWindow();
  if ( m )
  {
    int transform = m->getDocument()->getTransform();
    for (int i = 0; i < 8; i++)
    {
      int id = transformMenu->popupMenu()->idAt( i );
      transformMenu->popupMenu()->setItemChecked( id, transform == transformMenu->popupMenu()->itemParameter( id ));
    }
  }
}

void MyTestApp::transformMenuActivated( int num )
{
  slotStatusMsg(i18n("Transforming document..."));

  MyTestView* m = (MyTestView*) pWorkspace->activeWindow();
  if ( m )
  {
    m->getDocument()->transformDocument( num );
  }

  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::zoomMenuAboutToShow()
{
  MyTestView* m = (MyTestView*) pWorkspace->activeWindow();
  if ( m )
  {
    int scale = m->getDocument()->getScale();
    for (int i = 0; i < 7; i++)
    {
      zoomMenu->popupMenu()->setItemChecked( zoomMenu->popupMenu()->idAt( i ), scale == i + 1 );
    }
    zoomMenu->popupMenu()->setItemChecked( zoomMenu->popupMenu()->idAt( 8 ), scale == 8 );
    for (i = 10; i < 18; i++)
    {
      zoomMenu->popupMenu()->setItemChecked( zoomMenu->popupMenu()->idAt( i ), scale == i - 1 );
    }
  }
}

void MyTestApp::zoomMenuActivated( int num )
{
  slotStatusMsg(i18n("Rescaling document..."));

  MyTestView* m = (MyTestView*) pWorkspace->activeWindow();
  if ( m )
  {
    m->getDocument()->rescaleDocument( num );
  }

  m_pZoomSlider->setValue( num );
  
  switch ( num )
  {
  case  1: m_pZoomLabel->setText("12.5 %");  break;
  case  2: m_pZoomLabel->setText("25 %");    break;
  case  3: m_pZoomLabel->setText("37.5 %");  break;
  case  4: m_pZoomLabel->setText("50 %");    break;
  case  5: m_pZoomLabel->setText("62.5 %");  break;
  case  6: m_pZoomLabel->setText("75 %");    break;
  case  7: m_pZoomLabel->setText("87.5 %");  break;
  case  8: m_pZoomLabel->setText("100 %");   break;
  case  9: m_pZoomLabel->setText("112.5 %"); break;
  case 10: m_pZoomLabel->setText("125 %");   break;
  case 11: m_pZoomLabel->setText("137.5 %"); break;
  case 12: m_pZoomLabel->setText("150 %");   break;
  case 13: m_pZoomLabel->setText("162.5 %"); break;
  case 14: m_pZoomLabel->setText("175 %");   break;
  case 15: m_pZoomLabel->setText("187.5 %"); break;
  case 16: m_pZoomLabel->setText("200 %");   break;
  }
  
  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::zoomSliderChanged( int num )
{
  slotStatusMsg(i18n("Rescaling document..."));

  MyTestView* m = (MyTestView*) pWorkspace->activeWindow();
  if ( m )
  {
    m->getDocument()->rescaleDocument( num );
  }

  switch ( num )
  {
  case  1: m_pZoomLabel->setText("12.5 %");  break;
  case  2: m_pZoomLabel->setText("25 %");    break;
  case  3: m_pZoomLabel->setText("37.5 %");  break;
  case  4: m_pZoomLabel->setText("50 %");    break;
  case  5: m_pZoomLabel->setText("62.5 %");  break;
  case  6: m_pZoomLabel->setText("75 %");    break;
  case  7: m_pZoomLabel->setText("87.5 %");  break;
  case  8: m_pZoomLabel->setText("100 %");   break;
  case  9: m_pZoomLabel->setText("112.5 %"); break;
  case 10: m_pZoomLabel->setText("125 %");   break;
  case 11: m_pZoomLabel->setText("137.5 %"); break;
  case 12: m_pZoomLabel->setText("150 %");   break;
  case 13: m_pZoomLabel->setText("162.5 %"); break;
  case 14: m_pZoomLabel->setText("175 %");   break;
  case 15: m_pZoomLabel->setText("187.5 %"); break;
  case 16: m_pZoomLabel->setText("200 %");   break;
  }

  slotStatusMsg(i18n("Ready."));
}

void MyTestApp::windowMenuAboutToShow()
{
  windowMenu->popupMenu()->clear();
  windowMenu->insert(windowNewWindow);
  windowMenu->insert(windowCascade);
  windowMenu->insert(windowTile);

  if ( pWorkspace->windowList().isEmpty() ){
    windowNewWindow->setEnabled(false);
    windowCascade->setEnabled(false);
    windowTile->setEnabled(false);
  }
  else{
    windowNewWindow->setEnabled(true);
    windowCascade->setEnabled(true);
    windowTile->setEnabled(true);
  }
  windowMenu->popupMenu()->insertSeparator();

  QWidgetList windows = pWorkspace->windowList();
  for ( int i = 0; i < int(windows.count()); ++i )
  {
    int id = windowMenu->popupMenu()->insertItem(QString("&%1 ").arg(i+1)+windows.at(i)->caption(), this, SLOT( windowMenuActivated( int ) ) );
    windowMenu->popupMenu()->setItemParameter( id, i );
    windowMenu->popupMenu()->setItemChecked( id, pWorkspace->activeWindow() == windows.at(i) );
  }
}

void MyTestApp::windowMenuActivated( int id )
{
  QWidget* w = pWorkspace->windowList().at( id );
  if ( w )
    w->setFocus();
}

void MyTestApp::wsWindowActivated( QWidget *w )
{
  if ( w )
    m_pZoomSlider->setValue( ((MyTestView *)w)->getDocument()->getScale() );
}
