/***************************************************************************
                          myqtdoc.cpp  -  description
                             -------------------
    begin                : Mit Mr 10 13:31:39 CET 2004
    copyright            : (C) 2004 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qfileinfo.h>
#include <qwidget.h>
#include <qmessagebox.h>
#include <qfiledialog.h>


// application specific includes
#include "myqt.h"
#include "myqtview.h"
#include "myqtdoc.h"

#include "jpegimage.h"


MyQtDoc::MyQtDoc()
{
  pViewList = new QList<MyQtView>;
  pViewList->setAutoDelete(false);

  m_sizeDoc=QSize(8,8);
  m_ximage = 0;
  m_image_width = 8;
  m_image_height = 8;
  m_MCUwidth = 8;
  m_MCUheight = 8;
  m_crop_xoffset = 0;
  m_crop_yoffset = 0;
  m_crop_width = 0;
  m_crop_height = 0;
  m_transform = 0;
  m_scale = 0;
  m_scale_denom = 8;
  m_force_grayscale = 0;
}

MyQtDoc::~MyQtDoc()
{
  delete pViewList;
}

void MyQtDoc::addView(MyQtView *view)
{
  pViewList->append(view);
	changedViewList();
}

void MyQtDoc::removeView(MyQtView *view)
{
	  pViewList->remove(view);
	  if(!pViewList->isEmpty())
			changedViewList();
		else
			deleteContents();
}

void MyQtDoc::changedViewList(){	
	
	MyQtView *w;
	if((int)pViewList->count() == 1){
  	w=pViewList->first();
  	w->setCaption(m_title);
	}
	else{
		int i;
    for( i=1,w=pViewList->first(); w!=0; i++, w=pViewList->next())
  		w->setCaption(QString(m_title+":%1").arg(i));	
	}
}

bool MyQtDoc::isLastView() {
  return ((int) pViewList->count() == 1);
}


void MyQtDoc::updateAllViews(MyQtView *sender = 0, int hint = 0)
{
  if (hint)
    m_sizeDoc=QSize(m_ximage->width,m_ximage->height);

  for(MyQtView *w=pViewList->first(); w!=0; w=pViewList->next())
  {
     w->update(sender, hint);
  }
}

void MyQtDoc::setPathName(const QString &name)
{
  m_filename=name;
	m_title=QFileInfo(name).fileName();
}

const QString& MyQtDoc::pathName() const
{
  return m_filename;
}

void MyQtDoc::setTitle(const QString &title)
{
  m_title=title;
}

const QString &MyQtDoc::title() const
{
  return m_title;
}


void MyQtDoc::closeDocument()
{
  MyQtView *w;
  if(!isLastView())
  {
    for(w=pViewList->first(); w!=0; w=pViewList->next())
    {
   	 	if(!w->close())
 				break;
    }
	}
  if(isLastView())
  {
  	w=pViewList->first();
  	w->close();
  }
}

bool MyQtDoc::newDocument()
{
  /////////////////////////////////////////////////
  // TODO: Add your document initialization code here
  /////////////////////////////////////////////////
  modified=false;
  return true;
}

bool MyQtDoc::openDocument(const QString &filename, const char *format /*=0*/)
{
	QFile f( filename );
//	if ( !f.open( IO_ReadOnly ) )
//		return false;
  /////////////////////////////////////////////////
  // TODO: Add your document opening code here
  m_filename = filename;

  QApplication::setOverrideCursor(waitCursor);
  m_ximage = Read_JPEG_File(m_filename, m_scale, m_force_grayscale,
                            &m_image_width, &m_image_height,
                            &m_MCUwidth, &m_MCUheight,
                            &m_scale_denom);
  m_scale = m_scale_denom;
  QApplication::restoreOverrideCursor();
  if (!m_ximage)
    return false;
  m_sizeDoc = QSize(m_ximage->width, m_ximage->height);
  /////////////////////////////////////////////////
//	f.close();
	
  modified = false;
	m_title = QFileInfo(f).fileName();
  return true;
}

bool MyQtDoc::saveDocument(const QString &filename, const char *format /*=0*/)
{
//	QFile f( filename );
//	if ( !f.open( IO_WriteOnly ) )
//		return false;
//
//  /////////////////////////////////////////////////
//  // TODO: Add your document saving code here
//  /////////////////////////////////////////////////
//
//  f.close();
//
//  modified=false;
//  m_filename=filename;
//	m_title=QFileInfo(f).fileName();
  return true;
}

void MyQtDoc::deleteContents()
{
  if (m_ximage)
  {
    XDestroyImage(m_ximage);
    m_ximage = 0;
  }
}

void MyQtDoc::ReplaceXimage( XImage *ximage )
{
  int i = m_MCUwidth;
  m_MCUwidth = m_MCUheight;
  m_MCUheight = i;
  i = m_image_width;
  m_image_width = m_image_height;
  m_image_height = i;

  deleteContents();

  m_ximage = ximage;
}

void MyQtDoc::rescaleDocument( int scale )
{
  if (scale == m_scale)
    return;
  m_scale = scale;

  deleteContents();
  QApplication::setOverrideCursor(waitCursor);
  m_ximage = Read_JPEG_File(m_filename, m_scale, m_force_grayscale,
                            &m_image_width, &m_image_height,
                            &m_MCUwidth, &m_MCUheight,
                            &m_scale_denom);
  QApplication::restoreOverrideCursor();
  if (!m_ximage)
    return;
  doTransform();
  updateAllViews(0, 1);
}

void MyQtDoc::toggleGrayscale()
{
  m_force_grayscale ^= 1;

  deleteContents();
  QApplication::setOverrideCursor(waitCursor);
  m_ximage = Read_JPEG_File(m_filename, m_scale, m_force_grayscale,
                            &m_image_width, &m_image_height,
                            &m_MCUwidth, &m_MCUheight,
                            &m_scale_denom);
  QApplication::restoreOverrideCursor();
  if (!m_ximage)
    return;
  doTransform();
  updateAllViews();
}

bool MyQtDoc::canCloseFrame(MyQtView* pFrame)
{
	if(!isLastView())
		return true;
		
	bool ret=false;
  if(isModified())
  {
		QString saveName;
  	switch(QMessageBox::information(pFrame, title(), tr("The current file has been modified.\n"
                          "Do you want to save it?"),QMessageBox::Yes, QMessageBox::No, QMessageBox::Cancel ))
    {
			case QMessageBox::Yes:
				if(title().contains(tr("Untitled")))
				{
					saveName=QFileDialog::getSaveFileName(0, 0, pFrame);
                                          if(saveName.isEmpty())
          	                                return false;
				}
				else
					saveName=pathName();

				if(!saveDocument(saveName))
				{
 					switch(QMessageBox::critical(pFrame, tr("I/O Error !"), tr("Could not save the current document !\n"
																												"Close anyway ?"),QMessageBox::Yes ,QMessageBox::No))

 					{
 						case QMessageBox::Yes:
 							ret=true;
 						case QMessageBox::No:
 							ret=false;
 					}
				}
				else
					ret=true;
				break;
			case QMessageBox::No:
				ret=true;
				break;
			case QMessageBox::Cancel:
			default:
				ret=false;
				break;
		}
	}
	else
		ret=true;

	return ret;
}
