/***************************************************************************
                          myqt.cpp  -  description
                             -------------------
    begin                : Mit Mr 10 13:31:39 CET 2004
    copyright            : (C) 2004 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qvbox.h>
#include <qaccel.h>
#include <qradiobutton.h>
#include <qcheckbox.h>

// application specific includes
#include "myqt.h"
#include "myqtview.h"
#include "myqtdoc.h"
#include "preferences.h"

#include "filenew.xpm"
#include "fileopen.xpm"
#include "filesave.xpm"


MySlider::MySlider(int minValue, int maxValue, int pageStep, int value, Orientation orientation,
  QWidget * parent, const char * name = 0)
  : QSlider(minValue, maxValue, pageStep, value, orientation, parent, name)
{
}

void MySlider::mousePressEvent(QMouseEvent *e)
{
  if (e->button() == LeftButton)
  {
    QSlider::mousePressEvent(e);
  }
  else
  {
    int i = 1;
    while (e->x() > tic[i-1] && i < 16) i++;
    setValue(i);
  }
}


MyQtApp *myapp;

MyQtApp::MyQtApp()
{
  myapp = this;

  setCaption(tr("MyQt XWindow Application"));

  printer = new QPrinter;
  untitledCount=0;
  pDocList = new QList<MyQtDoc>();
  pDocList->setAutoDelete(true);

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initView();
  initActions();
  initMenuBar();
  initToolBar();
  initStatusBar();

  viewToolBar->setOn(true);
  viewStatusBar->setOn(true);

  m_show_blockgrid = 0;
  m_show_cropmask = 0;
  m_endpoint_snap = 1;
  m_trim = 0;
  m_optimize_coding = 0;
  m_copyoption = 2;
  m_dither = 1;
  m_processing_mode = 0;
  m_copyfiletime = 1;
  m_progressive = 0;
  m_width = 208;
  m_height = 208;
  m_xoffset = -1;
  m_yoffset = -1;
  m_cropspec = 0;
  m_actual = 0;

  m_show_fullscreen = 0;
  m_show_scrollbars = 1;

  load_inf();
}

MyQtApp::~MyQtApp()
{
  delete printer;
}

void MyQtApp::initActions()
{
  QPixmap openIcon, saveIcon, newIcon;
  newIcon = QPixmap(filenew);
  openIcon = QPixmap(fileopen);
  saveIcon = QPixmap(filesave);

  fileNew = new QAction(tr("New File"), newIcon, tr("&New"), QAccel::stringToKey(tr("Ctrl+N")), this);
  fileNew->setStatusTip(tr("Creates a new document"));
  fileNew->setWhatsThis(tr("New File\n\nCreates a new document"));
  connect(fileNew, SIGNAL(activated()), this, SLOT(slotFileNew()));

  fileOpen = new QAction(tr("Open File"), openIcon, tr("&Open..."), 0, this);
  fileOpen->setStatusTip(tr("Opens an existing document"));
  fileOpen->setWhatsThis(tr("Open File\n\nOpens an existing document"));
  connect(fileOpen, SIGNAL(activated()), this, SLOT(slotFileOpen()));

  fileSave = new QAction(tr("Save File"), saveIcon, tr("&Save"), QAccel::stringToKey(tr("Ctrl+S")), this);
  fileSave->setStatusTip(tr("Saves the actual document"));
  fileSave->setWhatsThis(tr("Save File.\n\nSaves the actual document"));
  connect(fileSave, SIGNAL(activated()), this, SLOT(slotFileSave()));

  fileSaveAs = new QAction(tr("Save File As"), tr("Save &as..."), 0, this);
  fileSaveAs->setStatusTip(tr("Saves the actual document under a new filename"));
  fileSaveAs->setWhatsThis(tr("Save As\n\nSaves the actual document under a new filename"));
  connect(fileSaveAs, SIGNAL(activated()), this, SLOT(slotFileSave()));

  fileClose = new QAction(tr("Close File"), tr("&Close"), QAccel::stringToKey(tr("Ctrl+W")), this);
  fileClose->setStatusTip(tr("Closes the actual document"));
  fileClose->setWhatsThis(tr("Close File\n\nCloses the actual document"));
  connect(fileClose, SIGNAL(activated()), this, SLOT(slotFileClose()));

  filePrint = new QAction(tr("Print File"), tr("&Print"), QAccel::stringToKey(tr("Ctrl+P")), this);
  filePrint->setStatusTip(tr("Prints out the actual document"));
  filePrint->setWhatsThis(tr("Print File\n\nPrints out the actual document"));
  connect(filePrint, SIGNAL(activated()), this, SLOT(slotFilePrint()));

  fileQuit = new QAction(tr("Exit"), tr("E&xit"), QAccel::stringToKey(tr("Ctrl+Q")), this);
  fileQuit->setStatusTip(tr("Quits the application"));
  fileQuit->setWhatsThis(tr("Exit\n\nQuits the application"));
  connect(fileQuit, SIGNAL(activated()), this, SLOT(slotFileQuit()));

  editCut = new QAction(tr("Cut"), tr("Cu&t"), QAccel::stringToKey(tr("Ctrl+X")), this);
  editCut->setStatusTip(tr("Cuts the selected section and puts it to the clipboard"));
  editCut->setWhatsThis(tr("Cut\n\nCuts the selected section and puts it to the clipboard"));
  connect(editCut, SIGNAL(activated()), this, SLOT(slotEditCut()));

  editCopy = new QAction(tr("Copy"), tr("&Copy"), QAccel::stringToKey(tr("Ctrl+C")), this);
  editCopy->setStatusTip(tr("Copies the selected section to the clipboard"));
  editCopy->setWhatsThis(tr("Copy\n\nCopies the selected section to the clipboard"));
  connect(editCopy, SIGNAL(activated()), this, SLOT(slotEditCopy()));

  editUndo = new QAction(tr("Undo"), tr("&Undo"), QAccel::stringToKey(tr("Ctrl+Z")), this);
  editUndo->setStatusTip(tr("Reverts the last editing action"));
  editUndo->setWhatsThis(tr("Undo\n\nReverts the last editing action"));
  connect(editUndo, SIGNAL(activated()), this, SLOT(slotEditUndo()));

  editPaste = new QAction(tr("Paste"), tr("&Paste"), QAccel::stringToKey(tr("Ctrl+V")), this);
  editPaste->setStatusTip(tr("Pastes the clipboard contents to actual position"));
  editPaste->setWhatsThis(tr("Paste\n\nPastes the clipboard contents to actual position"));
  connect(editPaste, SIGNAL(activated()), this, SLOT(slotEditPaste()));

  viewToolBar = new QAction(tr("Toolbar"), tr("Tool&bar"), 0, this, 0, true);
  viewToolBar->setStatusTip(tr("Enables/disables the toolbar"));
  viewToolBar->setWhatsThis(tr("Toolbar\n\nEnables/disables the toolbar"));
  connect(viewToolBar, SIGNAL(toggled(bool)), this, SLOT(slotViewToolBar(bool)));

  viewStatusBar = new QAction(tr("Statusbar"), tr("&Statusbar"), 0, this, 0, true);
  viewStatusBar->setStatusTip(tr("Enables/disables the statusbar"));
  viewStatusBar->setWhatsThis(tr("Statusbar\n\nEnables/disables the statusbar"));
  connect(viewStatusBar, SIGNAL(toggled(bool)), this, SLOT(slotViewStatusBar(bool)));
  
  windowNewWindow = new QAction(tr("New Window"), tr("&New Window"), 0, this);
  windowNewWindow->setStatusTip(tr("Opens a new view for the current document"));
  windowNewWindow->setWhatsThis(tr("New Window\n\nOpens a new view for the current document"));
  connect(windowNewWindow, SIGNAL(activated()), this, SLOT(slotWindowNewWindow()));

  windowCascade = new QAction(tr("Cascade"), tr("&Cascade"), 0, this);
  windowCascade->setStatusTip(tr("Cascades all windows"));
  windowCascade->setWhatsThis(tr("Cascade\n\nCascades all windows"));
  connect(windowCascade, SIGNAL(activated()), pWorkspace, SLOT(cascade()));

  windowTile = new QAction(tr("Tile"), tr("&Tile"), 0, this);
  windowTile->setStatusTip(tr("Tiles all windows"));
  windowTile->setWhatsThis(tr("Tile\n\nTiles all windows"));
  connect(windowTile, SIGNAL(activated()), pWorkspace, SLOT(tile()));


  windowAction = new QActionGroup(this, 0, false);
  windowAction->insert(windowNewWindow);
  windowAction->insert(windowCascade);
  windowAction->insert(windowTile);

  helpAboutApp = new QAction(tr("About"), tr("&About..."), 0, this);
  helpAboutApp->setStatusTip(tr("About the application"));
  helpAboutApp->setWhatsThis(tr("About\n\nAbout the application"));
  connect(helpAboutApp, SIGNAL(activated()), this, SLOT(slotHelpAbout()));

  filePreferences = new QAction(tr("Preferences"), tr("P&references..."), 0, this);
  filePreferences->setStatusTip(tr("Preferences"));
  filePreferences->setWhatsThis(tr("Preferences\n\nPreferences"));
  connect(filePreferences, SIGNAL(activated()), this, SLOT(slotPreferences()));
}

void MyQtApp::initMenuBar()
{
  ///////////////////////////////////////////////////////////////////
  // MENUBAR

  ///////////////////////////////////////////////////////////////////
  // menuBar entry pFileMenu
  pFileMenu=new QPopupMenu();
  fileNew->addTo(pFileMenu);
  fileOpen->addTo(pFileMenu);
  fileClose->addTo(pFileMenu);
  pFileMenu->insertSeparator();
  fileSave->addTo(pFileMenu);
  fileSaveAs->addTo(pFileMenu);
  pFileMenu->insertSeparator();
  filePreferences->addTo(pFileMenu);
  pFileMenu->insertSeparator();
  filePrint->addTo(pFileMenu);
  pFileMenu->insertSeparator();
  fileQuit->addTo(pFileMenu);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry editMenu
  pEditMenu=new QPopupMenu();
  editUndo->addTo(pEditMenu);
  pEditMenu->insertSeparator();
  editCut->addTo(pEditMenu);
  editCopy->addTo(pEditMenu);
  editPaste->addTo(pEditMenu);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry viewMenu
  pViewMenu=new QPopupMenu();
  pViewMenu->setCheckable(true);
  viewToolBar->addTo(pViewMenu);
  viewStatusBar->addTo(pViewMenu);
  pViewMenu->insertItem("&Full Screen", this, SLOT(slotViewFullScreen()));
  pViewMenu->insertItem("&Scroll Bars", this, SLOT(slotViewScrollBars()));
  pViewMenu->insertSeparator();
  pViewMenu->insertItem("&Block Grid", this, SLOT(slotViewBlockGrid()));
  connect(pViewMenu, SIGNAL(aboutToShow()), this, SLOT(viewMenuAboutToShow()));
  ///////////////////////////////////////////////////////////////////
  // EDIT YOUR APPLICATION SPECIFIC MENUENTRIES HERE
  ///////////////////////////////////////////////////////////////////
  // menuBar entry optionsMenu
  pOptionsMenu=new QPopupMenu();
  pOptionsMenu->setCheckable(true);
  pOptionsMenu->insertItem("&Grayscale Reduction", this, SLOT(slotOptionsGrayscale()));
  connect(pOptionsMenu, SIGNAL(aboutToShow()), this, SLOT(optionsMenuAboutToShow()));
  ///////////////////////////////////////////////////////////////////
  // menuBar entry transformMenu
  pTransformMenu=new QPopupMenu();
  pTransformMenu->setCheckable(true);
  pTransformMenu->setItemParameter( pTransformMenu->insertItem("Rotate 90 &Clockwise", this, SLOT( transformMenuActivated( int ) ) ), 5 );
  pTransformMenu->setItemParameter( pTransformMenu->insertItem("Rotate 90 C&ounterclockwise", this, SLOT( transformMenuActivated( int ) ) ), 7 );
  pTransformMenu->setItemParameter( pTransformMenu->insertItem("Flip &Horizontal", this, SLOT( transformMenuActivated( int ) ) ), 1 );
  pTransformMenu->setItemParameter( pTransformMenu->insertItem("Flip &Vertical", this, SLOT( transformMenuActivated( int ) ) ), 2 );
  pTransformMenu->setItemParameter( pTransformMenu->insertItem("Rotate &180", this, SLOT( transformMenuActivated( int ) ) ), 6 );
  pTransformMenu->setItemParameter( pTransformMenu->insertItem("&Transpose", this, SLOT( transformMenuActivated( int ) ) ), 3 );
  pTransformMenu->setItemParameter( pTransformMenu->insertItem("T&ransverse Transpose", this, SLOT( transformMenuActivated( int ) ) ), 4 );
  pTransformMenu->setItemParameter( pTransformMenu->insertItem("&Original", this, SLOT( transformMenuActivated( int ) ) ), 0 );
  pTransformMenu->setItemChecked( pTransformMenu->idAt( 7 ), TRUE );
  connect(pTransformMenu, SIGNAL(aboutToShow()), this, SLOT(transformMenuAboutToShow()));
  ///////////////////////////////////////////////////////////////////
  // menuBar entry zoomMenu
  pZoomMenu=new QPopupMenu();
  pZoomMenu->setCheckable(true);
  pZoomMenu->setItemParameter( pZoomMenu->insertItem( "12.5 %", this, SLOT( zoomMenuActivated( int ) ) ), 1 );
  pZoomMenu->setItemParameter( pZoomMenu->insertItem( "25 %", this, SLOT( zoomMenuActivated( int ) ) ), 2 );
  pZoomMenu->setItemParameter( pZoomMenu->insertItem( "37.5 %", this, SLOT( zoomMenuActivated( int ) ) ), 3 );
  pZoomMenu->setItemParameter( pZoomMenu->insertItem( "50 %", this, SLOT( zoomMenuActivated( int ) ) ), 4 );
  pZoomMenu->setItemParameter( pZoomMenu->insertItem( "62.5 %", this, SLOT( zoomMenuActivated( int ) ) ), 5 );
  pZoomMenu->setItemParameter( pZoomMenu->insertItem( "75 %", this, SLOT( zoomMenuActivated( int ) ) ), 6 );
  pZoomMenu->setItemParameter( pZoomMenu->insertItem( "87.5 %", this, SLOT( zoomMenuActivated( int ) ) ), 7 );
  pZoomMenu->insertSeparator();
  pZoomMenu->setItemParameter( pZoomMenu->insertItem( "100 %", this, SLOT( zoomMenuActivated( int ) ) ), 8 );
  pZoomMenu->insertSeparator();
  pZoomMenu->setItemParameter( pZoomMenu->insertItem( "112.5 %", this, SLOT( zoomMenuActivated( int ) ) ), 9 );
  pZoomMenu->setItemParameter( pZoomMenu->insertItem( "125 %", this, SLOT( zoomMenuActivated( int ) ) ), 10 );
  pZoomMenu->setItemParameter( pZoomMenu->insertItem( "137.5 %", this, SLOT( zoomMenuActivated( int ) ) ), 11 );
  pZoomMenu->setItemParameter( pZoomMenu->insertItem( "150 %", this, SLOT( zoomMenuActivated( int ) ) ), 12 );
  pZoomMenu->setItemParameter( pZoomMenu->insertItem( "162.5 %", this, SLOT( zoomMenuActivated( int ) ) ), 13 );
  pZoomMenu->setItemParameter( pZoomMenu->insertItem( "175 %", this, SLOT( zoomMenuActivated( int ) ) ), 14 );
  pZoomMenu->setItemParameter( pZoomMenu->insertItem( "187.5 %", this, SLOT( zoomMenuActivated( int ) ) ), 15 );
  pZoomMenu->setItemParameter( pZoomMenu->insertItem( "200 %", this, SLOT( zoomMenuActivated( int ) ) ), 16 );
  pZoomMenu->setItemChecked( pZoomMenu->idAt( 8 ), TRUE );
  connect(pZoomMenu, SIGNAL(aboutToShow()), this, SLOT(zoomMenuAboutToShow()));

  ///////////////////////////////////////////////////////////////////
  // menuBar entry windowMenu
  pWindowMenu = new QPopupMenu(this);
  pWindowMenu->setCheckable(true);
  connect(pWindowMenu, SIGNAL(aboutToShow()), this, SLOT(windowMenuAboutToShow()));

  ///////////////////////////////////////////////////////////////////
  // menuBar entry helpMenu
  pHelpMenu=new QPopupMenu();
  helpAboutApp->addTo(pHelpMenu);
  pHelpMenu->insertSeparator();
  pHelpMenu->insertItem(tr("What's &This"), this, SLOT(whatsThis()), SHIFT+Key_F1);


  menuBar()->insertItem(tr("&File"), pFileMenu);
  menuBar()->insertItem(tr("&Options"), pOptionsMenu);
  menuBar()->insertItem(tr("&Edit"), pEditMenu);
  menuBar()->insertItem(tr("&Transform"), pTransformMenu);
  menuBar()->insertItem(tr("&View"), pViewMenu);
  menuBar()->insertItem(tr("&Zoom"), pZoomMenu);
  menuBar()->insertItem(tr("&Window"), pWindowMenu);
  menuBar()->insertItem(tr("&Help"), pHelpMenu);
}

void MyQtApp::initToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  fileToolbar = new QToolBar(this, "file operations");
  fileNew->addTo(fileToolbar);
  fileOpen->addTo(fileToolbar);
  fileSave->addTo(fileToolbar);
  fileToolbar->addSeparator();
  QWhatsThis::whatsThisButton(fileToolbar);
  
  m_pZoomSlider = new MySlider(1, 16, 1, 8, Horizontal, fileToolbar);
  m_pZoomSlider->setTickmarks((QSlider::TickSetting)1);
  m_pZoomSlider->setFixedWidth(160);
  /* Adjust slider width for uniform tic grid with distance 10 */
  int i;
  QRect rect;
  m_pZoomSlider->setValue(1);
  rect = m_pZoomSlider->sliderRect();
  m_pZoomSlider->tic[0] = (rect.right() + rect.left()) >> 1;
  m_pZoomSlider->setValue(16);
  rect = m_pZoomSlider->sliderRect();
  m_pZoomSlider->tic[15] = (rect.right() + rect.left()) >> 1;
  if (m_pZoomSlider->tic[15] - m_pZoomSlider->tic[0] != 15 * 10)
  {
    m_pZoomSlider->setFixedWidth(160 + 15 * 10 - (m_pZoomSlider->tic[15] - m_pZoomSlider->tic[0]));
  }
  for (i = 1; i <= 16; i++)
  {
    m_pZoomSlider->setValue(i);
    rect = m_pZoomSlider->sliderRect();
    m_pZoomSlider->tic[i - 1] = (rect.right() + rect.left()) >> 1;
  }
  for (i = 0; i < 15; i++)
  {
    m_pZoomSlider->tic[i] = (m_pZoomSlider->tic[i] + m_pZoomSlider->tic[i+1]) >> 1;
  }
  m_pZoomSlider->setValue(8);
  connect(m_pZoomSlider, SIGNAL(valueChanged( int )), this, SLOT(zoomSliderChanged( int )));

  m_pZoomLabel = new QLabel("100 %", fileToolbar);
  m_pZoomLabel->setFixedWidth(56);
}

void MyQtApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->message(tr("Ready."));
}

void MyQtApp::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // set the main widget here
  QVBox* view_back = new QVBox( this );
  view_back->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
  pWorkspace = new QWorkspace( view_back );
  setCentralWidget(view_back);
  connect(pWorkspace, SIGNAL(windowActivated( QWidget * )), this, SLOT(wsWindowActivated( QWidget * )));
}

void MyQtApp::load_inf(void)
{
	FILE *fp;

	if ((fp = fopen(".myqtrc", "r")) == NULL)
		return;
	fscanf(fp, "OptimizeCoding = %d\n", &m_optimize_coding);
	if (m_optimize_coding < 0 || m_optimize_coding > 2)
		m_optimize_coding = 0;
	fscanf(fp, "CopyOption = %d\n", &m_copyoption);
	if (m_copyoption < 0 || m_copyoption > 2)
		m_copyoption = 2;
	fscanf(fp, "Dither = %d\n", &m_dither);
	if (m_dither < 0 || m_dither > 1)
		m_dither = 1;
	fscanf(fp, "ProcessingMode = %d\n", &m_processing_mode);
	if (m_processing_mode < 0 || m_processing_mode > 1)
		m_processing_mode = 0;
	fscanf(fp, "CopyFileTime = %d\n", &m_copyfiletime);
	if (m_copyfiletime < 0 || m_copyfiletime > 1)
		m_copyfiletime = 1;
	fscanf(fp, "Progressive = %d\n", &m_progressive);
	if (m_progressive < 0 || m_progressive > 1)
		m_progressive = 0;
	fclose(fp);
}

void MyQtApp::save_inf(void)
{
	FILE *fp;

	if ((fp = fopen(".myqtrc", "w")) == NULL)
		return;
	fprintf(fp, "OptimizeCoding = %d\n", m_optimize_coding);
	fprintf(fp, "CopyOption = %d\n", m_copyoption);
	fprintf(fp, "Dither = %d\n", m_dither);
	fprintf(fp, "ProcessingMode = %d\n", m_processing_mode);
	fprintf(fp, "CopyFileTime = %d\n", m_copyfiletime);
	fprintf(fp, "Progressive = %d\n", m_progressive);
	fclose(fp);
}

void MyQtApp::createClient(MyQtDoc* doc)
{
  MyQtView* w = new MyQtView(doc, pWorkspace,0,WDestructiveClose);
  w->installEventFilter(this);
  doc->addView(w);
//  if ( pWorkspace->windowList().isEmpty() ) // show the very first window in maximized mode
//    w->showMaximized();
//  else
    w->show();
}

void MyQtApp::openDocumentFile(const char* file)
{
  statusBar()->message(tr("Opening file..."));
  MyQtDoc* doc;
	// check, if document already open. If yes, set the focus to the first view
  for(doc=pDocList->first(); doc > 0; doc=pDocList->next())
  {
    if(doc->pathName()==file)
    {
      MyQtView* view=doc->firstView();	
      view->setFocus();
      return;
     }
  }
  doc = new MyQtDoc();
  pDocList->append(doc);
  doc->newDocument();
  // Creates an untitled window if file is 0	
  if(!file)
  {
    untitledCount+=1;
    QString fileName=QString(tr("Untitled%1")).arg(untitledCount);
    doc->setPathName(fileName);
    doc->setTitle(fileName);
  }
  // Open the file
  else
  {
    if(!doc->openDocument(file))
    {
      QMessageBox::critical(this, tr("Error !"),tr("Could not open document !"));
      delete doc;
      return;
    }
  }
  // create the window
  createClient(doc);

  statusBar()->message(tr("Ready."));
}

bool MyQtApp::queryExit()
{
  int exit=QMessageBox::information(this, tr("Quit..."),
                                    tr("Do your really want to quit?"),
                                    QMessageBox::Ok, QMessageBox::Cancel);

  if (exit==1)
  {

  }
  else
  {

  };

  return (exit==1);
}

bool MyQtApp::eventFilter(QObject* object, QEvent* event)
{
  if((event->type() == QEvent::Close)&&((MyQtApp*)object!=this))
  {
    QCloseEvent* e=(QCloseEvent*)event;
    MyQtView* pView=(MyQtView*)object;
    MyQtDoc* pDoc=pView->getDocument();
    if(pDoc->canCloseFrame(pView))
    {
      pDoc->removeView(pView);
      if(!pDoc->firstView())
        pDocList->remove(pDoc);

      e->accept();
    }
    else
      e->ignore();
  }
  return QWidget::eventFilter( object, event );    // standard event processing
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////


void MyQtApp::slotFileNew()
{
  statusBar()->message(tr("Creating new file..."));

  openDocumentFile();		

  statusBar()->message(tr("Ready."));
}

void MyQtApp::slotFileOpen()
{
  statusBar()->message(tr("Opening file..."));

  QString fileName = QFileDialog::getOpenFileName(0,"JPEG Files (*.jpg);;All Files (*)",this);
  if (!fileName.isEmpty())
  {
    openDocumentFile(fileName);		
  }

  statusBar()->message(tr("Ready."));
}


void MyQtApp::slotFileSave()
{
  statusBar()->message(tr("Saving file..."));
	
  MyQtView* m = (MyQtView*)pWorkspace->activeWindow();
  if( m )
  {
    MyQtDoc* doc = m->getDocument();
    if(doc->title().contains(tr("Untitled")))
      slotFileSaveAs();
    else
      if(!doc->saveDocument(doc->pathName()))
        QMessageBox::critical (this, tr("I/O Error !"), tr("Could not save the current document !"));
  }

  statusBar()->message(tr("Ready."));
}

void MyQtApp::slotFileSaveAs()
{
  statusBar()->message(tr("Saving file under new filename..."));
  QString fn = QFileDialog::getSaveFileName(0, 0, this);
  if (!fn.isEmpty())
  {
    MyQtView* m = (MyQtView*)pWorkspace->activeWindow();
    if( m )
    {
      MyQtDoc* doc = m->getDocument();
      if(!doc->saveDocument(fn))
      {
         QMessageBox::critical (this, tr("I/O Error !"), tr("Could not save the current document !"));
         return;
      }
      doc->changedViewList();
    }
  }
  statusBar()->message(tr("Ready."));
}

void MyQtApp::slotFileClose()
{
  statusBar()->message(tr("Closing file..."));
	
  MyQtView* m = (MyQtView*)pWorkspace->activeWindow();
  if( m )
  {
    MyQtDoc* doc=m->getDocument();
    doc->closeDocument();
  }

  statusBar()->message(tr("Ready."));
}

void MyQtApp::slotPreferences()
{
  statusBar()->message(tr("Preferences..."));

  Preferences *prefs = new Preferences( this, "preferences", TRUE );

  prefs->radioButton1->setChecked( FALSE );
  prefs->radioButton2->setChecked( FALSE );
  prefs->radioButton3->setChecked( FALSE );
  switch (m_optimize_coding)
  {
    case 0: prefs->radioButton1->setChecked( TRUE ); break;
    case 1: prefs->radioButton2->setChecked( TRUE ); break;
    case 2: prefs->radioButton3->setChecked( TRUE ); break;
  }
  prefs->radioButton4->setChecked( FALSE );
  prefs->radioButton5->setChecked( FALSE );
  prefs->radioButton6->setChecked( FALSE );
  switch (m_copyoption)
  {
    case 0: prefs->radioButton4->setChecked( TRUE ); break;
    case 1: prefs->radioButton5->setChecked( TRUE ); break;
    case 2: prefs->radioButton6->setChecked( TRUE ); break;
  }
  prefs->radioButton7->setChecked( FALSE );
  prefs->radioButton8->setChecked( FALSE );
  switch (m_processing_mode)
  {
    case 0: prefs->radioButton7->setChecked( TRUE ); break;
    case 1: prefs->radioButton8->setChecked( TRUE ); break;
  }
  prefs->checkBox1->setChecked( m_progressive ? TRUE : FALSE );
  prefs->checkBox2->setChecked( m_copyfiletime ? TRUE : FALSE );
  prefs->checkBox3->setChecked( m_dither ? TRUE : FALSE );
  if (prefs->exec())
  {
         if (prefs->radioButton1->isChecked()) m_optimize_coding = 0;
    else if (prefs->radioButton2->isChecked()) m_optimize_coding = 1;
    else if (prefs->radioButton3->isChecked()) m_optimize_coding = 2;
         if (prefs->radioButton4->isChecked()) m_copyoption = 0;
    else if (prefs->radioButton5->isChecked()) m_copyoption = 1;
    else if (prefs->radioButton6->isChecked()) m_copyoption = 2;
         if (prefs->radioButton7->isChecked()) m_processing_mode = 0;
    else if (prefs->radioButton8->isChecked()) m_processing_mode = 1;
    m_progressive = prefs->checkBox1->isChecked() ? 1 : 0;
    m_copyfiletime = prefs->checkBox2->isChecked() ? 1 : 0;
    m_dither = prefs->checkBox3->isChecked() ? 1 : 0;
  }

  statusBar()->message(tr("Ready."));
}

void MyQtApp::slotFilePrint()
{
  statusBar()->message(tr("Printing..."));
	
  MyQtView* m = (MyQtView*) pWorkspace->activeWindow();
  if ( m )
    m->print( printer );

  statusBar()->message(tr("Ready."));
}

void MyQtApp::slotFileQuit()
{ 
  statusBar()->message(tr("Exiting application..."));
  ///////////////////////////////////////////////////////////////////
  // exits the Application
//  if(doc->isModified())
//  {
//    if(queryExit())
//    {
//      qApp->quit();
//    }
//    else
//    {
//
//    };
//  }
//  else
//  {
    qApp->quit();
//  };

  statusBar()->message(tr("Ready."));
}

void MyQtApp::slotEditUndo()
{
  statusBar()->message(tr("Reverting last action..."));
	
  MyQtView* m = (MyQtView*) pWorkspace->activeWindow();
  if ( m )
//   m->undo();

  statusBar()->message(tr("Ready."));
}

void MyQtApp::slotEditCut()
{
  statusBar()->message(tr("Cutting selection..."));
	
  MyQtView* m = (MyQtView*) pWorkspace->activeWindow();
  if ( m )
//  m->cut();	

  statusBar()->message(tr("Ready."));
}

void MyQtApp::slotEditCopy()
{
  statusBar()->message(tr("Copying selection to clipboard..."));

  MyQtView* m = (MyQtView*) pWorkspace->activeWindow();
  if ( m )
//  m->copy();

  statusBar()->message(tr("Ready."));
}

void MyQtApp::slotEditPaste()
{
  statusBar()->message(tr("Inserting clipboard contents..."));
	
  MyQtView* m = (MyQtView*) pWorkspace->activeWindow();
  if ( m )
//   m->paste();

  statusBar()->message(tr("Ready."));
}


void MyQtApp::slotViewToolBar(bool toggle)
{
  statusBar()->message(tr("Toggle toolbar..."));
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
   if (toggle== false)
  {
    fileToolbar->hide();
  }
  else
  {
    fileToolbar->show();
  };

 statusBar()->message(tr("Ready."));
}

void MyQtApp::slotViewStatusBar(bool toggle)
{
  statusBar()->message(tr("Toggle statusbar..."));
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  
  if (toggle == false)
  {
    statusBar()->hide();
  }
  else
  {
    statusBar()->show();
  }

  statusBar()->message(tr("Ready."));
}

void MyQtApp::slotWindowNewWindow()
{
  statusBar()->message(tr("Opening new document view..."));
	
  MyQtView* m = (MyQtView*) pWorkspace->activeWindow();
  if ( m ){
    MyQtDoc* doc = m->getDocument();
    createClient(doc);
  }

  statusBar()->message(tr("Ready."));
}

void MyQtApp::slotHelpAbout()
{
  QMessageBox::about(this,tr("About..."),
                     tr("MyQt\nVersion " VERSION
                     "\nDeveloped 2004-2019 by Guido Vollbeding"));
}

void MyQtApp::slotStatusHelpMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}

void MyQtApp::optionsMenuAboutToShow()
{
  MyQtView* m = (MyQtView*) pWorkspace->activeWindow();
  int id = pOptionsMenu->idAt( 0 );
  int grayscale = 0;
  if ( m )
  {
    grayscale = m->getDocument()->getGrayscale();
  }
  pOptionsMenu->setItemEnabled( id, m != 0 );
  pOptionsMenu->setItemChecked( id, grayscale != 0 );
}

void MyQtApp::slotOptionsGrayscale()
{
  statusBar()->message(tr("Toggle document grayscale mode..."));

  MyQtView* m = (MyQtView*) pWorkspace->activeWindow();
  if ( m )
  {
    m->getDocument()->toggleGrayscale();
  }

  statusBar()->message(tr("Ready."));
}

void MyQtApp::viewMenuAboutToShow()
{
  pViewMenu->setItemChecked( pViewMenu->idAt( 2 ), m_show_fullscreen != 0 );
  pViewMenu->setItemChecked( pViewMenu->idAt( 3 ), m_show_scrollbars != 0 );
  pViewMenu->setItemChecked( pViewMenu->idAt( 5 ), m_show_blockgrid != 0 );
}

void MyQtApp::slotViewBlockGrid()
{
  statusBar()->message(tr("Toggle Block Grid view mode..."));

  m_show_blockgrid ^= 1;

  for (MyQtDoc* doc=pDocList->first(); doc!=0; doc=pDocList->next())
  {
    doc->updateAllViews();
  }

  statusBar()->message(tr("Ready."));
}

void MyQtApp::slotViewFullScreen()
{
  statusBar()->message(tr("Toggle Full Screen view mode..."));

  if (m_show_fullscreen ^= 1)
	{ // switch to FullScreen mode
//		saveMainWindowSettings( QGlobal::config(), "nonFullScreen MainWindow" );
		showFullScreen();
//		applyMainWindowSettings( QGlobal::config(), "FullScreen MainWindow" );
	}
	else
	{ // leave FullScreen mode
//		saveMainWindowSettings( QGlobal::config(), "FullScreen MainWindow" );
		showNormal();
//		applyMainWindowSettings( QGlobal::config(), "nonFullScreen MainWindow" );
	}

  statusBar()->message(tr("Ready."));
}

void MyQtApp::slotViewScrollBars()
{
  statusBar()->message(tr("Toggle Scroll Bars view mode..."));

  m_show_scrollbars ^= 1;

  for (MyQtDoc* doc=pDocList->first(); doc!=0; doc=pDocList->next())
  {
    for(MyQtView *w=doc->firstView(); w!=0; w=doc->nextView())
    {
      w->setVScrollBarMode(m_show_scrollbars ? QScrollView::Auto : QScrollView::AlwaysOff);
      w->setHScrollBarMode(m_show_scrollbars ? QScrollView::Auto : QScrollView::AlwaysOff);
    }
  }

  statusBar()->message(tr("Ready."));
}

void MyQtApp::transformMenuAboutToShow()
{
  MyQtView* m = (MyQtView*) pWorkspace->activeWindow();
  if ( m )
  {
    int transform = m->getDocument()->getTransform();
    for (int i = 0; i < 8; i++)
    {
      int id = pTransformMenu->idAt( i );
      pTransformMenu->setItemChecked( id, transform == pTransformMenu->itemParameter( id ));
    }
  }
}

void MyQtApp::transformMenuActivated( int num )
{
  statusBar()->message(tr("Transforming document..."));

  MyQtView* m = (MyQtView*) pWorkspace->activeWindow();
  if ( m )
  {
    m->getDocument()->transformDocument( num );
  }

  statusBar()->message(tr("Ready."));
}

void MyQtApp::zoomMenuAboutToShow()
{
  MyQtView* m = (MyQtView*) pWorkspace->activeWindow();
  if ( m )
  {
    int scale = m->getDocument()->getScale();
    for (int i = 0; i < 7; i++)
    {
      pZoomMenu->setItemChecked( pZoomMenu->idAt( i ), scale == i + 1 );
    }
    pZoomMenu->setItemChecked( pZoomMenu->idAt( 8 ), scale == 8 );
    for (i = 10; i < 18; i++)
    {
      pZoomMenu->setItemChecked( pZoomMenu->idAt( i ), scale == i - 1 );
    }
  }
}

void MyQtApp::zoomMenuActivated( int num )
{
  statusBar()->message(tr("Rescaling document..."));

  MyQtView* m = (MyQtView*) pWorkspace->activeWindow();
  if ( m )
  {
    m->getDocument()->rescaleDocument( num );
  }

  m_pZoomSlider->setValue( num );

  switch ( num )
  {
  case  1: m_pZoomLabel->setText("12.5 %");  break;
  case  2: m_pZoomLabel->setText("25 %");    break;
  case  3: m_pZoomLabel->setText("37.5 %");  break;
  case  4: m_pZoomLabel->setText("50 %");    break;
  case  5: m_pZoomLabel->setText("62.5 %");  break;
  case  6: m_pZoomLabel->setText("75 %");    break;
  case  7: m_pZoomLabel->setText("87.5 %");  break;
  case  8: m_pZoomLabel->setText("100 %");   break;
  case  9: m_pZoomLabel->setText("112.5 %"); break;
  case 10: m_pZoomLabel->setText("125 %");   break;
  case 11: m_pZoomLabel->setText("137.5 %"); break;
  case 12: m_pZoomLabel->setText("150 %");   break;
  case 13: m_pZoomLabel->setText("162.5 %"); break;
  case 14: m_pZoomLabel->setText("175 %");   break;
  case 15: m_pZoomLabel->setText("187.5 %"); break;
  case 16: m_pZoomLabel->setText("200 %");   break;
  }

  statusBar()->message(tr("Ready."));
}

void MyQtApp::zoomSliderChanged( int num )
{
  statusBar()->message(tr("Rescaling document..."));

  MyQtView* m = (MyQtView*) pWorkspace->activeWindow();
  if ( m )
  {
    m->getDocument()->rescaleDocument( num );
  }

  switch ( num )
  {
  case  1: m_pZoomLabel->setText("12.5 %");  break;
  case  2: m_pZoomLabel->setText("25 %");    break;
  case  3: m_pZoomLabel->setText("37.5 %");  break;
  case  4: m_pZoomLabel->setText("50 %");    break;
  case  5: m_pZoomLabel->setText("62.5 %");  break;
  case  6: m_pZoomLabel->setText("75 %");    break;
  case  7: m_pZoomLabel->setText("87.5 %");  break;
  case  8: m_pZoomLabel->setText("100 %");   break;
  case  9: m_pZoomLabel->setText("112.5 %"); break;
  case 10: m_pZoomLabel->setText("125 %");   break;
  case 11: m_pZoomLabel->setText("137.5 %"); break;
  case 12: m_pZoomLabel->setText("150 %");   break;
  case 13: m_pZoomLabel->setText("162.5 %"); break;
  case 14: m_pZoomLabel->setText("175 %");   break;
  case 15: m_pZoomLabel->setText("187.5 %"); break;
  case 16: m_pZoomLabel->setText("200 %");   break;
  }

  statusBar()->message(tr("Ready."));
}

void MyQtApp::windowMenuAboutToShow()
{
  pWindowMenu->clear();	
	windowNewWindow->addTo(pWindowMenu);
	windowCascade->addTo(pWindowMenu);
	windowTile->addTo(pWindowMenu);
	
  if ( pWorkspace->windowList().isEmpty() )
  {
    windowAction->setEnabled(false);
  }
  else
  {
    windowAction->setEnabled(true);
  }

  pWindowMenu->insertSeparator();

  QWidgetList windows = pWorkspace->windowList();
  for ( int i = 0; i < int(windows.count()); ++i )
  {
    int id = pWindowMenu->insertItem(QString("&%1 ").arg(i+1)+windows.at(i)->caption(), this, SLOT( windowMenuActivated( int ) ) );
    pWindowMenu->setItemParameter( id, i );
    pWindowMenu->setItemChecked( id, pWorkspace->activeWindow() == windows.at(i) );
  }
}

void MyQtApp::windowMenuActivated( int id )
{
  QWidget* w = pWorkspace->windowList().at( id );
  if ( w )
    w->setFocus();
}

void MyQtApp::wsWindowActivated( QWidget *w )
{
  if ( w )
    m_pZoomSlider->setValue( ((MyQtView *)w)->getDocument()->getScale() );
}
