/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.shapers.EditableEllipse2D;
import edu.xtec.jclic.shapers.EditableRectangle;
import edu.xtec.jclic.shapers.EditableShape;
import edu.xtec.jclic.shapers.EditableShapeConstants;
import edu.xtec.jclic.shapers.Holes;
import edu.xtec.jclic.shapers.PointListener;
import edu.xtec.jclic.shapers.PolygonDrawPanel;
import edu.xtec.jclic.shapers.ShapeData;
import edu.xtec.jclic.shapers.Shaper;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class HolesEditorPanel
extends JPanel
implements PointListener,
ActionListener,
PropertyChangeListener {
    public static final double ROTATE_UNIT = 0.2617993877991494;
    Options options;
    Holes shaper;
    Image img;
    Rectangle previewArea;
    BoxBase previewBb;
    ShapeListModel listModel;
    ListSelectionListener listSelectionListener;
    boolean modified;
    int currentShape;
    protected PolygonDrawPanel pdp;
    private boolean shapeDrawn = false;
    double xFactor = 1.0;
    double yFactor = 1.0;
    double lastWidth = -1.0;
    double lastHeight = -1.0;
    Dimension previewDim;
    private boolean initializing;
    private int zoomFactor = 1;
    public static final int MAX_ZOOM = 10;
    public static final int MIN_ZOOM = -2;
    private ButtonGroup bgMode;
    private JButton btBezier;
    private JButton btContract;
    private JButton btCopy;
    private JButton btDelete;
    private JToggleButton btDivide;
    private JToggleButton btEllipse;
    private JButton btExpand;
    private JToggleButton btGrid;
    private JButton btLine;
    private JToggleButton btMagnet;
    private JButton btPaste;
    private JToggleButton btPolygon;
    private JButton btQuad;
    private JToggleButton btRect;
    private JButton btRotateLeft;
    private JButton btRotateRight;
    private JToggleButton btSelect;
    private JToggleButton btShowDrawnPoints;
    private JButton btZoomIn;
    private JButton btZoomOut;
    private JButton downBtn;
    private SmallIntEditor gridSizeEdit;
    private JTextField lbZoom;
    private JScrollPane listScroll;
    private SmallIntEditor magnetRadiusEdit;
    private JPanel orderBtnPanel;
    private JScrollPane previewPanel;
    private JList<Object> shapesList;
    private JTextField tfName;
    private JButton upBtn;

    public HolesEditorPanel(Options options, Holes shaper, Dimension previewDim, Image img, BoxBase previewBb) {
        this.options = options;
        this.shaper = shaper;
        this.img = img;
        this.previewDim = previewDim;
        this.initializing = true;
        this.currentShape = shaper.getNumCells() + 1;
        this.previewArea = new Rectangle(img == null ? previewDim : new Dimension(img.getWidth(this), img.getHeight(this)));
        this.previewBb = previewBb;
        this.initMembers();
        this.initComponents();
        this.customizeComponents();
        this.pdp = new PolygonDrawPanel(img == null ? (int)previewDim.getWidth() : img.getWidth(this), img == null ? (int)previewDim.getHeight() : img.getHeight(this), this, img == null);
        this.pdp.addPointListener(this);
        if (this.previewPanel != null) {
            ((PreviewPanel)this.previewPanel).vp.addMouseMotionListener(this.pdp);
            ((PreviewPanel)this.previewPanel).vp.addMouseListener(this.pdp);
        }
        this.initializing = false;
        this.shapeChanged();
    }

    @Override
    public void setCursor(Cursor c) {
        if (this.previewPanel != null) {
            ((PreviewPanel)this.previewPanel).vp.setCursor(c);
        }
    }

    public void setCursor(Cursor c, boolean onlyPreviewPanel) {
        if (this.previewPanel != null) {
            ((PreviewPanel)this.previewPanel).vp.setCursor(c);
        }
    }

    private void initMembers() {
        this.listModel = new ShapeListModel();
        this.listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                if (ev.getValueIsAdjusting()) {
                    return;
                }
                int v = HolesEditorPanel.this.shapesList.getSelectedIndex();
                if (v != HolesEditorPanel.this.currentShape && v >= 0) {
                    if (HolesEditorPanel.this.pdp.getNumShapes() > 0) {
                        HolesEditorPanel.this.pdp.endPolygon(true, false, v);
                    }
                    if (v >= 0 && HolesEditorPanel.this.getHoles().getShapeData(v) != null) {
                        HolesEditorPanel.this.tfName.setText(HolesEditorPanel.this.getHoles().getShapeData((int)v).comment);
                    } else {
                        HolesEditorPanel.this.tfName.setText("");
                    }
                    HolesEditorPanel.this.setCurrentShapeNoList(v);
                } else {
                    HolesEditorPanel.this.tfName.setText("");
                }
                HolesEditorPanel.this.upBtn.setEnabled(v > 0);
                HolesEditorPanel.this.downBtn.setEnabled(v < HolesEditorPanel.this.shapesList.getModel().getSize() - 1);
            }
        };
    }

    protected void confirmChanges() {
        this.pdp.endPolygon();
    }

    protected void customizeComponents() {
        this.btShowDrawnPoints.setSelected(EditableShapeConstants.showDrawnPoints);
        this.btGrid.setSelected(EditableShapeConstants.gridWidth != -1);
        this.gridSizeEdit.setEnabled(this.btGrid.isSelected());
        this.btMagnet.setSelected(EditableShapeConstants.pointsOnGrid);
        this.magnetRadiusEdit.setEnabled(this.btMagnet.isSelected());
        this.btSelect.setSelected(true);
    }

    public void updateList() {
        this.initMembers();
        this.shapesList.setModel(this.listModel);
    }

    protected void setCurrentShape(int v) {
        if (this.shapesList.getSelectedIndex() != v) {
            this.shapesList.setSelectedIndex(v);
        }
        this.btDelete.setEnabled(this.pdp.getNumShapes() > 0);
        this.updateTransformingButtons();
        this.currentShape = v;
    }

    protected void setCurrentShapeNoList(int v) {
        this.currentShape = v;
        this.pdp.selectShape(v);
        this.btDelete.setEnabled(this.pdp.getNumShapes() > 0);
        ((PreviewPanel)this.previewPanel).updateView();
    }

    private void initComponents() {
        this.bgMode = new ButtonGroup();
        JPanel topPanel = new JPanel();
        JToolBar tbTop1 = new JToolBar();
        this.btShowDrawnPoints = new JToggleButton();
        this.btShowDrawnPoints.addActionListener(this);
        JToolBar.Separator sept1 = new JToolBar.Separator();
        this.btGrid = new JToggleButton();
        this.btGrid.addActionListener(this);
        this.gridSizeEdit = new SmallIntEditor();
        this.gridSizeEdit.addPropertyChangeListener(this);
        JToolBar.Separator sept2 = new JToolBar.Separator();
        this.btDelete = new JButton();
        this.btDelete.addActionListener(this);
        this.btCopy = new JButton();
        this.btCopy.addActionListener(this);
        this.btPaste = new JButton();
        this.btPaste.addActionListener(this);
        JToolBar.Separator sept3 = new JToolBar.Separator();
        this.btMagnet = new JToggleButton();
        this.btMagnet.addActionListener(this);
        this.magnetRadiusEdit = new SmallIntEditor();
        this.magnetRadiusEdit.addPropertyChangeListener(this);
        JToolBar.Separator sept4 = new JToolBar.Separator();
        JPanel zoomPanel = new JPanel();
        JLabel zoomLb = new JLabel();
        this.btZoomOut = new JButton();
        this.btZoomOut.addActionListener(this);
        this.lbZoom = new JTextField();
        this.btZoomIn = new JButton();
        this.btZoomIn.addActionListener(this);
        JLabel spacerTop = new JLabel();
        JSeparator sep0 = new JSeparator();
        JPanel leftPanel = new JPanel();
        JToolBar tbLeft1 = new JToolBar();
        this.btSelect = new JToggleButton();
        this.btSelect.addActionListener(this);
        this.btDivide = new JToggleButton();
        this.btDivide.addActionListener(this);
        JToolBar.Separator sep1 = new JToolBar.Separator();
        this.btRect = new JToggleButton();
        this.btRect.addActionListener(this);
        this.btEllipse = new JToggleButton();
        this.btEllipse.addActionListener(this);
        this.btPolygon = new JToggleButton();
        this.btPolygon.addActionListener(this);
        this.btLine = new JButton();
        this.btLine.addActionListener(this);
        this.btBezier = new JButton();
        this.btBezier.addActionListener(this);
        this.btQuad = new JButton();
        this.btQuad.addActionListener(this);
        JToolBar.Separator sep2 = new JToolBar.Separator();
        this.btExpand = new JButton();
        this.btExpand.addActionListener(this);
        this.btContract = new JButton();
        this.btContract.addActionListener(this);
        JToolBar.Separator sep4 = new JToolBar.Separator();
        this.btRotateRight = new JButton();
        this.btRotateRight.addActionListener(this);
        this.btRotateLeft = new JButton();
        this.btRotateLeft.addActionListener(this);
        JLabel spacerLeft = new JLabel();
        JSplitPane splitPane = new JSplitPane();
        this.previewPanel = new PreviewPanel();
        this.previewPanel.addPropertyChangeListener(this);
        JPanel listPanel = new JPanel();
        this.orderBtnPanel = new JPanel();
        this.upBtn = new JButton();
        this.downBtn = new JButton();
        this.listScroll = new JScrollPane();
        this.shapesList = new JList();
        this.tfName = new JTextField();
        this.tfName.addActionListener(this);
        this.setLayout(new GridBagLayout());
        topPanel.setLayout(new GridBagLayout());
        tbTop1.setFloatable(false);
        this.btShowDrawnPoints.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/vertex_off.gif")));
        this.btShowDrawnPoints.setToolTipText(this.options.getMsg("edit_shape_showPoints_tooltip"));
        this.btShowDrawnPoints.setSelectedIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/vertex_on.gif")));
        tbTop1.add(this.btShowDrawnPoints);
        sept1.setOrientation(1);
        tbTop1.add(sept1);
        this.btGrid.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/grid.gif")));
        this.btGrid.setToolTipText(this.options.getMsg("edit_shape_hideGrid"));
        tbTop1.add(this.btGrid);
        this.gridSizeEdit.setToolTipText(this.options.getMsg("edit_shape_gridSize_tooltip"));
        this.gridSizeEdit.setEditColumns(2);
        this.gridSizeEdit.setMax(50);
        this.gridSizeEdit.setMin(5);
        this.gridSizeEdit.setValue(10);
        this.gridSizeEdit.setValues(new int[]{5, 10, 15, 20, 30, 50});
        tbTop1.add(this.gridSizeEdit);
        sept2.setOrientation(1);
        tbTop1.add(sept2);
        this.btDelete.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/delete.gif")));
        this.btDelete.setToolTipText(this.options.getMsg("edit_shape_deletePoint"));
        this.btDelete.setMaximumSize(new Dimension(32, 32));
        this.btDelete.setMinimumSize(new Dimension(32, 32));
        tbTop1.add(this.btDelete);
        this.btCopy.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/copy.gif")));
        this.btCopy.setToolTipText(this.options.getMsg("COPY"));
        tbTop1.add(this.btCopy);
        this.btPaste.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/paste.gif")));
        this.btPaste.setToolTipText(this.options.getMsg("PASTE"));
        tbTop1.add(this.btPaste);
        sept3.setOrientation(1);
        tbTop1.add(sept3);
        this.btMagnet.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/imant.gif")));
        this.btMagnet.setToolTipText(this.options.getMsg("edit_shape_aproxPoints"));
        tbTop1.add(this.btMagnet);
        this.magnetRadiusEdit.setToolTipText(this.options.getMsg("edit_shape_magnetRadius_tooltip"));
        this.magnetRadiusEdit.setEditColumns(2);
        this.magnetRadiusEdit.setMax(15);
        this.magnetRadiusEdit.setMin(1);
        this.magnetRadiusEdit.setValue(4);
        this.magnetRadiusEdit.setValues(new int[]{1, 2, 4, 6, 10, 15});
        tbTop1.add(this.magnetRadiusEdit);
        sept4.setOrientation(1);
        tbTop1.add(sept4);
        zoomPanel.setOpaque(false);
        zoomPanel.setLayout(new BoxLayout(zoomPanel, 2));
        zoomLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/zoom.gif")));
        zoomLb.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        zoomPanel.add(zoomLb);
        this.btZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/minus.gif")));
        this.btZoomOut.setToolTipText(this.options.getMsg("edit_shape_zoomOut"));
        this.btZoomOut.setPreferredSize(new Dimension(16, 16));
        zoomPanel.add(this.btZoomOut);
        this.lbZoom.setColumns(3);
        this.lbZoom.setEditable(false);
        this.lbZoom.setHorizontalAlignment(0);
        this.lbZoom.setText("1x");
        zoomPanel.add(this.lbZoom);
        this.btZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/plus.gif")));
        this.btZoomIn.setToolTipText(this.options.getMsg("edit_shape_zoomIn"));
        this.btZoomIn.setPreferredSize(new Dimension(16, 16));
        zoomPanel.add(this.btZoomIn);
        tbTop1.add(zoomPanel);
        topPanel.add((Component)tbTop1, new GridBagConstraints());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        topPanel.add((Component)spacerTop, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)topPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)sep0, gridBagConstraints);
        leftPanel.setLayout(new GridBagLayout());
        tbLeft1.setFloatable(false);
        tbLeft1.setOrientation(1);
        this.bgMode.add(this.btSelect);
        this.btSelect.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/selectionMode.gif")));
        this.btSelect.setToolTipText(this.options.getMsg("edit_shape_select"));
        this.btSelect.setMaximumSize(new Dimension(32, 32));
        this.btSelect.setMinimumSize(new Dimension(32, 32));
        tbLeft1.add(this.btSelect);
        this.bgMode.add(this.btDivide);
        this.btDivide.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/add_point.gif")));
        this.btDivide.setToolTipText(this.options.getMsg("edit_shape_addPoint"));
        this.btDivide.setMaximumSize(new Dimension(32, 32));
        this.btDivide.setMinimumSize(new Dimension(32, 32));
        tbLeft1.add(this.btDivide);
        tbLeft1.add(sep1);
        this.bgMode.add(this.btRect);
        this.btRect.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/rect.gif")));
        this.btRect.setToolTipText(this.options.getMsg("edit_shape_drawRect"));
        this.btRect.setMaximumSize(new Dimension(32, 32));
        this.btRect.setMinimumSize(new Dimension(32, 32));
        tbLeft1.add(this.btRect);
        this.bgMode.add(this.btEllipse);
        this.btEllipse.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/rodona.gif")));
        this.btEllipse.setToolTipText(this.options.getMsg("edit_shape_drawEllipse"));
        this.btEllipse.setMaximumSize(new Dimension(32, 32));
        this.btEllipse.setMinimumSize(new Dimension(32, 32));
        tbLeft1.add(this.btEllipse);
        this.bgMode.add(this.btPolygon);
        this.btPolygon.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/pent.gif")));
        this.btPolygon.setToolTipText(this.options.getMsg("edit_shape_drawPoly"));
        this.btPolygon.setMaximumSize(new Dimension(32, 32));
        this.btPolygon.setMinimumSize(new Dimension(32, 32));
        tbLeft1.add(this.btPolygon);
        this.btLine.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/line.gif")));
        this.btLine.setToolTipText(this.options.getMsg("edit_shape_toLine"));
        this.btLine.setMaximumSize(new Dimension(32, 32));
        this.btLine.setMinimumSize(new Dimension(32, 32));
        tbLeft1.add(this.btLine);
        this.btBezier.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/bezier.gif")));
        this.btBezier.setToolTipText(this.options.getMsg("edit_shape_toBezier"));
        this.btBezier.setMaximumSize(new Dimension(32, 32));
        this.btBezier.setMinimumSize(new Dimension(32, 32));
        tbLeft1.add(this.btBezier);
        this.btQuad.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/quad.gif")));
        this.btQuad.setToolTipText(this.options.getMsg("edit_shape_toQuad"));
        this.btQuad.setMaximumSize(new Dimension(32, 32));
        this.btQuad.setMinimumSize(new Dimension(32, 32));
        tbLeft1.add(this.btQuad);
        tbLeft1.add(sep2);
        this.btExpand.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/expand.gif")));
        this.btExpand.setToolTipText(this.options.getMsg("edit_shape_expand"));
        tbLeft1.add(this.btExpand);
        this.btContract.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/contract.gif")));
        this.btContract.setToolTipText(this.options.getMsg("edit_shape_contract"));
        tbLeft1.add(this.btContract);
        tbLeft1.add(sep4);
        this.btRotateRight.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/rotate_right.gif")));
        this.btRotateRight.setToolTipText(this.options.getMsg("edit_shape_rRight"));
        tbLeft1.add(this.btRotateRight);
        this.btRotateLeft.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/rotate_left.gif")));
        this.btRotateLeft.setToolTipText(this.options.getMsg("edit_shape_rLeft"));
        tbLeft1.add(this.btRotateLeft);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        leftPanel.add((Component)tbLeft1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        leftPanel.add((Component)spacerLeft, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)leftPanel, gridBagConstraints);
        splitPane.setResizeWeight(1.0);
        this.previewPanel.setHorizontalScrollBarPolicy(32);
        this.previewPanel.setVerticalScrollBarPolicy(22);
        splitPane.setLeftComponent(this.previewPanel);
        listPanel.setLayout(new BorderLayout(10, 8));
        this.upBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/up.gif")));
        this.upBtn.setToolTipText(this.options.getMsg("edit_list_upBtn_tooltip"));
        this.upBtn.setEnabled(false);
        this.upBtn.setPreferredSize(new Dimension(16, 16));
        this.upBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HolesEditorPanel.this.upBtnActionPerformed(evt);
            }
        });
        this.orderBtnPanel.add(this.upBtn);
        this.downBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/down.gif")));
        this.downBtn.setToolTipText(this.options.getMsg("edit_list_downBtn_tooltip"));
        this.downBtn.setEnabled(false);
        this.downBtn.setPreferredSize(new Dimension(16, 16));
        this.downBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HolesEditorPanel.this.downBtnActionPerformed(evt);
            }
        });
        this.orderBtnPanel.add(this.downBtn);
        listPanel.add((Component)this.orderBtnPanel, "North");
        this.listScroll.setToolTipText(this.options.getMsg("edit_shape_elements"));
        this.listScroll.setPreferredSize(new Dimension(80, 100));
        this.shapesList.setModel(this.listModel);
        this.shapesList.addListSelectionListener(this.listSelectionListener);
        this.listScroll.setViewportView(this.shapesList);
        listPanel.add((Component)this.listScroll, "Center");
        this.tfName.setToolTipText(this.options.getMsg("edit_shape_elemName"));
        listPanel.add((Component)this.tfName, "South");
        splitPane.setRightComponent(listPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)splitPane, gridBagConstraints);
    }

    private void upBtnActionPerformed(ActionEvent evt) {
        int sel;
        if (this.listModel != null && (sel = this.shapesList.getSelectedIndex()) > 0 && sel < this.listModel.getSize() - 1) {
            this.listModel.switchShapes(sel, sel - 1);
            this.shapesList.setSelectedIndex(sel - 1);
            this.modified = true;
            this.repaint(0L);
        }
    }

    private void downBtnActionPerformed(ActionEvent evt) {
        int sel;
        if (this.listModel != null && (sel = this.shapesList.getSelectedIndex()) >= 0 && sel < this.listModel.getSize() - 2) {
            this.listModel.switchShapes(sel, sel + 1);
            this.shapesList.setSelectedIndex(sel + 1);
            this.modified = true;
            this.repaint(0L);
        }
    }

    private void setDrawingRectangleMode() {
        this.deselectAll();
        this.btRect.setSelected(true);
        this.pdp.setDrawingMode(5);
        this.pdp.deSelectAll();
        this.repaint(0L);
    }

    private void deselectAll() {
        this.pdp.cancelCurrentOperations();
        this.btSelect.setSelected(false);
        this.btRect.setSelected(false);
        this.btEllipse.setSelected(false);
        this.btPolygon.setSelected(false);
        this.btBezier.setSelected(false);
        this.btQuad.setSelected(false);
        this.btDivide.setSelected(false);
    }

    public void setDrawingMode(int drawingMode) {
        this.pdp.setDrawingMode(drawingMode);
        switch (drawingMode) {
            case 1: {
                this.btSelect.setSelected(true);
                break;
            }
            case 4: {
                this.btDivide.setSelected(true);
            }
        }
        this.btDelete.setEnabled(this.pdp.getNumShapes() > 0);
    }

    @Override
    public void shapeChanged() {
        if (this.pdp.getNumShapes() > 0) {
            this.btDelete.setEnabled(true);
            this.shapeDrawn = true;
            this.repaint(0L);
        } else {
            this.btDelete.setEnabled(this.pdp.hasSelectedPoint());
            this.clean();
        }
        if (!this.btDivide.isSelected()) {
            this.pdp.setDrawingMode(1);
            this.deselectAll();
            this.btSelect.setSelected(true);
        } else {
            this.btSelect.setSelected(false);
        }
        this.updateTransformingButtons();
    }

    protected void updateTransformingButtons() {
        List<EditableShape> v = this.pdp.getSelectedShapes();
        if (v.size() == 1) {
            EditableShape shape = v.get(0);
            if (!(shape instanceof EditableRectangle)) {
                this.btBezier.setEnabled(true);
                this.btQuad.setEnabled(true);
            }
            if (!(shape instanceof EditableEllipse2D)) {
                this.btLine.setEnabled(true);
            }
        } else {
            this.btBezier.setEnabled(false);
            this.btQuad.setEnabled(false);
            this.btLine.setEnabled(false);
            this.repaint(0L);
        }
    }

    public JComponent getPreviewPanel() {
        return this.previewPanel;
    }

    private void clean() {
        this.pdp.deleteSelected(false);
        this.shapeDrawn = false;
        this.deselectAll();
        this.btRect.setEnabled(true);
        this.btEllipse.setEnabled(true);
        this.btPolygon.setEnabled(true);
    }

    public void updateView() {
        ((PreviewPanel)this.previewPanel).updateView();
    }

    public Holes getHoles() {
        return this.shaper;
    }

    public Rectangle getPreviewArea() {
        return this.previewArea;
    }

    public void setPreviewArea(Rectangle r) {
        this.previewArea = r;
    }

    public int getNumShapes() {
        return this.shaper.getNumCells();
    }

    public static Shaper getShaper(Shaper initialShaper, Component parent, Options options, Dimension dim, Image img, BoxBase bb) {
        Holes sh;
        Messages msg = options.getMessages();
        if (initialShaper == null || !(initialShaper instanceof Holes)) {
            return null;
        }
        try {
            sh = (Holes)initialShaper.clone();
        }
        catch (CloneNotSupportedException ex) {
            msg.showErrorWarning(parent, "edit_act_shaper_err", ex);
            return null;
        }
        HolesEditorPanel he = new HolesEditorPanel(options, sh, dim, img, bb);
        boolean b = msg.showInputDlg(parent, he, "edit_act_shaper_properties");
        if (b) {
            he.confirmChanges();
        }
        return b ? sh : null;
    }

    public void updatePreviewArea(double xFactor, double yFactor) {
        if (this.lastWidth != -1.0) {
            this.lastWidth *= xFactor;
            this.lastHeight *= yFactor;
        } else {
            this.lastWidth = this.previewArea.getWidth() * xFactor;
            this.lastHeight = this.previewArea.getHeight() * yFactor;
        }
        this.xFactor *= xFactor;
        this.yFactor *= yFactor;
        this.previewArea = new Rectangle(new Dimension((int)this.lastWidth, (int)this.lastHeight));
        this.updateView();
    }

    public void incDrawingArea(double incWidth, double incHeight) {
        this.modifyDrawingArea((double)this.previewArea.width + incWidth, (double)this.previewArea.height + incHeight);
    }

    protected void modifyDrawingArea(double newWidth, double newHeight) {
        if (newWidth > 0.0 && newHeight > 0.0) {
            double xFactorMod = newWidth / (double)this.previewArea.width;
            double yFactorMod = newHeight / (double)this.previewArea.height;
            for (int i = 0; i < this.shaper.getNumCells(); ++i) {
                ShapeData sd = this.shaper.getShapeData(i);
                sd.scaleTo(xFactorMod, yFactorMod);
            }
            this.previewArea.setSize((int)newWidth, (int)newHeight);
            this.previewDim.setSize(this.previewArea.getSize());
            this.shaper.scaleW = newWidth;
            this.shaper.scaleH = newHeight;
            this.updateView();
        }
    }

    @Override
    public void pointMoved(Point2D p) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.initializing && actionEvent != null) {
            Object obj = actionEvent.getSource();
            if (obj == this.btDivide) {
                this.deselectAll();
                this.requestFocus();
                this.btDivide.setSelected(true);
                this.pdp.setDrawingMode(4);
                this.pdp.deSelectAll();
                this.repaint(0L);
            } else if (obj == this.btDelete) {
                this.clean();
                this.shapeChanged();
                this.repaint(0L);
            } else if (obj == this.btEllipse) {
                this.requestFocus();
                this.pdp.setDrawingMode(6);
            } else if (obj == this.btRect) {
                this.requestFocus();
                this.pdp.setDrawingMode(5);
            } else if (obj == this.btLine) {
                this.requestFocus();
                this.pdp.convertToLine();
                this.repaint(0L);
            } else if (obj == this.btBezier) {
                this.requestFocus();
                this.pdp.convertToBezier();
                this.repaint(0L);
            } else if (obj == this.btQuad) {
                this.requestFocus();
                this.pdp.convertToQuad();
                this.repaint(0L);
            } else if (obj == this.btPolygon) {
                this.requestFocus();
                this.pdp.setDrawingMode(7);
            } else if (obj == this.btSelect) {
                this.requestFocus();
                this.pdp.setDrawingMode(1);
            } else if (obj == this.btShowDrawnPoints) {
                EditableShapeConstants.showDrawnPoints = this.btShowDrawnPoints.isSelected();
                this.repaint(0L);
            } else if (obj == this.btGrid) {
                EditableShapeConstants.gridWidth = this.btGrid.isSelected() ? this.gridSizeEdit.getValue() : -1;
                this.gridSizeEdit.setEnabled(this.btGrid.isSelected());
                this.repaint();
            } else if (obj == this.btMagnet) {
                EditableShapeConstants.pointsOnGrid = this.btMagnet.isSelected();
                this.magnetRadiusEdit.setEnabled(this.btMagnet.isSelected());
                this.repaint(0L);
            } else if (obj == this.btRotateRight) {
                this.pdp.rotate(0.2617993877991494, false, false);
            } else if (obj == this.btRotateLeft) {
                this.pdp.rotate(-0.2617993877991494, false, false);
            } else if (obj == this.btExpand) {
                this.pdp.scale(EditableShapeConstants.scaleXFactor, EditableShapeConstants.scaleYFactor, false, false);
            } else if (obj == this.btContract) {
                if (EditableShapeConstants.scaleXFactor != 0.0 && EditableShapeConstants.scaleYFactor != 0.0) {
                    this.pdp.scale(1.0 / EditableShapeConstants.scaleXFactor, 1.0 / EditableShapeConstants.scaleYFactor, false, false);
                }
            } else if (obj == this.btZoomIn) {
                this.doZoom(true);
            } else if (obj == this.btZoomOut) {
                this.doZoom(false);
            } else if (obj == this.btCopy) {
                this.pdp.copy(false);
                this.updateView();
            } else if (obj == this.btPaste) {
                this.pdp.endPolygon();
                this.pdp.paste();
                this.updateView();
            } else if (obj == this.tfName && this.currentShape >= 0) {
                ShapeData sd = this.getHoles().getShapeData(this.currentShape);
                String txt = this.tfName.getText().trim();
                if (sd != null && txt.length() > 0) {
                    sd.comment = txt;
                }
                this.updateList();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (!this.initializing && ev != null) {
            Object obj = ev.getSource();
            if (obj == this.gridSizeEdit) {
                int v;
                int n = v = this.btGrid.isSelected() ? this.gridSizeEdit.getValue() : -1;
                if (v != EditableShapeConstants.gridWidth) {
                    EditableShapeConstants.gridWidth = v;
                    this.repaint();
                }
            } else if (obj == this.magnetRadiusEdit) {
                int v = this.magnetRadiusEdit.getValue() * 2;
                if (v != EditableShapeConstants.selectLength) {
                    EditableShapeConstants.selectLength = v;
                    this.pdp.initDrawnBorders();
                    this.repaint();
                }
            } else if (obj == this.previewPanel) {
                this.repaint(0L);
            }
        }
    }

    protected void doZoom(boolean in) {
        double den;
        double zoomDelta = 1.0;
        if (in) {
            if (this.zoomFactor < 10) {
                if (this.zoomFactor >= 1) {
                    zoomDelta = ((double)this.zoomFactor + 1.0) / (double)this.zoomFactor;
                } else {
                    den = Math.abs(this.zoomFactor - 2);
                    zoomDelta = 1.0 / (den - 1.0) / (1.0 / den);
                }
                ++this.zoomFactor;
            }
        } else if (this.zoomFactor > -2) {
            if (this.zoomFactor > 1) {
                zoomDelta = ((double)this.zoomFactor - 1.0) / (double)this.zoomFactor;
            } else {
                den = Math.abs(this.zoomFactor - 2);
                zoomDelta = 1.0 / (den + 1.0) / (1.0 / den);
            }
            --this.zoomFactor;
        }
        if (zoomDelta != 1.0) {
            this.pdp.endPolygon();
            this.updatePreviewArea(zoomDelta, zoomDelta);
        }
        this.btZoomIn.setEnabled(this.zoomFactor < 10);
        this.btZoomOut.setEnabled(this.zoomFactor > -2);
        String sFactor = this.zoomFactor >= 1 ? Integer.toString(this.zoomFactor) : "1/" + Math.abs(this.zoomFactor - 2);
        this.lbZoom.setText(sFactor + "x");
    }

    class VP
    extends JPanel {
        private int xBak = -1;
        private int yBak = -1;
        private int wBak = -1;
        private int hBak = -1;
        List<Shape> shapes = new ArrayList<Shape>();

        VP() {
        }

        public void updateView() {
            this.setSize(this.getSize());
            this.setPreferredSize(this.getSize());
            this.updateComponentsView();
        }

        public void updateComponentsView() {
            this.shapes.clear();
            for (int i = 0; i < HolesEditorPanel.this.shaper.getNumCells(); ++i) {
                this.shapes.add(HolesEditorPanel.this.shaper.getShape(i, HolesEditorPanel.this.previewArea));
            }
            if (HolesEditorPanel.this.pdp != null) {
                HolesEditorPanel.this.pdp.updateView();
            }
            super.updateUI();
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            RenderingHints rh = g2.getRenderingHints();
            g2.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
            Color defaultBgColor = g2.getBackground();
            Color defaultColor = g2.getColor();
            g2.setColor(HolesEditorPanel.this.previewBb.backColor);
            g2.fill(HolesEditorPanel.this.previewArea);
            g2.setBackground(HolesEditorPanel.this.previewBb.backColor);
            g2.setColor(HolesEditorPanel.this.previewBb.borderColor);
            Stroke defaultStroke = g2.getStroke();
            g2.setStroke(HolesEditorPanel.this.previewBb.getBorder());
            if (HolesEditorPanel.this.img != null) {
                g2.drawImage(HolesEditorPanel.this.img, HolesEditorPanel.this.previewArea.x, HolesEditorPanel.this.previewArea.y, HolesEditorPanel.this.previewArea.width, HolesEditorPanel.this.previewArea.height, this);
            }
            HolesEditorPanel.this.pdp.drawGrid(g, EditableShapeConstants.gridWidth);
            g2.setColor(Color.black);
            for (int i = 0; i < this.shapes.size(); ++i) {
                if (i == HolesEditorPanel.this.currentShape) continue;
                g2.draw(this.shapes.get(i));
            }
            g2.setColor(Color.red);
            HolesEditorPanel.this.pdp.paint(g2);
            g2.setStroke(defaultStroke);
            g2.setColor(defaultColor);
            g2.setBackground(defaultBgColor);
            g2.setRenderingHints(rh);
        }

        protected void drawBorder(Graphics g, Color c) {
            g.setColor(c);
            g.fillRect(0, 0, (int)HolesEditorPanel.this.previewArea.getX(), this.getHeight());
        }

        @Override
        public void doLayout() {
            HolesEditorPanel.this.previewArea.x = (this.getBounds().width - HolesEditorPanel.this.previewArea.width) / 2;
            HolesEditorPanel.this.previewArea.y = (this.getBounds().height - HolesEditorPanel.this.previewArea.height) / 2;
            if (HolesEditorPanel.this.previewArea.x != this.xBak || HolesEditorPanel.this.previewArea.y != this.yBak || HolesEditorPanel.this.previewArea.width != this.wBak || HolesEditorPanel.this.previewArea.height != this.hBak) {
                this.xBak = HolesEditorPanel.this.previewArea.x;
                this.yBak = HolesEditorPanel.this.previewArea.y;
                this.wBak = HolesEditorPanel.this.previewArea.width;
                this.hBak = HolesEditorPanel.this.previewArea.height;
                HolesEditorPanel.this.pdp.initDrawnBorders();
            }
            this.updateComponentsView();
        }

        @Override
        public Dimension getSize() {
            return new Dimension(HolesEditorPanel.this.previewArea.x + (int)HolesEditorPanel.this.previewArea.getBounds().getWidth(), HolesEditorPanel.this.previewArea.y + (int)HolesEditorPanel.this.previewArea.getBounds().getHeight());
        }
    }

    class PreviewPanel
    extends JScrollPane {
        public VP vp;

        public PreviewPanel() {
            this.vp = new VP();
            this.setViewportView(this.vp);
            this.updateView();
        }

        public void updateView() {
            this.vp.updateView();
        }
    }

    class ShapeListModel
    extends AbstractListModel<Object> {
        ShapeListModel() {
        }

        @Override
        public int getSize() {
            return HolesEditorPanel.this.shaper.shapeData.length;
        }

        @Override
        public Object getElementAt(int index) {
            ShapeData sd = HolesEditorPanel.this.shaper.shapeData[index];
            return sd.comment == null || sd.comment.length() == 0 ? Integer.toString(index) : sd.comment;
        }

        public void switchShapes(int index1, int index2) {
            if (HolesEditorPanel.this.shaper == null || index1 < 0 || index1 >= HolesEditorPanel.this.shaper.shapeData.length || index2 < 0 || index2 < HolesEditorPanel.this.shaper.shapeData.length) {
                // empty if block
            }
        }
    }
}

