/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExportToJSDlg
extends JPanel {
    ResourceBridge rb;
    Options options;
    String outputFolder;
    String scormFile;
    boolean exportAll = true;
    boolean exportScorm = true;
    private JFileChooser chooser;
    private JFileChooser scormFileChooser;
    private JCheckBox allPrjChk;
    private JLabel exportLb;
    private JPanel exportPanel;
    private JCheckBox exportScormChk;
    private JButton outputFolderBtn;
    private JLabel outputFolderLb;
    private JTextField outputFolderText;
    private JButton scormFileBtn;
    private JTextField scormFileText;
    private JLabel scormFolderLb;
    private JPanel scormPanel;
    private JLabel spacer;

    public ExportToJSDlg(ResourceBridge rb) {
        this.rb = rb;
        this.options = rb.getOptions();
        this.initComponents();
    }

    private void initComponents() {
        this.exportPanel = new JPanel();
        this.exportLb = new JLabel();
        this.outputFolderLb = new JLabel();
        this.outputFolderText = new JTextField();
        this.outputFolderBtn = new JButton();
        JLabel spacer2 = new JLabel();
        this.allPrjChk = new JCheckBox();
        this.spacer = new JLabel();
        this.scormPanel = new JPanel();
        this.exportScormChk = new JCheckBox();
        this.scormFolderLb = new JLabel();
        this.scormFileText = new JTextField();
        this.scormFileBtn = new JButton();
        JLabel spacer3 = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.exportPanel.setBorder(BorderFactory.createTitledBorder("HTML5"));
        this.exportPanel.setLayout(new GridBagLayout());
        this.exportLb.setText(this.options.getMsg("export_project_desc"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.exportPanel.add((Component)this.exportLb, gridBagConstraints);
        this.outputFolderLb.setLabelFor(this.outputFolderText);
        this.outputFolderLb.setText(this.options.getMsg("export_project_output_folder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.exportPanel.add((Component)this.outputFolderLb, gridBagConstraints);
        this.outputFolderText.setToolTipText(this.options.getMsg("edit_new_project_folder_tooltip"));
        this.outputFolderText.setMinimumSize(new Dimension(320, 21));
        this.outputFolderText.setPreferredSize(new Dimension(320, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.exportPanel.add((Component)this.outputFolderText, gridBagConstraints);
        this.outputFolderBtn.setText(this.options.getMsg("edit_new_project_folder_browse"));
        this.outputFolderBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportToJSDlg.this.outputFolderBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.exportPanel.add((Component)this.outputFolderBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.exportPanel.add((Component)spacer2, gridBagConstraints);
        this.allPrjChk.setText(this.options.getMsg("export_project_includeAll"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.exportPanel.add((Component)this.allPrjChk, gridBagConstraints);
        this.add(this.exportPanel);
        this.spacer.setPreferredSize(new Dimension(25, 25));
        this.add(this.spacer);
        this.scormPanel.setBorder(BorderFactory.createTitledBorder("SCORM"));
        this.scormPanel.setLayout(new GridBagLayout());
        this.exportScormChk.setText(this.options.getMsg("export_project_exportSCORM"));
        this.exportScormChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportToJSDlg.this.scormSelChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.scormPanel.add((Component)this.exportScormChk, gridBagConstraints);
        this.scormFolderLb.setLabelFor(this.scormFileText);
        this.scormFolderLb.setText(this.options.getMsg("export_project_scorm_file"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.scormPanel.add((Component)this.scormFolderLb, gridBagConstraints);
        this.scormFileText.setToolTipText(this.options.getMsg("export_project_scorm_file_tooltip"));
        this.scormFileText.setMinimumSize(new Dimension(320, 21));
        this.scormFileText.setPreferredSize(new Dimension(320, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.scormPanel.add((Component)this.scormFileText, gridBagConstraints);
        this.scormFileBtn.setText(this.options.getMsg("export_project_scorm_file_browse"));
        this.scormFileBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportToJSDlg.this.scormFileBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.scormPanel.add((Component)this.scormFileBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.scormPanel.add((Component)spacer3, gridBagConstraints);
        this.add(this.scormPanel);
    }

    private void outputFolderBtnActionPerformed(ActionEvent evt) {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            this.chooser.setApproveButtonText(this.options.getMsg("export_project_selectFolder"));
            this.chooser.setFileSelectionMode(1);
        }
        this.outputFolder = StrUtils.nullableString(this.outputFolderText.getText());
        if (this.outputFolder != null) {
            try {
                File f = new File(this.outputFolder);
                if (!f.exists()) {
                    f.mkdirs();
                }
                this.chooser.setSelectedFile(f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.chooser.showOpenDialog(this) == 0) {
            this.outputFolder = this.chooser.getSelectedFile().getAbsolutePath();
            this.outputFolderText.setText(this.outputFolder);
        }
    }

    private void scormFileBtnActionPerformed(ActionEvent evt) {
        if (this.scormFileChooser == null) {
            this.scormFileChooser = new JFileChooser();
            this.scormFileChooser.setFileSelectionMode(0);
        }
        this.scormFile = StrUtils.nullableString(this.scormFileText.getText());
        if (this.scormFile != null) {
            try {
                File f = new File(this.scormFile);
                if (!f.getParentFile().exists()) {
                    f.getParentFile().mkdirs();
                }
                this.scormFileChooser.setSelectedFile(f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.scormFileChooser.showSaveDialog(this) == 0) {
            this.scormFile = this.scormFileChooser.getSelectedFile().getAbsolutePath();
            this.scormFileText.setText(this.scormFile);
        }
    }

    private void scormSelChanged(ActionEvent evt) {
        this.scormFileBtn.setEnabled(this.exportScormChk.isSelected());
        this.scormFolderLb.setEnabled(this.exportScormChk.isSelected());
    }

    public void fillData() {
        this.outputFolderText.setText(this.outputFolder == null ? "" : this.outputFolder);
        this.scormFileText.setText(this.scormFile == null ? "" : this.scormFile);
        this.allPrjChk.setSelected(this.exportAll);
        this.exportScormChk.setSelected(this.exportScorm);
    }

    public void getData() {
        this.outputFolder = StrUtils.nullableString(this.outputFolderText.getText());
        this.exportAll = this.allPrjChk.isSelected();
        this.exportScorm = this.exportScormChk.isSelected();
        this.scormFile = StrUtils.nullableString(this.scormFileText.getText());
    }

    public static String[] prompt(ResourceBridge rb, Component parent, String inputPath, String exportBasePath, String scormBasePath) {
        String[] result = null;
        ExportToJSDlg exportDlg = new ExportToJSDlg(rb);
        Messages msg = rb.getOptions().getMessages();
        File inputFile = new File(inputPath);
        String inputBase = inputFile.getName();
        exportDlg.exportAll = !inputBase.toLowerCase().equals("projects");
        exportDlg.outputFolder = new File(new File(exportBasePath), inputBase).getPath();
        exportDlg.scormFile = new File(new File(scormBasePath), inputBase + ".scorm.zip").getPath();
        exportDlg.fillData();
        while (result == null && msg.showInputDlg(parent, exportDlg, "export_project_title")) {
            exportDlg.getData();
            if (exportDlg.outputFolder == null) {
                msg.showErrorWarning(parent, "export_project_err_empty", null);
                continue;
            }
            try {
                boolean folderOk = true;
                boolean scormOk = true;
                File outputFolderFile = new File(exportDlg.outputFolder);
                if (exportDlg.outputFolder.equals(inputPath)) {
                    msg.showErrorWarning(parent, "export_project_err_sameFolder", null);
                    folderOk = false;
                } else if (exportDlg.outputFolder.startsWith(inputPath)) {
                    msg.showErrorWarning(parent, "export_project_err_nestedFolders", null);
                    folderOk = false;
                } else if (outputFolderFile.exists() && outputFolderFile.isDirectory()) {
                    if (outputFolderFile.list().length > 0) {
                        folderOk = msg.showQuestionDlg(parent, "export_project_warning_noEmptyFolder", null, "yn") == 1;
                    }
                } else if (!outputFolderFile.mkdirs()) {
                    msg.showErrorWarning(parent, "edit_new_project_err_folderCreation", null);
                    folderOk = false;
                }
                if (folderOk && exportDlg.exportScorm) {
                    if (exportDlg.scormFile == null) {
                        msg.showErrorWarning(parent, "export_project_scorm_file_err_empty", null);
                        scormOk = false;
                    } else {
                        File scormFile = new File(exportDlg.scormFile);
                        if (scormFile.exists()) {
                            scormOk = msg.showQuestionDlg(parent, "export_project_scorm_file_exists", null, "yn") == 1;
                        } else if (!scormFile.getParentFile().exists() && !scormFile.getParentFile().mkdirs()) {
                            msg.showErrorWarning(parent, "edit_new_project_err_folderCreation", null);
                            scormOk = false;
                        }
                    }
                }
                if (!folderOk || !scormOk) continue;
                result = new String[]{exportDlg.outputFolder, inputPath, exportDlg.exportAll ? "true" : "false", exportDlg.exportScorm ? exportDlg.scormFile : null};
            }
            catch (Exception ex) {
                msg.showErrorWarning(parent, "ERROR", ex);
            }
        }
        return result;
    }
}

