/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.misc;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.beans.ColorButton;
import edu.xtec.jclic.misc.Gradient;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GradientEditor
extends JPanel {
    Options options;
    Gradient gradient;
    private static Map<Options, GradientEditor> panels = new HashMap<Options, GradientEditor>();
    private ColorButton startColorBtn;
    private JTextField cyclesTxt;
    private ColorButton endColorBtn;
    private JSlider cyclesSlider;
    private JPanel previewPanel;
    private JSlider orientationSlider;
    private JTextField orientationTxt;

    public GradientEditor(Options options, Gradient gradient) {
        this.options = options;
        this.initComponents();
        this.setGradient(gradient);
    }

    private void initComponents() {
        this.previewPanel = new GradientPreview();
        JLabel startColorLb = new JLabel();
        this.startColorBtn = new ColorButton();
        this.startColorBtn.setOptions(this.options);
        JLabel endColorLb = new JLabel();
        this.endColorBtn = new ColorButton();
        this.endColorBtn.setOptions(this.options);
        JLabel cyclesLb = new JLabel();
        this.cyclesTxt = new JTextField();
        this.cyclesSlider = new JSlider();
        JLabel orientationLb = new JLabel();
        this.orientationTxt = new JTextField();
        this.orientationSlider = new JSlider();
        this.setLayout(new GridBagLayout());
        this.previewPanel.setBorder(new SoftBevelBorder(0));
        this.previewPanel.setPreferredSize(new Dimension(100, 100));
        this.previewPanel.setMinimumSize(new Dimension(100, 100));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        this.add((Component)this.previewPanel, gridBagConstraints);
        startColorLb.setText(this.options.getMsg("edit_gradient_startColor"));
        startColorLb.setLabelFor(this.startColorBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.add((Component)startColorLb, gridBagConstraints);
        this.startColorBtn.setToolTipText(this.options.getMsg("edit_gradient_startColor_tooltip"));
        this.startColorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GradientEditor.this.startColorBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.startColorBtn, gridBagConstraints);
        endColorLb.setText(this.options.getMsg("edit_gradient_endColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.add((Component)endColorLb, gridBagConstraints);
        this.endColorBtn.setToolTipText(this.options.getMsg("edit_gradient_endColor_tooltip"));
        this.endColorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GradientEditor.this.endColorBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.endColorBtn, gridBagConstraints);
        cyclesLb.setText(this.options.getMsg("edit_gradient_cycles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.add((Component)cyclesLb, gridBagConstraints);
        this.cyclesTxt.setToolTipText(this.options.getMsg("edit_gradient_cycles_tooltip"));
        this.cyclesTxt.setPreferredSize(new Dimension(40, 21));
        this.cyclesTxt.setMinimumSize(new Dimension(40, 21));
        this.cyclesTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GradientEditor.this.cyclesTxtActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cyclesTxt, gridBagConstraints);
        this.cyclesSlider.setMinorTickSpacing(10);
        this.cyclesSlider.setPaintTicks(true);
        this.cyclesSlider.setMinimum(1);
        this.cyclesSlider.setMajorTickSpacing(10);
        this.cyclesSlider.setToolTipText(this.options.getMsg("edit_gradient_cycles_tooltip"));
        this.cyclesSlider.setMaximum(50);
        this.cyclesSlider.setPreferredSize(new Dimension(100, 27));
        this.cyclesSlider.setMinimumSize(new Dimension(100, 27));
        this.cyclesSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GradientEditor.this.cyclesSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cyclesSlider, gridBagConstraints);
        orientationLb.setText(this.options.getMsg("edit_gradient_orientation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.add((Component)orientationLb, gridBagConstraints);
        this.orientationTxt.setToolTipText(this.options.getMsg("edit_gradient_orientation_tooltip"));
        this.orientationTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GradientEditor.this.orientationTxtActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.orientationTxt, gridBagConstraints);
        this.orientationSlider.setMinorTickSpacing(30);
        this.orientationSlider.setPaintTicks(true);
        this.orientationSlider.setMajorTickSpacing(90);
        this.orientationSlider.setToolTipText(this.options.getMsg("edit_gradient_orientation_tooltip"));
        this.orientationSlider.setMaximum(360);
        this.orientationSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GradientEditor.this.orientationSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.orientationSlider, gridBagConstraints);
    }

    private void endColorBtnActionPerformed(ActionEvent evt) {
        this.gradient.setColors(this.startColorBtn.getColor(), this.endColorBtn.getColor());
        this.previewPanel.repaint();
    }

    private void startColorBtnActionPerformed(ActionEvent evt) {
        this.gradient.setColors(this.startColorBtn.getColor(), this.endColorBtn.getColor());
        this.previewPanel.repaint();
    }

    private void orientationSliderStateChanged(ChangeEvent evt) {
        int v = this.orientationSlider.getValue();
        this.orientationTxt.setText(Integer.toString(v));
        this.orientationSlider.setValue(v);
        this.gradient.setAngle(v);
        this.previewPanel.repaint();
    }

    private void cyclesSliderStateChanged(ChangeEvent evt) {
        int v = this.cyclesSlider.getValue();
        this.cyclesTxt.setText(Integer.toString(v));
        this.cyclesSlider.setValue(v);
        this.gradient.setCycles(v);
        this.previewPanel.repaint();
    }

    private void orientationTxtActionPerformed(ActionEvent evt) {
        int v = this.gradient.angle;
        try {
            v = Math.max(0, Integer.parseInt(this.orientationTxt.getText())) % 360;
        }
        catch (Exception ex) {
            this.options.getMessages().showErrorWarning(this, "ERROR", ex);
        }
        this.orientationTxt.setText(Integer.toString(v));
        this.orientationSlider.setValue(v);
        this.gradient.setAngle(v);
        this.previewPanel.repaint();
    }

    private void cyclesTxtActionPerformed(ActionEvent evt) {
        int v = this.gradient.cycles;
        try {
            v = Math.max(1, Integer.parseInt(this.cyclesTxt.getText()));
        }
        catch (Exception ex) {
            this.options.getMessages().showErrorWarning(this, "ERROR", ex);
        }
        this.cyclesTxt.setText(Integer.toString(v));
        this.cyclesSlider.setValue(v);
        this.gradient.setCycles(v);
        this.previewPanel.repaint();
    }

    public void setGradient(Gradient g) {
        if (g == null) {
            g = new Gradient();
        }
        this.gradient = new Gradient(g.getColors()[0], g.getColors()[1], g.getAngle(), g.getCycles());
        this.startColorBtn.setColor(this.gradient.c1);
        this.endColorBtn.setColor(this.gradient.c2);
        this.cyclesSlider.setValue(this.gradient.cycles);
        this.cyclesTxt.setText(Integer.toString(this.gradient.cycles));
        this.orientationSlider.setValue(this.gradient.angle);
        this.orientationTxt.setText(Integer.toString(this.gradient.angle));
    }

    public static Gradient getGradient(Gradient initialGradient, Component parent, Options options) {
        Messages msg = options.getMessages();
        GradientEditor ge = panels.get(options);
        if (ge == null) {
            ge = new GradientEditor(options, initialGradient);
            panels.put(options, ge);
        } else {
            ge.setGradient(initialGradient);
        }
        boolean b = msg.showInputDlg(parent, ge, "edit_gradient_title");
        return b ? ge.gradient : null;
    }

    class GradientPreview
    extends JPanel {
        GradientPreview() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            RenderingHints rh = g2.getRenderingHints();
            g2.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
            GradientEditor.this.gradient.paint(g2, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            g2.setRenderingHints(rh);
        }
    }
}

