/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.beans.BoxBaseButton;
import edu.xtec.jclic.beans.ImgButton;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBagContentEditor;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.ActiveBoxGrid;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.shapers.Shaper;
import edu.xtec.util.CtrlPanel;
import edu.xtec.util.Options;
import edu.xtec.util.TripleString;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JToggleButton;

public class ActiveBagContentControlPanel
extends CtrlPanel {
    ActiveBagContentEditor parent;
    ActiveBagContent abc;
    ActiveBagContent altAbc;
    ActiveBagContentControlPanel syncPanel;
    boolean altNull;
    Options options;
    int index;
    int altIndex;
    int visualIndex;
    boolean simpleMode;
    private JCheckBox altChk;
    private JCheckBox borderChk;
    private BoxBaseButton boxBaseButton;
    private SmallIntEditor heightEdit;
    private ImgButton imgButton;
    private JLabel imgLb;
    private SmallIntEditor nColsEdit;
    private JLabel nColsLb;
    private SmallIntEditor nRowsEdit;
    private JLabel nRowsLb;
    private JCheckBox scrambleChk;
    private JComboBox<Object> shaperCombo;
    private JButton shaperEditBtn;
    private JLabel shaperLb;
    private JToggleButton toggleAlt;
    private SmallIntEditor widthEdit;

    public ActiveBagContentControlPanel(ActiveBagContentEditor parent, int index, int altIndex, int visualIndex, boolean simpleMode) {
        this.setInitializing(true);
        this.simpleMode = simpleMode;
        this.parent = parent;
        this.options = parent.getOptions();
        this.index = index;
        this.altIndex = altIndex;
        this.visualIndex = visualIndex;
        this.altNull = altIndex >= 0;
        this.initComponents();
        if (altIndex < 0 || simpleMode) {
            this.altChk.setEnabled(false);
            this.altChk.setVisible(false);
            this.toggleAlt.setEnabled(false);
            this.toggleAlt.setVisible(false);
        }
        if (simpleMode) {
            this.shaperLb.setVisible(false);
            this.shaperCombo.setVisible(false);
            this.shaperEditBtn.setVisible(false);
            this.scrambleChk.setVisible(false);
            this.nRowsLb.setVisible(false);
            this.nRowsEdit.setVisible(false);
            this.nColsLb.setVisible(false);
            this.nColsEdit.setVisible(false);
            this.imgLb.setVisible(false);
            this.imgButton.setVisible(false);
        }
        this.setInitializing(false);
    }

    protected void setSyncpanel(ActiveBagContentControlPanel syncPanel) {
        this.syncPanel = syncPanel;
    }

    private void initComponents() {
        JLabel spacer3 = new JLabel();
        this.shaperLb = new JLabel();
        this.shaperCombo = new JComboBox<Object>(Shaper.getSystemShaperList(this.options).toArray());
        this.shaperEditBtn = new JButton();
        this.scrambleChk = new JCheckBox();
        this.altChk = new JCheckBox();
        this.toggleAlt = new JToggleButton();
        JLabel spacer2 = new JLabel();
        this.nRowsLb = new JLabel();
        this.nRowsEdit = new SmallIntEditor();
        this.nColsLb = new JLabel();
        this.nColsEdit = new SmallIntEditor();
        this.imgLb = new JLabel();
        this.imgButton = new ImgButton();
        this.imgButton.setOptions(this.options);
        JLabel widthLb = new JLabel();
        this.widthEdit = new SmallIntEditor();
        JLabel heightLb = new JLabel();
        this.heightEdit = new SmallIntEditor();
        JLabel styleLb = new JLabel();
        this.boxBaseButton = new BoxBaseButton();
        this.boxBaseButton.setOptions(this.options);
        this.borderChk = new JCheckBox();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)spacer3, gridBagConstraints);
        this.shaperLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/select_shaper.gif")));
        this.shaperLb.setLabelFor(this.shaperCombo);
        this.shaperLb.setText(":");
        this.shaperLb.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.shaperLb, gridBagConstraints);
        this.shaperCombo.setToolTipText(this.options.getMsg("edit_act_shaper_tooltip"));
        this.shaperCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add(this.shaperCombo, gridBagConstraints);
        this.shaperEditBtn.setText("...");
        this.shaperEditBtn.setMargin(new Insets(0, 4, 0, 4));
        this.shaperEditBtn.setEnabled(false);
        this.shaperEditBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.shaperEditBtn, gridBagConstraints);
        this.scrambleChk.setText(this.options.getMsg("edit_act_scramble"));
        this.scrambleChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.scrambleChk, gridBagConstraints);
        this.altChk.setToolTipText(this.options.getMsg("edit_act_alt_tooltip"));
        this.altChk.setText(this.options.getMsg("edit_act_alt"));
        this.altChk.setHorizontalTextPosition(2);
        this.altChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.altChk, gridBagConstraints);
        this.toggleAlt.setToolTipText(this.options.getMsg("edit_act_alt_toggle_tooltip"));
        this.toggleAlt.setText(this.options.getMsg("edit_act_alt_toggle"));
        this.toggleAlt.setMargin(new Insets(0, 4, 0, 4));
        this.toggleAlt.setEnabled(false);
        this.toggleAlt.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.toggleAlt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)spacer2, gridBagConstraints);
        this.nRowsLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/adjust_rows.gif")));
        this.nRowsLb.setLabelFor(this.nRowsEdit);
        this.nRowsLb.setText(":");
        this.nRowsLb.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.nRowsLb, gridBagConstraints);
        this.nRowsEdit.setToolTipText(this.options.getMsg("edit_act_num_rows_tooltip"));
        this.nRowsEdit.setMax(30);
        this.nRowsEdit.setMin(1);
        this.nRowsEdit.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.nRowsEdit, gridBagConstraints);
        this.nColsLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/adjust_cols.gif")));
        this.nColsLb.setLabelFor(this.nColsEdit);
        this.nColsLb.setText(":");
        this.nColsLb.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.nColsLb, gridBagConstraints);
        this.nColsEdit.setToolTipText(this.options.getMsg("edit_act_num_cols_tooltip"));
        this.nColsEdit.setMax(30);
        this.nColsEdit.setMin(1);
        this.nColsEdit.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.nColsEdit, gridBagConstraints);
        this.imgLb.setLabelFor(this.imgButton);
        this.imgLb.setText(this.options.getMsg("edit_act_image"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.imgLb, gridBagConstraints);
        this.imgButton.setToolTipText(this.options.getMsg("edit_act_image_tooltip"));
        this.imgButton.addPropertyChangeListener("imageName", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.imgButton, gridBagConstraints);
        widthLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/adjust_width.gif")));
        widthLb.setLabelFor(this.widthEdit);
        widthLb.setText(":");
        widthLb.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)widthLb, gridBagConstraints);
        this.widthEdit.setToolTipText(this.options.getMsg("edit_act_cell_width_tooltip"));
        this.widthEdit.setMax(999);
        this.widthEdit.setMin(10);
        this.widthEdit.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.widthEdit, gridBagConstraints);
        heightLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/adjust_height.gif")));
        heightLb.setLabelFor(this.heightEdit);
        heightLb.setText(":");
        heightLb.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)heightLb, gridBagConstraints);
        this.heightEdit.setToolTipText(this.options.getMsg("edit_act_cell_height_tooltip"));
        this.heightEdit.setMax(999);
        this.heightEdit.setMin(10);
        this.heightEdit.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.heightEdit, gridBagConstraints);
        styleLb.setLabelFor(this.boxBaseButton);
        styleLb.setText(this.options.getMsg("edit_act_style"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)styleLb, gridBagConstraints);
        this.boxBaseButton.setToolTipText(this.options.getMsg("edit_style_tooltip"));
        this.boxBaseButton.addPropertyChangeListener("boxBase", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.boxBaseButton, gridBagConstraints);
        this.borderChk.setText(this.options.getMsg("edit_act_border"));
        this.borderChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.borderChk, gridBagConstraints);
    }

    @Override
    public boolean eventPerformed(EventObject ev) {
        boolean result = true;
        if (this.abc != null && ev != null && ev.getSource() != null) {
            Object src = ev.getSource();
            if (src == this.altChk) {
                this.altChkActionPerformed();
            } else if (src == this.toggleAlt) {
                this.toggleAltActionPerformed();
                result = false;
            } else if (src == this.shaperCombo) {
                this.shaperComboActionPerformed();
            } else if (src == this.shaperEditBtn) {
                result = this.shaperEditBtnActionPerformed();
            } else if (src == this.boxBaseButton) {
                this.boxBaseButtonActionPerformed();
            } else if (src == this.imgButton) {
                this.imgButtonActionPerformed();
            } else if (src == this.borderChk) {
                this.borderChkActionPerformed();
            }
            if (src == this.widthEdit || src == this.heightEdit) {
                this.parent.abcpp.doResize(this.visualIndex, this.widthEdit.getValue(), this.heightEdit.getValue(), true);
            } else {
                if (src == this.nColsEdit || src == this.nRowsEdit || src == this.shaperCombo || src == this.shaperEditBtn) {
                    this.shaperChange();
                    this.sync();
                }
                this.parent.abcpp.setActiveBagContent(this.visualIndex, this.abc, this.altNull ? null : this.altAbc, null);
                ActiveBoxBag abg = (ActiveBoxBag)this.parent.abcpp.getAbstractBox(this.visualIndex);
                if (abg != null) {
                    this.boxBaseButton.setPreview(abg);
                    abg.setAlternative(this.toggleAlt.isSelected());
                }
            }
        }
        return result;
    }

    protected void resized() {
        if (this.abc != null) {
            this.widthEdit.setValue((int)this.abc.w);
            this.heightEdit.setValue((int)this.abc.h);
        }
    }

    public void fillData(Activity act) {
        this.abc = act != null && act.abc != null && act.abc.length > this.index ? act.abc[this.index] : null;
        this.altAbc = act != null && act.abc != null && this.altIndex >= 0 && this.altIndex < act.abc.length ? act.abc[this.altIndex] : null;
        this.setActiveBagContent(this.abc, this.altAbc);
        this.scrambleChk.setSelected(act != null && (act.shuffleAlways() || act.scramble != null && act.scramble.length > this.index && act.scramble[this.index]));
        this.scrambleChk.setEnabled(act != null && !act.shuffleAlways());
    }

    public void setActiveBagContent(ActiveBagContent abc, ActiveBagContent altAbc) {
        this.abc = abc;
        this.altAbc = altAbc;
        boolean bl = this.altNull = altAbc == null;
        if (abc != null && !this.simpleMode) {
            abc.checkCells();
        }
        if (altAbc != null && !this.simpleMode) {
            altAbc.checkCells();
        }
        this.altChk.setSelected(!this.altNull);
        this.altChk.setEnabled(abc != null);
        this.toggleAlt.setSelected(false);
        this.toggleAlt.setEnabled(!this.altNull);
        this.imgButton.setMediaBagEditor(this.parent.mediaBagEditor);
        this.imgButton.setImgName(abc != null ? abc.imgName : null);
        this.imgButton.setEnabled(abc != null);
        this.boxBaseButton.setBoxBase(abc != null ? abc.bb : null);
        this.parent.abcpp.setActiveBagContent(this.visualIndex, abc, altAbc, null);
        this.boxBaseButton.setPreview(this.parent.abcpp.getAbstractBox(this.visualIndex));
        this.boxBaseButton.setEnabled(abc != null);
        Shaper sh = abc != null ? abc.getShaper() : null;
        ComboBoxModel<Object> model = this.shaperCombo.getModel();
        int modelSize = model.getSize();
        int i = -1;
        if (sh != null) {
            TripleString ts;
            String s = sh.getClassName();
            for (i = 0; i < modelSize && !s.equals((ts = (TripleString)model.getElementAt(i)).getClassName()); ++i) {
            }
        }
        this.shaperCombo.setSelectedIndex(i < modelSize ? i : -1);
        this.shaperCombo.setEnabled(abc != null);
        this.shaperEditBtn.setEnabled(sh != null && sh.getEditorPanelClassName() != null);
        this.nColsEdit.setValue(sh != null ? sh.getNumColumns() : 1);
        this.nColsEdit.setEnabled(abc != null);
        this.nRowsEdit.setValue(sh != null ? sh.getNumRows() : 1);
        this.nRowsEdit.setEnabled(abc != null);
        this.widthEdit.setValue(abc != null ? (int)abc.w : 30);
        this.widthEdit.setEnabled(abc != null);
        this.heightEdit.setValue(abc != null ? (int)abc.h : 20);
        this.heightEdit.setEnabled(abc != null);
        this.borderChk.setSelected(abc != null ? abc.border : false);
        this.borderChk.setEnabled(abc != null);
    }

    public void saveData(Activity act) {
        if (act != null && act.abc != null && act.abc.length > this.index) {
            act.abc[this.index] = this.abc;
            act.scramble[this.index] = this.scrambleChk.isSelected();
            if (this.altIndex >= 0 && this.altIndex < act.abc.length) {
                act.abc[this.altIndex] = this.altNull ? null : this.altAbc;
            }
        }
    }

    private void altChkActionPerformed() {
        if (this.toggleAlt.isSelected()) {
            this.toggleAlt.setSelected(false);
            this.toggleAltActionPerformed();
        }
        boolean bl = this.altNull = !this.altChk.isSelected();
        if (this.abc != null && !this.altNull && this.altAbc == null) {
            this.altAbc = ActiveBagContent.initNew(this.abc.ncw, this.abc.nch, 65);
            if (this.parent.abcpp != null) {
                this.parent.abcpp.setActiveBagContent(this.visualIndex, this.abc, this.altAbc, null);
            }
        }
        this.toggleAlt.setEnabled(!this.altNull);
    }

    private void toggleAltActionPerformed() {
        if (this.abc != null && !this.altNull && this.altAbc != null && this.parent.abcpp != null && this.parent.abcpp.getAbstractBox(this.visualIndex) != null) {
            boolean alt = this.toggleAlt.isSelected();
            ((ActiveBoxGrid)this.parent.abcpp.getAbstractBox(this.visualIndex)).setAlternative(alt);
            this.imgButton.setImgName(alt ? this.altAbc.imgName : this.abc.imgName);
        }
    }

    private void shaperComboActionPerformed() {
        TripleString ts = (TripleString)this.shaperCombo.getSelectedItem();
    }

    private boolean shaperEditBtnActionPerformed() {
        if (this.abc == null) {
            return false;
        }
        AbstractBox bx = this.parent.abcpp.getAbstractBox(this.visualIndex);
        Dimension d = new Dimension((int)bx.getWidth(), (int)bx.getHeight());
        Dimension dBak = (Dimension)d.clone();
        Shaper sh = this.abc.shaper.edit(this, this.options, d, this.abc.img, bx.getBoxBaseResolve());
        if (sh == null) {
            return false;
        }
        this.abc.setShaper(sh);
        this.abc.ncw = Math.max(1, sh.getNumColumns());
        this.abc.nch = Math.max(1, sh.getNumRows());
        this.nColsEdit.setValue(this.abc.ncw);
        this.nRowsEdit.setValue(this.abc.nch);
        this.abc.checkCells();
        if (!dBak.equals(d)) {
            this.abc.w = d.width / this.abc.ncw;
            this.abc.h = d.height / this.abc.nch;
        }
        return true;
    }

    private void boxBaseButtonActionPerformed() {
        BoxBase bb = this.boxBaseButton.getBoxBase();
        if (this.abc != null && bb != null) {
            this.abc.setBoxBase(bb);
            if (this.altAbc != null && this.simpleMode) {
                this.altAbc.setBoxBase(bb);
            }
        }
    }

    private void imgButtonActionPerformed() {
        if (this.abc != null) {
            ActiveBagContent abcDest;
            ActiveBagContent activeBagContent = abcDest = this.toggleAlt.isSelected() ? this.altAbc : this.abc;
            if (abcDest.imgName != null) {
                abcDest.img = null;
            }
            abcDest.imgName = this.imgButton.getImgName();
            if (this.parent.mediaBagEditor != null) {
                try {
                    if (abcDest.imgName != null) {
                        abcDest.setImgContent(this.parent.mediaBagEditor.getMediaBag().getImageElement(abcDest.imgName), true);
                    } else {
                        abcDest.setImgContent(null, false);
                    }
                }
                catch (Exception ex) {
                    this.options.getMessages().showErrorWarning(this, "ERROR", ex);
                }
            }
        }
    }

    protected void sync() {
        if (this.abc != null && this.syncPanel != null && this.syncPanel.abc != null) {
            this.syncPanel.nColsEdit.setValue(this.nColsEdit.getValue());
            this.syncPanel.nRowsEdit.setValue(this.nRowsEdit.getValue());
            this.syncPanel.shaperCombo.setSelectedItem(this.shaperCombo.getSelectedItem());
            this.syncPanel.shaperChange();
        }
    }

    private void shaperChange() {
        if (this.abc == null) {
            return;
        }
        try {
            this.abc.ncw = this.nColsEdit.getValue();
            this.abc.nch = this.nRowsEdit.getValue();
            TripleString ts = (TripleString)this.shaperCombo.getSelectedItem();
            String newShaperClass = ts.getClassName();
            if (!this.abc.getShaper().getClassName().equals(newShaperClass)) {
                this.abc.setShaper(Shaper.createShaper(newShaperClass, this.abc.ncw, this.abc.nch));
                this.abc.checkCells();
            } else {
                this.abc.getShaper().reset(this.abc.ncw, this.abc.nch);
                this.abc.checkCells();
            }
            if (this.abc.imgName != null) {
                this.abc.setImgContent(this.parent.mediaBagEditor.getMediaBag().getImageElement(this.abc.imgName), true);
            }
            if (this.altAbc != null) {
                this.altAbc.setShaper(this.abc.getShaper());
                this.altAbc.checkCells();
                if (this.altAbc.imgName != null) {
                    this.altAbc.setImgContent(this.parent.mediaBagEditor.getMediaBag().getImageElement(this.altAbc.imgName), true);
                }
            }
            this.shaperEditBtn.setEnabled(this.abc.getShaper().getEditorPanelClassName() != null);
        }
        catch (Exception ex) {
            this.options.getMessages().showErrorWarning(this, "edit_act_shaper_err", ex);
        }
    }

    private void borderChkActionPerformed() {
        if (this.abc != null) {
            this.abc.border = this.borderChk.isSelected();
        }
    }
}

