/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.beans;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class Compass
extends JPanel {
    public static final String PROP_DIRECTION = "direction";
    public static final String[] BT_NAMES = new String[]{"nw", "n", "ne", "w", "c", "e", "sw", "s", "se"};
    public static final Dimension BT_DIMENSION = new Dimension(16, 16);
    private JToggleButton[] buttons;
    private int direction;

    public Compass() {
        super(new GridLayout(3, 3));
        this.setOpaque(false);
        this.direction = -1;
        ActionListener lst = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String c = ev.getActionCommand();
                for (int i = 0; i < 9; ++i) {
                    if (!BT_NAMES[i].equals(c)) continue;
                    Compass.this.setDirection(i);
                    break;
                }
            }
        };
        ButtonGroup bg = new ButtonGroup();
        this.buttons = new JToggleButton[9];
        for (int i = 0; i < 9; ++i) {
            JToggleButton btn = new JToggleButton(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/" + BT_NAMES[i] + ".gif")));
            btn.setPreferredSize(BT_DIMENSION);
            bg.add(btn);
            btn.setActionCommand(BT_NAMES[i]);
            btn.addActionListener(lst);
            btn.setFocusPainted(false);
            this.add(btn);
            this.buttons[i] = btn;
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int value) {
        int oldValue = this.direction;
        this.direction = value;
        this.firePropertyChange(PROP_DIRECTION, oldValue, this.direction);
        if (value >= 0) {
            if (this.buttons[value] != null && !this.buttons[value].isSelected()) {
                this.buttons[value].setSelected(true);
            }
        } else if (oldValue >= 0) {
            this.buttons[oldValue].setSelected(false);
        }
    }

    public int[] getDoubleDirection() {
        int[] result = new int[2];
        int v = this.direction < 0 ? 4 : this.direction;
        result[0] = v % 3;
        result[1] = v / 3;
        return result;
    }

    public void setDoubleDirection(int[] value) {
        if (value == null || value.length != 2 || value[0] < 0 || value[1] < 0) {
            this.setDirection(-1);
        } else {
            this.setDirection(3 * value[1] + value[0]);
        }
    }
}

