/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.ActivityEditor;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import edu.xtec.util.TripleString;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectActivityClass
extends JPanel {
    Options options;
    private List<TripleString> activityClasses;
    private List<TripleString> currentSet;
    private String currentClassName;
    private static final String TYPE_STYLE = "font-family:Helvetica;font-size:12;font-weight:bold;";
    private static final String DESC_STYLE = "font-family:Helvetica;font-size:12;";
    private JLabel alertLabel;
    protected JTextField classField;
    private JList classList;
    private JEditorPane descText;
    private JSplitPane jSplitPane1;
    private JPanel promptPanel;
    private JScrollPane scroll2;

    public SelectActivityClass(Options options) {
        this.options = options;
        this.activityClasses = ActivityEditor.getSystemActivityList(options);
        this.currentSet = new ArrayList<TripleString>();
        this.initComponents();
        this.classList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SelectActivityClass.this.updateSelection();
                }
            }
        });
        this.setListFilter(null, true);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        JScrollPane scroll = new JScrollPane();
        this.classList = new JList();
        JPanel rightPanel = new JPanel();
        this.scroll2 = new JScrollPane();
        this.descText = new JEditorPane();
        this.promptPanel = new JPanel();
        JLabel classLb = new JLabel();
        this.classField = new JTextField();
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(500, 300));
        this.setLayout(new BorderLayout());
        scroll.setMinimumSize(new Dimension(100, 200));
        this.classList.setMinimumSize(new Dimension(200, 0));
        scroll.setViewportView(this.classList);
        this.jSplitPane1.setLeftComponent(scroll);
        rightPanel.setLayout(new GridBagLayout());
        this.scroll2.setMinimumSize(new Dimension(200, 200));
        this.descText.setEditable(false);
        this.descText.setContentType("text/html");
        this.scroll2.setViewportView(this.descText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        rightPanel.add((Component)this.scroll2, gridBagConstraints);
        this.promptPanel.setLayout(new GridBagLayout());
        classLb.setText(this.options.getMsg("edit_act_newActivity_class"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.promptPanel.add((Component)classLb, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.promptPanel.add((Component)this.classField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        rightPanel.add((Component)this.promptPanel, gridBagConstraints);
        this.jSplitPane1.setRightComponent(rightPanel);
        this.add((Component)this.jSplitPane1, "Center");
    }

    public final void setListFilter(String[] allowedClasses, boolean allowOther) {
        ArrayList<TripleString> v = new ArrayList<TripleString>();
        if (allowedClasses != null) {
            for (int i = 0; i < allowedClasses.length; ++i) {
                int p = TripleString.getFirstItemWithClass(this.activityClasses, allowedClasses[i]);
                if (p < 0) continue;
                v.add(this.activityClasses.get(p));
            }
        } else {
            v.addAll(this.activityClasses);
        }
        if (allowOther) {
            v.add(new TripleString(this.options.getMsg("edit_act_newActivity_other"), null, null));
        }
        this.classList.setListData(v.toArray());
        this.currentSet = v;
        this.setCurrentClassName(this.currentClassName);
    }

    private void updateSelection() {
        Object o = this.classList.getSelectedValue();
        boolean showPrompt = false;
        if (o instanceof TripleString) {
            TripleString ts = (TripleString)o;
            this.currentClassName = ts.getClassName();
            this.descText.setContentType("text/html");
            this.descText.setText(this.getFormattedHtmlText(ts.toString(), ts.getDescription(), ts.getClassName()));
        } else if (o != null) {
            showPrompt = true;
            this.currentClassName = StrUtils.nullableString(this.classField.getText());
            this.descText.setContentType("text/html");
            this.descText.setText(this.getFormattedHtmlText(o.toString(), this.options.getMsg("edit_act_newActivity_info"), null));
        } else {
            this.currentClassName = null;
            this.descText.setContentType("text/html");
            this.descText.setText("");
        }
        this.promptPanel.setVisible(showPrompt);
        if (this.classList.getSelectedIndex() >= 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SelectActivityClass.this.classList.ensureIndexIsVisible(SelectActivityClass.this.classList.getSelectedIndex());
                }
            });
        }
    }

    String getFormattedHtmlText(String type, String desc, String className) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        if (type != null) {
            sb.append("<p style=\"").append(TYPE_STYLE).append("\">").append(type).append("</p>");
        }
        if (desc != null) {
            sb.append("<p style=\"").append(DESC_STYLE).append("\">").append(desc).append("</p>");
        }
        if (className != null) {
            sb.append("<p style=\"").append(DESC_STYLE).append("\">");
            sb.append(this.options.getMsg("edit_act_newActivity_class")).append(" <i>").append(className);
            sb.append("</i></p>");
        }
        sb.append("</body></html>");
        return sb.substring(0);
    }

    public String getCurrentClassName() {
        this.updateSelection();
        return StrUtils.nullableString(this.currentClassName);
    }

    public void setCurrentClassName(String currentClassName) {
        this.currentClassName = currentClassName;
        if (currentClassName != null) {
            int p = TripleString.getFirstItemWithClass(this.currentSet, currentClassName);
            if (p >= 0) {
                this.classList.setSelectedIndex(p);
            } else {
                this.classField.setText(StrUtils.secureString(currentClassName));
            }
        }
        this.updateSelection();
    }

    public void setAlertMsg(String alertMsg) {
        if (this.alertLabel != null) {
            this.remove(this.alertLabel);
        }
        this.alertLabel = new JLabel(alertMsg);
        this.add((Component)this.alertLabel, "North");
    }
}

