/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.ActivityBagElementEditor;
import edu.xtec.jclic.bags.ActivitySequenceEditor;
import edu.xtec.jclic.bags.ActivitySequenceEditorPanel;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.bags.ActivitySequenceElementEditor;
import edu.xtec.jclic.bags.ActivitySequenceJump;
import edu.xtec.jclic.bags.ConditionalJumpInfo;
import edu.xtec.jclic.bags.ConditionalJumpPanel;
import edu.xtec.jclic.bags.JumpInfo;
import edu.xtec.jclic.beans.NullableObject;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.util.CustomListCellRenderer;
import edu.xtec.util.ListComboModel;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;

public class ActivitySequenceElementEditorPanel
extends EditorPanel {
    String[] fwdOptions;
    String[] backOptions;
    Icon[] fwdIcons;
    Icon[] backIcons;
    protected ListComboModel actModel;
    protected ListComboModel jmpTagModel;
    protected JComboBox<Object> tagCombo;
    protected JTextField prjEdit;
    protected JComponent[] prompt_objects;
    protected String[] prompt_keys;
    protected String[] prompt_msg;
    private static final String[] FWD_OPTIONS_KEYS = new String[]{"edit_seq_action_fwd", "edit_seq_action_jump", "edit_seq_action_stop", "edit_seq_action_return", "edit_seq_action_exit"};
    private static final String[] FWD_OPTIONS_ICONS = new String[]{"seq_next", "seq_next_jump", "seq_next_stop", "seq_next_return", "seq_exit"};
    private static final String[] BACK_OPTIONS_KEYS = new String[]{"edit_seq_action_back", "edit_seq_action_jump", "edit_seq_action_stop", "edit_seq_action_return", "edit_seq_action_exit"};
    private static final String[] BACK_OPTIONS_ICONS = new String[]{"seq_prev", "seq_prev_jump", "seq_prev_stop", "seq_prev_return", "seq_exit"};
    private JComboBox<Object> actCombo;
    private JCheckBox autoChk;
    private JComboBox<Object> backActionCombo;
    private JCheckBox backEnabledChk;
    private JButton backJumpBtn;
    private JLabel backJumpLb;
    private SmallIntEditor delayEditor;
    private JTextArea descText;
    private JButton editActBtn;
    private JComboBox<Object> fwdActionCombo;
    private JCheckBox fwdEnabledChk;
    private JButton fwdJumpBtn;
    private JLabel fwdJumpLb;
    private NullableObject lowerBtn;
    private JPanel mainPanel;
    private JScrollPane scroll;
    private JTextField tagText;
    private NullableObject upperBtn;

    public ActivitySequenceElementEditorPanel(Options options) {
        super(options);
        this.initObjects();
        this.initComponents();
        this.postInit(250, false, false);
        this.setEnabled(false);
    }

    private void initObjects() {
        int l = FWD_OPTIONS_KEYS.length;
        this.fwdOptions = new String[l];
        this.fwdIcons = new Icon[l];
        this.backOptions = new String[l];
        this.backIcons = new Icon[l];
        for (int i = 0; i < FWD_OPTIONS_KEYS.length; ++i) {
            this.fwdOptions[i] = this.options.getMsg(FWD_OPTIONS_KEYS[i]);
            this.fwdIcons[i] = ResourceManager.getImageIcon("icons/" + FWD_OPTIONS_ICONS[i] + ".gif");
            this.backOptions[i] = this.options.getMsg(BACK_OPTIONS_KEYS[i]);
            this.backIcons[i] = ResourceManager.getImageIcon("icons/" + BACK_OPTIONS_ICONS[i] + ".gif");
        }
        this.tagCombo = new JComboBox();
        this.tagCombo.setEditable(true);
        this.tagCombo.addActionListener(this);
        this.prjEdit = new JTextField();
        this.prompt_objects = new JComponent[]{this.tagCombo, this.prjEdit};
        this.prompt_keys = new String[]{"edit_seq_tag", "edit_seq_project"};
        this.prompt_msg = new String[]{"edit_seq_jump_msg"};
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        JLabel actLabel = new JLabel();
        this.actCombo = new JComboBox();
        this.editActBtn = new JButton();
        this.editActBtn.addActionListener(this);
        JLabel tagLabel = new JLabel();
        this.tagText = new JTextField();
        JLabel descLabel = new JLabel();
        this.scroll = new JScrollPane();
        this.descText = new JTextArea();
        JPanel fwdPanel = new JPanel();
        JLabel fwIcon = new JLabel();
        this.fwdEnabledChk = new JCheckBox();
        JLabel fwdActionLb = new JLabel();
        this.fwdActionCombo = new JComboBox<String>(this.fwdOptions);
        this.fwdJumpBtn = new JButton();
        this.fwdJumpLb = new JLabel();
        this.autoChk = new JCheckBox();
        JLabel delayLabel = new JLabel();
        this.delayEditor = new SmallIntEditor();
        JPanel condJumpPanel = new JPanel();
        JLabel upperLb = new JLabel();
        this.upperBtn = new CondJumpBtn(true);
        JLabel lowerLb = new JLabel();
        this.lowerBtn = new CondJumpBtn(false);
        JPanel backPanel = new JPanel();
        JLabel bkIcon = new JLabel();
        this.backEnabledChk = new JCheckBox();
        JLabel backActionLb = new JLabel();
        this.backActionCombo = new JComboBox<String>(this.backOptions);
        this.backJumpBtn = new JButton();
        this.backJumpLb = new JLabel();
        JLabel spacer = new JLabel();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        actLabel.setText(this.options.getMsg("edit_seq_activity"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)actLabel, gridBagConstraints);
        this.actCombo.setToolTipText(this.options.getMsg("edit_seq_activity_tooltip"));
        this.actCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add(this.actCombo, gridBagConstraints);
        this.editActBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/miniclic.png")));
        this.editActBtn.setToolTipText(this.options.getMsg("edit_act_editActivity_tooltip"));
        this.editActBtn.setText(this.options.getMsg("edit_act_editActivity"));
        this.editActBtn.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.editActBtn, gridBagConstraints);
        tagLabel.setText(this.options.getMsg("edit_seq_tag"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)tagLabel, gridBagConstraints);
        this.tagText.setToolTipText(this.options.getMsg("edit_seq_tag_tooltip"));
        this.tagText.setPreferredSize(new Dimension(130, 21));
        this.tagText.setMinimumSize(new Dimension(130, 21));
        this.tagText.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.tagText, gridBagConstraints);
        descLabel.setText(this.options.getMsg("edit_seq_description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)descLabel, gridBagConstraints);
        this.scroll.setPreferredSize(new Dimension(200, 60));
        this.scroll.setMinimumSize(new Dimension(200, 40));
        this.descText.setWrapStyleWord(true);
        this.descText.setToolTipText(this.options.getMsg("edit_seq_description_tooltip"));
        this.descText.setLineWrap(true);
        this.descText.setRows(2);
        this.descText.getDocument().addDocumentListener(this);
        this.scroll.setViewportView(this.descText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.scroll, gridBagConstraints);
        fwdPanel.setBorder(BorderFactory.createTitledBorder(this.options.getMsg("edit_seq_arrow_fwd")));
        fwdPanel.setLayout(new GridBagLayout());
        fwIcon.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/next.gif")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        fwdPanel.add((Component)fwIcon, gridBagConstraints);
        this.fwdEnabledChk.setToolTipText(this.options.getMsg("edit_seq_button_enabled_tooltip"));
        this.fwdEnabledChk.setText(this.options.getMsg("edit_seq_button_enabled"));
        this.fwdEnabledChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        fwdPanel.add((Component)this.fwdEnabledChk, gridBagConstraints);
        fwdActionLb.setText(this.options.getMsg("edit_seq_action"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        fwdPanel.add((Component)fwdActionLb, gridBagConstraints);
        this.fwdActionCombo.setToolTipText(this.options.getMsg("edit_seq_action_tooltip_fw"));
        this.fwdActionCombo.setRenderer(new CustomListCellRenderer(this.fwdOptions, this.fwdIcons));
        this.fwdActionCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        fwdPanel.add(this.fwdActionCombo, gridBagConstraints);
        this.fwdJumpBtn.setToolTipText(this.options.getMsg("edit_seq_jump_tooltip"));
        this.fwdJumpBtn.setText("...");
        this.fwdJumpBtn.setMargin(new Insets(0, 3, 0, 3));
        this.fwdJumpBtn.setEnabled(false);
        this.fwdJumpBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        fwdPanel.add((Component)this.fwdJumpBtn, gridBagConstraints);
        this.fwdJumpLb.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        fwdPanel.add((Component)this.fwdJumpLb, gridBagConstraints);
        this.autoChk.setText(this.options.getMsg("edit_seq_auto"));
        this.autoChk.setToolTipText(this.options.getMsg("edit_seq_auto_tooltip"));
        this.autoChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        fwdPanel.add((Component)this.autoChk, gridBagConstraints);
        delayLabel.setText(this.options.getMsg("edit_seq_delay"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        fwdPanel.add((Component)delayLabel, gridBagConstraints);
        this.delayEditor.setToolTipText(this.options.getMsg("edit_seq_delay_tooltip"));
        this.delayEditor.setMax(999);
        this.delayEditor.setMin(1);
        this.delayEditor.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        fwdPanel.add((Component)this.delayEditor, gridBagConstraints);
        condJumpPanel.setBorder(BorderFactory.createTitledBorder(this.options.getMsg("edit_seq_condJump")));
        condJumpPanel.setToolTipText(this.options.getMsg("edit_seq_condJump_tooltip"));
        condJumpPanel.setLayout(new GridBagLayout());
        upperLb.setLabelFor(this.upperBtn);
        upperLb.setText(this.options.getMsg("edit_seq_condJump_upper"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        condJumpPanel.add((Component)upperLb, gridBagConstraints);
        this.upperBtn.setToolTipText(this.options.getMsg("edit_seq_condJump_upper_tooltip"));
        this.upperBtn.setText("<Not Set>");
        this.upperBtn.addPropertyChangeListener("customObject", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        condJumpPanel.add((Component)this.upperBtn, gridBagConstraints);
        lowerLb.setLabelFor(this.lowerBtn);
        lowerLb.setText(this.options.getMsg("edit_seq_condJump_lower"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        condJumpPanel.add((Component)lowerLb, gridBagConstraints);
        this.lowerBtn.setToolTipText(this.options.getMsg("edit_seq_condJump_lower_tooltip"));
        this.lowerBtn.setText("<Not Set>");
        this.lowerBtn.addPropertyChangeListener("customObject", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        condJumpPanel.add((Component)this.lowerBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        fwdPanel.add((Component)condJumpPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)fwdPanel, gridBagConstraints);
        backPanel.setBorder(BorderFactory.createTitledBorder(this.options.getMsg("edit_seq_arrow_back")));
        backPanel.setLayout(new GridBagLayout());
        bkIcon.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/prev.gif")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        backPanel.add((Component)bkIcon, gridBagConstraints);
        this.backEnabledChk.setToolTipText(this.options.getMsg("edit_seq_button_enabled_tooltip"));
        this.backEnabledChk.setText(this.options.getMsg("edit_seq_button_enabled"));
        this.backEnabledChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        backPanel.add((Component)this.backEnabledChk, gridBagConstraints);
        backActionLb.setText(this.options.getMsg("edit_seq_action"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        backPanel.add((Component)backActionLb, gridBagConstraints);
        this.backActionCombo.setToolTipText(this.options.getMsg("edit_seq_action_tooltip_bk"));
        this.backActionCombo.setRenderer(new CustomListCellRenderer(this.backOptions, this.backIcons));
        this.backActionCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        backPanel.add(this.backActionCombo, gridBagConstraints);
        this.backJumpBtn.setText("...");
        this.backJumpBtn.setToolTipText(this.options.getMsg("edit_seq_jump_tooltip"));
        this.backJumpBtn.setMargin(new Insets(0, 3, 0, 3));
        this.backJumpBtn.setEnabled(false);
        this.backJumpBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        backPanel.add((Component)this.backJumpBtn, gridBagConstraints);
        this.backJumpLb.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        backPanel.add((Component)this.backJumpLb, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)backPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)spacer, gridBagConstraints);
        this.add((Component)this.mainPanel, "West");
    }

    @Override
    public boolean checkIfEditorValid(Editor e) {
        return e instanceof ActivitySequenceElementEditor;
    }

    protected ActivitySequenceElement getActivitySequenceElement() {
        if (this.editor == null) {
            return null;
        }
        return ((ActivitySequenceElementEditor)this.editor).getActivitySequenceElement();
    }

    protected int getRealDelayValue() {
        return this.autoChk.isSelected() ? this.delayEditor.getValue() : 0;
    }

    protected int getBtnValue() {
        boolean fw = this.fwdEnabledChk.isSelected();
        boolean bk = this.backEnabledChk.isSelected();
        return fw ? (bk ? 3 : 1) : (bk ? 2 : 0);
    }

    @Override
    protected void fillData() {
        JClicProjectEditor jcpe;
        ActivitySequenceElement ase = this.getActivitySequenceElement();
        JClicProjectEditor jClicProjectEditor = jcpe = ase == null ? null : ((ActivitySequenceElementEditor)this.getEditor()).getProjectEditor();
        if (jcpe != null) {
            AbstractListModel<Object> lm = jcpe.getActivityBagEditor().getListModel();
            if (this.actModel == null || this.actModel.getListModel() != lm) {
                this.actModel = new ListComboModel(lm);
                this.actCombo.setModel(this.actModel);
            }
            if (ase != null) {
                this.actCombo.setSelectedItem(jcpe.getActivityBagEditor().getChildByName(ase.getActivityName()));
            }
        } else {
            this.actModel = new ListComboModel();
            this.actCombo.setModel(this.actModel);
            this.actCombo.setSelectedItem(null);
        }
        this.fwdEnabledChk.setSelected(ase == null ? true : (ase.navButtons & 1) != 0);
        this.fwdActionCombo.setSelectedIndex(ase == null || ase.fwdJump == null ? 0 : ase.fwdJump.action + 1);
        this.backEnabledChk.setSelected(ase == null ? true : (ase.navButtons & 2) != 0);
        this.backActionCombo.setSelectedIndex(ase == null || ase.backJump == null ? 0 : ase.backJump.action + 1);
        this.tagText.setText(StrUtils.secureString(ase == null ? null : ase.getTag()));
        this.descText.setText(StrUtils.secureString(ase == null ? null : ase.getDescription()));
        this.autoChk.setSelected(ase != null && ase.delay > 0);
        this.delayEditor.setValue(Math.max(1, ase == null ? 0 : ase.delay));
        ((CondJumpBtn)this.upperBtn).setConditionalJumpInfo(ase == null || ase.fwdJump == null ? null : ase.fwdJump.upperJump);
        ((CondJumpBtn)this.lowerBtn).setConditionalJumpInfo(ase == null || ase.fwdJump == null ? null : ase.fwdJump.lowerJump);
        this.setJumpLabels();
        this.checkEnabled();
        this.repaint();
    }

    @Override
    public boolean eventPerformed(EventObject ev) {
        Object src = ev == null ? null : ev.getSource();
        ActivitySequenceElement ase = this.getActivitySequenceElement();
        if (src == null || ase == null) {
            return false;
        }
        if (src == this.tagCombo) {
            if (this.tagCombo.getSelectedIndex() >= 0) {
                this.tagCombo.getEditor().setItem(this.tagCombo.getSelectedItem());
            }
            return false;
        }
        if (src == this.editActBtn && this.getEditor() != null && this.actCombo.getSelectedItem() != null) {
            JClicProjectEditor prjed = ((ActivitySequenceElementEditor)this.getEditor()).getProjectEditor();
            if (prjed != null && prjed.getTestPlayerContainer() != null) {
                prjed.getTestPlayerContainer().editActivity(this.actCombo.getSelectedItem().toString());
            }
            return false;
        }
        if (src == this.fwdActionCombo || src == this.fwdJumpBtn) {
            ase.fwdJump = (ActivitySequenceJump)this.checkJump(ase.fwdJump, this.fwdActionCombo, true, src == this.fwdJumpBtn);
            this.setJumpLabels();
        } else if (src == this.backActionCombo || src == this.backJumpBtn) {
            ase.backJump = (ActivitySequenceJump)this.checkJump(ase.backJump, this.backActionCombo, true, src == this.backJumpBtn);
            this.setJumpLabels();
        }
        this.checkEnabled();
        this.repaint();
        this.updateTable();
        return true;
    }

    @Override
    public boolean documentChangePerformed(DocumentEvent documentEvent) {
        if (documentEvent != null && documentEvent.getDocument().equals(this.tagText.getDocument())) {
            this.updateTable();
        }
        return true;
    }

    private void updateTable() {
        Container cnt = this.getAWTAncestor(ActivitySequenceEditorPanel.class);
        if (cnt != null) {
            this.setInitializing(true);
            this.saveData();
            int row = ((ActivitySequenceEditorPanel)cnt).seqTable.getSelectionModel().getAnchorSelectionIndex();
            ((ActivitySequenceEditorPanel)cnt).tableModel.fireTableDataChanged();
            ((ActivitySequenceEditorPanel)cnt).seqTable.getSelectionModel().setSelectionInterval(row, row);
            this.setInitializing(false);
        }
    }

    protected JumpInfo checkJump(JumpInfo ji, JComboBox combo, boolean allowNull, boolean forcePrompt) {
        int offset = allowNull ? 1 : 0;
        int v = combo.getSelectedIndex();
        if (v == 0 && allowNull) {
            ji = null;
        } else {
            boolean b;
            if (ji == null) {
                ji = new ActivitySequenceJump(v - offset);
            } else {
                ji.action = v - offset;
            }
            if (ji.action == 0 && (forcePrompt || ji.sequence == null && ji.projectPath == null) && (!(b = this.promptJumpParams(ji, this)) || ji.sequence == null && ji.projectPath == null)) {
                if (allowNull) {
                    ji = null;
                } else {
                    ji.action = 2;
                }
                this.setInitializing(true);
                combo.setSelectedIndex(ji == null ? 0 : ji.action + offset);
                this.setInitializing(false);
            }
        }
        return ji;
    }

    @Override
    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.actCombo.setEnabled(enabled);
        this.fwdEnabledChk.setEnabled(enabled);
        this.backEnabledChk.setEnabled(enabled);
        this.tagText.setEnabled(enabled);
        this.descText.setEnabled(enabled);
        this.autoChk.setEnabled(enabled);
        this.checkEnabled();
    }

    public void checkEnabled() {
        boolean e = this.isEnabled();
        boolean fw = this.fwdEnabledChk.isSelected() || this.autoChk.isSelected();
        boolean fwBtn = fw && this.fwdActionCombo.getSelectedIndex() == 1;
        boolean fwCond = fw && this.fwdActionCombo.getSelectedIndex() > 0;
        boolean bk = this.backEnabledChk.isSelected();
        boolean bkBtn = bk && this.backActionCombo.getSelectedIndex() == 1;
        this.fwdActionCombo.setEnabled(e && fw);
        this.fwdJumpBtn.setEnabled(e && fwBtn);
        this.delayEditor.setEnabled(e && this.autoChk.isSelected());
        this.backActionCombo.setEnabled(e && bk);
        this.backJumpBtn.setEnabled(e && bkBtn);
        this.upperBtn.setEnabled(e && fwCond);
        this.lowerBtn.setEnabled(e && fwCond);
    }

    @Override
    protected void saveData() {
        ActivitySequenceElement ase = this.getActivitySequenceElement();
        ActivityBagElementEditor abed = (ActivityBagElementEditor)this.actCombo.getSelectedItem();
        if (ase != null && abed != null) {
            ase.setActivityName(abed.toString());
            String tag = StrUtils.nullableString(this.tagText.getText());
            if (!StrUtils.compareObjects(tag, ase.getTag())) {
                ActivitySequenceEditor ased = (ActivitySequenceEditor)this.getEditor().getEditorParent();
                if (ase.getTag() != null && ased != null && ased.tagList != null) {
                    ased.tagList.removeElement(ased.getTag(ase.getTag()));
                }
                ase.setTag(tag);
                if (tag != null && ased != null && ased.tagList != null) {
                    ased.tagList.addElement(tag);
                }
            }
            ase.setTag(StrUtils.nullableString(this.tagText.getText()));
            ase.setDescription(StrUtils.nullableString(this.descText.getText()));
            ase.navButtons = this.getBtnValue();
            ase.delay = this.getRealDelayValue();
            if (ase.fwdJump != null) {
                ase.fwdJump.upperJump = ((CondJumpBtn)this.upperBtn).getConditionalJumpInfo();
                ase.fwdJump.lowerJump = ((CondJumpBtn)this.lowerBtn).getConditionalJumpInfo();
            }
        }
    }

    @Override
    protected Icon getIcon() {
        return ActivitySequenceElementEditor.getIcon();
    }

    @Override
    protected String getTitle() {
        return "Activity sequence element";
    }

    protected boolean promptJumpParams(JumpInfo ji, Component parent) {
        JClicProjectEditor jcpe;
        boolean result = false;
        ActivitySequenceElement ase = this.getActivitySequenceElement();
        if (ase != null && (jcpe = ((ActivitySequenceElementEditor)this.getEditor()).getProjectEditor()) != null) {
            ListModel<Object> lm = jcpe.getActivitySequenceEditor().getTagList();
            if (this.jmpTagModel == null || this.jmpTagModel.getListModel() != lm) {
                this.jmpTagModel = new ListComboModel(lm);
            }
            this.tagCombo.setModel(this.jmpTagModel);
            this.tagCombo.setSelectedItem(ji.sequence);
            String tx = ji.projectPath;
            this.prjEdit.setText(tx == null ? "" : tx);
            result = this.options.getMessages().showInputDlg(parent, this.prompt_msg, this.prompt_keys, this.prompt_objects, "edit_seq_jump_title");
            if (result) {
                ji.sequence = StrUtils.nullableString(this.tagCombo.getEditor().getItem());
                ji.projectPath = StrUtils.nullableString(this.prjEdit.getText());
            }
        }
        return result;
    }

    private void setJumpLabels() {
        StringBuilder sb = new StringBuilder();
        ActivitySequenceElement ase = this.getActivitySequenceElement();
        if (ase != null && ase.fwdJump != null) {
            if (ase.fwdJump.sequence != null) {
                sb.append(ase.fwdJump.sequence);
            }
            if (ase.fwdJump.projectPath != null) {
                sb.append(" (").append(ase.fwdJump.projectPath).append(")");
            }
        }
        this.fwdJumpLb.setText(sb.append(' ').substring(0));
        sb.setLength(0);
        if (ase != null && ase.backJump != null) {
            if (ase.backJump.sequence != null) {
                sb.append(ase.backJump.sequence);
            }
            if (ase.backJump.projectPath != null) {
                sb.append(" (").append(ase.backJump.projectPath).append(")");
            }
        }
        this.backJumpLb.setText(sb.append(' ').substring(0));
    }

    class CondJumpBtn
    extends NullableObject {
        boolean upper;
        ConditionalJumpPanel cjp;

        CondJumpBtn(boolean upper) {
            this.upper = upper;
            this.setOptions(ActivitySequenceElementEditorPanel.this.options);
        }

        ConditionalJumpInfo getConditionalJumpInfo() {
            return (ConditionalJumpInfo)this.getObject();
        }

        void setConditionalJumpInfo(ConditionalJumpInfo cji) {
            this.setObject(cji);
            this.checkIcon();
        }

        @Override
        protected Object createObject() {
            return new ConditionalJumpInfo(2, null, this.upper ? 80 : 20);
        }

        @Override
        protected Object editObject(Object o) {
            if (o == null) {
                o = this.createObject();
            }
            ConditionalJumpInfo cji = (ConditionalJumpInfo)o;
            if (this.cjp == null) {
                this.cjp = new ConditionalJumpPanel(this.options, ActivitySequenceElementEditorPanel.this, this.upper);
            }
            this.cjp.setJumpInfo((ConditionalJumpInfo)o, this.upper);
            boolean b = this.options.getMessages().showInputDlg(this, this.cjp, "edit_seq_condJump_" + (this.upper ? "upper" : "lower"));
            return b ? this.cjp.getJumpInfo() : null;
        }

        @Override
        public void changeObject(Object o) {
            super.changeObject(o);
            this.checkIcon();
        }

        private void checkIcon() {
            ConditionalJumpInfo o = this.getConditionalJumpInfo();
            if (o == null || ActivitySequenceElementEditorPanel.this.fwdIcons == null) {
                this.setIcon(null);
            } else {
                this.setIcon(ActivitySequenceElementEditorPanel.this.fwdIcons[o.action + 1]);
            }
            this.repaint();
        }
    }
}

