/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.CopyActivityAttributesPanel;
import edu.xtec.jclic.bags.ActivityBag;
import edu.xtec.jclic.bags.ActivityBagEditorPanel;
import edu.xtec.jclic.bags.ActivityBagElement;
import edu.xtec.jclic.bags.ActivityBagElementEditor;
import edu.xtec.jclic.bags.ActivitySequenceEditor;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.bags.NewActivityPanel;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorAction;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jdom.Element;

public class ActivityBagEditor
extends Editor {
    public static ImageIcon icon;
    public static EditorAction newActivityBagElementAction;
    public static EditorAction copyActivityAttributesAction;
    public static boolean actionsCreated;
    private boolean initializing;
    private static NewActivityPanel newActivityPanel;

    public ActivityBagEditor(ActivityBag ab) {
        super(ab);
    }

    @Override
    protected void createChildren() {
        this.initializing = true;
        ActivityBag ab = this.getActivityBag();
        if (ab != null) {
            int s = ab.size();
            for (int i = 0; i < s; ++i) {
                ab.elementAt(i).getEditor(this);
            }
        }
        this.initializing = false;
    }

    @Override
    public EditorPanel createEditorPanel(Options options) {
        return new ActivityBagEditorPanel(options);
    }

    @Override
    public Class getEditorPanelClass() {
        return ActivityBagEditorPanel.class;
    }

    @Override
    public String getTitleKey() {
        return "edit_activities";
    }

    public ActivityBag getActivityBag() {
        return (ActivityBag)this.getUserObject();
    }

    public static Icon getIcon() {
        if (icon == null) {
            icon = ResourceManager.getImageIcon("icons/database.gif");
        }
        return icon;
    }

    @Override
    public Icon getIcon(boolean leaf, boolean expanded) {
        return ActivityBagEditor.getIcon();
    }

    @Override
    public String toString() {
        return "Activity bag";
    }

    public Options getOptions() {
        return this.getActivityBag().getProject().getBridge().getOptions();
    }

    public JClicProjectEditor getProjectEditor() {
        return (JClicProjectEditor)this.getFirstParent(JClicProjectEditor.class);
    }

    public boolean createNewActivityBagElement(int index, Component dlgParent) {
        Activity act;
        String actClassName = null;
        String actName = null;
        while (true) {
            if (newActivityPanel == null) {
                newActivityPanel = new NewActivityPanel(this.getOptions());
            } else {
                newActivityPanel.setActivityName(null);
            }
            if (!this.getOptions().getMessages().showInputDlg(dlgParent, newActivityPanel, "edit_act_newActivity")) {
                return false;
            }
            actClassName = newActivityPanel.gectActivityClassName();
            if (actClassName == null) {
                this.getOptions().getMessages().showAlert(dlgParent, "edit_act_newActivity_error_noAct");
                continue;
            }
            actName = newActivityPanel.getActivityName();
            if (actName == null) {
                this.getOptions().getMessages().showAlert(dlgParent, "edit_act_newActivity_error_noName");
                continue;
            }
            if (this.getActivityBag().getElementIndex(actName) < 0) break;
            this.getOptions().getMessages().showAlert(dlgParent, "edit_media_rename_exists");
        }
        try {
            act = Activity.getActivity(actClassName, this.getProjectEditor().getProject());
            act.name = actName;
        }
        catch (Exception ex) {
            this.getOptions().getMessages().showErrorWarning(dlgParent, "edit_act_newActivity_error_creating", ex);
            return false;
        }
        Element e = act.getJDomElement();
        if (e == null) {
            this.getOptions().getMessages().showErrorWarning(dlgParent, "edit_act_newActivity_error_creating", null);
            return false;
        }
        ActivityBagElement abe = new ActivityBagElement(act.getJDomElement());
        ActivityBagElementEditor abeed = (ActivityBagElementEditor)abe.getEditor(null);
        index = index < 0 ? this.getChildCount() : Math.min(index, this.getChildCount());
        return this.insertEditor(abeed, true, index, true);
    }

    public void changeActivityClass(ActivityBagElementEditor abed, String newClassName) throws Exception {
        abed.collectData();
        ActivityBagElement abe = abed.getActivityBagElement();
        abed.forgetActivityEditor();
        Activity act = Activity.getActivity(newClassName, this.getProjectEditor().getProject());
        act.setProperties(abe.getData(), null);
        abe.setData(act.getJDomElement());
        this.setModified(true);
    }

    @Override
    public void setActionsOwner() {
        this.allowPaste = false;
        this.allowCopy = false;
        this.allowCut = false;
        this.allowDelete = false;
        super.setActionsOwner();
        if (actionsCreated) {
            newActivityBagElementAction.setActionOwner(this);
        }
    }

    @Override
    public void clearActionsOwner() {
        super.clearActionsOwner();
        if (actionsCreated) {
            newActivityBagElementAction.setActionOwner(null);
        }
    }

    public static void createActions(Options options) {
        ActivityBagEditor.createBasicActions(options);
        if (!actionsCreated) {
            newActivityBagElementAction = new EditorAction("edit_act_newActivity", "icons/new_miniclic.png", "edit_act_newActivity_tooltip", options){

                @Override
                protected void doAction(Editor e) {
                    Editor ch = null;
                    if (e instanceof ActivityBagElementEditor) {
                        ch = e;
                        e = e.getEditorParent();
                    }
                    if (e instanceof ActivityBagEditor) {
                        ((ActivityBagEditor)e).createNewActivityBagElement(e.getNearestIndex(ch, true), this.getComponentSrc());
                    }
                }
            };
            copyActivityAttributesAction = new EditorAction("edit_act_copyAttributes", "icons/copy_properties.gif", "edit_act_copyAttributes_tooltip", options){

                @Override
                protected void doAction(Editor e) {
                    Object ch = null;
                    if (e instanceof ActivityBagElementEditor) {
                        CopyActivityAttributesPanel catrp = new CopyActivityAttributesPanel(this.options, (ActivityBagElementEditor)e);
                        catrp.showDialog(this.getComponentSrc());
                    }
                }
            };
            actionsCreated = true;
        }
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        if (!this.initializing) {
            ActivityBagElement abe = ((ActivityBagElementEditor)newChild).getActivityBagElement();
            if (this.getActivityBag().getElementIndex(abe.getName()) >= 0) {
                int i;
                String name = abe.getName();
                for (i = name.length() - 1; i >= 0 && Character.isDigit(name.charAt(i)); --i) {
                }
                if (!(name = name.substring(0, i + 1)).endsWith("_")) {
                    name = name + "_";
                }
                int suffix = 2;
                while (this.getActivityBag().getElementIndex(name + suffix) >= 0) {
                    ++suffix;
                }
                abe.getData().setAttribute("name", name + suffix);
            }
            this.getActivityBag().insertElementAt(abe, childIndex);
        }
    }

    @Override
    public void remove(int childIndex) {
        super.remove(childIndex);
        this.getActivityBag().removeElementAt(childIndex);
    }

    public boolean nameChanged(int type, String oldName, String newName) {
        boolean result = false;
        Enumeration<TreeNode> en = this.children();
        while (en.hasMoreElements()) {
            result |= ((ActivityBagElementEditor)en.nextElement()).nameChanged(type, oldName, newName);
        }
        return result;
    }

    public int checkOrphanElements(Options options, Component parent, boolean prompt) {
        int result = 1;
        ArrayList<String> v = new ArrayList<String>();
        ActivityBagElement[] abel = this.getActivityBag().getElements();
        ActivitySequenceEditor ased = this.getProjectEditor().getActivitySequenceEditor();
        ActivitySequenceElement[] asel = ased.getActivitySequence().getElements();
        for (int i = 0; i < abel.length; ++i) {
            int j;
            String actName = abel[i].getName();
            for (j = 0; j < asel.length && !asel[j].getActivityName().equals(actName); ++j) {
            }
            if (j != asel.length) continue;
            v.add(actName);
        }
        if (!v.isEmpty()) {
            boolean doIt;
            boolean bl = doIt = !prompt;
            if (!doIt) {
                Object[] object = new Object[]{options.getMsg("edit_project_orphanActivities"), v.size() > 10 ? new JScrollPane(new JList<Object>(v.toArray())) : v, options.getMsg("edit_project_orphanActivities_prompt")};
                result = options.getMessages().showQuestionDlgObj(parent, object, "edit_project_orphanActivities_title", "ync");
                boolean bl2 = doIt = result == 1;
            }
            if (doIt) {
                Iterator it = v.iterator();
                while (it.hasNext()) {
                    ased.createNewSequenceElement((String)it.next(), null, -1);
                }
            }
        }
        return result;
    }

    static {
        newActivityPanel = null;
    }
}

