/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.automation.tagreplace;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.automation.AutoContentProviderEditor;
import edu.xtec.jclic.automation.tagreplace.TagReplace;
import edu.xtec.jclic.automation.tagreplace.TagReplaceEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TagReplaceEditorPanel
extends EditorPanel {
    private JButton browseBtn;
    private JComboBox<Object> charsetCombo;
    private JLabel charsetLb;
    private JLabel fileLb;
    private JPanel filePanel;
    private JTextField fileTx;
    private JLabel tagEndLb;
    private JTextField tagEndTx;
    private JPanel tagPanel;
    private JLabel tagStartLb;
    private JTextField tagStartTx;

    public TagReplaceEditorPanel(Options options) {
        super(options);
        this.initComponents();
        this.postInit(250, false, false);
    }

    private void initComponents() {
        this.tagPanel = new JPanel();
        this.tagStartLb = new JLabel();
        this.tagStartTx = new JTextField();
        this.tagEndLb = new JLabel();
        this.tagEndTx = new JTextField();
        this.filePanel = new JPanel();
        this.fileLb = new JLabel();
        this.fileTx = new JTextField();
        this.browseBtn = new JButton();
        this.charsetLb = new JLabel();
        this.charsetCombo = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.tagPanel.setBorder(BorderFactory.createTitledBorder(this.options.getMsg("edit_tagRep_tags")));
        this.tagPanel.setLayout(new GridBagLayout());
        this.tagStartLb.setLabelFor(this.tagStartTx);
        this.tagStartLb.setText(this.options.getMsg("edit_tagRep_tagStart"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.tagPanel.add((Component)this.tagStartLb, gridBagConstraints);
        this.tagStartTx.setColumns(5);
        this.tagStartTx.setText("[");
        this.tagStartTx.setToolTipText(this.options.getMsg("edit_tagRep_tagStart_tooltip"));
        this.tagStartTx.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.tagPanel.add((Component)this.tagStartTx, gridBagConstraints);
        this.tagEndLb.setLabelFor(this.tagEndTx);
        this.tagEndLb.setText(this.options.getMsg("edit_tagRep_tagEnd"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.tagPanel.add((Component)this.tagEndLb, gridBagConstraints);
        this.tagEndTx.setColumns(5);
        this.tagEndTx.setText("]");
        this.tagEndTx.setToolTipText(this.options.getMsg("edit_tagRep_tagEnd_tooltip"));
        this.tagEndTx.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.tagPanel.add((Component)this.tagEndTx, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.tagPanel, gridBagConstraints);
        this.filePanel.setBorder(BorderFactory.createTitledBorder(this.options.getMsg("edit_tagRep_file")));
        this.filePanel.setLayout(new GridBagLayout());
        this.fileLb.setLabelFor(this.fileTx);
        this.fileLb.setText(this.options.getMsg("edit_tagRep_fileName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.filePanel.add((Component)this.fileLb, gridBagConstraints);
        this.fileTx.setText("[");
        this.fileTx.setToolTipText(this.options.getMsg("edit_tagRep_fileName_tooltip"));
        this.fileTx.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.filePanel.add((Component)this.fileTx, gridBagConstraints);
        this.browseBtn.setText(this.options.getMsg("edit_tagRep_browseFile"));
        this.browseBtn.setToolTipText(this.options.getMsg("edit_tagRep_browseFile_tooltip"));
        this.browseBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.filePanel.add((Component)this.browseBtn, gridBagConstraints);
        this.charsetLb.setLabelFor(this.charsetCombo);
        this.charsetLb.setText(this.options.getMsg("edit_tagRep_charset"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.filePanel.add((Component)this.charsetLb, gridBagConstraints);
        this.charsetCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"UTF8", "UTF-16", "ISO8859_1", "ASCII"}));
        this.charsetCombo.setSelectedItem("UTF8");
        this.charsetCombo.setToolTipText(this.options.getMsg("edit_tagRep_charset_tooltip"));
        this.charsetCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.filePanel.add(this.charsetCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.filePanel, gridBagConstraints);
    }

    @Override
    public boolean checkIfEditorValid(Editor e) {
        return e instanceof TagReplaceEditor;
    }

    public TagReplaceEditor getTagReplaceEditor() {
        return (TagReplaceEditor)this.getEditor();
    }

    public TagReplace getTagReplace() {
        TagReplaceEditor tred = this.getTagReplaceEditor();
        return tred == null ? null : (TagReplace)tred.getAutoContentProvider();
    }

    @Override
    protected void fillData() {
        TagReplace tr = this.getTagReplace();
        this.tagStartTx.setText(tr == null ? "" : tr.tagStart);
        this.tagEndTx.setText(tr == null ? "" : tr.tagEnd);
        this.fileTx.setText(tr == null ? "" : tr.mapFileName);
        this.charsetCombo.setSelectedItem(tr == null ? "UTF8" : tr.fileCharset);
        this.setModified(false);
    }

    @Override
    protected void saveData() {
        TagReplace tr = this.getTagReplace();
        if (tr != null) {
            tr.tagStart = this.tagStartTx.getText();
            tr.tagEnd = this.tagEndTx.getText();
            tr.mapFileName = StrUtils.nullableString(this.fileTx.getText());
            tr.fileCharset = (String)this.charsetCombo.getSelectedItem();
        }
    }

    @Override
    public boolean eventPerformed(EventObject ev) {
        boolean result;
        Object cmp = ev == null ? null : ev.getSource();
        boolean bl = result = cmp != null;
        if (cmp == this.browseBtn) {
            this.selectTextFile();
        }
        return result;
    }

    protected void selectTextFile() {
        int[] filters;
        FileSystem fs;
        String[] files;
        Activity act;
        TagReplaceEditor tred = this.getTagReplaceEditor();
        if (tred != null && (act = tred.getActivity()) != null && (files = (fs = act.getProject().getFileSystem()).chooseFiles(null, false, filters = new int[]{22}, this.options, "edit_find_media", this, true, false)) != null && files.length > 0 && files[0] != null) {
            this.fileTx.setText(files[0]);
            this.setModified(true);
        }
    }

    @Override
    protected Icon getIcon() {
        return AutoContentProviderEditor.getIcon();
    }

    @Override
    protected String getTitle() {
        return this.options.getMsg("edit_tagRep_title");
    }
}

