/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.ActivityEditorInternalPanel;
import edu.xtec.jclic.ActivityEditorPanel;
import edu.xtec.jclic.activities.text.TargetMarker;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityBaseEditor;
import edu.xtec.jclic.activities.text.TextPrevScreenEditorPanel;
import edu.xtec.jclic.activities.text.TextStyleEditorPanel;
import edu.xtec.jclic.beans.ColorButton;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.ActiveBoxContentEditor;
import edu.xtec.jclic.boxes.JPanelActiveBox;
import edu.xtec.util.FontCheck;
import edu.xtec.util.Resizer;
import edu.xtec.util.ResizerPanel;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.SmallButtonBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class TextActivityEditorTextPanel
extends ActivityEditorInternalPanel
implements Resizer.ResizerListener {
    protected Resizer resizer;
    protected boolean skipUpdate;
    protected String fontName;
    protected int fontSize;
    protected boolean changeCombos = true;
    CaretListener caretListener = new CaretListener(){

        @Override
        public void caretUpdate(CaretEvent e) {
            TextActivityEditorTextPanel.this.showAttributes(e.getDot());
        }
    };
    private static final Dimension DEFAULT_SIZE = new Dimension(400, 300);
    private JToggleButton alCenterBtn;
    private JToggleButton alLeftBtn;
    private JToggleButton alRightBtn;
    private ButtonGroup alignGrp;
    private ColorButton bgColorBtn;
    private JToggleButton boldBtn;
    private JButton clearStylesBtn;
    private JButton editTargetBtn;
    private JComboBox<Object> fontFaceCombo;
    private JComboBox<Object> fontSizeCombo;
    private SmallIntEditor heightEdit;
    private JButton insertBoxBtn;
    private JToggleButton italicBtn;
    private JScrollPane mainScroll;
    private JButton optionsBtn;
    private JButton prevScreenBtn;
    private JPanel previewPanel;
    private JButton styleBtn;
    private JToggleButton targetBtn;
    private ColorButton textColorBtn;
    private JTextPane textPane;
    private JScrollPane textScroll;
    private JButton typeBtn;
    private JToggleButton underlineBtn;
    private SmallIntEditor widthEdit;

    public TextActivityEditorTextPanel(ActivityEditorPanel parent) {
        super(parent);
        this.initComponents();
        this.textScroll.setBorder(BorderFactory.createEmptyBorder());
        this.textScroll.getVerticalScrollBar().setBorder(BorderFactory.createLineBorder(Color.darkGray, 1));
        this.textPane.addCaretListener(this.caretListener);
        this.resizer = new Resizer(this.previewPanel, null, false, this);
    }

    private void initComponents() {
        this.alignGrp = new ButtonGroup();
        this.mainScroll = new JScrollPane();
        this.previewPanel = new PreviewPanel();
        this.textScroll = new JScrollPane();
        this.textPane = new JTextPane();
        JTabbedPane ctrlPanel = new JTabbedPane();
        JPanel actPanel = new JPanel();
        this.targetBtn = new JToggleButton();
        this.editTargetBtn = new JButton();
        this.insertBoxBtn = new JButton();
        this.prevScreenBtn = new JButton();
        this.optionsBtn = new JButton();
        this.typeBtn = new JButton();
        JLabel widthLb = new JLabel();
        this.widthEdit = new SmallIntEditor();
        JLabel heightLb = new JLabel();
        this.heightEdit = new SmallIntEditor();
        JPanel stylePanel = new JPanel();
        this.styleBtn = new JButton();
        this.clearStylesBtn = new JButton();
        this.fontFaceCombo = new JComboBox<String>(FontCheck.getFontList(false));
        this.fontSizeCombo = new JComboBox<String>(FontCheck.fontSizes);
        this.boldBtn = new JToggleButton();
        this.italicBtn = new JToggleButton();
        this.underlineBtn = new JToggleButton();
        this.alLeftBtn = new JToggleButton();
        this.alCenterBtn = new JToggleButton();
        this.alRightBtn = new JToggleButton();
        JLabel textColorLb = new JLabel();
        this.textColorBtn = new ColorButton();
        this.textColorBtn.setOptions(this.options);
        JLabel bgColorLb = new JLabel();
        this.bgColorBtn = new ColorButton();
        this.bgColorBtn.setOptions(this.options);
        this.setLayout(new BorderLayout());
        this.previewPanel.setPreferredSize(new Dimension(780, 580));
        this.textPane.setPreferredSize(new Dimension(400, 300));
        this.textScroll.setViewportView(this.textPane);
        this.previewPanel.add(this.textScroll);
        this.mainScroll.setViewportView(this.previewPanel);
        this.add((Component)this.mainScroll, "Center");
        actPanel.setLayout(new GridBagLayout());
        this.targetBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/text_target.gif")));
        this.targetBtn.setToolTipText(this.options.getMsg("edit_text_act_target_toggle"));
        this.targetBtn.setBorder(new SmallButtonBorder(this.targetBtn, true));
        this.targetBtn.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        actPanel.add((Component)this.targetBtn, gridBagConstraints);
        this.editTargetBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/text_target_edit.gif")));
        this.editTargetBtn.setToolTipText(this.options.getMsg("edit_text_act_edit_target"));
        this.editTargetBtn.setBorder(new SmallButtonBorder(this.editTargetBtn, true));
        this.editTargetBtn.setEnabled(false);
        this.editTargetBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 8);
        actPanel.add((Component)this.editTargetBtn, gridBagConstraints);
        this.insertBoxBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/insert_box.gif")));
        this.insertBoxBtn.setToolTipText(this.options.getMsg("edit_text_act_insertCell"));
        this.insertBoxBtn.setBorder(new SmallButtonBorder(this.prevScreenBtn, true));
        this.insertBoxBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 8, 2, 8);
        actPanel.add((Component)this.insertBoxBtn, gridBagConstraints);
        this.prevScreenBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/prev_screen.gif")));
        this.prevScreenBtn.setToolTipText(this.options.getMsg("edit_text_act_prevScreen_title"));
        this.prevScreenBtn.setBorder(new SmallButtonBorder(this.prevScreenBtn, true));
        this.prevScreenBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 8, 2, 8);
        actPanel.add((Component)this.prevScreenBtn, gridBagConstraints);
        this.optionsBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/check.gif")));
        this.optionsBtn.setToolTipText(this.options.getMsg("edit_text_act_check_bt"));
        this.optionsBtn.setBorder(new SmallButtonBorder(this.optionsBtn, true));
        this.optionsBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 8, 2, 8);
        actPanel.add((Component)this.optionsBtn, gridBagConstraints);
        this.typeBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/type.gif")));
        this.typeBtn.setToolTipText(this.options.getMsg("edit_text_act_typeBtn"));
        this.typeBtn.setBorder(new SmallButtonBorder(this.typeBtn, true));
        this.typeBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 8, 2, 8);
        actPanel.add((Component)this.typeBtn, gridBagConstraints);
        widthLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/adjust_width.gif")));
        widthLb.setLabelFor(this.widthEdit);
        widthLb.setText(":");
        widthLb.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 8, 2, 2);
        actPanel.add((Component)widthLb, gridBagConstraints);
        this.widthEdit.setToolTipText(this.options.getMsg("edit_act_width_tooltip"));
        this.widthEdit.setMax(999);
        this.widthEdit.setMin(50);
        this.widthEdit.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 8);
        actPanel.add((Component)this.widthEdit, gridBagConstraints);
        heightLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/adjust_height.gif")));
        heightLb.setLabelFor(this.heightEdit);
        heightLb.setText(":");
        heightLb.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 8, 2, 2);
        actPanel.add((Component)heightLb, gridBagConstraints);
        this.heightEdit.setToolTipText(this.options.getMsg("edit_act_height_tooltip"));
        this.heightEdit.setMax(999);
        this.heightEdit.setMin(50);
        this.heightEdit.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 8);
        actPanel.add((Component)this.heightEdit, gridBagConstraints);
        ctrlPanel.addTab(this.options.getMsg("edit_text_act_content"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/content.gif")), actPanel);
        stylePanel.setLayout(new GridBagLayout());
        this.styleBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/doc_styles.gif")));
        this.styleBtn.setToolTipText(this.options.getMsg("edit_text_act_editStylesBtn"));
        this.styleBtn.setBorder(new SmallButtonBorder(this.styleBtn, true));
        this.styleBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        stylePanel.add((Component)this.styleBtn, gridBagConstraints);
        this.clearStylesBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/doc_styles_clear.gif")));
        this.clearStylesBtn.setToolTipText(this.options.getMsg("edit_text_act_clearStylesBtn"));
        this.clearStylesBtn.setBorder(new SmallButtonBorder(this.styleBtn, true));
        this.clearStylesBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 8);
        stylePanel.add((Component)this.clearStylesBtn, gridBagConstraints);
        this.fontFaceCombo.setEditable(true);
        this.fontFaceCombo.setPreferredSize(new Dimension(120, this.fontFaceCombo.getPreferredSize().height));
        this.fontFaceCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 8, 2, 2);
        stylePanel.add(this.fontFaceCombo, gridBagConstraints);
        this.fontSizeCombo.setEditable(true);
        this.fontSizeCombo.setPreferredSize(new Dimension(50, this.fontSizeCombo.getPreferredSize().height));
        this.fontSizeCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 8);
        stylePanel.add(this.fontSizeCombo, gridBagConstraints);
        this.boldBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/font_bold.gif")));
        this.boldBtn.setToolTipText(this.options.getMsg("edit_font_bold"));
        this.boldBtn.setBorder(new SmallButtonBorder(this.boldBtn, true));
        this.boldBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 8, 2, 2);
        stylePanel.add((Component)this.boldBtn, gridBagConstraints);
        this.italicBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/font_italic.gif")));
        this.italicBtn.setToolTipText(this.options.getMsg("edit_font_italic"));
        this.italicBtn.setBorder(new SmallButtonBorder(this.italicBtn, true));
        this.italicBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        stylePanel.add((Component)this.italicBtn, gridBagConstraints);
        this.underlineBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/font_underline.gif")));
        this.underlineBtn.setToolTipText(this.options.getMsg("edit_font_underline"));
        this.underlineBtn.setBorder(new SmallButtonBorder(this.underlineBtn, true));
        this.underlineBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 8);
        stylePanel.add((Component)this.underlineBtn, gridBagConstraints);
        this.alignGrp.add(this.alLeftBtn);
        this.alLeftBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/al_left.gif")));
        this.alLeftBtn.setToolTipText(this.options.getMsg("edit_text_align_left"));
        this.alLeftBtn.setBorder(new SmallButtonBorder(this.alLeftBtn, true));
        this.alLeftBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 8, 2, 2);
        stylePanel.add((Component)this.alLeftBtn, gridBagConstraints);
        this.alignGrp.add(this.alCenterBtn);
        this.alCenterBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/al_center.gif")));
        this.alCenterBtn.setToolTipText(this.options.getMsg("edit_text_align_center"));
        this.alCenterBtn.setBorder(new SmallButtonBorder(this.alCenterBtn, true));
        this.alCenterBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        stylePanel.add((Component)this.alCenterBtn, gridBagConstraints);
        this.alignGrp.add(this.alRightBtn);
        this.alRightBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/al_right.gif")));
        this.alRightBtn.setToolTipText(this.options.getMsg("edit_text_align_right"));
        this.alRightBtn.setBorder(new SmallButtonBorder(this.alRightBtn, true));
        this.alRightBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 8);
        stylePanel.add((Component)this.alRightBtn, gridBagConstraints);
        textColorLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/fg.gif")));
        textColorLb.setText(":");
        textColorLb.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 8, 2, 2);
        stylePanel.add((Component)textColorLb, gridBagConstraints);
        this.textColorBtn.setToolTipText(this.options.getMsg("edit_act_textColor_tooltip"));
        this.textColorBtn.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 6);
        stylePanel.add((Component)this.textColorBtn, gridBagConstraints);
        bgColorLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/bg.gif")));
        bgColorLb.setText(":");
        bgColorLb.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        stylePanel.add((Component)bgColorLb, gridBagConstraints);
        this.bgColorBtn.setToolTipText(this.options.getMsg("edit_act_bgColor_tooltip"));
        this.bgColorBtn.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        stylePanel.add((Component)this.bgColorBtn, gridBagConstraints);
        ctrlPanel.addTab(this.options.getMsg("edit_text_act_style"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/styles.gif")), stylePanel);
        this.add((Component)ctrlPanel, "North");
    }

    protected TextActivityBase getTextActivity() {
        return (TextActivityBase)this.getActivity();
    }

    protected TextActivityBaseEditor getTextActivityEditor() {
        return (TextActivityBaseEditor)this.getActivityEditor();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textPane.setEnabled(enabled);
        this.widthEdit.setEnabled(enabled);
        this.heightEdit.setEnabled(enabled);
        this.fontFaceCombo.setEnabled(enabled);
        this.fontSizeCombo.setEnabled(enabled);
        this.boldBtn.setEnabled(enabled);
        this.italicBtn.setEnabled(enabled);
        this.underlineBtn.setEnabled(enabled);
        this.textColorBtn.setEnabled(enabled);
        this.bgColorBtn.setEnabled(enabled);
        this.targetBtn.setEnabled(enabled);
        this.alCenterBtn.setEnabled(enabled);
        this.alRightBtn.setEnabled(enabled);
        this.alLeftBtn.setEnabled(enabled);
        this.resizer.setEnabled(enabled);
        if (!enabled) {
            this.editTargetBtn.setEnabled(false);
            this.typeBtn.setEnabled(false);
        }
    }

    @Override
    public void fillData() {
        Dimension d;
        TextActivityBaseEditor tabe = this.getTextActivityEditor();
        TextActivityBase act = tabe == null ? null : tabe.getTextActivity();
        this.typeBtn.setEnabled(tabe != null && tabe.hasType());
        DefaultStyledDocument doc = act == null ? new DefaultStyledDocument() : act.tad;
        Style defaultStyle = doc.getStyle("default");
        AttributeSet as = defaultStyle.copyAttributes();
        this.textPane.setStyledDocument(doc);
        defaultStyle.addAttributes(as);
        doc.addDocumentListener(this);
        Dimension dimension = d = act == null ? DEFAULT_SIZE : act.getWindowSize();
        if (act == null || act.tad.getLength() == 0) {
            this.textPane.setBounds(0, 0, d.width, d.height);
        }
        this.widthEdit.setValue(d.width);
        this.heightEdit.setValue(d.height);
        this.textPane.setBackground(act == null ? Color.white : StyleConstants.getBackground(this.textPane.getStyle("default")));
        this.textScroll.setBounds(0, 0, d.width, d.height);
        this.resizer.setRect(this.textScroll.getBounds());
        this.resizer.setEnabled(act != null);
        if (act != null) {
            JPanelActiveBox[] boxes = act.tad.getPanelBoxes();
            for (int i = 0; i < boxes.length; ++i) {
                boxes[i].catchMouseEvents = false;
                Resizer resizer = new Resizer(boxes[i], null, true, this);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextActivityEditorTextPanel.this.textPane.revalidate();
                }
            });
        }
    }

    @Override
    public void resizeObjectTo(Rectangle r, JComponent jc) {
        if (jc == this.previewPanel) {
            TextActivityBase act = this.getTextActivity();
            if (act != null) {
                this.textScroll.setBounds(r.x, r.y, r.width, r.height);
                act.setWindowSize(this.textScroll.getSize());
                this.widthEdit.setValue(r.width);
                this.heightEdit.setValue(r.height);
                this.textScroll.revalidate();
                this.repaint();
                this.setModified(true);
            }
        } else if (jc instanceof JPanelActiveBox) {
            JPanelActiveBox jpab = (JPanelActiveBox)jc;
            jpab.setBounds(r.x, r.y, r.width, r.height);
            Dimension d = new Dimension(r.width, r.height);
            jpab.getActiveBoxContent().setDimension(d);
            jpab.setPreferredSize(d);
            jpab.setMaximumSize(d);
            this.setModified(true);
        }
    }

    @Override
    public void editObject(Rectangle r, JComponent jc, Point pt) {
        if (jc instanceof JPanelActiveBox) {
            ActiveBoxContent abc;
            JPanelActiveBox jpab = (JPanelActiveBox)jc;
            if (jpab.ab != null && (abc = ActiveBoxContentEditor.getActiveBoxContent(jpab.ab.getContent(), jpab, this.options, this.getActivityEditor().getMediaBagEditor(), jpab.ab)) != null) {
                jpab.setActiveBoxContent(abc);
                Dimension d = abc.getDimension();
                if (d != null) {
                    this.resizeObjectTo(new Rectangle(jpab.getX(), jpab.getY(), d.width, d.height), jpab);
                }
                this.setModified(true);
            }
        }
    }

    @Override
    public void saveData() {
        TextActivityBase act = this.getTextActivity();
        if (act != null) {
            // empty if block
        }
    }

    @Override
    protected Icon getIcon() {
        return ResourceManager.getImageIcon("icons/text_edit.gif");
    }

    @Override
    protected String getTitle() {
        return this.options.getMsg("edit_act_panels_text");
    }

    @Override
    protected String getTooltip() {
        return this.options.getMsg("edit_act_panels_text_tooltip");
    }

    @Override
    public boolean documentChangePerformed(DocumentEvent ev) {
        if (ev != null && ev.getType() == DocumentEvent.EventType.REMOVE && this.getTextActivity() != null) {
            this.getTextActivity().tad.tmb.removeUnattachedElements();
        }
        return ev != null;
    }

    @Override
    public boolean eventPerformed(EventObject ev) {
        boolean result = false;
        TextActivityBaseEditor tabe = this.getTextActivityEditor();
        if (tabe != null && !this.skipUpdate) {
            TextActivityBase ta = tabe.getTextActivity();
            SimpleAttributeSet attr = new SimpleAttributeSet();
            boolean paragraphAttr = false;
            boolean charAttr = false;
            boolean replace = false;
            Object src = ev == null ? null : ev.getSource();
            int xStart = this.textPane.getSelectionStart();
            int xFinish = this.textPane.getSelectionEnd();
            int len = 0;
            if (xStart != xFinish) {
                if (xFinish < xStart) {
                    int s = xStart;
                    xStart = xFinish;
                    xFinish = s;
                }
                len = xFinish - xStart;
            }
            if (src != null && src.equals(this.fontFaceCombo)) {
                this.fontName = this.fontFaceCombo.getSelectedItem().toString();
                StyleConstants.setFontFamily(attr, this.fontName);
                charAttr = true;
            } else if (src != null && src.equals(this.fontSizeCombo)) {
                int fs;
                try {
                    fs = Integer.parseInt(this.fontSizeCombo.getSelectedItem().toString());
                }
                catch (NumberFormatException ex) {
                    return false;
                }
                if (fs >= 1) {
                    this.fontSize = fs;
                    StyleConstants.setFontSize(attr, this.fontSize);
                    charAttr = true;
                }
            } else if (src == this.boldBtn) {
                StyleConstants.setBold(attr, this.boldBtn.isSelected());
                charAttr = true;
            } else if (src == this.italicBtn) {
                StyleConstants.setItalic(attr, this.italicBtn.isSelected());
                charAttr = true;
            } else if (src == this.underlineBtn) {
                StyleConstants.setUnderline(attr, this.underlineBtn.isSelected());
                charAttr = true;
            } else if (src == this.textColorBtn) {
                StyleConstants.setForeground(attr, this.textColorBtn.getColor());
                charAttr = true;
            } else if (src == this.targetBtn) {
                TargetMarker tm;
                boolean b = this.targetBtn.isSelected();
                TargetMarker targetMarker = tm = b ? this.createNewTarget() : ta.tad.tmb.getElementByOffset(xFinish, true);
                if (tm == null) {
                    return false;
                }
                if (!b && !this.deleteTarget(tm)) {
                    return true;
                }
                this.textPane.setCaretPosition(xStart);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextActivityEditorTextPanel.this.showAttributes(-1);
                    }
                });
            } else if (tabe.canEditTarget() && src == this.editTargetBtn) {
                tabe.editTarget(xFinish, this.options, this);
            } else if (src == this.insertBoxBtn) {
                JPanelActiveBox jpab = tabe.createNewBox(xStart, this.options, this);
                if (jpab != null) {
                    jpab.catchMouseEvents = false;
                    Resizer tm = new Resizer(jpab, null, true, this);
                }
            } else if (src == this.optionsBtn) {
                tabe.editCheckOptions(this.options, this);
            } else if (src == this.typeBtn && tabe.hasType()) {
                tabe.editType(this.options, this);
            } else if (src == this.bgColorBtn) {
                if (len != 0) {
                    StyleConstants.setBackground(attr, this.bgColorBtn.getColor());
                    charAttr = true;
                }
            } else if (src == this.alLeftBtn || src == this.alCenterBtn || src == this.alRightBtn) {
                int align = src == this.alCenterBtn ? 1 : (src == this.alRightBtn ? 2 : 0);
                StyleConstants.setAlignment(attr, align);
                paragraphAttr = true;
            } else if (src == this.styleBtn) {
                StyleContext sc = TextStyleEditorPanel.editStyleContext(this.options, ta.tad.styleContext, this);
                if (sc != null) {
                    try {
                        ta.setStyleContext(sc);
                        this.setInitializing(true);
                        this.fillData();
                        this.setInitializing(false);
                    }
                    catch (Exception ex) {
                        System.err.println("error applying styles:\n" + ex);
                    }
                }
            } else if (src == this.clearStylesBtn) {
                int d = this.options.getMessages().showQuestionDlg(this, "edit_text_act_clearStylesPrompt", null, "yn");
                if (d == 1) {
                    try {
                        ta.setTextActivityDocument(ta.tad.getJDomElementWithoutStyles());
                        this.setInitializing(true);
                        this.fillData();
                        this.setInitializing(false);
                    }
                    catch (Exception ex) {
                        System.err.println("Error cleaning styles:\n" + ex);
                    }
                }
            } else if (src == this.prevScreenBtn) {
                if (TextPrevScreenEditorPanel.editPrevScreen(this.options, (TextActivityBaseEditor)this.getActivityEditor(), this)) {
                    this.setModified(true);
                }
            } else if (src == this.widthEdit || src == this.heightEdit) {
                ta.setWindowSize(new Dimension(this.widthEdit.getValue(), this.heightEdit.getValue()));
                this.previewPanel.revalidate();
            }
            this.changeCombos = false;
            if (paragraphAttr) {
                ta.tad.setParagraphAttributes(xStart, len, attr, replace);
            }
            if (charAttr) {
                if (len > 0) {
                    ta.tad.setCharacterAttributes(xStart, len, attr, replace);
                } else {
                    MutableAttributeSet inputAttributes = this.textPane.getInputAttributes();
                    inputAttributes.addAttributes(attr);
                }
            }
            this.textPane.grabFocus();
            this.changeCombos = true;
            result = true;
        }
        return result;
    }

    protected TargetMarker createNewTarget() {
        TargetMarker result = null;
        TextActivityBaseEditor tabe = this.getTextActivityEditor();
        if (tabe != null) {
            int from = this.textPane.getSelectionStart();
            int to = this.textPane.getSelectionEnd();
            result = tabe.createNewTarget(from, to, this.options, this);
        }
        return result;
    }

    protected boolean deleteTarget(TargetMarker tm) {
        boolean result = false;
        TextActivityBaseEditor tabe = this.getTextActivityEditor();
        if (tabe != null) {
            result = tabe.deleteTarget(tm, this.options, this);
        }
        return result;
    }

    protected void showAttributes(int p) {
        TextActivityBaseEditor tabe = this.getTextActivityEditor();
        if (tabe != null) {
            int size;
            AttributeSet a;
            String name;
            TextActivityBase ta = tabe.getTextActivity();
            this.skipUpdate = true;
            if (p < 0) {
                p = Math.max(0, this.textPane.getCaretPosition());
            }
            if (!(name = StyleConstants.getFontFamily(a = ta.tad.getCharacterElement(p).getAttributes())).equals(this.fontName) && this.changeCombos) {
                this.fontName = name;
                this.fontFaceCombo.setSelectedItem(name);
            }
            if (this.fontSize != (size = StyleConstants.getFontSize(a)) && this.changeCombos) {
                this.fontSize = size;
                this.fontSizeCombo.setSelectedItem(Integer.toString(this.fontSize));
            }
            this.boldBtn.setSelected(StyleConstants.isBold(a));
            this.italicBtn.setSelected(StyleConstants.isItalic(a));
            this.underlineBtn.setSelected(StyleConstants.isUnderline(a));
            Color c = StyleConstants.getForeground(a);
            if (!c.equals(this.textColorBtn.getColor())) {
                this.textColorBtn.setColor(c);
            }
            if (!(c = StyleConstants.getBackground(a)).equals(this.bgColorBtn.getColor())) {
                this.bgColorBtn.setColor(c);
            }
            this.targetBtn.setSelected(a.isDefined("target"));
            this.editTargetBtn.setEnabled(tabe.canEditTarget() && a.isDefined("target"));
            int alignment = StyleConstants.getAlignment(a);
            this.alCenterBtn.setSelected(alignment == 1);
            this.alRightBtn.setSelected(alignment == 2);
            this.alLeftBtn.setSelected(alignment != 2 && alignment != 1);
            this.skipUpdate = false;
        }
    }

    protected class PreviewPanel
    extends ResizerPanel {
        protected PreviewPanel() {
        }

        @Override
        public void doLayout() {
            if (TextActivityEditorTextPanel.this.textScroll != null) {
                TextActivityBase act = TextActivityEditorTextPanel.this.getTextActivity();
                Dimension d = act != null ? act.getWindowSize() : new Dimension(400, 300);
                TextActivityEditorTextPanel.this.textScroll.setBounds(0, 0, d.width, d.height);
            }
        }
    }
}

