/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.util.Options;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class CheckOptionsPanel
extends JPanel {
    Options options;
    private JPanel btnPanel;
    private JCheckBox checkButtonChk;
    private JTextField checkButtonTxt;

    public CheckOptionsPanel(Options options) {
        this.options = options;
        this.initComponents();
    }

    private void initComponents() {
        this.btnPanel = new JPanel();
        this.checkButtonChk = new JCheckBox();
        JLabel checkButtonTextLb = new JLabel();
        this.checkButtonTxt = new JTextField();
        this.setLayout(new BoxLayout(this, 1));
        this.btnPanel.setLayout(new GridBagLayout());
        this.btnPanel.setBorder(new TitledBorder(this.options.getMsg("edit_text_act_checkButton")));
        this.checkButtonChk.setText(this.options.getMsg("edit_text_act_checkButton_show"));
        this.checkButtonChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckOptionsPanel.this.checkButtonChkActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.btnPanel.add((Component)this.checkButtonChk, gridBagConstraints);
        checkButtonTextLb.setText(this.options.getMsg("edit_text_act_checkButtonText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.btnPanel.add((Component)checkButtonTextLb, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.btnPanel.add((Component)this.checkButtonTxt, gridBagConstraints);
        this.add(this.btnPanel);
    }

    private void checkButtonChkActionPerformed(ActionEvent evt) {
        this.checkButtonTxt.setEnabled(this.checkButtonChk.isSelected());
    }

    public void setOptions(TextActivityBase tab) {
        this.checkButtonChk.setSelected(tab.hasCheckButton);
        String s = tab.checkButtonText;
        if (s == null || s.length() < 1) {
            s = this.options.getMsg("edit_text_act_defaultCheckButtonText");
        }
        this.checkButtonTxt.setText(s);
        this.checkButtonTxt.setEnabled(this.checkButtonChk.isSelected());
    }

    public void collectData(TextActivityBase tab) {
        tab.hasCheckButton = this.checkButtonChk.isSelected();
        String s = this.checkButtonTxt.getText();
        if (s == null || s.length() < 1) {
            s = this.options.getMsg("edit_text_act_defaultCheckButtonText");
        }
        tab.checkButtonText = s;
    }
}

