/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.AuthorSettings;
import edu.xtec.jclic.beans.ColorButton;
import edu.xtec.util.ExtendedJDialog;
import edu.xtec.util.LFUtil;
import edu.xtec.util.Messages;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class AuthorSettingsDlg
extends ExtendedJDialog {
    AuthorSettings settings;
    public boolean result;
    Component parent;
    Messages msg;
    private JTextField JScodebaseTxt;
    private JTextField browserField;
    private JTextField codebaseTxt;
    private ColorButton colorButton;
    private JTextField countryField;
    private JTextField heightText;
    private JPanel imgSizePanel;
    private JComboBox<Object> langCombo;
    private JComboBox<Object> lookCombo;
    private JRadioButton mDefaultBtn;
    private JRadioButton mJMFbtn;
    private JRadioButton mQTbtn;
    private JTextField maxImgHeightText;
    private JTextField maxImgWidthText;
    private JTextField variantField;
    private JTextField widthText;

    public AuthorSettingsDlg(AuthorSettings settings, Component parent) {
        super(parent, "", true);
        this.parent = parent;
        this.settings = settings;
        this.msg = settings.rb.getOptions().getMessages();
        this.setTitle(this.msg.get("settings_title"));
        this.result = false;
        this.initComponents();
        this.centerOver(parent);
    }

    private void initComponents() {
        ButtonGroup reportGroup = new ButtonGroup();
        ButtonGroup mediaGroup = new ButtonGroup();
        JTabbedPane mainPane = new JTabbedPane();
        JPanel generalPane = new JPanel();
        JLabel lookLb = new JLabel();
        this.lookCombo = new JComboBox<String>(LFUtil.VALUES);
        JLabel langLb = new JLabel();
        this.langCombo = new JComboBox<String>(Messages.getDescriptiveLanguageCodes(this.msg.getLocale()));
        JLabel countryLb = new JLabel();
        this.countryField = new JTextField();
        JLabel variantLb = new JLabel();
        this.variantField = new JTextField();
        JLabel browserLb = new JLabel();
        this.browserField = new JTextField();
        this.imgSizePanel = new JPanel();
        JLabel maxImgWidthLb = new JLabel();
        this.maxImgWidthText = new JTextField();
        JLabel maxImgHeightLb = new JLabel();
        this.maxImgHeightText = new JTextField();
        JPanel mediaPane = new JPanel();
        JPanel mediaSystemPanel = new JPanel();
        this.mDefaultBtn = new JRadioButton();
        this.mJMFbtn = new JRadioButton();
        this.mQTbtn = new JRadioButton();
        JPanel htmlPane = new JPanel();
        JLabel codebaseLb = new JLabel();
        this.codebaseTxt = new JTextField();
        JLabel colorLb = new JLabel();
        this.colorButton = new ColorButton();
        this.colorButton.setOptions(this.settings.rb.getOptions());
        JLabel widthLb = new JLabel();
        this.widthText = new JTextField();
        JLabel heightLb = new JLabel();
        this.heightText = new JTextField();
        JLabel JScodebaseLb = new JLabel();
        this.JScodebaseTxt = new JTextField();
        JPanel btPanel = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AuthorSettingsDlg.this.closeDialog(evt);
            }
        });
        mainPane.setToolTipText(this.msg.get("settings_report_tooltip"));
        mainPane.setPreferredSize(new Dimension(500, 400));
        generalPane.setToolTipText(this.msg.get("settings_general_tooltip"));
        generalPane.setLayout(new GridBagLayout());
        lookLb.setLabelFor(this.lookCombo);
        lookLb.setText(this.msg.get("settings_look"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)lookLb, gridBagConstraints);
        this.lookCombo.setSelectedItem(this.settings.lookAndFeel);
        this.lookCombo.setToolTipText(this.msg.get("settings_look_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add(this.lookCombo, gridBagConstraints);
        langLb.setLabelFor(this.langCombo);
        langLb.setText(this.msg.get("settings_language"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)langLb, gridBagConstraints);
        this.langCombo.setSelectedItem(Messages.getDescriptiveLanguageCode(this.settings.language));
        this.langCombo.setToolTipText(this.msg.get("settings_language_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add(this.langCombo, gridBagConstraints);
        countryLb.setLabelFor(this.countryField);
        countryLb.setText(this.msg.get("settings_country"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)countryLb, gridBagConstraints);
        this.countryField.setText(this.settings.country);
        this.countryField.setToolTipText(this.msg.get("settings_country_tooltip"));
        this.countryField.setMinimumSize(new Dimension(75, 21));
        this.countryField.setPreferredSize(new Dimension(200, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)this.countryField, gridBagConstraints);
        variantLb.setLabelFor(this.variantField);
        variantLb.setText(this.msg.get("settings_variant"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)variantLb, gridBagConstraints);
        this.variantField.setText(this.settings.variant);
        this.variantField.setToolTipText(this.msg.get("settings_variant_tooltip"));
        this.variantField.setMinimumSize(new Dimension(75, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)this.variantField, gridBagConstraints);
        browserLb.setText(this.msg.get("settings_browser"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)browserLb, gridBagConstraints);
        this.browserField.setText(this.settings.preferredBrowser);
        this.browserField.setToolTipText(this.msg.get("settings_browser_tooltip"));
        this.browserField.setMinimumSize(new Dimension(75, 21));
        this.browserField.setPreferredSize(new Dimension(200, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)this.browserField, gridBagConstraints);
        this.imgSizePanel.setBorder(BorderFactory.createTitledBorder(this.msg.get("img_max_size")));
        this.imgSizePanel.setLayout(new GridBagLayout());
        maxImgWidthLb.setLabelFor(this.maxImgWidthText);
        maxImgWidthLb.setText(this.msg.get("WIDTH"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.imgSizePanel.add((Component)maxImgWidthLb, gridBagConstraints);
        this.maxImgWidthText.setHorizontalAlignment(4);
        this.maxImgWidthText.setText(Integer.toString(this.settings.imgMaxWidth));
        this.maxImgWidthText.setToolTipText(this.msg.get("img_max_width_tooltip"));
        this.maxImgWidthText.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.imgSizePanel.add((Component)this.maxImgWidthText, gridBagConstraints);
        maxImgHeightLb.setLabelFor(this.maxImgHeightText);
        maxImgHeightLb.setText(this.msg.get("HEIGHT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.imgSizePanel.add((Component)maxImgHeightLb, gridBagConstraints);
        this.maxImgHeightText.setHorizontalAlignment(4);
        this.maxImgHeightText.setText(Integer.toString(this.settings.imgMaxHeight));
        this.maxImgHeightText.setToolTipText(this.msg.get("img_max_height_tooltip"));
        this.maxImgHeightText.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.imgSizePanel.add((Component)this.maxImgHeightText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        generalPane.add((Component)this.imgSizePanel, gridBagConstraints);
        mainPane.addTab(this.msg.get("settings_general"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/settings.gif")), generalPane, "");
        mediaPane.setToolTipText(this.msg.get("settings_media_tooltip"));
        mediaPane.setLayout(new GridBagLayout());
        mediaSystemPanel.setBorder(BorderFactory.createTitledBorder(this.msg.get("settings_media_system")));
        mediaSystemPanel.setLayout(new GridBagLayout());
        mediaGroup.add(this.mDefaultBtn);
        this.mDefaultBtn.setSelected("default".equals(this.settings.mediaSystem));
        this.mDefaultBtn.setText(this.msg.get("settings_media_default"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        mediaSystemPanel.add((Component)this.mDefaultBtn, gridBagConstraints);
        mediaGroup.add(this.mJMFbtn);
        this.mJMFbtn.setSelected("Java Media Framework".equals(this.settings.mediaSystem));
        this.mJMFbtn.setText(this.msg.get("settings_media_jmf"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        mediaSystemPanel.add((Component)this.mJMFbtn, gridBagConstraints);
        mediaGroup.add(this.mQTbtn);
        this.mQTbtn.setSelected("QuickTime".equals(this.settings.mediaSystem));
        this.mQTbtn.setText(this.msg.get("settings_media_qt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        mediaSystemPanel.add((Component)this.mQTbtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        mediaPane.add((Component)mediaSystemPanel, gridBagConstraints);
        mainPane.addTab(this.msg.get("settings_media"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/audio_on.gif")), mediaPane, "");
        htmlPane.setToolTipText(this.msg.get("settings_applet_tooltip"));
        htmlPane.setLayout(new GridBagLayout());
        codebaseLb.setLabelFor(this.codebaseTxt);
        codebaseLb.setText(this.msg.get("applet_codebase"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        htmlPane.add((Component)codebaseLb, gridBagConstraints);
        this.codebaseTxt.setText(this.settings.appletCodeBase);
        this.codebaseTxt.setToolTipText(this.msg.get("applet_codebase_tooltip"));
        this.codebaseTxt.setPreferredSize(new Dimension(300, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        htmlPane.add((Component)this.codebaseTxt, gridBagConstraints);
        colorLb.setLabelFor(this.colorButton);
        colorLb.setText(this.msg.get("applet_bgcolor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        htmlPane.add((Component)colorLb, gridBagConstraints);
        this.colorButton.setToolTipText(this.msg.get("applet_bgcolor_tooltip"));
        this.colorButton.setColor(this.settings.appletBgColor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        htmlPane.add((Component)this.colorButton, gridBagConstraints);
        widthLb.setLabelFor(this.widthText);
        widthLb.setText(this.msg.get("WIDTH"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        htmlPane.add((Component)widthLb, gridBagConstraints);
        this.widthText.setHorizontalAlignment(4);
        this.widthText.setText(this.settings.appletWidth);
        this.widthText.setToolTipText(this.msg.get("applet_width_tooltip"));
        this.widthText.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        htmlPane.add((Component)this.widthText, gridBagConstraints);
        heightLb.setLabelFor(this.heightText);
        heightLb.setText(this.msg.get("HEIGHT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        htmlPane.add((Component)heightLb, gridBagConstraints);
        this.heightText.setHorizontalAlignment(4);
        this.heightText.setText(this.settings.appletHeight);
        this.heightText.setToolTipText(this.msg.get("applet_height_tooltip"));
        this.heightText.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        htmlPane.add((Component)this.heightText, gridBagConstraints);
        JScodebaseLb.setLabelFor(this.JScodebaseTxt);
        JScodebaseLb.setText(this.msg.get("js_codebase"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 2, 2, 2);
        htmlPane.add((Component)JScodebaseLb, gridBagConstraints);
        this.JScodebaseTxt.setText(this.settings.jsCodeBase);
        this.JScodebaseTxt.setToolTipText(this.msg.get("js_codebase_tooltip"));
        this.JScodebaseTxt.setPreferredSize(new Dimension(300, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 2, 2, 2);
        htmlPane.add((Component)this.JScodebaseTxt, gridBagConstraints);
        mainPane.addTab(this.msg.get("settings_html"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/html_doc.gif")), htmlPane);
        this.getContentPane().add((Component)mainPane, "Center");
        okButton.setText(this.msg.get("OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuthorSettingsDlg.this.okButtonActionPerformed(evt);
            }
        });
        btPanel.add(okButton);
        cancelButton.setText(this.msg.get("CANCEL"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuthorSettingsDlg.this.cancelButtonActionPerformed(evt);
            }
        });
        btPanel.add(cancelButton);
        this.getContentPane().add((Component)btPanel, "South");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = false;
        this.closeDialog(null);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.accept()) {
            this.result = true;
            this.closeDialog(null);
        }
    }

    public boolean accept() {
        Object p1 = null;
        this.settings.lookAndFeel = (String)this.lookCombo.getSelectedItem();
        this.settings.preferredBrowser = this.browserField.getText();
        this.settings.language = Messages.getLanguageFromDescriptive((String)this.langCombo.getSelectedItem());
        this.settings.country = StrUtils.nullableString(this.countryField.getText());
        this.settings.variant = StrUtils.nullableString(this.variantField.getText());
        this.settings.mediaSystem = this.mJMFbtn.isSelected() ? "Java Media Framework" : (this.mQTbtn.isSelected() ? "QuickTime" : "default");
        this.settings.appletCodeBase = StrUtils.secureString(this.codebaseTxt.getText(), "http://clic.xtec.cat/dist/jclic");
        this.settings.appletWidth = StrUtils.secureString(this.widthText.getText(), "700");
        this.settings.appletHeight = StrUtils.secureString(this.heightText.getText(), "450");
        this.settings.appletBgColor = this.colorButton.getColor();
        this.settings.jsCodeBase = StrUtils.secureString(this.JScodebaseTxt.getText(), "https://clic.xtec.cat/dist/jclic.js/jclic.min.js");
        this.settings.imgMaxWidth = Integer.parseInt(StrUtils.secureString(this.maxImgWidthText.getText(), Integer.toString(800)));
        this.settings.imgMaxHeight = Integer.parseInt(StrUtils.secureString(this.maxImgHeightText.getText(), Integer.toString(600)));
        return true;
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

