/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.AuthorSettings;
import edu.xtec.jclic.beans.ColorButton;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.BrowserLauncher;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class AppletHtmlCreator
extends JPanel
implements ActionListener {
    Options options;
    AuthorSettings settings;
    static String appletCode = "<!doctype html public \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<html>\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=%ENCODING\">\n<title>%TITLE</title>\n<script language=\"JavaScript\" src=\"%JAR_BASE/jclicplugin.js\" type=\"text/javascript\"></script>\n</head>\n<body %BODYPARAMS>\n%PRE_APPLET\n<script language=\"JavaScript\">\nsetJarBase('%JAR_BASE');%OTHER\nwritePlugin('%PROJECT', '%WIDTH', '%HEIGHT');\n</script>\n%POST_APPLET\n</body>\n</html>";
    private ButtonGroup bg;
    private JCheckBox centeredChk;
    private ColorButton colorButton;
    private JTextField exitUrlTxt;
    private JRadioButton fullPageOption;
    private JTextField heightText;
    private JRadioButton mixedContentOption;
    private JTextArea postTextEdit;
    private JTextArea prevTextEdit;
    private JPanel sizePanel;
    private JTextField titleTxt;
    private JTextField widthText;
    private static AppletHtmlCreator panel;

    public AppletHtmlCreator(Options options, AuthorSettings settings) {
        this.options = options;
        this.settings = settings;
        this.initComponents();
        this.fullPageOption.addActionListener(this);
        this.mixedContentOption.addActionListener(this);
        this.checkEnabled();
    }

    private void initComponents() {
        this.bg = new ButtonGroup();
        JLabel titleLb = new JLabel();
        this.titleTxt = new JTextField();
        JLabel exitUrlLb = new JLabel();
        this.exitUrlTxt = new JTextField();
        this.fullPageOption = new JRadioButton();
        this.mixedContentOption = new JRadioButton();
        this.sizePanel = new JPanel();
        JLabel colorLb = new JLabel();
        this.colorButton = new ColorButton();
        this.colorButton.setOptions(this.options);
        JLabel prevTxtLb = new JLabel();
        JScrollPane prevTextScroll = new JScrollPane();
        this.prevTextEdit = new JTextArea();
        JLabel widthLb = new JLabel();
        this.widthText = new JTextField();
        JLabel heightLb = new JLabel();
        this.heightText = new JTextField();
        this.centeredChk = new JCheckBox();
        JLabel postTxtLb = new JLabel();
        JScrollPane postTextScroll = new JScrollPane();
        this.postTextEdit = new JTextArea();
        this.setLayout(new GridBagLayout());
        titleLb.setLabelFor(this.titleTxt);
        titleLb.setText(this.options.getMsg("applet_page_title"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)titleLb, gridBagConstraints);
        this.titleTxt.setToolTipText(this.options.getMsg("applet_page_title_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.titleTxt, gridBagConstraints);
        exitUrlLb.setLabelFor(this.exitUrlTxt);
        exitUrlLb.setText(this.options.getMsg("applet_exitUrl"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)exitUrlLb, gridBagConstraints);
        this.exitUrlTxt.setToolTipText(this.options.getMsg("applet_exitUrl_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.exitUrlTxt, gridBagConstraints);
        this.fullPageOption.setSelected(true);
        this.fullPageOption.setText(this.options.getMsg("applet_page_full"));
        this.bg.add(this.fullPageOption);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.fullPageOption, gridBagConstraints);
        this.mixedContentOption.setText(this.options.getMsg("applet_page_mixed"));
        this.bg.add(this.mixedContentOption);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.mixedContentOption, gridBagConstraints);
        this.sizePanel.setLayout(new GridBagLayout());
        this.sizePanel.setBorder(new TitledBorder(this.options.getMsg("applet_size")));
        this.sizePanel.setToolTipText(this.options.getMsg("applet_size_tooltip"));
        colorLb.setLabelFor(this.colorButton);
        colorLb.setText(this.options.getMsg("applet_bgcolor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)colorLb, gridBagConstraints);
        this.colorButton.setToolTipText(this.options.getMsg("applet_bgcolor_tooltip"));
        this.colorButton.setColor(this.settings.appletBgColor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)this.colorButton, gridBagConstraints);
        prevTxtLb.setLabelFor(this.prevTextEdit);
        prevTxtLb.setText(this.options.getMsg("applet_prev_text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)prevTxtLb, gridBagConstraints);
        prevTextScroll.setPreferredSize(new Dimension(200, 60));
        prevTextScroll.setMinimumSize(new Dimension(200, 60));
        this.prevTextEdit.setWrapStyleWord(true);
        this.prevTextEdit.setToolTipText(this.options.getMsg("applet_prev_text_tooltip"));
        this.prevTextEdit.setLineWrap(true);
        prevTextScroll.setViewportView(this.prevTextEdit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)prevTextScroll, gridBagConstraints);
        widthLb.setLabelFor(this.widthText);
        widthLb.setText(this.options.getMsg("WIDTH"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)widthLb, gridBagConstraints);
        this.widthText.setToolTipText(this.options.getMsg("applet_width_tooltip"));
        this.widthText.setText(this.settings.appletWidth);
        this.widthText.setHorizontalAlignment(4);
        this.widthText.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)this.widthText, gridBagConstraints);
        heightLb.setLabelFor(this.heightText);
        heightLb.setText(this.options.getMsg("HEIGHT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)heightLb, gridBagConstraints);
        this.heightText.setToolTipText(this.options.getMsg("applet_height_tooltip"));
        this.heightText.setText(this.settings.appletHeight);
        this.heightText.setHorizontalAlignment(4);
        this.heightText.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)this.heightText, gridBagConstraints);
        this.centeredChk.setToolTipText(this.options.getMsg("applet_centered_tooltip"));
        this.centeredChk.setSelected(true);
        this.centeredChk.setText(this.options.getMsg("applet_centered"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)this.centeredChk, gridBagConstraints);
        postTxtLb.setLabelFor(this.postTextEdit);
        postTxtLb.setText(this.options.getMsg("applet_post_text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)postTxtLb, gridBagConstraints);
        postTextScroll.setPreferredSize(new Dimension(200, 60));
        postTextScroll.setMinimumSize(new Dimension(200, 60));
        this.postTextEdit.setWrapStyleWord(true);
        this.postTextEdit.setToolTipText(this.options.getMsg("applet_post_text_tooltip"));
        this.postTextEdit.setLineWrap(true);
        postTextScroll.setViewportView(this.postTextEdit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel.add((Component)postTextScroll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 2, 2, 2);
        this.add((Component)this.sizePanel, gridBagConstraints);
    }

    public void setValues(JClicProject prj) {
        this.titleTxt.setText(prj.settings.title);
    }

    public static void createHtml(JClicProject prj, AuthorSettings settings, Component parent) {
        Options options = prj.getBridge().getOptions();
        Messages msg = options.getMessages();
        if (panel == null) {
            panel = new AppletHtmlCreator(options, settings);
        }
        String prjFile = FileSystem.getFileNameOf(prj.getFullPath());
        panel.setValues(prj);
        if (msg.showInputDlg(parent, panel, "applet_create_title")) {
            String path;
            boolean full = AppletHtmlCreator.panel.fullPageOption.isSelected();
            String title = AppletHtmlCreator.panel.titleTxt.getText();
            String width = AppletHtmlCreator.panel.widthText.getText();
            String height = AppletHtmlCreator.panel.heightText.getText();
            String preApplet = AppletHtmlCreator.panel.prevTextEdit.getText();
            String postApplet = AppletHtmlCreator.panel.postTextEdit.getText();
            Color bgColor = AppletHtmlCreator.panel.colorButton.getColor();
            boolean centered = AppletHtmlCreator.panel.centeredChk.isSelected();
            StringBuilder optionalParams = new StringBuilder();
            String ps = StrUtils.nullableString(AppletHtmlCreator.panel.exitUrlTxt.getText());
            if (ps != null) {
                optionalParams.append("\r\nsetExitUrl('").append(ps).append("');");
            }
            int[] filters = new int[]{21};
            FileSystem fs = prj.getFileSystem();
            String fileName = fs.chooseFile(path = "index.htm", true, filters, options, null, parent, false);
            if (fileName != null) {
                try {
                    File file = new File(prj.getFileSystem().getFullFileNamePath(fileName));
                    FileOutputStream fos = prj.getFileSystem().createSecureFileOutputStream(fileName, false);
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                    PrintWriter pw = new PrintWriter(osw);
                    String s = StrUtils.replace(appletCode, "%ENCODING", "UTF-8");
                    s = StrUtils.replace(s, "%JAR_BASE", settings.appletCodeBase);
                    s = StrUtils.replace(s, "%TITLE", title);
                    StringBuilder sb = new StringBuilder();
                    if (full) {
                        sb.append("leftmargin=\"0\" topmargin=\"0\" marginwidth=\"0\" marginheight=\"0\" onLoad=\"window.focus();\"");
                    } else {
                        sb.append("bgcolor=#");
                        sb.append(Integer.toHexString(bgColor.getRed()));
                        sb.append(Integer.toHexString(bgColor.getGreen()));
                        sb.append(Integer.toHexString(bgColor.getBlue()));
                    }
                    s = StrUtils.replace(s, "%BODYPARAMS", sb.substring(0));
                    sb.setLength(0);
                    if (!full) {
                        if (centered) {
                            sb.append("<div align=\"center\">");
                        }
                        if (preApplet.length() > 0) {
                            sb.append(preApplet).append("<br>");
                        }
                    }
                    s = StrUtils.replace(s, "%PRE_APPLET", sb.substring(0));
                    s = StrUtils.replace(s, "%OTHER", optionalParams.substring(0));
                    s = StrUtils.replace(s, "%WIDTH", full ? "100%" : width);
                    s = StrUtils.replace(s, "%HEIGHT", full ? "100%" : height);
                    s = StrUtils.replace(s, "%PROJECT", prjFile);
                    sb.setLength(0);
                    if (!full) {
                        if (postApplet.length() > 0) {
                            sb.append("<br>").append(postApplet);
                        }
                        if (centered) {
                            sb.append("</div>");
                        }
                    }
                    s = StrUtils.replace(s, "%POST_APPLET", sb.substring(0));
                    pw.print(s);
                    pw.flush();
                    pw.close();
                    String prompt = StrUtils.replace(msg.get("applet_created_info"), "%s", fileName);
                    if (msg.showQuestionDlgObj(parent, prompt + "\n" + msg.get("applet_created_prompt"), null, "yn") == 1) {
                        BrowserLauncher.openURL(prj.getFileSystem().getUrl(fileName));
                    }
                }
                catch (Exception ex) {
                    options.getMessages().showErrorWarning(parent, "ERROR", ex);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.checkEnabled();
    }

    public final void checkEnabled() {
        boolean b = this.mixedContentOption.isSelected();
        this.colorButton.setEnabled(b);
        this.widthText.setEnabled(b);
        this.heightText.setEnabled(b);
        this.centeredChk.setEnabled(b);
        this.prevTextEdit.setEnabled(b);
        this.postTextEdit.setEnabled(b);
    }
}

