/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.ActivityEditor;
import edu.xtec.jclic.ActivityEditorInternalPanel;
import edu.xtec.jclic.activities.text.TextActivityEditorTextPanel;
import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.boxes.ActiveBagContentEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.util.Options;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class ActivityEditorPanel
extends EditorPanel {
    List<ActivityEditorInternalPanel> internalPanels = new ArrayList<ActivityEditorInternalPanel>(4);
    String currentActivityClass;
    Map<String, ActivityEditorInternalPanel> panelStore = new HashMap<String, ActivityEditorInternalPanel>();
    public static final String SINGLE = "SINGLE";
    public static final String SINGLE_ALT = "SINGLE_ALT";
    public static final String SINGLE_BOOL_ALT = "SINGLE_BOOL_ALT";
    public static final String SINGLE_LAYOUT = "SINGLE_LAYOUT";
    public static final String DOUBLE_ALT = "DOUBLE_ALT";
    public static final String DOUBLE_REL = "DOUBLE_REL";
    public static final String DOUBLE_REL_ALT = "DOUBLE_REL_ALT";
    public static final String TEXTGRID_ALT = "TEXTGRID_ALT";
    public static final String TEXTGRID_CRW = "TEXTGRID_CRW";
    public static final String TEXT_BASE = "TEXT_BASE";
    private JPanel mainPanel;
    private JTabbedPane tabbedPane;

    public ActivityEditorPanel(Options options) {
        super(options);
        this.initComponents();
        this.postInit(250, false, false);
        this.setEnabled(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Iterator<ActivityEditorInternalPanel> it = this.internalPanels.iterator();
        while (it.hasNext()) {
            it.next().setEnabled(enabled);
        }
    }

    public void addInternalPanel(ActivityEditorInternalPanel panel, String title, String tooltip) {
        if (title == null) {
            title = panel.getTitle();
        }
        if (tooltip == null) {
            tooltip = panel.getTooltip();
        }
        this.tabbedPane.addTab(title, panel.getIcon(), panel, tooltip);
        this.internalPanels.add(panel);
    }

    public void addInternalPanel(String storeKey, String title, String tooltip) {
        ActivityEditorInternalPanel panel = this.panelStore.get(storeKey);
        if (panel == null) {
            if (SINGLE.equals(storeKey)) {
                panel = new ActiveBagContentEditor(this, 0);
                this.panelStore.put(storeKey, panel);
            } else if (SINGLE_LAYOUT.equals(storeKey)) {
                panel = new ActiveBagContentEditor(this, 3);
                this.panelStore.put(storeKey, panel);
            } else if (SINGLE_ALT.equals(storeKey)) {
                panel = new ActiveBagContentEditor(this, 1);
                this.panelStore.put(storeKey, panel);
            } else if (SINGLE_BOOL_ALT.equals(storeKey)) {
                panel = new ActiveBagContentEditor(this, 2);
                this.panelStore.put(storeKey, panel);
            } else if (DOUBLE_ALT.equals(storeKey)) {
                panel = new ActiveBagContentEditor(this, 4);
                this.panelStore.put(storeKey, panel);
            } else if (DOUBLE_REL.equals(storeKey)) {
                panel = new ActiveBagContentEditor(this, 5);
                this.panelStore.put(storeKey, panel);
            } else if (DOUBLE_REL_ALT.equals(storeKey)) {
                panel = new ActiveBagContentEditor(this, 6);
                this.panelStore.put(storeKey, panel);
            } else if (TEXTGRID_ALT.equals(storeKey)) {
                panel = new ActiveBagContentEditor(this, 7);
                this.panelStore.put(storeKey, panel);
            } else if (TEXTGRID_CRW.equals(storeKey)) {
                panel = new ActiveBagContentEditor(this, 8);
                this.panelStore.put(storeKey, panel);
            } else if (TEXT_BASE.equals(storeKey)) {
                panel = new TextActivityEditorTextPanel(this);
                this.panelStore.put(storeKey, panel);
            }
        }
        if (panel != null) {
            this.addInternalPanel(panel, title, tooltip);
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.setToolTipText(this.options.getMsg("edit_act_descriptionTab_tooltip"));
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.mainPanel, "Center");
    }

    @Override
    protected synchronized void setEditor(Editor e) {
        if (e instanceof ActivityEditor) {
            String s;
            ActivityEditor ae = (ActivityEditor)e;
            MediaBagEditor mbe = ae.getMediaBagEditor();
            if (mbe != null && Utils.lowMemoryCondition()) {
                mbe.getMediaBag().clearData();
            }
            if (!(s = ae.getActivity().getClass().getName()).equals(this.currentActivityClass)) {
                int cs = Math.max(this.tabbedPane.getSelectedIndex(), 0);
                int c = this.tabbedPane.getTabCount();
                for (int i = c - 1; i >= 3; --i) {
                    this.tabbedPane.remove(this.internalPanels.remove(i));
                }
                ae.createPanels(this);
                final int csx = Math.min(cs, this.internalPanels.size() - 1);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ActivityEditorPanel.this.internalPanels.size() >= csx) {
                            ActivityEditorPanel.this.tabbedPane.setSelectedIndex(csx);
                        }
                    }
                });
            }
            this.currentActivityClass = s;
        }
        super.setEditor(e);
    }

    @Override
    public boolean checkIfEditorValid(Editor e) {
        return e instanceof ActivityEditor;
    }

    protected ActivityEditor getActivityEditor() {
        return (ActivityEditor)this.editor;
    }

    protected Activity getActivity() {
        if (this.editor == null) {
            return null;
        }
        return this.getActivityEditor().getActivity();
    }

    @Override
    public void fillData() {
        Activity act = this.getActivity();
        if (act != null) {
            Iterator<ActivityEditorInternalPanel> it = this.internalPanels.iterator();
            while (it.hasNext()) {
                it.next().fillData();
            }
        }
    }

    @Override
    public void saveData() {
        Activity act = this.getActivity();
        if (act != null) {
            Iterator<ActivityEditorInternalPanel> it = this.internalPanels.iterator();
            while (it.hasNext()) {
                it.next().saveData();
            }
            this.getActivityEditor().saveData();
        }
    }

    @Override
    protected Icon getIcon() {
        return ActivityEditor.getIcon();
    }

    @Override
    protected String getTitle() {
        return "activity";
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.editor != null) {
            this.editor.collectData();
        }
    }
}

