/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.report.ActivityData;
import edu.xtec.jclic.report.GroupData;
import edu.xtec.jclic.report.ReportUtils;
import edu.xtec.jclic.report.SessionData;
import edu.xtec.jclic.report.UserData;
import edu.xtec.jclic.report.rp.BasicReport;
import edu.xtec.jclic.report.rp.Img;
import edu.xtec.jclic.report.rp.Main;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;

public abstract class Report
extends BasicReport {
    public static final int DEFAULT_SELECT_WIDTH = 180;
    public static final String SESSION = "session";
    protected boolean isEditable = true;
    protected boolean userTables = true;
    protected String change;
    protected String opcioDefecte;
    protected Object[] session;
    protected List<GroupData> groups;
    protected List<UserData> users;
    protected List projects;
    public static final String[] KCC_LABELS = new String[]{"report_key", "report_code", "report_context"};

    @Override
    public boolean init() throws Exception {
        if (!super.init()) {
            return false;
        }
        this.isEditable = !"false".equalsIgnoreCase(this.getParamNotNull("edit"));
        this.userTables = bridge.hasUserTables();
        if (this.userTables) {
            this.groups = bridge.getGroups();
            if (this.groupId.length() > 0) {
                this.users = bridge.getUsers(this.groupId);
            }
        }
        this.session = this.getParams(SESSION);
        this.change = this.getParam("change");
        switch ("group".equals(this.change) ? 0 : ("user".equals(this.change) ? 1 : ("date".equals(this.change) ? 2 : ("project".equals(this.change) ? 3 : ("activity".equals(this.change) ? 4 : 5))))) {
            case 0: {
                this.userId = this.users != null && this.users.size() > 0 ? this.users.get(0).getId() : "";
            }
            case 1: {
                this.projectName = "-1";
            }
            case 2: 
            case 3: {
                this.session = null;
                this.activityName = "-1";
            }
        }
        return true;
    }

    @Override
    public void head(PrintWriter out) throws Exception {
        super.head(out);
        StringBuilder sb = new StringBuilder(300);
        this.writeGoScript(sb);
        this.dm.writeDateScript(sb);
        out.println(sb.substring(0));
    }

    @Override
    public void body(PrintWriter out) throws Exception {
        super.body(out);
        StringBuilder sb = new StringBuilder(2000);
        if (this.isEditable) {
            sb.append(Report.linkTo(Report.urlParam(Main.URL, "lang", this.lang), this.bundle.getString(Main.TITLE), null));
        }
        this.standardHeader(out, Report.filter(this.getTitle(this.bundle)), sb.substring(0));
        sb.setLength(0);
        sb.append("<form action=\"").append(this.getUrl()).append("\" method=\"post\" name=\"").append("mainForm").append("\">\n");
        sb.append("<input type=\"hidden\" name=\"").append("change").append("\" value=\"").append("new").append("\">\n");
        sb.append("<input type=\"hidden\" name=\"").append("lang").append("\" value=\"").append(this.lang).append("\">\n");
        this.dm.writeHiddenFields(sb);
        if (this.session != null) {
            for (int i = 0; i <= this.session.length; ++i) {
                sb.append("<input type=\"hidden\" name=\"").append(SESSION).append("\" value=\"");
                sb.append(i < this.session.length && this.session[i] != null ? (String)this.session[i] : "false").append("\">\n");
            }
        }
        if (!this.isEditable) {
            sb.append("<input type=\"hidden\" name=\"").append("edit").append("\" value=\"").append("false").append("\">\n");
        }
        out.println(sb.substring(0));
    }

    protected void writeGoScript(StringBuilder sb) {
        sb.append("<script language=\"JavaScript\" type=\"text/javascript\">\n");
        sb.append("<!--\n");
        sb.append(" function go(canvi){\n");
        sb.append("   document.").append("mainForm").append(".").append("change").append(".value=canvi;\n");
        sb.append("   document.").append("mainForm").append(".submit();\n");
        sb.append(" };\n");
        sb.append("//-->\n");
        sb.append("</script>\n");
    }

    protected void writeSessionScript(StringBuilder sb) {
        sb.append("<script language=\"JavaScript\" type=\"text/javascript\">\n");
        sb.append("<!--\n");
        sb.append(" function session(id,v){\n");
        sb.append("     document.").append("mainForm").append(".").append(SESSION).append("[id].value=v\n");
        sb.append("     go('").append(SESSION).append("');\n");
        sb.append(" };\n");
        sb.append("//-->\n");
        sb.append("</script>\n");
    }

    protected void llista(StringBuilder sb, String selectName, boolean submitOnChange, String defaultOption, String[][] values, String selectedValue, int width) {
        sb.append("<select name=\"").append(selectName);
        if (width > 0) {
            sb.append("\" style=\"width:").append(width).append("px\"");
        }
        sb.append(" size=\"1\"");
        if (submitOnChange) {
            sb.append(" onChange=\"go('").append(selectName).append("')\"");
        }
        sb.append(">\n");
        if (defaultOption != null) {
            sb.append("<option>").append(Report.filter(defaultOption)).append("</option>\n");
        }
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                sb.append("<option value=\"").append(Report.filter(values[i][0])).append("\"");
                if (selectedValue != null && selectedValue.equals(values[i][0])) {
                    sb.append(" selected");
                }
                sb.append(">").append(Report.filter(values[i][1])).append("</option>\n");
            }
        } else {
            sb.append("<option>");
            for (int i = 0; i < 27; ++i) {
                sb.append("&nbsp;");
            }
            sb.append("</option>\n");
        }
        sb.append("</select>\n");
    }

    protected void zona(StringBuilder sb, String descKey, String selectName, boolean submitOnChange, String defaultOption, String[][] values, String selectedValue, boolean showList, int width) {
        sb.append("<p>").append(Report.filter(this.getMsg(descKey))).append("&nbsp;");
        if (showList && values != null) {
            this.llista(sb, selectName, submitOnChange, defaultOption, values, selectedValue, width);
        } else {
            sb.append("<input type=\"hidden\" name=\"").append(selectName).append("\"");
            if (selectedValue != null) {
                sb.append(" value=\"").append(Report.filter(selectedValue)).append("\"");
            }
            sb.append("/>\n");
            if (selectedValue != null && values != null) {
                for (int i = 0; i < values.length; ++i) {
                    if (!selectedValue.equals(values[i][0])) continue;
                    sb.append(Report.filter(values[i][1])).append("\n");
                    break;
                }
            }
        }
        sb.append("</p>\n");
    }

    protected void zonaData(StringBuilder sb) {
        StringBuilder sb2 = new StringBuilder(100);
        sb2.append("go('").append("date").append("')");
        this.dm.zonaData(sb, Report.buttonAction(sb2.substring(0), this.getMsg("submit"), null));
    }

    protected void zonaParams(StringBuilder sb) {
        sb.append("<div class=\"inputForm\" id=\"compact\">\n");
        for (int i = 0; i < KCC.length; ++i) {
            sb.append("<p>");
            if (this.isEditable) {
                sb.append(Report.filter(this.getMsg(KCC_LABELS[i]))).append("&nbsp;");
            }
            sb.append("<input name=\"").append(KCC[i]).append("\" size=\"8\"");
            if (this.kcc[i] != null) {
                sb.append(" value=\"").append(Report.filter(this.kcc[i])).append("\"");
            }
            if (!this.isEditable) {
                sb.append(" type=\"hidden\"");
            }
            sb.append("></p>\n");
        }
        sb.append("</div>\n");
    }

    protected void grafic(StringBuilder sb, String type, boolean dist, boolean withHeader) throws Exception {
        int w = dist ? Img.DIST_WIDTH : Img.DEFAULT_WIDTH;
        int h = Img.DEFAULT_HEIGHT + Img.DEFAULT_HEADER_HEIGHT;
        StringBuilder urlG = new StringBuilder(300);
        urlG.append("img");
        Report.urlParamSb(urlG, "type", type, true);
        if (dist) {
            Report.urlParamSb(urlG, "dist", "true", false);
        }
        if (withHeader) {
            Report.urlParamSb(urlG, "header", "true", false);
        }
        Report.urlParamSb(urlG, "w", Integer.toString(w), false);
        Report.urlParamSb(urlG, "h", Integer.toString(h), false);
        Report.urlParamSb(urlG, "pid", this.pageId, false);
        Report.urlParamSb(urlG, "user", this.userId, false);
        Report.urlParamSb(urlG, "group", this.groupId, false);
        if (this.projectName.length() > 0 && !this.projectName.equals("-1")) {
            Report.urlParamSb(urlG, "project", this.projectName, false);
        }
        if (this.activityName.length() > 0 && !this.activityName.equals("-1")) {
            Report.urlParamSb(urlG, "activity", this.activityName, false);
        }
        for (int i = 0; i < KCC.length; ++i) {
            Report.urlParamSb(urlG, KCC[i], this.kcc[i], false);
        }
        Report.urlParamSb(urlG, "from", ReportUtils.dateToStr(this.dm.dFrom), false);
        Report.urlParamSb(urlG, "to", ReportUtils.dateToStr(this.dm.dTo), false);
        sb.append("<img src=\"").append((CharSequence)urlG).append("\" width=\"").append(w).append("\" height=\"").append(h).append("\">");
    }

    protected void llistaSessions(StringBuilder sb, List<SessionData> v, boolean expandable, String className, String style) throws Exception {
        int n = 0;
        sb.append("<table class=\"").append(className).append("\"");
        if (style != null) {
            sb.append(" style=\"").append(style).append("");
        }
        sb.append(">\n");
        sb.append("<tr>");
        sb.append("<th>").append(Report.toNbsp(this.getMsg("report_header_date"))).append("</th>\n");
        ++n;
        if (this.type == 2 || this.type == 1) {
            sb.append("<th>").append(Report.toNbsp(this.getMsg("report_header_user"))).append("</th>\n");
            sb.append("<th>").append(Report.toNbsp(this.getMsg("report_header_sessions"))).append("</th>\n");
            n += 2;
        }
        if (this.type == 0) {
            sb.append("<th colspan=2>").append(Report.toNbsp(this.getMsg("report_header_project"))).append("</th>\n");
            n += 2;
        }
        sb.append("<th>").append(Report.toNbsp(this.getMsg("report_header_numActs"))).append("</th>\n");
        sb.append("<th>").append(Report.toNbsp(this.getMsg("report_header_actsSolved"))).append("</th>\n");
        sb.append("<th>").append(Report.toNbsp(this.getMsg("report_header_time"))).append("</th>\n");
        sb.append("<th>").append(Report.toNbsp(this.getMsg("report_header_prec"))).append("</th>\n");
        n += 4;
        sb.append("</tr>\n");
        StringBuilder sb2 = new StringBuilder(500);
        StringBuilder sb3 = new StringBuilder(100);
        int numSess = 0;
        for (SessionData sd : v) {
            boolean status;
            sb.append("<tr>\n");
            sb2.setLength(0);
            boolean link = expandable && sd.id != null && sd.id.length() > 0;
            boolean bl = status = link && sd.actData != null;
            if (expandable) {
                if (link) {
                    sb2.append("<a href=\"javascript:session(").append(numSess).append(",'").append(status ? "false" : "true").append("')\">");
                    sb2.append("<img src=\"").append(Report.resourceUrl(status ? "menys.gif" : "mes.gif"));
                    sb2.append("\" width=\"9\" height=\"9\" border=\"0\" alt=\"");
                    sb2.append(this.getMsg("report_session_detail_" + (status ? "hide" : "show"))).append("\" id=\"noPrint\">");
                    sb2.append("</a>&nbsp;");
                } else {
                    sb2.append("&nbsp;&nbsp;");
                }
            }
            sb2.append(this.shortDateFormat.format(sd.date));
            sb3.setLength(0);
            if (status) {
                sb3.append(" valign=\"top\" rowspan=\"").append(sd.actData.size() + 2).append("\"");
            }
            sb.append("<td align=\"right\"").append(sb3.substring(0)).append(">").append(sb2.substring(0)).append("</td>\n");
            if (this.type == 1 || this.type == 2) {
                String s = sd.getUsr();
                if ("*".equals(s)) {
                    sb2.setLength(0);
                    sb2.append("(").append(this.numberFormat.format(sd.users.size())).append(" ").append(this.bundle.getString("report_n_users")).append(")");
                    s = sb2.substring(0);
                }
                sb.append("<td align=\"right\">").append(Report.filter(s)).append("</td>\n");
                sb.append("<td align=\"right\">").append(this.numberFormat.format(sd.sessionCount)).append("</td>\n");
            }
            if (this.type == 0) {
                sb.append("<td align=\"left\" colspan=2>").append(Report.filter(sd.project)).append("</td>\n");
            }
            sb.append("<td align=\"right\">").append(this.numberFormat.format(sd.numActs)).append("</td>\n");
            sb.append("<td align=\"right\">").append(this.numberFormat.format(sd.actsSolved)).append("&nbsp;(").append(this.numberFormat.format(sd.percentSolved())).append("%)</td>\n");
            sb.append("<td align=\"right\">").append(this.formatTime(sd.totalTime)).append("</td>\n");
            sb.append("<td align=\"right\">").append(this.numberFormat.format(sd.percentPrec())).append("%</td>\n");
            sb.append("</tr>\n");
            if (status) {
                this.llistaActivitats(sb, sd.actData);
            }
            ++numSess;
        }
        sb.append("</table>");
    }

    protected void llistaActivitats(StringBuilder sb, List<ActivityData> v) throws Exception {
        sb.append("<tr id=\"t2x\">\n");
        sb.append("<th>").append(Report.toNbsp(this.getMsg("report_header_activity"))).append("</th>\n");
        if (this.type == 2 || this.type == 1) {
            sb.append("<th>").append(Report.toNbsp(this.getMsg("report_header_user"))).append("</th>\n");
        }
        if (this.type == 1) {
            sb.append("<th>").append(Report.toNbsp(this.getMsg("report_header_project"))).append("</th>\n");
        }
        sb.append("<th>").append(Report.toNbsp(this.getMsg("report_header_solved"))).append("</th>\n");
        sb.append("<th>").append(Report.toNbsp(this.getMsg("report_header_actions"))).append("</th>\n");
        sb.append("<th>").append(Report.toNbsp(this.getMsg("report_header_score"))).append("</th>\n");
        sb.append("<th>").append(Report.toNbsp(this.getMsg("report_header_time"))).append("</th>\n");
        sb.append("<th>").append(Report.toNbsp(this.getMsg("report_header_prec"))).append("</th>\n");
        sb.append("</tr>\n");
        for (ActivityData ad : v) {
            sb.append("<tr id=\"t2x\">\n");
            sb.append("<td>").append(Report.filter(ad.activityName)).append("</td>\n");
            if (this.type == 2 || this.type == 1) {
                sb.append("<td></td>\n");
            }
            if (this.type == 1) {
                sb.append("<td>").append(Report.filter(ad.project)).append("</td>\n");
            }
            sb.append("<td id=\"").append(ad.solved ? "green" : "red").append("\">");
            sb.append(this.getMsg(ad.solved ? "YES_SHORT" : "NOT_SHORT")).append("</td>\n");
            sb.append("<td align=\"right\">").append(this.numberFormat.format(ad.actions)).append("</td>\n");
            sb.append("<td align=\"right\">").append(this.numberFormat.format(ad.score)).append("&nbsp;(").append(this.numberFormat.format(ad.percentSolved())).append("%)</td>\n");
            sb.append("<td align=\"right\">").append(this.formatTime(ad.time)).append("</td>\n");
            sb.append("<td align=\"right\">").append(this.numberFormat.format(ad.qualification)).append("%</td>\n");
            sb.append("</tr>\n");
        }
    }

    protected void resumGlobal(StringBuilder sb, List<SessionData> v, String className, String style) throws Exception {
        int sess = 0;
        int numProjects = 0;
        int act_fetes = 0;
        int act_res = 0;
        int temps = 0;
        int precisio = 0;
        if (!this.projectName.equals("-1")) {
            numProjects = 1;
        } else if (this.projects != null) {
            numProjects = this.projects.size();
            if (this.projects.size() > 0 && "-1".equals(this.projects.get(0))) {
                --numProjects;
            }
        }
        HashSet<String> hs = new HashSet<String>();
        for (SessionData sd : v) {
            act_fetes += sd.numActs;
            act_res += sd.actsSolved;
            temps += sd.totalTime;
            precisio += sd.totalPrec;
            sess += sd.sessionCount;
            hs.addAll(sd.users);
        }
        int usrs = hs.size();
        sb.append("<table class=\"").append(className).append("\"");
        if (style != null) {
            sb.append(" style=\"").append(style).append("\"");
        }
        sb.append(">\n");
        sb.append("<tr><th colspan=2>").append(Report.filter(this.getMsg("report_globalSummary"))).append("</th></tr>\n");
        if (usrs > 1) {
            this.resumTD(sb, this.getMsg("report_users"), this.numberFormat.format(usrs));
        }
        this.resumTD(sb, this.getMsg("report_sessions"), this.numberFormat.format(sess));
        if (this.type != 2) {
            this.resumTD(sb, this.getMsg("report_projects"), this.numberFormat.format(numProjects));
        }
        this.resumTD(sb, this.getMsg("report_actDone"), this.numberFormat.format(act_fetes));
        StringBuilder sb2 = new StringBuilder(200);
        sb2.append(this.numberFormat.format(act_res)).append(" (").append(this.numberFormat.format(act_fetes == 0 ? 0L : (long)(100 * act_res / act_fetes))).append("%)");
        this.resumTD(sb, this.getMsg("report_actSolved"), sb2.substring(0));
        this.resumTD(sb, this.getMsg("report_totalTime"), this.formatTime(temps));
        sb2.setLength(0);
        sb2.append(this.numberFormat.format(act_fetes == 0 ? 0L : (long)(precisio / act_fetes))).append("%");
        this.resumTD(sb, this.getMsg("report_globalPrec"), sb2.substring(0));
        sb.append("</table>\n");
    }

    protected void resumTD(StringBuilder sb, String td1, String td2) {
        sb.append("<tr><td>").append(Report.toNbsp(td1));
        sb.append("</td><td align=\"right\">").append(Report.toNbsp(td2)).append("</td></tr>\n");
    }

    public String formatTime(int secs) {
        secs = Math.max(0, secs);
        String[] n = Report.getFormattedNumbers();
        int h = secs / 3600;
        int m = (secs - h * 60 * 60) / 60;
        int s = secs % 60;
        StringBuilder sb = new StringBuilder(8);
        if (h > 0) {
            sb.append(h).append(":");
        }
        sb.append(n[m]).append(":").append(n[s]);
        return sb.substring(0);
    }
}

