/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.report.SessionData;
import edu.xtec.jclic.report.rp.Basic;
import edu.xtec.jclic.report.rp.DateManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class BasicReport
extends Basic {
    public static final int USR = 0;
    public static final int GRP = 1;
    public static final int PRJ = 2;
    public static final int UNKNOWN = -1;
    public static final String EDIT = "edit";
    public static final String CHANGE = "change";
    public static final String NEW = "new";
    public static final String GROUP = "group";
    public static final String USER = "user";
    public static final String PROJECT = "project";
    public static final String ACTIVITY = "activity";
    public static final String DATE = "date";
    public static final String PID = "pid";
    public static final String WILDCARD = "-1";
    public static final String[] KCC = new String[]{"sessionKey", "sessionCode", "sessionContext"};
    public static final File SDIR = new File(System.getProperty("java.io.tmpdir"));
    protected String groupId;
    protected String userId;
    protected String projectName;
    protected String activityName;
    protected String[] kcc;
    protected int type = -1;
    protected String pageId;
    protected DateManager dm;

    @Override
    public boolean init() throws Exception {
        if (!super.init()) {
            return false;
        }
        this.dm = new DateManager(this);
        this.userId = this.getParamNotNull(USER);
        if (this.userId.length() > 0 && this.userId.charAt(0) == '\u00a0') {
            this.userId = this.userId.replace('\u00a0', ' ');
        }
        this.groupId = this.getParamNotNull(GROUP);
        this.projectName = this.getParamNotNull(PROJECT);
        this.activityName = this.getParamNotNull(ACTIVITY);
        this.kcc = new String[3];
        for (int i = 0; i < KCC.length; ++i) {
            this.kcc[i] = this.getParam(KCC[i]);
        }
        this.pageId = this.getParam(PID);
        if (this.pageId == null || this.pageId.length() == 0) {
            this.pageId = Long.toString(100000000L + (long)(Math.random() * 1.0E8));
        }
        return this.dm.init();
    }

    protected List<SessionData> getSessionList() throws Exception {
        List<SessionData> v;
        switch (this.type) {
            case 0: {
                v = bridge.getInfoSessionUser(this.userId, this.projectName, this.dm.dFrom, this.dm.dTo, this.kcc, false);
                break;
            }
            case 1: {
                v = bridge.getInfoSessionGroup(this.groupId, this.projectName, this.dm.dFrom, this.dm.dTo, this.kcc, true);
                break;
            }
            case 2: {
                v = bridge.getInfoSessionAct(this.projectName, this.activityName, this.dm.dFrom, this.dm.dTo, this.kcc, true);
                break;
            }
            default: {
                v = new ArrayList<SessionData>();
            }
        }
        return v;
    }

    public String[][] vToArray(List<String> v, String wildCardKey, String wildCardMsg) {
        String[][] result = null;
        if (wildCardKey != null || v != null && v.size() > 0) {
            int l = v != null ? v.size() : 0;
            result = new String[l + (wildCardKey != null ? 1 : 0)][];
            int k = 0;
            if (wildCardKey != null) {
                String s = wildCardKey;
                if (wildCardMsg != null) {
                    s = this.getMsg(wildCardMsg);
                }
                result[k++] = new String[]{wildCardKey, s};
            }
            if (v != null) {
                for (String s : v) {
                    s = s.trim();
                    result[k++] = new String[]{s, s};
                }
            }
        }
        return result;
    }

    public String[][] vToArray(List<Object[]> v, int keyIndex, int valueIndex) {
        String[][] result = null;
        if (v != null && v.size() > 0) {
            int l = v.size();
            result = new String[l][];
            for (int i = 0; i < l; ++i) {
                Object[] o = v.get(i);
                result[i] = new String[2];
                result[i][0] = ((String)o[keyIndex]).trim();
                result[i][1] = ((String)o[valueIndex]).trim();
            }
        }
        return result;
    }
}

