/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.servlet.RequestProcessor;
import edu.xtec.util.Html;
import edu.xtec.util.StrUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class HTTPRequest {
    public Socket socket;
    public BufferedReader in;
    public OutputStream os;
    public PrintWriter pw;
    public Map<String, Object> cookies = new HashMap<String, Object>();
    public Map<String, Object> params = new HashMap<String, Object>();
    public String method;
    public String urlBase;
    public String protocol;
    public boolean commited;
    public String firstLine;
    public InputStream inputStream;
    ResponseHead head = new ResponseHead();
    public static final int OK = 200;
    public static final int BAD_REQUEST = 400;
    public static final int MOVED_PERM = 301;
    public static final int FOUND = 302;
    public static final int NOT_FOUND = 404;
    public static final int SERVER_ERROR = 500;
    public static final String MIME_HTML = "text/html";

    public HTTPRequest(Socket socket) throws Exception {
        String line;
        this.socket = socket;
        this.buildStreams();
        int cl = -1;
        try {
            this.firstLine = this.in.readLine();
            if (this.firstLine == null) {
                while (this.in.ready()) {
                    this.in.readLine();
                }
                return;
            }
            StringTokenizer st = new StringTokenizer(this.firstLine, " ");
            this.method = st.nextToken();
            String s = st.nextToken();
            int i = s.indexOf(63);
            if (i < 0) {
                this.urlBase = s;
            } else {
                this.urlBase = s.substring(0, i);
                HTTPRequest.processParamsLine(s.substring(i + 1), this.params, '&', '=', true);
            }
            this.protocol = st.nextToken();
            if (this.protocol == null || !this.protocol.equals("HTTP/1.0") && !this.protocol.equals("HTTP/1.1")) {
                this.error(400, null);
                throw new Exception("Bad request!");
            }
        }
        catch (Exception ex) {
            this.error(400, null);
            throw ex;
        }
        while ((line = StrUtils.nullableString(this.in.readLine())) != null) {
            if (line.toLowerCase().startsWith("cookie:")) {
                int k = line.indexOf(32);
                if (k <= 0) continue;
                HTTPRequest.processParamsLine(line.substring(k + 1), this.cookies, ';', '=', false);
                continue;
            }
            if (!line.toLowerCase().startsWith("content-length:")) continue;
            cl = Integer.parseInt(line.substring(16));
        }
        if (cl >= 0) {
            char[] buf = new char[cl];
            int k = this.in.read(buf);
            String line2 = String.copyValueOf(buf, 0, k);
            this.inputStream = new ByteArrayInputStream(line2.getBytes());
            if (!line2.startsWith("<")) {
                HTTPRequest.processParamsLine(line2, this.params, '&', '=', true);
            }
        } else {
            while (this.in.ready() && (line = StrUtils.nullableString(this.in.readLine())) != null) {
                HTTPRequest.processParamsLine(line, this.params, '&', '=', true);
            }
        }
    }

    private void buildStreams() throws IOException {
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.os = new BufferedOutputStream(this.socket.getOutputStream());
        this.pw = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream(), "ISO-8859-1"));
    }

    private void buildStreamsDebug(final PrintStream log) throws IOException {
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream())){

            @Override
            public String readLine() throws IOException {
                String result = super.readLine();
                if (result != null) {
                    log.println("< " + result);
                }
                return result;
            }

            @Override
            public int read(char[] buf) throws IOException {
                int result = super.read(buf);
                if (result > 0) {
                    log.println("< " + new String(buf, 0, result));
                }
                return result;
            }
        };
        this.os = new BufferedOutputStream(this.socket.getOutputStream()){

            @Override
            public synchronized void write(byte[] b, int off, int len) throws IOException {
                if (b != null) {
                    log.println("> " + new String(b, off, len));
                }
                super.write(b, off, len);
            }
        };
        this.pw = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream(), "ISO-8859-1")){

            @Override
            public void write(String s, int off, int len) {
                log.println("> " + s);
                super.write(s, off, len);
            }
        };
    }

    public static void processParamsLine(String txt, Map<String, Object> map, char sep, char equalSign, boolean arrays) {
        if (txt != null && txt.length() > 0 && map != null) {
            StringTokenizer st = new StringTokenizer(txt, String.valueOf(sep));
            while (st.hasMoreTokens()) {
                String key;
                String s = st.nextToken().trim();
                String value = null;
                int k = s.indexOf(equalSign);
                if (k > 0) {
                    key = Html.decode(s.substring(0, k).replace('+', ' '));
                    if (k < s.length() - 1) {
                        value = Html.decode(s.substring(k + 1).replace('+', ' '));
                    }
                } else {
                    key = Html.decode(s.replace('+', ' '));
                }
                if (arrays) {
                    String[] vArray = (String[])map.get(key);
                    if (vArray == null) {
                        vArray = new String[]{value};
                    } else {
                        String[] v2 = new String[vArray.length + 1];
                        for (int i = 0; i < vArray.length; ++i) {
                            v2[i] = vArray[i];
                        }
                        v2[i] = value;
                        vArray = v2;
                    }
                    map.put(key, vArray);
                    continue;
                }
                map.put(key, value);
            }
        }
    }

    public final void error(int code, String msg) throws Exception {
        String err;
        switch (code) {
            case 400: {
                err = "Bad Request";
                break;
            }
            case 301: {
                err = "Moved permanently";
                break;
            }
            case 404: {
                err = "File not found";
                break;
            }
            case 500: {
                err = "Server error";
                break;
            }
            default: {
                err = "Undefined error";
            }
        }
        this.head.code = code;
        this.head.title = err;
        this.head.write();
        StringBuilder sb = new StringBuilder(100);
        sb.append("<B>").append(err).append("</B>\n<BR>&nbsp;<BR>\n");
        if (msg != null) {
            sb.append(msg);
        }
        this.minimalPage("ERROR: " + err, sb.substring(0));
    }

    public void redirect(String url) throws Exception {
        this.head.contentType = null;
        this.head.code = 301;
        this.head.title = "Moved permanently";
        StringBuilder sb = new StringBuilder(100);
        sb.append("http://");
        String serverAddress = this.socket.getLocalAddress().getHostAddress();
        if (serverAddress == null || "0.0.0.0".equals(serverAddress)) {
            serverAddress = InetAddress.getLocalHost().getHostAddress();
        }
        sb.append(serverAddress);
        sb.append(":").append(this.socket.getLocalPort()).append("/").append(url);
        String fullUrl = sb.substring(0);
        sb.setLength(0);
        sb.append("Location: ").append(fullUrl);
        this.head.extra = sb.substring(0);
        this.head.write();
        sb.setLength(0);
        sb.append("redirected to: <A HREF=\"").append(fullUrl).append("\">").append(fullUrl).append("</A>");
        this.minimalPage("redirect", sb.substring(0));
    }

    public void minimalPage(String title, String text) throws Exception {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n");
        sb.append("<HTTP>\n<HEAD>\n");
        if (title != null) {
            sb.append("<TITLE>").append(title).append("</TITLE>\n");
        }
        sb.append("</HEAD>\n<BODY>\n");
        sb.append("<H2>").append(title).append("</H2>\n");
        sb.append(text);
        sb.append("\n</BODY>\n</HTML>");
        this.pw.println(sb.substring(0));
        this.os.flush();
        this.commited = true;
    }

    public class ResponseHead {
        public String contentType = "text/html";
        public int code = 200;
        public int contentLength = -1;
        public String title;
        public String extra;
        public boolean cache = true;
        public boolean commited = false;

        public void write() {
            StringBuilder sb = new StringBuilder(200);
            sb.append("HTTP/1.0 ");
            sb.append(this.code).append(" ").append(this.title == null ? "OK" : this.title);
            HTTPRequest.this.pw.println(sb.substring(0));
            if (this.extra != null) {
                HTTPRequest.this.pw.println(this.extra);
            }
            if (this.contentType != null) {
                sb.setLength(0);
                HTTPRequest.this.pw.println(sb.append("Content-Type: ").append(this.contentType).substring(0));
            }
            sb.setLength(0);
            HTTPRequest.this.pw.println(sb.append("Date: ").append(RequestProcessor.httpDate(new Date())).substring(0));
            HTTPRequest.this.pw.println("Server: JClicHttpServer 1.0");
            if (!this.cache) {
                HTTPRequest.this.pw.println("Pragma: no-cache");
                HTTPRequest.this.pw.println("Cache-Control: no-cache");
                HTTPRequest.this.pw.println("Expires: 0");
            }
            if (HTTPRequest.this.cookies.size() > 0) {
                sb.setLength(0);
                sb.append("Set-Cookie: ");
                Iterator<String> it = HTTPRequest.this.cookies.keySet().iterator();
                boolean first = true;
                while (it.hasNext()) {
                    String key = it.next();
                    if (!first) {
                        sb.append(";");
                    } else {
                        first = false;
                    }
                    sb.append(key).append("=").append(HTTPRequest.this.cookies.get(key));
                }
                HTTPRequest.this.pw.println(sb.substring(0));
            }
            if (this.contentLength > 0) {
                sb.setLength(0);
                HTTPRequest.this.pw.println(sb.append("Content-Length: ").append(this.contentLength).substring(0));
            }
            HTTPRequest.this.pw.println("");
            HTTPRequest.this.pw.flush();
            this.commited = true;
        }
    }
}

