/*
 * Decompiled with CFR 0.152.
 */
import edu.xtec.jclic.ReportServerConstants;
import edu.xtec.jclic.report.HTTPReportServer;
import edu.xtec.jclic.report.ReportServerEvent;
import edu.xtec.jclic.report.ReportServerEventMaker;
import edu.xtec.jclic.report.ReportServerJDBCBridge;
import edu.xtec.util.Encryption;
import edu.xtec.util.Messages;
import edu.xtec.util.db.ConnectionBeanProvider;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;

public class CmdReportServer
implements ReportServerEventMaker.Listener,
ReportServerConstants {
    static String iDriver;
    static String iUrl;
    static String iUser;
    static String iPwd;
    static int iHttpPort;
    static int iHttpTimeout;
    static boolean iCreateTables;
    static String iTablePrefix;
    DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);

    public CmdReportServer(String driver, String url, String user, String pwd, int httpPort, int httpTimeOut, boolean createTables, String tablePrefix) throws Exception {
        this.showValidCommands();
        ConnectionBeanProvider cbp = ConnectionBeanProvider.getConnectionBeanProvider(true, driver, url, user, pwd, true);
        ReportServerJDBCBridge bridge = new ReportServerJDBCBridge(cbp, createTables, tablePrefix);
        this.reportEventPerformed(new ReportServerEvent(0, url, null, 0));
        HTTPReportServer httpServer = new HTTPReportServer(new Messages("messages.ReportServerMessages"));
        httpServer.addListener(this);
        httpServer.startServer(httpPort, httpTimeOut);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        boolean loop = true;
        String s = null;
        while (loop) {
            try {
                s = in.readLine();
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                loop = false;
            }
            if (s == null) continue;
            if (s.equalsIgnoreCase("stop")) {
                httpServer.stopServer();
                continue;
            }
            if (s.equalsIgnoreCase("start")) {
                httpServer.startServer(httpPort, httpTimeOut);
                continue;
            }
            if (s.equalsIgnoreCase("exit")) {
                if (httpServer.serverRunning()) {
                    httpServer.stopServer();
                }
                loop = false;
                continue;
            }
            this.showValidCommands();
        }
        bridge.end();
        this.reportEventPerformed(new ReportServerEvent(0, url, null, 1));
    }

    public static void main(String[] args) {
        String propFile = "jclicReports.properties";
        int i = 0;
        if (args.length > 0) {
            if (args[1].equals("-help")) {
                CmdReportServer.displayHelp();
                return;
            }
            if (!args[0].startsWith("-")) {
                propFile = args[0];
                ++i;
            }
        }
        Properties prop = new Properties();
        try {
            prop.load(ReportServerConstants.class.getResourceAsStream("jclicReports.properties"));
            if (!"jclicReports.properties".equals(propFile)) {
                prop.load(CmdReportServer.class.getResourceAsStream(propFile));
                String pwd = prop.getProperty("dbPassword");
                if (pwd != null && pwd.length() > 0) {
                    prop.setProperty("dbPassword", Encryption.Decrypt(pwd));
                }
            }
        }
        catch (Exception ex) {
            System.err.println("ERROR: Invalid properties file name\n" + ex);
            CmdReportServer.displayHelp();
            return;
        }
        iDriver = prop.getProperty("dbDriver", "sun.jdbc.odbc.JdbcOdbcDriver");
        iUrl = prop.getProperty("dbServer", "jdbc:odbc:JClicUserReports");
        iUser = prop.getProperty("dbLogin", null);
        iPwd = prop.getProperty("dbPassword", null);
        iHttpPort = Integer.parseInt(prop.getProperty("http_port", Integer.toString(9000)));
        iHttpTimeout = Integer.parseInt(prop.getProperty("http_timeout", Integer.toString(1200)));
        iTablePrefix = prop.getProperty("tablePrefix", null);
        iCreateTables = "true".equalsIgnoreCase(prop.getProperty("createTables", "true"));
        while (i < args.length) {
            boolean err = false;
            if (i < args.length - 1) {
                if (args[i].equals("-driver")) {
                    iDriver = args[++i];
                } else if (args[i].equals("-url")) {
                    iUrl = args[++i];
                } else if (args[i].equals("-user")) {
                    iUser = args[++i];
                } else if (args[i].equals("-pwd")) {
                    iPwd = args[++i];
                } else if (args[i].equals("-port")) {
                    iHttpPort = Integer.parseInt(args[++i]);
                } else if (args[i].equals("-timeout")) {
                    iHttpTimeout = Integer.parseInt(args[++i]);
                } else if (args[i].equals("-prefix")) {
                    iTablePrefix = args[++i];
                } else if (args[i].equals("-create")) {
                    iCreateTables = "true".equalsIgnoreCase(args[++i]);
                } else {
                    err = true;
                }
            } else {
                err = true;
            }
            if (err) {
                System.err.println("Syntax error!");
                CmdReportServer.displayHelp();
                return;
            }
            ++i;
        }
        try {
            new CmdReportServer(iDriver, iUrl, iUser, iPwd, iHttpPort, iHttpTimeout, iCreateTables, iTablePrefix);
            System.err.println("Report Server closed");
        }
        catch (Exception ex) {
            System.err.println("Unable to start!\n" + ex);
        }
    }

    static void displayHelp() {
        System.out.println("Syntax: java CmdReportServer [-help] [fileName] [-option value]..");
        System.out.println("Switches:");
        System.out.println("  -help     displays this message");
        System.out.println("  fileName  get values from the specified fileName");
        System.out.println("            if ommitted, default values will be read");
        System.out.println("            from ReportServer.properties");
        System.out.println("Option-Value pairs:");
        System.out.println("  -driver   name of the JDBC driver");
        System.out.println("  -url      JDBC path to the database");
        System.out.println("  -user     system user name");
        System.out.println("  -pwd      system user password");
        System.out.println("  -port     HTTP port for foreign connections (default: 9000)");
        System.out.println("  -timeout  maximum number of seconds of socket inactivity");
        System.out.println("  -create   [true|false] automatic creation of tables (default: true)");
        System.out.println("  -prefix   prefix used in table names");
    }

    @Override
    public void reportEventPerformed(ReportServerEvent ev) {
        System.out.println(this.dateFormat.format(new Date()) + " " + ev.toString());
    }

    void showValidCommands() {
        System.out.println("-----------------------------------------------------");
        System.out.println("Valid control commands:");
        System.out.println("stop - Close all connections and stop server");
        System.out.println("start - Start server");
        System.out.println("exit - Close all connections, stop server and exit");
        System.out.println("-----------------------------------------------------");
    }
}

