/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.applet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.spi.mpeg.sampled.convert.MpegFormatConversionProvider;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileReader;
import org.tritonus.applet.MpegAudioFileReaderWorkaround;

public class AppletMpegSPIWorkaround {
    public static boolean DEBUG = false;
    public static String useragent = null;

    public static AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        try {
            return AudioSystem.getAudioInputStream(targetFormat, sourceStream);
        }
        catch (IllegalArgumentException iae) {
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec");
            }
            try {
                Class.forName("javazoom.spi.mpeg.sampled.convert.MpegFormatConversionProvider");
                return new MpegFormatConversionProvider().getAudioInputStream(targetFormat, sourceStream);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("Mpeg codec not properly installed");
            }
        }
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec (AudioInputStream:file)");
            }
            return AppletMpegSPIWorkaround.getAudioInputStream(inputStream);
        }
        catch (UnsupportedAudioFileException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
        catch (IOException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
    }

    public static AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        try {
            Class.forName("javazoom.spi.mpeg.sampled.file.MpegAudioFileReader");
            return new MpegAudioFileReaderWorkaround().getAudioInputStream(url, useragent);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("Mpeg codec not properly installed");
        }
    }

    public static AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec (AudioFileFormat:file)");
            }
            AudioFileFormat audioFileFormat = AppletMpegSPIWorkaround.getAudioFileFormat(inputStream);
            return audioFileFormat;
        }
    }

    public static AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        BufferedInputStream inputStream = null;
        if (useragent != null) {
            URLConnection myCon = url.openConnection();
            myCon.setUseCaches(false);
            myCon.setDoInput(true);
            myCon.setDoOutput(true);
            myCon.setAllowUserInteraction(false);
            myCon.setRequestProperty("User-Agent", useragent);
            myCon.setRequestProperty("Accept", "*/*");
            myCon.setRequestProperty("Icy-Metadata", "1");
            myCon.setRequestProperty("Connection", "close");
            inputStream = new BufferedInputStream(myCon.getInputStream());
        } else {
            inputStream = new BufferedInputStream(url.openStream());
        }
        try {
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec (AudioFileFormat:url)");
            }
            AudioFileFormat audioFileFormat = AppletMpegSPIWorkaround.getAudioFileFormatForUrl(inputStream);
            return audioFileFormat;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public static AudioFileFormat getAudioFileFormatForUrl(InputStream is) throws UnsupportedAudioFileException, IOException {
        try {
            throw new Exception();
        }
        catch (Exception iae) {
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec (AudioFileFormat)");
            }
            try {
                Class.forName("javazoom.spi.mpeg.sampled.file.MpegAudioFileReader");
                AudioFileFormat audioFileFormat = new MpegAudioFileReader().getAudioFileFormat(is, -1L);
                return audioFileFormat;
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("Mpeg codec not properly installed");
            }
        }
    }

    public static AudioFileFormat getAudioFileFormat(InputStream is) throws UnsupportedAudioFileException, IOException {
        try {
            try {
                throw new Exception();
            }
            catch (Exception iae) {
                if (DEBUG) {
                    System.err.println("Using AppletMpegSPIWorkaround to get codec (AudioFileFormat)");
                }
                try {
                    Class.forName("javazoom.spi.mpeg.sampled.file.MpegAudioFileReader");
                    is.mark(4096);
                    AudioFileFormat audioFileFormat = new MpegAudioFileReader().getAudioFileFormat(is);
                    return audioFileFormat;
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalArgumentException("Mpeg codec not properly installed");
                }
            }
        }
        finally {
            is.reset();
        }
    }

    public static AudioInputStream getAudioInputStream(InputStream is) throws UnsupportedAudioFileException, IOException {
        try {
            throw new Exception();
        }
        catch (Exception iae) {
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec");
            }
            try {
                Class.forName("javazoom.spi.mpeg.sampled.file.MpegAudioFileReader");
                return new MpegAudioFileReader().getAudioInputStream(is);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("Mpeg codec not properly installed");
            }
        }
    }
}

