/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;

public class SimpleFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private String m_description = null;
    private String[] m_extension = null;

    public SimpleFileFilter(String extension, String description) {
        this(new String[]{extension}, description);
    }

    public SimpleFileFilter(String[] extension, String description) {
        this.m_description = description;
        this.m_extension = extension;
        if (this.m_extension != null) {
            for (int i = 0; i < this.m_extension.length; ++i) {
                if (this.m_extension[i].startsWith(".")) continue;
                this.m_extension[i] = "." + this.m_extension[i];
            }
        }
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public boolean accept(File f) {
        boolean result = false;
        if (f == null) {
            result = false;
        } else if (f.isDirectory()) {
            result = true;
        } else if (this.m_extension != null) {
            String s = f.getName().toLowerCase();
            for (String ex : this.m_extension) {
                if (!ex.equals(".*") && !s.endsWith(ex)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public FilenameFilter getFilenameFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File f, String name) {
                return SimpleFileFilter.this.accept(new File(f, name));
            }
        };
    }

    public File checkFileExtension(File f) {
        File result = f;
        if (!this.accept(result)) {
            for (String ex : this.m_extension) {
                if (ex.equals(".*")) continue;
                result = new File(f.getAbsolutePath() + ex);
            }
        }
        return result;
    }
}

