/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.ResourceManager;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;

public class MultiBundle {
    ArrayList<ResourceBundleEx> bundles = new ArrayList(1);

    public MultiBundle(ResourceBundle mainBundle, String resource, Locale l) {
        this.bundles.add(new ResourceBundleEx(mainBundle, resource, l));
    }

    public void addBundle(ResourceBundle bundle, String resource, Locale l) {
        for (int i = 0; i < this.bundles.size(); ++i) {
            if (!this.bundles.get((int)i).resource.equals(resource)) continue;
            return;
        }
        this.bundles.add(new ResourceBundleEx(bundle, resource, l));
    }

    public void setLocale(Locale l) {
        for (int i = 0; i < this.bundles.size(); ++i) {
            this.bundles.get(i).setLocale(l);
        }
    }

    public String getString(String key) {
        String result = key;
        for (int i = 0; i < this.bundles.size(); ++i) {
            try {
                result = this.bundles.get((int)i).bundle.getString(key);
                return result;
            }
            catch (Exception exception) {
                continue;
            }
        }
        System.err.println("Unable to find resource message: [" + result + "]");
        return result;
    }

    class ResourceBundleEx {
        ResourceBundle bundle = null;
        String resource = null;
        Locale locale = null;

        ResourceBundleEx(ResourceBundle bundle, String resource, Locale locale) {
            this.resource = resource;
            this.locale = locale;
            this.bundle = bundle;
        }

        void setLocale(Locale l) {
            if (!this.locale.equals(l)) {
                try {
                    this.bundle = ResourceManager.getBundle(this.resource, l);
                    this.locale = l;
                }
                catch (Exception ex) {
                    System.err.println("unable to build messagesBundle: " + this.resource);
                    System.err.println(ex);
                }
            }
        }
    }
}

