/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.MultiBundle;
import edu.xtec.util.NarrowOptionPane;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.Collator;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class Messages {
    public static final String LANGUAGE = "language";
    public static final String COUNTRY = "country";
    public static final String VARIANT = "variant";
    public static final String BASIC_BUNDLE = "messages.BasicMessages";
    public static final String MESSAGES = "messages";
    public static final String ERROR = "ERROR";
    public static final String WARNING = "WARNING";
    public static final int OK = 0;
    public static final int YES = 1;
    public static final int RETRY = 2;
    public static final int NO = 3;
    public static final int IGNORE = 4;
    public static final int CANCEL = 5;
    public static final int YES_TO_ALL = 6;
    public static final int NO_TO_ALL = 7;
    private static final int NUM_BUTTONS = 8;
    private static final String BTN_KEYS = "oyrnicYN";
    private static final String[] BTN_CODES = new String[]{"OK", "YES", "RETRY", "NO", "IGNORE", "CANCEL", "YES_TO_ALL", "NO_TO_ALL"};
    private String[] dlgButtons;
    public static final int MAX_PASSWORD_LENGTH = 24;
    private Locale currentLocale;
    private MultiBundle messages;
    private Collator collator;
    private NumberFormat numberFormat;
    private NumberFormat percentFormat;
    public static final String OPTIONS_DELIMITER = ",";
    public static final String[] KNOWN_LANGS = new String[]{"angl\u00e8s", "arabic", "araucanian", "basque", "catal\u00e0", "catal\u00e1n", "chinese", "english", "espanyol", "espa\u00f1ol", "esperanto", "euskara", "franc\u00e9s", "franc\u00e8s", "french", "gallego", "german", "greek", "ingl\u00e9s", "italian", "latin", "occit\u00e0", "occitan", "portugu\u00e8s", "romanian", "spanish", "swedish", "vasco"};
    public static final String[] KNOWN_LANG_CODES = new String[]{"en", "ar", "arn", "eu", "ca", "ca", "ch", "en", "es", "es", "eo", "eu", "fr", "fr", "fr", "gl", "de", "gr", "en", "it", "la", "oc", "oc", "pt", "ro", "es", "sv", "eu"};
    public static final HashMap<String, String> ISO_639_2_CODES = new HashMap();
    private static HashMap<String, String[]> descriptiveLanguageCodes;
    private static HashMap<String, String> codesToNames;
    private static HashMap<String, String> namesToCodes;

    public Messages(String bundle) {
        this.init(bundle, null, null, null);
    }

    public Messages(String bundle, String options) {
        StringTokenizer st = new StringTokenizer(options, OPTIONS_DELIMITER);
        this.init(bundle, st.hasMoreTokens() ? st.nextToken() : null, st.hasMoreTokens() ? st.nextToken() : null, st.hasMoreTokens() ? st.nextToken() : null);
    }

    public Messages(String bundle, HashMap options) {
        this.init(bundle, (String)options.get(LANGUAGE), (String)options.get(COUNTRY), (String)options.get(VARIANT));
    }

    public Messages(String bundle, String language, String country, String variant) {
        this.init(bundle, language, country, variant);
    }

    public static Messages getMessages(HashMap<String, Object> options, String bundle) {
        Messages msg = (Messages)options.get(MESSAGES);
        if (msg == null) {
            String language = (String)options.get(LANGUAGE);
            if (language == null) {
                JOptionPane pane = new JOptionPane("Please select your language:", 3, 2);
                pane.setSelectionValues(Messages.getDescriptiveLanguageCodes(null));
                pane.setWantsInput(true);
                String initialSelection = Messages.getDescriptiveLanguageCode(Locale.getDefault().getLanguage());
                pane.setInitialSelectionValue(initialSelection);
                Messages.showDlg((Component)options.get("mainParentComponent"), pane, "Language selecion");
                String sel = (String)pane.getInputValue();
                if (sel == null) {
                    sel = initialSelection;
                }
                options.put(LANGUAGE, Messages.getLanguageFromDescriptive(sel));
            }
            msg = new Messages(bundle, options);
            options.put(MESSAGES, msg);
            Locale.setDefault(msg.getLocale());
        } else if (bundle != null) {
            msg.setLocale(options);
            msg.addBundle(bundle);
        }
        return msg;
    }

    private void init(String bundle, String language, String country, String variant) {
        this.setLocale(language, country, variant);
        this.addBundle(bundle);
        this.addBundle(BASIC_BUNDLE);
        this.getDlgButtons(true);
    }

    public void setLocale(HashMap options) {
        this.setLocale((String)options.get(LANGUAGE), (String)options.get(COUNTRY), (String)options.get(VARIANT));
    }

    public void setLocale(String language, String country, String variant) {
        Locale l;
        if (country == null) {
            country = "";
        }
        if (!(l = language == null || language.length() == 0 ? (this.currentLocale == null ? Locale.getDefault() : this.currentLocale) : (variant == null || variant.length() == 0 ? new Locale(language, country) : new Locale(language, country, variant))).equals(this.currentLocale)) {
            this.currentLocale = l;
            this.numberFormat = NumberFormat.getInstance(this.currentLocale);
            this.percentFormat = NumberFormat.getPercentInstance(this.currentLocale);
            this.collator = null;
            if (this.messages != null) {
                this.messages.setLocale(this.currentLocale);
                this.getDlgButtons(true);
            }
        }
    }

    public String[] getDlgButtons(boolean update) {
        if (update || this.dlgButtons == null) {
            this.dlgButtons = new String[8];
            for (int i = 0; i < 8; ++i) {
                this.dlgButtons[i] = this.get(BTN_CODES[i]);
            }
        }
        return this.dlgButtons;
    }

    public void addBundle(String bundle) {
        if (this.currentLocale != null && bundle != null) {
            try {
                ResourceBundle b = ResourceManager.getBundle(bundle, this.currentLocale);
                if (this.messages == null) {
                    this.messages = new MultiBundle(b, bundle, this.currentLocale);
                } else {
                    this.messages.addBundle(b, bundle, this.currentLocale);
                }
            }
            catch (Exception ex) {
                System.err.println("unable to build messagesBundle: " + bundle);
                System.err.println(ex);
            }
        }
    }

    public String getShortDateStr(Date date) {
        DateFormat df = DateFormat.getDateInstance(3, this.currentLocale);
        return df.format(date);
    }

    public String getShortDateTimeStr(Date date) {
        DateFormat df = DateFormat.getDateTimeInstance(3, 2, this.currentLocale);
        return df.format(date);
    }

    public Date parseShortDate(String str) {
        Date result = null;
        if (str != null) {
            try {
                result = DateFormat.getDateInstance(3, this.currentLocale).parse(str);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    public String get(String group, String key) {
        return this.get(new StringBuilder(group).append(key).substring(0));
    }

    public static String get(HashMap<String, Object> options, String group, String key) {
        return Messages.getMessages(options, null).get(group, key);
    }

    public String get(String key) {
        return this.messages == null ? key : this.messages.getString(key);
    }

    public static String get(HashMap<String, Object> options, String key) {
        return Messages.getMessages(options, null).get(key);
    }

    public String getAllowNull(String key) {
        return key == null ? "" : this.get(key);
    }

    public String get(String key1, String s, String key2) {
        StringBuilder sb = new StringBuilder(this.getAllowNull(key1));
        sb.append(" ").append(s != null ? s : "").append(" ").append(this.getAllowNull(key2));
        return sb.substring(0);
    }

    public Locale getLocale() {
        return this.currentLocale;
    }

    public Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance(this.currentLocale);
        }
        return this.collator;
    }

    protected String[] parseButtons(String btnCodes) {
        btnCodes = StrUtils.secureString(btnCodes, "o");
        String[] result = new String[btnCodes.length()];
        String[] dlg = this.getDlgButtons(false);
        for (int i = 0; i < btnCodes.length(); ++i) {
            int k = Math.max(BTN_KEYS.indexOf(btnCodes.charAt(i)), 0);
            result[i] = dlg[k];
        }
        return result;
    }

    protected JButton[] parseJButtons(String btnCodes) {
        btnCodes = StrUtils.secureString(btnCodes, "o");
        JButton[] result = new JButton[btnCodes.length()];
        String[] dlg = this.getDlgButtons(false);
        for (int i = 0; i < btnCodes.length(); ++i) {
            int k = Math.max(BTN_KEYS.indexOf(btnCodes.charAt(i)), 0);
            result[i] = new JButton(dlg[k]);
            result[i].setActionCommand(BTN_CODES[k]);
        }
        return result;
    }

    public int showQuestionDlg(Component parent, String key, String titleKey, String buttons) {
        return this.showQuestionDlgObj(parent, this.get(key), titleKey, buttons);
    }

    public int showQuestionDlgObj(Component parent, Object msg, String titleKey, String buttons) {
        NarrowOptionPane pane = new NarrowOptionPane(60, msg, 3, -1, null, this.parseButtons(buttons));
        String title = this.get(StrUtils.secureString(titleKey, "QUESTION"));
        return this.getFeedback(parent, pane, title);
    }

    public String showInputDlg(Component parent, String msgKey, String shortPromptKey, String initialValue, String titleKey, boolean isPassword) {
        String[] msgKeys = null;
        if (msgKey != null) {
            msgKeys = new String[]{msgKey};
        }
        return this.showInputDlg(parent, msgKeys, shortPromptKey, initialValue, titleKey, isPassword);
    }

    public String showInputDlg(Component parent, String[] msgKeys, String shortPromptKey, String initialValue, String titleKey, boolean isPassword) {
        JTextField textField;
        String result = null;
        if (isPassword) {
            textField = new JPasswordField(24);
            if (shortPromptKey == null) {
                shortPromptKey = "PASSWORD";
            }
        } else {
            textField = new JTextField(24);
        }
        if (initialValue != null) {
            textField.setText(initialValue);
        }
        if (this.showInputDlg(parent, msgKeys, new String[]{shortPromptKey}, new JComponent[]{textField}, titleKey)) {
            if (isPassword) {
                char[] pwch = ((JPasswordField)textField).getPassword();
                if (pwch != null && pwch.length > 0) {
                    result = String.copyValueOf(pwch);
                }
            } else {
                result = textField.getText();
            }
        }
        return result;
    }

    public boolean showInputDlg(Component parent, String[] msgKeys, String[] shortPromptKeys, JComponent[] promptObjects, String titleKey) {
        ArrayList<Object> v = new ArrayList<Object>();
        if (msgKeys != null) {
            for (String msgKey : msgKeys) {
                v.add(this.get(msgKey));
            }
        }
        if (promptObjects != null) {
            if (shortPromptKeys == null) {
                for (JComponent jc : promptObjects) {
                    v.add(jc);
                }
            } else {
                GridBagLayout gridBag = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 1;
                c.insets = new Insets(3, 3, 3, 3);
                JPanel panel = new JPanel(gridBag);
                for (int i = 0; i < promptObjects.length; ++i) {
                    if (shortPromptKeys.length > i) {
                        JLabel lb = new JLabel(this.get(shortPromptKeys[i]));
                        lb.setLabelFor(promptObjects[i]);
                        lb.setHorizontalAlignment(2);
                        c.gridwidth = -1;
                        gridBag.setConstraints(lb, c);
                        panel.add(lb);
                    }
                    c.gridwidth = 0;
                    gridBag.setConstraints(promptObjects[i], c);
                    panel.add(promptObjects[i]);
                }
                v.add(panel);
            }
        }
        String title = titleKey != null ? this.get(titleKey) : "";
        NarrowOptionPane pane = new NarrowOptionPane(60, v.toArray(), 3, -1, null, this.parseButtons("oc"));
        return this.getFeedback(parent, pane, title) == 0;
    }

    public boolean showInputDlg(Component parent, JComponent mainComponent, String titleKey) {
        return this.showInputDlg(parent, mainComponent, titleKey, "oc");
    }

    public boolean showInputDlg(Component parent, JComponent mainComponent, String titleKey, String buttons) {
        return this.showInputDlg(parent, mainComponent, titleKey, buttons, false);
    }

    public boolean showInputDlg(Component parent, JComponent mainComponent, String titleKey, String buttons, boolean centerOnParent) {
        InputDlg dlg = new InputDlg(parent, titleKey, buttons, mainComponent, centerOnParent);
        return dlg.getFeedback() == 0;
    }

    public void showAlert(Component parent, String key) {
        this.showAlert(parent, new String[]{this.get(key)});
    }

    public void showAlert(Component parent, String[] msg) {
        System.err.println("Warning:");
        for (String s : msg) {
            System.err.println(s);
        }
        NarrowOptionPane pane = new NarrowOptionPane(60, msg, 2, -1, null, this.parseButtons(null));
        this.getFeedback(parent, pane, this.get(WARNING));
    }

    public int showErrorWarning(Component parent, String key, Exception ex) {
        return this.showErrorWarning(parent, key, (List<Object>)null, ex, null);
    }

    public int showErrorWarning(Component parent, String key, Exception ex, String buttons) {
        return this.showErrorWarning(parent, key, (List<Object>)null, ex, buttons);
    }

    public int showErrorWarning(Component parent, String key, String value, Exception ex, String buttons) {
        ArrayList<Object> v = new ArrayList<Object>();
        if (value != null) {
            v.add(value);
        }
        return this.showErrorWarning(parent, key, v, ex, buttons);
    }

    public int showErrorWarning(Component parent, String key, List<Object> values, Exception ex, String buttons) {
        if (key == null) {
            key = ERROR;
        }
        ArrayList<Object> v = new ArrayList<Object>();
        String mainMsg = this.get(key);
        System.err.println(mainMsg);
        v.add(mainMsg);
        if (values != null) {
            for (Object o : values) {
                if (o == null) continue;
                v.add(o);
                System.err.println(o);
            }
        }
        if (ex != null) {
            String s = ex.getLocalizedMessage();
            if (s != null) {
                v.add(s);
            } else {
                v.add(ex.toString());
            }
            System.err.println(s);
            ex.printStackTrace(System.err);
        }
        NarrowOptionPane pane = new NarrowOptionPane(60, v.toArray(), 0, -1, null, this.parseButtons(buttons));
        return this.getFeedback(parent, pane, this.get(ERROR));
    }

    public boolean confirmReadableFile(Component parent, File f) {
        boolean result = f.canRead();
        if (!result) {
            this.showAlert(parent, new String[]{this.get("FILE_BEG"), Messages.quote(f.getAbsolutePath()), this.get(f.exists() ? "FILE_NOT READABLE" : "FILE_NOT_EXIST")});
        }
        return result;
    }

    public int confirmOverwriteFile(Component parent, File f, String buttons) {
        int result = 1;
        if (f.exists()) {
            boolean readOnly;
            boolean dir = f.isDirectory();
            ArrayList<Object> v = new ArrayList<Object>();
            v.add(this.get(dir ? "FILE_DIR_BEG" : "FILE_BEG"));
            v.add(Messages.quote(f.getAbsolutePath()));
            boolean bl = readOnly = !f.canWrite();
            if (readOnly) {
                v.add(this.get("FILE_READONLY"));
            } else {
                v.add(this.get("FILE_EXISTS"));
                v.add(this.get(dir ? "FILE_OVERWRITE_DIR_PROMPT" : "FILE_OVERWRITE_PROMPT"));
            }
            if (readOnly) {
                this.showErrorWarning(parent, ERROR, v, null, null);
                result = 5;
            } else {
                NarrowOptionPane pane = new NarrowOptionPane(60, v.toArray(), 3, -1, null, this.parseButtons(buttons));
                result = this.getFeedback(parent, pane, this.get("CONFIRM"));
            }
        }
        return result;
    }

    private static boolean showDlg(Component parent, JOptionPane pane, String title) {
        if (parent != null && !(parent instanceof Frame)) {
            parent = JOptionPane.getFrameForComponent(parent);
        }
        JDialog dialog = pane.createDialog(parent, title);
        pane.selectInitialValue();
        return Messages.showDlg(dialog);
    }

    public static boolean showDlg(final JDialog dialog) {
        if (SwingUtilities.isEventDispatchThread()) {
            dialog.setVisible(true);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        dialog.setVisible(true);
                    }
                });
            }
            catch (Exception ex) {
                System.err.println("Show dialog error: " + ex);
                return false;
            }
        }
        return true;
    }

    protected int getFeedback(Component parent, JOptionPane pane, String title) {
        Object selectedValue;
        int result = 5;
        if (Messages.showDlg(parent, pane, title) && (selectedValue = pane.getValue()) != null) {
            for (int i = 0; i < 8; ++i) {
                if (!this.dlgButtons[i].equals(selectedValue)) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public static String quote(String text) {
        return new StringBuilder(" \"").append(text).append("\" ").substring(0);
    }

    public String kValue(long v) {
        StringBuilder sb = new StringBuilder(20);
        sb.append(this.numberFormat.format(v / 1024L)).append(" Kb");
        return sb.substring(0);
    }

    public String fileSize(long size) {
        StringBuilder sb = new StringBuilder(20);
        int kb = (int)size / 1024;
        double mb = (double)size / 1048576.0;
        if (kb == 0) {
            sb.append(this.numberFormat.format(size)).append(" bytes");
        } else if (mb < 1.0) {
            sb.append(this.numberFormat.format(kb)).append(" Kb");
        } else {
            int digits = this.numberFormat.getMaximumFractionDigits();
            this.numberFormat.setMaximumFractionDigits(1);
            sb.append(this.numberFormat.format(mb)).append(" Mb");
            this.numberFormat.setMaximumFractionDigits(digits);
        }
        return sb.substring(0);
    }

    public String getNumber(long v) {
        return this.numberFormat.format(v);
    }

    public String getNumber(double v) {
        return this.numberFormat.format(v);
    }

    public String getPercent(long v) {
        return this.percentFormat.format((double)v / 100.0);
    }

    public String getPercent(double v) {
        return this.percentFormat.format(v);
    }

    public String getHmsTime(long milis) {
        long v = milis / 1000L;
        if (v < 1L) {
            v = 1L;
        }
        StringBuilder sb = new StringBuilder(50);
        if (v >= 3600L) {
            sb.append(v / 3600L).append("h");
        }
        if (v >= 60L) {
            sb.append(v % 3600L / 60L).append("'");
        }
        sb.append(v % 60L).append("\"");
        return sb.substring(0);
    }

    public static String getDescriptiveLanguageCode(String languageCode) {
        String result = null;
        if (languageCode != null) {
            result = ISO_639_2_CODES.get(languageCode);
            if (result == null) {
                Locale lx = new Locale(languageCode, "");
                result = lx.getDisplayName(Locale.getDefault());
            }
            result = result + " (" + languageCode + ")";
        }
        return result;
    }

    public static String getLanguageFromDescriptive(String descriptive) {
        String result = null;
        int p = -1;
        if (descriptive != null && (descriptive = descriptive.trim()).length() > 4 && (p = descriptive.lastIndexOf(40)) > 0) {
            result = descriptive.substring(p + 1, descriptive.length() - 1);
        }
        return result;
    }

    public static String[] getDescriptiveLanguageCodes(Locale inLocale) {
        String key = inLocale == null ? "null" : inLocale.toString();
        String[] result = descriptiveLanguageCodes.get(key);
        if (result == null) {
            Locale dl = Locale.getDefault();
            String[] lc = Locale.getISOLanguages();
            TreeMap<String, String> tree = new TreeMap<String, String>();
            for (String l : lc) {
                String s;
                if (inLocale == null && l.equals("eu")) {
                    s = "euskara";
                } else if (inLocale == null && l.equals("gl")) {
                    s = "galego";
                } else {
                    Locale lx = new Locale(l, "");
                    s = lx.getDisplayName(inLocale == null ? lx : dl);
                }
                tree.put(l, s + " (" + l + ")");
            }
            for (String k : ISO_639_2_CODES.keySet()) {
                String s = ISO_639_2_CODES.get(k);
                tree.put(k, s + " (" + k + ")");
            }
            result = new String[tree.size()];
            Iterator it = tree.values().iterator();
            int i = 0;
            while (it.hasNext()) {
                result[i++] = (String)it.next();
            }
            descriptiveLanguageCodes.put(key, result);
        }
        return result;
    }

    public String[] getDescriptiveLanguageCodes() {
        return Messages.getDescriptiveLanguageCodes(this.getLocale());
    }

    public static String getKnownLanguageCode(String language) {
        String result = null;
        String lang = language == null ? "" : language.toLowerCase();
        for (int i = 0; i < KNOWN_LANGS.length; ++i) {
            if (!KNOWN_LANGS[i].equals(lang)) continue;
            result = KNOWN_LANG_CODES[i];
            break;
        }
        return result;
    }

    private static void buildLanguageMaps() {
        String[] dlc = Messages.getDescriptiveLanguageCodes(null);
        codesToNames = new HashMap(dlc.length);
        namesToCodes = new HashMap(dlc.length);
        for (String c : dlc) {
            int p = c.lastIndexOf(40) - 1;
            String name = c.substring(0, p).toLowerCase();
            String code = c.substring(p + 2, c.length() - 1);
            codesToNames.put(code, name);
            namesToCodes.put(name, code);
        }
    }

    public static HashMap getCodesToNames() {
        if (codesToNames == null) {
            Messages.buildLanguageMaps();
        }
        return codesToNames;
    }

    public static HashMap getNamesToCodes() {
        if (namesToCodes == null) {
            Messages.buildLanguageMaps();
        }
        return namesToCodes;
    }

    static {
        ISO_639_2_CODES.put("ast", "asturianu");
        ISO_639_2_CODES.put("vec", "v\u00e8neto");
        descriptiveLanguageCodes = new HashMap();
    }

    class InputDlg
    extends JDialog
    implements ActionListener {
        int result;
        Component parent;
        boolean centerOnParent;

        InputDlg(Component parent, String titleKey, String buttons, JComponent mainComponent, boolean centerOnParent) {
            super(JOptionPane.getFrameForComponent(parent), true);
            this.result = 5;
            if (titleKey != null) {
                this.setTitle(Messages.this.get(titleKey));
            }
            this.parent = parent;
            this.centerOnParent = centerOnParent;
            this.setDefaultCloseOperation(2);
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            if (mainComponent != null) {
                this.getContentPane().add((Component)mainComponent, "Center");
            }
            JButton[] btn = Messages.this.parseJButtons(buttons);
            JPanel btnPanel = new JPanel();
            JButton defaultBtn = null;
            for (JButton b : btn) {
                btnPanel.add(b);
                b.addActionListener(this);
                String cmd = b.getActionCommand();
                if (defaultBtn != null || !BTN_CODES[0].equals(cmd) && !BTN_CODES[1].equals(cmd)) continue;
                defaultBtn = b;
            }
            this.getContentPane().add((Component)btnPanel, "South");
            if (defaultBtn != null) {
                this.getRootPane().setDefaultButton(defaultBtn);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (ev != null) {
                String cmd = ev.getActionCommand();
                for (int i = 0; i < BTN_CODES.length; ++i) {
                    if (!BTN_CODES[i].equals(cmd)) continue;
                    this.result = i;
                    break;
                }
                this.setVisible(false);
            }
        }

        public int getFeedback() {
            Component cmp;
            this.pack();
            Component component = cmp = this.centerOnParent ? this.parent : JOptionPane.getFrameForComponent(this.parent);
            if (cmp != null) {
                int pw = cmp.getWidth();
                int ph = cmp.getHeight();
                this.setLocation((pw - this.getWidth()) / 2, (ph - this.getHeight()) / 2);
                this.setLocationRelativeTo(cmp);
            }
            if (!Messages.showDlg(this)) {
                this.result = 5;
            }
            return this.result;
        }
    }
}

