/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.StrUtils;
import java.io.PrintStream;
import java.util.Map;
import java.util.StringTokenizer;

public class Html {
    public static final String SP = " ";
    public static final String NBSP = "&nbsp;";
    public static final String BR = "\n<BR>\n";
    public static final String P = "\n<P>\n";
    public static final String Q = "\"";
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final String[] ALIGN = new String[]{"", "ALIGN=\"center\"", "ALIGN=\"right\""};
    protected StringBuilder sb;
    public static final String validChars = " -_.*0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    public Html(int bufSize) {
        this.sb = new StringBuilder(bufSize);
    }

    public Html(StringBuilder sb) {
        this.sb = sb;
    }

    public String toString() {
        return this.sb.substring(0);
    }

    public Html append(String str) {
        this.sb.append(str == null ? "" : str);
        return this;
    }

    public Html appendParagraphs(String source) {
        StringTokenizer st = new StringTokenizer(source, "\n");
        boolean first = true;
        while (st.hasMoreTokens()) {
            if (!first) {
                this.sb.append(BR);
            } else {
                first = false;
            }
            this.sb.append(st.nextToken());
        }
        return this;
    }

    public Html mailTo(String mail, boolean parenthesis) {
        if (parenthesis) {
            this.sb.append("(");
        }
        this.sb.append("<A HREF=\"mailto:").append(mail).append("\">").append(mail).append("</A>");
        if (parenthesis) {
            this.sb.append(")");
        }
        return this;
    }

    public Html linkTo(String url, String text) {
        this.sb.append("<A HREF=\"").append(url).append("\">");
        this.sb.append(text == null ? url : text);
        this.sb.append("</A>");
        return this;
    }

    public Html bold(String text) {
        this.sb.append("<B>").append(text).append("</B>");
        return this;
    }

    public Html td(boolean init) {
        this.sb.append(init ? "<TD VALIGN=\"top\">" : "</TD>\n");
        return this;
    }

    public Html td(String text) {
        return this.td(text, false);
    }

    public Html td(String text, int align, boolean bold, String tdParams) {
        this.sb.append("<TD VALIGN=\"top\" ");
        if (align > 0) {
            this.sb.append(SP).append(ALIGN[align]);
        }
        if (tdParams != null) {
            this.sb.append(SP).append(tdParams);
        }
        this.sb.append(">");
        if (bold) {
            this.bold(text);
        } else {
            this.sb.append(text);
        }
        this.sb.append("</TD>\n");
        return this;
    }

    public Html td(String text, boolean bld) {
        this.sb.append("<TD VALIGN=\"top\">");
        if (bld) {
            this.bold(text);
        } else {
            this.sb.append(text);
        }
        this.sb.append("</TD>\n");
        return this;
    }

    public Html tr(boolean init) {
        return this.append(init ? "<TR>" : "</TR>\n");
    }

    public Html br() {
        return this.append(BR);
    }

    public Html p() {
        return this.append(P);
    }

    public Html sp() {
        return this.append(SP);
    }

    public Html nbsp() {
        return this.append(NBSP);
    }

    public Html doubleCell(String tx1, boolean b1, String tx2, boolean b2) {
        this.tr(true);
        this.td(true);
        if (b1) {
            this.sb.append("<B>");
        }
        this.appendParagraphs(tx1);
        if (b1) {
            this.sb.append("</B>");
        }
        this.td(false);
        this.td(true);
        if (b2) {
            this.sb.append("<B>");
        }
        this.appendParagraphs(tx2);
        if (b2) {
            this.sb.append("</B>");
        }
        this.td(false);
        this.tr(false);
        return this;
    }

    public static String table(String content, String width, int border, int cellPadding, int cellSpacing, String style, boolean simpleCell) {
        int v = content != null ? content.length() : 100;
        StringBuilder sbs = new StringBuilder(v + 200);
        sbs.append("<TABLE ");
        if (width != null) {
            sbs.append(" WIDTH=\"").append(width).append(Q);
        }
        if (border >= 0) {
            sbs.append(" BORDER=\"").append(border).append(Q);
        }
        if (cellPadding >= 0) {
            sbs.append(" CELLPADDING=\"").append(cellPadding).append(Q);
        }
        if (cellSpacing >= 0) {
            sbs.append(" CELLSPACING=\"").append(cellSpacing).append(Q);
        }
        if (style != null) {
            sbs.append(" STYLE=\"").append(style).append(Q);
        }
        sbs.append(">\n");
        if (simpleCell) {
            sbs.append("<TR><TD>");
        }
        sbs.append(content);
        if (simpleCell) {
            sbs.append("</TD></TR>");
        }
        sbs.append("\n</TABLE>");
        return sbs.substring(0);
    }

    public static String getHtmlDoc(String content, String bgColor) {
        int v = content != null ? content.length() : 100;
        StringBuilder sbs = new StringBuilder(v + 100);
        sbs.append("<HTML>\n");
        sbs.append("<BODY");
        if (bgColor != null) {
            sbs.append(" BGCOLOR=\"#").append(bgColor).append(Q);
        }
        sbs.append(">\n");
        sbs.append(content);
        sbs.append("</BODY></HTML>");
        return sbs.substring(0);
    }

    public static String quote(String txt) {
        StringBuilder sbs = new StringBuilder(txt.length() * 3);
        sbs.append("'");
        sbs.append(StrUtils.replace(StrUtils.replace(StrUtils.replace(txt, "'", "&#39;"), Q, "&quot;"), "`", "&rsquo;"));
        sbs.append("'");
        return sbs.substring(0);
    }

    public static String encode(String src) {
        if (src == null || src.length() < 1) {
            return src;
        }
        int len = src.length();
        StringBuilder sbs = new StringBuilder(len * 2);
        for (int i = 0; i < len; ++i) {
            char ch = src.charAt(i);
            if (validChars.indexOf(ch) >= 0) {
                sbs.append(ch);
                continue;
            }
            if (ch < '\u0100') {
                sbs.append("%").append(Integer.toHexString(ch));
                continue;
            }
            sbs.append("%26%23").append(Integer.toHexString(ch)).append("%3B");
        }
        return sbs.substring(0);
    }

    public static String decode(String src) {
        if (src == null || src.length() < 1) {
            return src;
        }
        int len = src.length();
        StringBuilder sbs = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = src.charAt(i);
            if (ch == '%') {
                sbs.append((char)Integer.parseInt(src.substring(i + 1, i + 3), 16));
                i += 2;
                continue;
            }
            sbs.append(ch);
        }
        String s = sbs.substring(0);
        len = s.length();
        sbs.setLength(0);
        int j = 0;
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '&' && (j = s.indexOf(59, i)) > i + 2) {
                String v = s.substring(i + 1, j).toLowerCase();
                if (v.length() > 2 && v.charAt(0) == '#') {
                    int k = v.charAt(1) == 'x' ? Integer.parseInt(v.substring(2), 16) : Integer.parseInt(v.substring(1));
                    sbs.append((char)k);
                } else {
                    sbs.append('?');
                }
                i = j;
                continue;
            }
            sbs.append(ch);
        }
        return sbs.substring(0);
    }

    public static void processParamsLine(String txt, Map<String, String> map, char sep, char equalSign) {
        if (txt != null && txt.length() > 0 && map != null) {
            StringTokenizer st = new StringTokenizer(txt, String.valueOf(sep));
            while (st.hasMoreTokens()) {
                String key;
                String s = st.nextToken().trim();
                String value = null;
                int k = s.indexOf(equalSign);
                if (k > 0) {
                    key = Html.decode(s.substring(0, k).replace('+', ' '));
                    if (k < s.length() - 1) {
                        value = Html.decode(s.substring(k + 1).replace('+', ' '));
                    }
                } else {
                    key = Html.decode(s.replace('+', ' '));
                }
                map.put(key, value);
            }
        }
    }

    public static void writeScriptConfirm(PrintStream pOut) {
        pOut.println("<SCRIPT language=\"javascript\">");
        pOut.println("function confirmAction(msg){");
        pOut.println("   var agree=confirm(msg);");
        pOut.println("   if (agree)");
        pOut.println("     return true;");
        pOut.println("   else");
        pOut.println("     return false;");
        pOut.println("}");
        pOut.println("</SCRIPT>");
    }
}

