/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.ResourceManager;
import edu.xtec.util.StreamIO;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;

public class FontCheck {
    public static final String DEFAULT_FONT_NAME = "default";
    public static final Font DEFAULT_FONT = new Font("default", 0, 17);
    public static final String TMP_FONT_PREFIX = "tmp_font_";
    private static final Map<Object, Font> systemFonts = new HashMap<Object, Font>(12);
    private static String[] fontList;
    public static final String[] fontSizes;

    private FontCheck() {
    }

    public static String[] getFontList(boolean reload) {
        if (fontList == null || reload) {
            fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        return fontList;
    }

    public static boolean checkFont(Font font) {
        boolean result = false;
        if (font != null) {
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
            TextLayout layout = new TextLayout("AB", font, frc);
            result = layout.getBounds().getWidth() > 1.0;
        }
        return result;
    }

    public static boolean checkFontFamilyName(Object family) {
        return family != null && family instanceof String && FontCheck.checkFont(new Font((String)family, 0, 17));
    }

    public static Font getValidFont(String family, int style, int size) {
        Font f = new Font(family, style, size);
        if (!FontCheck.checkFont(f)) {
            Font fontBase = systemFonts.get(family.toLowerCase());
            if (fontBase == null) {
                fontBase = DEFAULT_FONT;
            }
            f = fontBase.deriveFont(style, size);
        }
        return f;
    }

    public static String getValidFontFamilyName(Object family) {
        Font f = systemFonts.get(family instanceof String ? ((String)family).toLowerCase() : family);
        if (f != null) {
            return f.getFamily();
        }
        return FontCheck.checkFontFamilyName(family) ? (String)family : DEFAULT_FONT_NAME;
    }

    public static Font checkSystemFont(String fontName, String fontFileName) {
        String fnLower = fontName.toLowerCase();
        Font f = systemFonts.get(fnLower);
        if (!(f != null || FontCheck.checkFont(f = new Font(fontName, 0, 17)) && fontName.toLowerCase().equals(f.getFamily().toLowerCase()))) {
            try {
                f = FontCheck.buildNewFont(fontFileName, ResourceManager.STREAM_PROVIDER, "fonts/" + fontFileName);
                if (FontCheck.checkFont(f)) {
                    systemFonts.put(fnLower, f);
                } else {
                    f = DEFAULT_FONT;
                }
            }
            catch (Exception ex) {
                System.err.println("Unable to build font " + fontName + "\n:" + ex);
            }
        }
        return f;
    }

    public static Font buildNewFont(String fileName, StreamIO.InputStreamProvider isp, String resourceName) throws Exception {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font font = Font.createFont(0, isp.getInputStream(resourceName));
        if (ge != null && font != null) {
            ge.registerFont(font);
            font = FontCheck.getValidFont(font.getName(), 0, 1);
        }
        return font;
    }

    static {
        fontSizes = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    }
}

