/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import java.io.File;
import java.lang.reflect.Method;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;

public class FileChooserForFiles
extends JFileChooser {
    static Class<?> WindowsFileChooserUIClass;
    static Method getFileNameMethod;

    public FileChooserForFiles() {
        this.setFileSelectionMode(0);
    }

    public FileChooserForFiles(File file) {
        super(file);
        this.setFileSelectionMode(0);
    }

    public FileChooserForFiles(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
        this.setFileSelectionMode(0);
    }

    public FileChooserForFiles(FileSystemView fsw) {
        super(fsw);
        this.setFileSelectionMode(0);
    }

    public FileChooserForFiles(String file) {
        super(file);
        this.setFileSelectionMode(0);
    }

    public FileChooserForFiles(String currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
        this.setFileSelectionMode(0);
    }

    @Override
    public void setCurrentDirectory(File dir) {
        String oldFileName = this.getCurrentFileName();
        super.setCurrentDirectory(dir);
        if (oldFileName != null && oldFileName.indexOf(34) == -1 && this.getCurrentFileName() == null) {
            this.setSelectedFile(new File(dir, oldFileName));
        }
    }

    private String getCurrentFileName() {
        String fileName;
        FileChooserUI fchui = this.getUI();
        if (fchui instanceof MetalFileChooserUI) {
            fileName = ((MetalFileChooserUI)fchui).getFileName();
        } else if (WindowsFileChooserUIClass != null && WindowsFileChooserUIClass.isInstance(fchui) && getFileNameMethod != null) {
            try {
                fileName = (String)getFileNameMethod.invoke((Object)fchui, (Object[])null);
            }
            catch (Exception ex) {
                fileName = null;
            }
        } else {
            fileName = null;
        }
        return fileName == null || fileName.trim().length() == 0 ? null : fileName;
    }

    public void directSetSelectedFile(File selectedFile) {
        super.setSelectedFile(selectedFile);
    }

    @Override
    public void setSelectedFile(File selectedFile) {
        if (selectedFile != null && (selectedFile.isDirectory() && this.isDirectorySelectionEnabled() || !selectedFile.isDirectory() && this.isFileSelectionEnabled())) {
            super.setSelectedFile(selectedFile);
        }
    }

    static {
        try {
            if (FileChooserForFiles.class.getResource("/com/sun/java/swing/plaf/windows/WindowsFileChooserUI.class") != null && (WindowsFileChooserUIClass = Class.forName("com.sun.java.swing.plaf.windows.WindowsFileChooserUI")) != null) {
                getFileNameMethod = WindowsFileChooserUIClass.getMethod("getFileName", null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

