/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.Desktop;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import javax.swing.JOptionPane;

public class BrowserLauncher {
    private static String preferredBrowser;
    public static final String BROWSER = "browser";
    private static final String errMsg = "Error attempting to launch web browser";

    public static void openURL(URL url, Component parent) {
        BrowserLauncher.openURL(url.toExternalForm(), parent);
    }

    public static void openURL(String surl, Component parent) {
        surl = StrUtils.replace(surl, " ", "%20");
        try {
            Desktop dsk;
            if (Desktop.isDesktopSupported() && (dsk = Desktop.getDesktop()) != null) {
                dsk.browse(new URI(surl));
                return;
            }
        }
        catch (Exception dsk) {
            // empty catch block
        }
        String osName = System.getProperty("os.name");
        try {
            String[] cmd;
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, surl);
                return;
            }
            if (osName.startsWith("Windows")) {
                cmd = new String[]{"rundll32", "url.dll,FileProtocolHandler", surl};
            } else {
                String[] browsers = new String[]{preferredBrowser, "xdg-open", "sensible-browser", "chromium", "firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (browsers[count] == null || browsers[count].length() <= 0 || Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                cmd = new String[]{browser, surl};
            }
            if (Runtime.getRuntime().exec(cmd).waitFor() != 0) {
                throw new Exception("Error opening page: " + surl);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(parent, "Error attempting to launch web browser:\n" + e.getLocalizedMessage());
        }
    }

    public static void openURL(URL url) {
        BrowserLauncher.openURL(url, null);
    }

    public static void openURL(String surl) {
        BrowserLauncher.openURL(surl, null);
    }

    public static void setPreferredBrowser(String browserCmd) {
        preferredBrowser = StrUtils.nullableString(browserCmd);
    }

    public static String getPreferredBrowser(String defaultValue) {
        return StrUtils.secureString(preferredBrowser, defaultValue);
    }
}

