/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.shapers.ShapeData;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Options;
import edu.xtec.util.TripleString;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public abstract class Shaper
implements Cloneable,
Domable {
    protected final double WIDTH = 1.0;
    protected final double HEIGHT = 1.0;
    protected static final String DELIM = "|";
    protected int nCols;
    protected int nRows;
    protected int nCells;
    protected ShapeData[] shapeData;
    protected boolean initiated = false;
    public static final String ELEMENT_NAME = "shaper";
    public static final String COLS = "cols";
    public static final String ROWS = "rows";
    public static final String BASE_CLASS = "edu.xtec.jclic.shapers.";
    public static final String BASE_CLASS_TAG = "@";
    public static final String SYSTEM_LIST = "shapers.listshapers";

    public Shaper(int nx, int ny) {
        this.reset(nx, ny);
    }

    public void reset(int nCols, int nRows) {
        this.nCols = nCols;
        this.nRows = nRows;
        this.nCells = nRows * nCols;
        this.initiated = false;
        this.shapeData = new ShapeData[this.nCells];
        for (int i = 0; i < this.nCells; ++i) {
            this.shapeData[i] = new ShapeData();
        }
    }

    public void reset() {
        this.reset(this.nCols, this.nRows);
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        e.setAttribute("class", this.getClassName());
        e.setAttribute(COLS, Integer.toString(this.nCols));
        e.setAttribute(ROWS, Integer.toString(this.nRows));
        return e;
    }

    public String getClassName() {
        String result = this.getClass().getName();
        if (result.startsWith(BASE_CLASS)) {
            result = BASE_CLASS_TAG + result.substring(BASE_CLASS.length());
        }
        return result;
    }

    public static Shaper getShaper(Element e) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        String className = JDomUtility.getClassName(e);
        int cw = JDomUtility.getIntAttr(e, COLS, 1);
        int ch = JDomUtility.getIntAttr(e, ROWS, 1);
        Shaper sh = Shaper.createShaper(className, cw, ch);
        sh.setProperties(e, null);
        return sh;
    }

    public static Shaper createShaper(String className, int cw, int ch) throws Exception {
        if (className.startsWith(BASE_CLASS_TAG)) {
            className = BASE_CLASS + className.substring(1);
        }
        Class[] cparams = new Class[]{Integer.TYPE, Integer.TYPE};
        Object[] initArgs = new Object[]{new Integer(cw), new Integer(ch)};
        Class<?> shaperClass = Class.forName(className);
        Constructor<?> con = shaperClass.getConstructor(cparams);
        return (Shaper)con.newInstance(initArgs);
    }

    protected abstract void buildShapes();

    public boolean rectangularShapes() {
        return false;
    }

    public String getEditorPanelClassName() {
        return null;
    }

    public Shaper edit(Component parent, Options options, Dimension dim, Image img, BoxBase bb) {
        Shaper result = null;
        if (this.getEditorPanelClassName() != null) {
            try {
                Class<?> cl = Class.forName(this.getEditorPanelClassName());
                Method m = cl.getMethod("getShaper", Shaper.class, Component.class, Options.class, Dimension.class, Image.class, BoxBase.class);
                result = (Shaper)m.invoke(null, this, parent, options, dim, img, bb);
            }
            catch (Exception ex) {
                options.getMessages().showErrorWarning(parent, "edit_act_shaper_err", ex);
            }
        }
        return result;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
    }

    public Shape getShape(int n, Rectangle2D rect) {
        if (!this.initiated) {
            this.buildShapes();
        }
        if (n >= this.nCells || this.shapeData[n] == null) {
            return null;
        }
        return this.shapeData[n].getShape(rect);
    }

    public ShapeData getShapeData(int n) {
        return n >= 0 && n < this.shapeData.length ? this.shapeData[n] : null;
    }

    protected ShapeData getEnclosingShapeData() {
        ShapeData sh = new ShapeData();
        sh.moveTo(0.0, 0.0);
        sh.lineTo(1.0, 0.0);
        sh.lineTo(1.0, 1.0);
        sh.lineTo(0.0, 1.0);
        sh.closePath();
        return sh;
    }

    public boolean hasRemainder() {
        return false;
    }

    public Shape getRemainderShape(Rectangle2D rect) {
        if (!this.hasRemainder()) {
            return null;
        }
        if (!this.initiated) {
            this.buildShapes();
        }
        GeneralPath gp = (GeneralPath)this.getEnclosingShapeData().getShape(rect);
        gp.setWindingRule(0);
        for (int i = 0; i < this.nCells; ++i) {
            if (this.shapeData[i] == null) continue;
            gp.append(this.shapeData[i].getShape(rect), false);
        }
        return gp;
    }

    public int getNumRows() {
        return this.nRows;
    }

    public void setNumRows(int n) {
        if (n > 0 && n != this.nRows) {
            this.reset(this.nCols, n);
        }
    }

    public int getNumColumns() {
        return this.nCols;
    }

    public void setNumColumns(int n) {
        if (n > 0 && n != this.nCols) {
            this.reset(this.nRows, n);
        }
    }

    public int getNumCells() {
        return this.nCells;
    }

    public static List getSystemShaperList(Options options) {
        List<Object> result = new ArrayList();
        try {
            result = TripleString.getTripleList(SYSTEM_LIST, options, false, true, true);
        }
        catch (Exception ex) {
            System.err.println("Error reading list of shapers!\n" + ex);
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        Shaper clon = (Shaper)super.clone();
        clon.shapeData = (ShapeData[])this.shapeData.clone();
        for (int i = 0; i < this.shapeData.length; ++i) {
            if (this.shapeData[i] == null) continue;
            clon.shapeData[i] = (ShapeData)this.shapeData[i].clone();
        }
        return clon;
    }
}

