/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.jclic.project.Author;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.project.Organization;
import edu.xtec.jclic.project.Revision;
import edu.xtec.util.Domable;
import edu.xtec.util.Html;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import edu.xtec.util.StrUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.jdom.Element;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectSettings
implements Editable,
Domable {
    public String title = UNTITLED;
    public String iconFileName = null;
    public String description = null;
    public String descriptors = null;
    public String area = null;
    public String level = null;
    public Locale locale = null;
    public String[] languages = null;
    public Author[] authors = null;
    public Organization[] organizations = null;
    public Revision[] revisions = new Revision[]{new Revision(new Date(), "created")};
    public String skinFileName = null;
    public EventSounds eventSounds = new EventSounds(null);
    public String coverFileName = null;
    public String thumbnailFileName = null;
    public String icon16 = null;
    public String icon72 = null;
    public String icon192 = null;
    public Locale[] meta_langs = new Locale[1];
    public String[] descriptions;
    public List<String> area_codes;
    public List<String> level_codes;
    public String[] lang_codes;
    public int license;
    public static String UNTITLED = "untitled";
    public static String ELEMENT_NAME = "settings";
    public static String TITLE = "title";
    public static String LOCALE = "locale";
    public static String LANGUAGE = "language";
    public static String DESCRIPTION = "description";
    public static String DESCRIPTORS = "descriptors";
    public static String SKIN = "skin";
    public static String FILE = "file";
    public static String AREA = "area";
    public static String AREA_CODES = "area-codes";
    public static String LEVEL = "level";
    public static String LEVEL_CODES = "level-codes";
    public static String ICON = "icon";
    public static String COVER = "cover";
    public static String THUMB = "thumb";
    public static String ICON16 = "icon16";
    public static String ICON72 = "icon72";
    public static String ICON192 = "icon192";
    public static String META_LANGS = "meta_langs";
    public static String DESCRIPTIONS = "descriptions";
    public static String LICENSE = "license";
    public static String TYPE = "type";
    public static String URL = "url";
    public static String[] KNOWN_META_LANGS = new String[]{"ca", "es", "en"};
    public static List<String>[] KNOWN_LEVEL_DESCS = new List[]{Arrays.asList("Infantil (3-6)", "Infantil (3-6)", "Kindergarten (3-6)"), Arrays.asList("Prim\u00e0ria (6-12)", "Primaria (6-12)", "Primary school (6-12)"), Arrays.asList("Secund\u00e0ria (12-16)", "Secundaria (12-16)", "Secondary school (12-16)"), Arrays.asList("Batxillerat (16-18)", "Bachillerato (16-18)", "High school (16-18)")};
    public static String[] KNOWN_LEVEL_CODES = new String[]{"INF", "PRI", "SEC", "BTX"};
    public static List<String>[] KNOWN_AREA_DESCS = new List[]{Arrays.asList("Lleng\u00fces", "Lenguas", "Languages"), Arrays.asList("Matem\u00e0tiques", "Matem\u00e1ticas", "Mathematics"), Arrays.asList("Ci\u00e8ncies socials", "Ciencias sociales", "Social sciences"), Arrays.asList("Ci\u00e8ncies experimentals", "Ciencias experimentales", "Experimental sciences"), Arrays.asList("M\u00fasica", "M\u00fasica", "Music"), Arrays.asList("Visual i pl\u00e0stica", "Pl\u00e1stica y visual", "Art & design"), Arrays.asList("Educaci\u00f3 f\u00edsica", "Educaci\u00f3n f\u00edsica", "Physical education"), Arrays.asList("Tecnologies", "Tecnolog\u00eda", "Design & technology"), Arrays.asList("Diversos", "Diversos", "Miscellaneous")};
    public static String[] KNOWN_AREA_CODES = new String[]{"lleng", "mat", "soc", "exp", "mus", "vip", "ef", "tec", "div"};
    public static String[] CC_LICENSES = new String[]{"by", "by-sa", "by-nd", "by-nc", "by-nc-sa", "by-nc-nd", "other"};
    public static int CC_BY = 0;
    public static int CC_BY_SA = 1;
    public static int CC_BY_ND = 2;
    public static int CC_BY_NC = 3;
    public static int CC_BY_NC_SA = 4;
    public static int CC_BY_NC_ND = 5;
    public static int OTHER = 6;
    public static String CC_URL = "https://creativecommons.org/licenses/%%CODE%%/4.0";
    public static String OTHER_URL = "See 'description'";
    public static String[] LICENSE_DESC = new String[]{"Aquesta obra est\u00e0 sota una llic\u00e8ncia de Creative Commons <a href=\"%%URL%%\">%%CODE%%</a>", "Esta obra est\u00e1 bajo una licencia de Creative Commons <a href=\"%%URL%%\">%%CODE%%</a>", "Licensed under a Creative Commons license <a href=\"%%URL%%\">%%CODE%%</a>"};
    public static String[] LICENSE_OTHER = new String[]{"Els termes de la llic\u00e8ncia d'\u00fas s'especifiquen a la descripci\u00f3 del projecte", "Los t\u00e9rminos de la licencia de uso se especifican en la descripci\u00f3n del proyecto", "License terms are specified in project description"};

    public ProjectSettings() {
        this.meta_langs[0] = Locale.getDefault();
        this.descriptions = new String[1];
        this.descriptions[0] = "";
        this.license = CC_BY_NC_SA;
    }

    @Override
    public Element getJDomElement() {
        int i;
        Element e = new Element(ELEMENT_NAME);
        e.addContent(new Element(TITLE).setText(this.title));
        if (this.revisions != null) {
            for (Domable domable : this.revisions) {
                e.addContent(((Revision)domable).getJDomElement());
            }
        }
        if (this.authors != null) {
            for (Author author : this.authors) {
                e.addContent(author.getJDomElement());
            }
        }
        if (this.organizations != null) {
            for (Organization organization : this.organizations) {
                e.addContent(organization.getJDomElement());
            }
        }
        if (this.languages != null) {
            for (String string : this.languages) {
                e.addContent(new Element(LANGUAGE).setText(string));
            }
        }
        if (this.locale != null) {
            e.setAttribute(LOCALE, this.locale.toLanguageTag());
        }
        if (this.description != null) {
            JDomUtility.addParagraphs(e, DESCRIPTION, this.description);
        }
        Element child = new Element(DESCRIPTORS);
        if (this.area != null) {
            child.setAttribute(AREA, this.area);
        }
        if (this.area_codes != null && this.area_codes.size() > 0) {
            child.setAttribute(AREA_CODES, StrUtils.getEnumeration(this.area_codes));
        }
        if (this.level != null) {
            child.setAttribute(LEVEL, this.level);
        }
        if (this.level_codes != null && this.level_codes.size() > 0) {
            child.setAttribute(LEVEL_CODES, StrUtils.getEnumeration(this.level_codes));
        }
        if (this.descriptors != null) {
            child.setText(this.descriptors);
        }
        e.addContent(child);
        child = this.eventSounds.getJDomElement();
        if (child != null) {
            e.addContent(child);
        }
        if (this.skinFileName != null) {
            child = new Element(SKIN);
            child.setAttribute(FILE, this.skinFileName);
            e.addContent(child);
        }
        if (this.iconFileName != null) {
            child = new Element(ICON);
            child.setAttribute(FILE, this.iconFileName);
            e.addContent(child);
        }
        if (this.coverFileName != null) {
            child = new Element(COVER);
            child.setAttribute(FILE, this.coverFileName);
            e.addContent(child);
        }
        if (this.thumbnailFileName != null) {
            child = new Element(THUMB);
            child.setAttribute(FILE, this.thumbnailFileName);
            e.addContent(child);
        }
        if (this.icon16 != null) {
            child = new Element(ICON16);
            child.setAttribute(FILE, this.icon16);
            e.addContent(child);
        }
        if (this.icon72 != null) {
            child = new Element(ICON72);
            child.setAttribute(FILE, this.icon72);
            e.addContent(child);
        }
        if (this.icon192 != null) {
            child = new Element(ICON192);
            child.setAttribute(FILE, this.icon192);
            e.addContent(child);
        }
        child = new Element(META_LANGS);
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.meta_langs.length; ++i) {
            sb.append(i > 0 ? "," : "").append(this.meta_langs[i].toLanguageTag());
        }
        child.setText(sb.substring(0));
        e.addContent(child);
        child = new Element(DESCRIPTIONS);
        for (i = 0; i < this.meta_langs.length; ++i) {
            Element child2 = JDomUtility.addParagraphs(child, DESCRIPTION, this.descriptions[i] == null ? "" : this.descriptions[i]);
            child2.setAttribute(LANGUAGE, this.meta_langs[i].toLanguageTag());
        }
        e.addContent(child);
        child = new Element(LICENSE);
        child.setAttribute(TYPE, CC_LICENSES[this.license]);
        child.setAttribute(URL, this.license < OTHER ? CC_URL.replace("%%CODE%%", CC_LICENSES[this.license]) : OTHER_URL);
        e.addContent(child);
        return e;
    }

    public static ProjectSettings getProjectSettings(Element e) throws Exception {
        ProjectSettings st = new ProjectSettings();
        st.setProperties(e, null);
        return st;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        StringTokenizer stk;
        String s;
        JDomUtility.checkName(e, ELEMENT_NAME);
        Element child = e.getChild(TITLE);
        if (child != null) {
            this.title = child.getText();
        }
        ArrayList<Revision> alr = new ArrayList<Revision>();
        Iterator itr = e.getChildren("revision").iterator();
        while (itr.hasNext()) {
            alr.add(Revision.getRevision((Element)itr.next()));
        }
        if (!alr.isEmpty()) {
            this.revisions = alr.toArray(new Revision[alr.size()]);
        }
        ArrayList<Author> alau = new ArrayList<Author>();
        itr = e.getChildren("author").iterator();
        while (itr.hasNext()) {
            alau.add(Author.getAuthor((Element)itr.next()));
        }
        if (!alau.isEmpty()) {
            this.authors = alau.toArray(new Author[alau.size()]);
        }
        ArrayList<Organization> alo = new ArrayList<Organization>();
        itr = e.getChildren("organization").iterator();
        while (itr.hasNext()) {
            alo.add(Organization.getOrganization((Element)itr.next()));
        }
        if (!alo.isEmpty()) {
            this.organizations = alo.toArray(new Organization[alo.size()]);
        }
        ArrayList<String> all = new ArrayList<String>();
        itr = e.getChildren(LANGUAGE).iterator();
        while (itr.hasNext()) {
            all.add(((Element)itr.next()).getText());
        }
        if (!all.isEmpty()) {
            this.languages = all.toArray(new String[all.size()]);
            for (int i = 0; i < this.languages.length; ++i) {
                String lng = Messages.getLanguageFromDescriptive(this.languages[i]);
                Locale loc = Locale.forLanguageTag(lng == null ? this.languages[i] : lng);
                if (loc.getLanguage().equals("")) {
                    lng = Messages.getKnownLanguageCode(this.languages[i]);
                    loc = Locale.forLanguageTag(lng == null ? this.languages[i] : lng);
                }
                this.languages[i] = loc.toLanguageTag();
            }
        }
        if (this.languages != null && this.languages.length > 0 && this.languages[0].length() > 1 && !this.languages[0].equals("und")) {
            this.meta_langs[0] = Locale.forLanguageTag(this.languages[0]);
        }
        if ((s = JDomUtility.getStringAttr(e, LOCALE, null, false)) != null) {
            stk = new StringTokenizer(s, "-");
            String l = null;
            String c = null;
            String v = null;
            if (stk.hasMoreTokens()) {
                l = stk.nextToken();
            }
            if (stk.hasMoreTokens()) {
                c = stk.nextToken();
            }
            if (stk.hasMoreTokens()) {
                v = stk.nextToken();
            }
            if (l != null && c != null) {
                this.locale = v != null ? new Locale(l, c, v) : new Locale(l, c);
            }
        }
        this.description = JDomUtility.getParagraphs(e.getChild(DESCRIPTION));
        if (this.description != null) {
            this.descriptions[0] = this.description;
        }
        if ((child = e.getChild(DESCRIPTORS)) != null) {
            ArrayList<String> al;
            StringBuffer sb;
            if (!child.getChildren("p").isEmpty()) {
                this.descriptors = JDomUtility.getParagraphs(e.getChild(DESCRIPTORS));
                this.descriptors = StrUtils.replace(this.descriptors, "\n", ", ");
            } else {
                this.descriptors = StrUtils.nullableString(child.getTextNormalize());
            }
            this.area = JDomUtility.getStringAttr(child, AREA, this.area, false);
            String ac = JDomUtility.getStringAttr(child, AREA_CODES, null, false);
            if (ac != null) {
                this.area_codes = StrUtils.enumerationToList(ac, ",");
            } else if (this.area != null) {
                sb = new StringBuffer();
                al = new ArrayList<String>();
                stk = new StringTokenizer(this.area, ",");
                while (stk.hasMoreElements()) {
                    int i;
                    s = stk.nextToken().trim();
                    for (i = 0; i < KNOWN_AREA_DESCS.length; ++i) {
                        if (!KNOWN_AREA_DESCS[i].contains(s)) continue;
                        al.add(KNOWN_AREA_CODES[i]);
                        break;
                    }
                    if (i != KNOWN_AREA_DESCS.length) continue;
                    sb.append(sb.length() > 0 ? ", " : "").append(s);
                }
                String string = this.area = sb.length() > 0 ? sb.toString() : null;
                if (al.size() > 0) {
                    this.area_codes = al;
                }
            }
            this.level = JDomUtility.getStringAttr(child, LEVEL, this.level, false);
            String lc = JDomUtility.getStringAttr(child, LEVEL_CODES, null, false);
            if (lc != null) {
                this.level_codes = StrUtils.enumerationToList(lc, ",");
            } else if (this.level != null) {
                sb = new StringBuffer();
                al = new ArrayList();
                stk = new StringTokenizer(this.level, ",");
                while (stk.hasMoreElements()) {
                    int i;
                    s = stk.nextToken().trim();
                    for (i = 0; i < KNOWN_LEVEL_DESCS.length; ++i) {
                        if (!KNOWN_LEVEL_DESCS[i].contains(s)) continue;
                        al.add(KNOWN_LEVEL_CODES[i]);
                        break;
                    }
                    if (i != KNOWN_LEVEL_DESCS.length) continue;
                    sb.append(sb.length() > 0 ? ", " : "").append(s);
                }
                String string = this.level = sb.length() > 0 ? sb.toString() : null;
                if (al.size() > 0) {
                    this.level_codes = al;
                }
            }
        }
        if ((child = e.getChild("eventSounds")) != null) {
            this.eventSounds = EventSounds.getEventSounds(child);
        }
        if ((child = e.getChild(SKIN)) != null) {
            this.skinFileName = JDomUtility.getStringAttr(child, FILE, this.skinFileName, false);
        }
        if ((child = e.getChild(ICON)) != null) {
            this.iconFileName = JDomUtility.getStringAttr(child, FILE, this.iconFileName, false);
        }
        if ((child = e.getChild(COVER)) != null) {
            this.coverFileName = JDomUtility.getStringAttr(child, FILE, this.coverFileName, false);
        }
        if ((child = e.getChild(THUMB)) != null) {
            this.thumbnailFileName = JDomUtility.getStringAttr(child, FILE, this.thumbnailFileName, false);
        }
        if ((child = e.getChild(ICON16)) != null) {
            this.icon16 = JDomUtility.getStringAttr(child, FILE, this.icon16, false);
        }
        if ((child = e.getChild(ICON72)) != null) {
            this.icon72 = JDomUtility.getStringAttr(child, FILE, this.icon72, false);
        }
        if ((child = e.getChild(ICON192)) != null) {
            this.icon192 = JDomUtility.getStringAttr(child, FILE, this.icon192, false);
        }
        if ((child = e.getChild(META_LANGS)) != null) {
            String[] ml = child.getTextNormalize().split(",");
            this.meta_langs = new Locale[ml.length];
            this.descriptions = new String[ml.length];
            for (int i = 0; i < ml.length; ++i) {
                this.meta_langs[i] = Locale.forLanguageTag(ml[i]);
                this.descriptions[i] = i == 0 && this.description != null ? this.description : "";
            }
        }
        if ((child = e.getChild(DESCRIPTIONS)) != null) {
            List descs = child.getChildren(DESCRIPTION);
            this.descriptions = new String[Math.max(this.meta_langs.length, descs.size())];
            for (int i = 0; i < descs.size(); ++i) {
                this.descriptions[i] = JDomUtility.getParagraphs((Element)descs.get(i));
            }
        }
        if ((child = e.getChild(LICENSE)) != null) {
            this.license = JDomUtility.getStrIndexAttr(child, TYPE, CC_LICENSES, CC_BY_NC_SA);
        }
    }

    public String toHtmlString(Messages msg) {
        int i;
        int k;
        String msgBase = "about_window_lb_";
        Html html = new Html(1000);
        html.doubleCell(msg.get(msgBase + "project"), true, this.title, true);
        if (this.area != null) {
            html.doubleCell(msg.get(msgBase + "area"), true, this.area, false);
        }
        if (this.level != null) {
            html.doubleCell(msg.get(msgBase + "level"), true, this.level, false);
        }
        if (this.authors != null) {
            k = this.authors.length;
            html.tr(true).td(msg.get(msgBase + "author" + (k > 1 ? "s" : "")), true).td(true);
            for (i = 0; i < k; ++i) {
                if (this.authors[i] == null) continue;
                html.append(this.authors[i].toHtmlString(msg)).br();
            }
            html.td(false).tr(false);
        }
        if (this.organizations != null) {
            k = this.organizations.length;
            html.tr(true).td(msg.get(msgBase + "organization" + (k > 1 ? "s" : "")), true).td(true);
            for (i = 0; i < this.organizations.length; ++i) {
                if (i > 0) {
                    html.nbsp().br();
                }
                if (this.organizations[i] == null) continue;
                html.append(this.organizations[i].toHtmlString(msg)).br();
            }
            html.td(false).tr(false);
        }
        if (this.revisions != null) {
            html.tr(true).td(msg.get(msgBase + "history"), true).td(true);
            for (int i2 = 0; i2 < this.revisions.length; ++i2) {
                if (i2 > 0) {
                    html.nbsp().br();
                }
                if (this.revisions[i2] == null) continue;
                html.append(this.revisions[i2].toHtmlString(msg)).br();
            }
            html.td(false).tr(false);
        }
        if (this.languages != null) {
            k = this.languages.length;
            html.tr(true).td(msg.get(msgBase + "language" + (k > 1 ? "s" : "")), true).td(true);
            for (i = 0; i < k; ++i) {
                if (this.languages[i] == null) continue;
                html.append(this.languages[i]).sp();
            }
            html.td(false).tr(false);
        }
        if (this.description != null) {
            html.doubleCell(msg.get(msgBase + "description"), true, this.description, false);
        }
        if (this.descriptors != null) {
            html.doubleCell(msg.get(msgBase + "descriptors"), true, this.descriptors, false);
        }
        return Html.table(html.toString(), null, 1, 5, -1, null, false);
    }

    public void readJSON(JSONObject json, JClicProject parent, boolean preserve) throws Exception {
        int i;
        if (json.has("title") && (!preserve || this.title.length() == 0)) {
            this.title = json.getString("title");
        }
        if (json.has("author") && (!preserve || this.authors == null || this.authors.length == 0)) {
            String[] authStr = json.getString("author").split(", ");
            this.authors = new Author[authStr.length];
            for (i = 0; i < authStr.length; ++i) {
                this.authors[i] = Author.fromString(authStr[i]);
            }
        }
        if (json.has("school") && (!preserve || this.organizations == null || this.organizations.length == 0)) {
            String[] orgStr = json.getString("school").split(", ");
            this.organizations = new Organization[orgStr.length];
            for (i = 0; i < orgStr.length; ++i) {
                this.organizations[i] = Organization.fromString(orgStr[i]);
            }
        }
        if (json.has("meta_langs") && (!preserve || this.meta_langs.length == 1 && this.meta_langs[0] == Locale.getDefault())) {
            JSONArray langTags = json.getJSONArray("meta_langs");
            this.meta_langs = new Locale[langTags.length()];
            for (i = 0; i < this.meta_langs.length; ++i) {
                this.meta_langs[i] = new Locale(langTags.getString(i));
            }
        }
        if (json.has("description") && (!preserve || this.descriptions.length == 1 || this.descriptions[0].length() == 0)) {
            JSONObject descs = json.getJSONObject("description");
            this.descriptions = new String[this.meta_langs.length];
            for (i = 0; i < this.meta_langs.length; ++i) {
                this.descriptions[i] = descs.optString(this.meta_langs[i].toLanguageTag());
            }
            this.description = this.descriptions[0];
        }
        if (json.has("cover") && (!preserve || this.coverFileName == null)) {
            this.coverFileName = json.getString("cover");
            parent.mediaBag.addElement(new MediaBagElement(this.coverFileName));
        }
        if (json.has("thumbnail") && (!preserve || this.thumbnailFileName == null)) {
            this.thumbnailFileName = json.getString("thumbnail");
            parent.mediaBag.addElement(new MediaBagElement(this.thumbnailFileName));
        }
        if (this.icon16 == null) {
            this.icon16 = "favicon.ico";
            parent.mediaBag.addElement(new MediaBagElement(this.icon16));
        }
        if (this.icon72 == null) {
            this.icon72 = "icon-72.png";
            parent.mediaBag.addElement(new MediaBagElement(this.icon72));
        }
        if (this.icon192 == null) {
            this.icon192 = "icon-192.png";
            parent.mediaBag.addElement(new MediaBagElement(this.icon192));
        }
    }

    public JSONObject toJSON(Messages msg) throws JSONException {
        int j;
        JSONObject jso;
        int i;
        Object jso2;
        int p;
        Object lang;
        int n;
        int n2;
        Object[] objectArray;
        StringBuilder sb;
        int numLangs = this.meta_langs.length;
        String[] langTags = new String[numLangs];
        for (int i2 = 0; i2 < numLangs; ++i2) {
            langTags[i2] = this.meta_langs[i2].toLanguageTag();
        }
        JSONObject json = new JSONObject();
        json.put("title", this.title);
        if (this.authors != null && this.authors.length > 0) {
            sb = new StringBuilder();
            objectArray = this.authors;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                Object a = objectArray[n];
                StrUtils.addToEnum(sb, ((Author)a).toString());
            }
            json.put("author", sb.toString());
        }
        if (this.organizations != null && this.organizations.length > 0) {
            sb = new StringBuilder();
            objectArray = this.organizations;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                Object o = objectArray[n];
                StrUtils.addToEnum(sb, ((Organization)o).toString());
            }
            json.put("school", sb.toString());
        }
        if (this.revisions != null && this.revisions.length > 0) {
            json.put("date", msg.getShortDateStr(this.revisions[0].date));
        }
        if (this.languages != null && this.languages.length > 0) {
            String[] langDescs = new String[numLangs];
            objectArray = this.languages;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                lang = objectArray[n];
                Object code = null;
                p = ((String)lang).lastIndexOf(40);
                int q = ((String)lang).lastIndexOf(41);
                if (p > 0 && q > p) {
                    code = ((String)lang).substring(p + 1, q);
                } else {
                    code = (String)Messages.getNamesToCodes().get(((String)lang).toLowerCase());
                    if (code == null) {
                        code = lang;
                    }
                }
                json.append("langCodes", code);
                Locale loc = new Locale((String)code);
                for (int i3 = 0; i3 < numLangs; ++i3) {
                    langDescs[i3] = StrUtils.addToEnum(langDescs[i3] == null ? "" : langDescs[i3], loc.getDisplayName(this.meta_langs[i3]));
                }
            }
            jso2 = new JSONObject();
            for (i = 0; i < numLangs; ++i) {
                ((JSONObject)jso2).put(langTags[i], langDescs[i]);
            }
            json.put("languages", jso2);
        }
        if (this.area_codes != null && this.area_codes.size() > 0) {
            json.put("areaCodes", new JSONArray(this.area_codes));
            jso = new JSONObject();
            jso2 = langTags;
            i = ((String[])jso2).length;
            for (n = 0; n < i; ++n) {
                lang = jso2[n];
                String areaDescs = "";
                p = StrUtils.getIndexOf((String)lang, KNOWN_META_LANGS);
                if (p >= 0) {
                    StringBuilder sb2 = new StringBuilder();
                    for (String code : this.area_codes) {
                        j = StrUtils.getIndexOf(code, KNOWN_AREA_CODES);
                        StrUtils.addToEnum(sb2, j >= 0 ? KNOWN_AREA_DESCS[j].get(p) : code);
                    }
                    areaDescs = sb2.toString();
                } else {
                    areaDescs = StrUtils.getEnumeration(this.area_codes);
                }
                if (this.area != null && this.area.length() > 0) {
                    areaDescs = StrUtils.addToEnum(areaDescs, this.area);
                }
                jso.put((String)lang, areaDescs);
            }
            json.put("areas", jso);
        } else if (this.area != null) {
            jso = new JSONObject();
            jso2 = langTags;
            i = ((String[])jso2).length;
            for (n = 0; n < i; ++n) {
                lang = jso2[n];
                jso.put((String)lang, this.area);
            }
            json.put("areas", jso);
        }
        if (this.level_codes != null && this.level_codes.size() > 0) {
            json.put("levelCodes", new JSONArray(this.level_codes));
            jso = new JSONObject();
            jso2 = langTags;
            i = ((String[])jso2).length;
            for (n = 0; n < i; ++n) {
                lang = jso2[n];
                String levelDescs = "";
                p = StrUtils.getIndexOf((String)lang, KNOWN_META_LANGS);
                if (p >= 0) {
                    StringBuilder sb3 = new StringBuilder();
                    for (String level : this.level_codes) {
                        j = StrUtils.getIndexOf(level, KNOWN_LEVEL_CODES);
                        StrUtils.addToEnum(sb3, j >= 0 ? KNOWN_LEVEL_DESCS[j].get(p) : level);
                    }
                    levelDescs = sb3.toString();
                } else {
                    levelDescs = StrUtils.getEnumeration(this.level_codes);
                }
                if (this.level != null && this.level.length() > 0) {
                    levelDescs = StrUtils.addToEnum(levelDescs, this.level);
                }
                jso.put((String)lang, levelDescs);
            }
            json.put("levels", jso);
        } else if (this.level != null) {
            jso = new JSONObject();
            jso2 = langTags;
            i = ((String[])jso2).length;
            for (n = 0; n < i; ++n) {
                lang = jso2[n];
                jso.put((String)lang, this.level);
            }
            json.put("levels", jso);
        }
        jso = new JSONObject();
        for (int i4 = 0; i4 < numLangs && i4 < this.descriptions.length; ++i4) {
            if (this.descriptions[i4] == null) continue;
            jso.put(langTags[i4], this.descriptions[i4]);
        }
        json.put("description", jso);
        jso = new JSONObject();
        String url = this.license < OTHER ? CC_URL.replace("%%CODE%%", CC_LICENSES[this.license]) : OTHER_URL;
        for (i = 0; i < numLangs; ++i) {
            int p2 = StrUtils.getIndexOf(langTags[i], KNOWN_META_LANGS);
            if (p2 < 0) {
                p2 = 2;
            }
            String str = this.license < OTHER ? LICENSE_DESC[p2].replace("%%URL%%", url).replace("%%CODE%%", CC_LICENSES[this.license].toUpperCase()) : LICENSE_OTHER[p2];
            jso.put(langTags[i], str);
        }
        json.put("license", jso);
        json.put("meta_langs", new JSONArray(langTags));
        if (this.coverFileName != null) {
            json.put("cover", this.coverFileName);
        }
        if (this.thumbnailFileName != null) {
            json.put("thumbnail", this.thumbnailFileName);
        }
        return json;
    }

    public static String[] getLicensesList(String otherTxt) {
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < OTHER; ++i) {
            v.add("Creative Commons " + CC_LICENSES[i].toUpperCase());
        }
        v.add(otherTxt);
        return v.toArray(new String[v.size()]);
    }

    @Override
    public Editor getEditor(Editor parent) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, parent);
    }
}

