/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

public class ProjectInstaller
implements Domable {
    public static final String SEP = ";";
    public static final String ITEM_SEP = ",";
    public static final String EQUAL_SEP = ":";
    public static final String FILES = "files";
    public static final String ITEM_NAMES = "itemNames";
    public static final String ITEM_PROJECTS = "itemProjects";
    public static final String ITEM_ICONS = "itemIcons";
    public static final String ITEM_DESCRIPTIONS = "itemDescriptions";
    public static final String ELEMENT_NAME = "JClicInstall";
    public static final String TITLE = "title";
    public static final String AUTHORS = "authors";
    public static final String FROM = "from";
    public static final String FILE = "file";
    public static final String SRC = "src";
    public static final String FOLDER = "folder";
    public static final String SHORTCUT = "shortcut";
    public static final String ICON = "icon";
    public static final String PROJECT = "project";
    public static final String TEXT = "text";
    public static final String DESCRIPTION = "description";
    public static final String INSTALLER_EXTENSION = ".jclic.inst";
    public String fName;
    public String from;
    public String baseFolder;
    public String projectTitle;
    public String authors;
    public List<String> files = new ArrayList<String>();
    public List<IconItem> iconItems = new ArrayList<IconItem>();

    @Override
    public Element getJDomElement() {
        return this.getJDomElement(true);
    }

    public Element getJDomElement(boolean includeFrom) {
        Element child;
        Element e = new Element(ELEMENT_NAME);
        JDomUtility.setStringAttr(e, TITLE, this.projectTitle, false);
        JDomUtility.setStringAttr(e, AUTHORS, this.authors, false);
        JDomUtility.setStringAttr(e, FOLDER, this.baseFolder, false);
        if (includeFrom) {
            JDomUtility.setStringAttr(e, FROM, this.from, false);
        }
        if (this.files != null) {
            for (int i = 0; i < this.files.size(); ++i) {
                child = new Element(FILE);
                child.setAttribute(SRC, this.getFile(i));
                e.addContent(child);
            }
        }
        if (this.iconItems != null) {
            for (IconItem ii : this.iconItems) {
                child = new Element(SHORTCUT);
                JDomUtility.setStringAttr(child, PROJECT, ii.project, false);
                JDomUtility.setStringAttr(child, TEXT, ii.text, false);
                JDomUtility.setStringAttr(child, DESCRIPTION, ii.description, false);
                JDomUtility.setStringAttr(child, ICON, ii.icon, false);
                e.addContent(child);
            }
        }
        return e;
    }

    public static ProjectInstaller getProjectInstaller(String fileName) throws Exception {
        InputStream is;
        boolean isUrl = FileSystem.isStrUrl(fileName);
        URL url = null;
        File f = null;
        if (isUrl) {
            url = new URL(fileName);
            is = url.openStream();
        } else {
            f = new File(fileName);
            is = new FileInputStream(f);
        }
        Document doc = JDomUtility.getSAXBuilder().build(is);
        JDomUtility.clearNewLineElements(doc.getRootElement());
        is.close();
        ProjectInstaller result = ProjectInstaller.getProjectInstaller(doc.getRootElement());
        String from = null;
        String fName = null;
        if (isUrl && url != null) {
            String s0 = url.toExternalForm();
            int k = s0.lastIndexOf(47);
            if (k < 0) {
                throw new Exception("Unable to get install store path from " + s0);
            }
            from = s0.substring(0, k);
            fName = s0.substring(k + 1);
        } else if (f != null) {
            from = f.getParent();
            fName = f.getName();
        }
        if (from != null) {
            result.from = from;
        }
        if (fName != null) {
            result.fName = fName;
        }
        return result;
    }

    public static ProjectInstaller getProjectInstaller(Element e) throws Exception {
        ProjectInstaller pi = new ProjectInstaller();
        pi.setProperties(e, null);
        return pi;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.projectTitle = JDomUtility.getStringAttr(e, TITLE, this.projectTitle, false);
        this.authors = JDomUtility.getStringAttr(e, AUTHORS, this.authors, false);
        this.baseFolder = JDomUtility.getStringAttr(e, FOLDER, this.baseFolder, false);
        this.from = JDomUtility.getStringAttr(e, FROM, this.from, false);
        for (Element child : e.getChildren(FILE)) {
            this.addFile(JDomUtility.getStringAttr(child, SRC, null, false));
        }
        for (Element child : e.getChildren(SHORTCUT)) {
            IconItem ii = this.createIconItem();
            ii.project = JDomUtility.getStringAttr(child, PROJECT, ii.project, false);
            ii.text = JDomUtility.getStringAttr(child, TEXT, ii.text, false);
            ii.description = JDomUtility.getStringAttr(child, DESCRIPTION, ii.description, false);
            ii.icon = JDomUtility.getStringAttr(child, ICON, ii.icon, false);
        }
    }

    public void addFile(String s) {
        if (s != null && !this.files.contains(s)) {
            this.files.add(s);
        }
    }

    public String getFile(int i) {
        if (this.files != null && i < this.files.size()) {
            return this.files.get(i);
        }
        return null;
    }

    public IconItem getIconItem(int i) {
        if (this.iconItems != null && i < this.iconItems.size()) {
            return this.iconItems.get(i);
        }
        return null;
    }

    public IconItem createIconItem() {
        IconItem result = new IconItem();
        this.iconItems.add(result);
        return result;
    }

    public class IconItem {
        protected String text;
        protected String description;
        protected String project;
        protected String icon;

        public String toString() {
            return this.project == null ? "--" : this.project;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public String getProject() {
            return this.project;
        }

        public void setProject(String project) {
            this.project = project;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

