/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.ActivityBag;
import edu.xtec.jclic.bags.ActivitySequence;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.fileSystem.ZipFileSystem;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.jclic.project.ProjectSettings;
import edu.xtec.jclic.skins.Skin;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ProgressDialog;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.StrUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.json.JSONObject;

public class JClicProject
implements Editable,
Domable {
    public static String CURRENT_VERSION = "0.1.3";
    protected ResourceBridge bridge;
    protected FileSystem fileSystem;
    public ActivityBag activityBag;
    public ActivitySequence activitySequence;
    public MediaBag mediaBag;
    public Skin skin;
    protected String name;
    public String version;
    public ProjectSettings settings;
    public String type;
    public String code;
    protected String fullPath;
    public boolean isScorm;
    public static String TYPE = "type";
    public static String ELEMENT_NAME = "JClicProject";
    public static String VERSION = "version";
    public static String NAME = "name";
    public static String CODE = "code";

    public JClicProject(ResourceBridge bridge, FileSystem fileSystem, String fullPath) {
        this.fileSystem = fileSystem;
        this.bridge = bridge;
        this.fullPath = fullPath == null ? "" : fullPath;
        this.isScorm = this.fullPath.endsWith(".scorm.zip");
        this.version = CURRENT_VERSION;
        this.settings = new ProjectSettings();
        this.settings.title = bridge.getMsg("UNNAMED");
        this.setName(this.settings.title);
        this.type = null;
        this.activityBag = new ActivityBag(this);
        this.activitySequence = new ActivitySequence(this);
        this.mediaBag = new MediaBag(this);
        this.skin = null;
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        e.setAttribute(NAME, this.name);
        e.setAttribute(VERSION, CURRENT_VERSION);
        if (this.type != null) {
            e.setAttribute(TYPE, this.type);
        }
        if (this.code != null) {
            e.setAttribute(CODE, this.code);
        }
        e.addContent(this.settings.getJDomElement());
        e.addContent(this.activitySequence.getJDomElement());
        e.addContent(this.activityBag.getJDomElement());
        e.addContent(this.mediaBag.getJDomElement());
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.name = JDomUtility.getStringAttr(e, NAME, this.name, false);
        this.version = JDomUtility.getStringAttr(e, VERSION, this.version, false);
        this.type = JDomUtility.getStringAttr(e, TYPE, this.type, false);
        this.code = JDomUtility.getStringAttr(e, CODE, this.code, false);
        Element child = e.getChild(ProjectSettings.ELEMENT_NAME);
        if (child != null) {
            this.settings = ProjectSettings.getProjectSettings(child);
        }
        this.activitySequence.setProperties(e.getChild("sequence"), null);
        this.activityBag.setProperties(e.getChild("activities"), null);
        if (this.version.compareTo("0.1.2") <= 0) {
            this.activityBag.sortByName();
        }
        this.mediaBag.setProperties(e.getChild(MediaBag.ELEMENT_NAME), null);
    }

    public void readJSON(JSONObject json, boolean preserve) throws Exception {
        this.settings.readJSON(json, this, preserve);
    }

    public static JClicProject getJClicProject(Element e, ResourceBridge rb, FileSystem fs, String fullPath) throws Exception {
        JClicProject jcp = new JClicProject(rb, fs, fullPath);
        jcp.setProperties(e, null);
        return jcp;
    }

    public static JClicProject getJClicProject(ResourceBridge rb, String fullPath, ProgressDialog pd) throws Exception {
        FileSystem fileSystem;
        JClicProject result = null;
        if (pd != null) {
            pd.setText(rb.getMsg("msg_loading") + " " + fullPath);
        }
        if ((fullPath = (fileSystem = FileSystem.createFileSystem(fullPath, rb)).getUrl(fullPath)).startsWith("file://")) {
            fullPath = fullPath.substring(7);
        }
        String projectName = null;
        JSONObject json = null;
        if (fullPath.endsWith(".jclic.zip")) {
            fileSystem = FileSystem.createFileSystem(fullPath, rb);
            String[] projects = ((ZipFileSystem)fileSystem).getEntries(".jclic");
            if (projects == null) {
                throw new Exception("File " + fullPath + " does not contain any jclic project");
            }
            projectName = projects[0];
        } else if (fullPath.endsWith(".scorm.zip")) {
            fileSystem = FileSystem.createFileSystem(fullPath, rb);
            if (fileSystem.fileExists("project.json")) {
                json = new JSONObject(new String(fileSystem.getBytes("project.json")));
                projectName = json.optString("mainFile", null);
            }
            if (projectName == null) {
                throw new Exception("Invalid JClic SCORM file: " + fullPath);
            }
        } else {
            fileSystem = new FileSystem(FileSystem.getPathPartOf(fullPath), rb);
            projectName = FileSystem.getFileNameOf(fullPath);
            if (fileSystem.fileExists("project.json")) {
                json = new JSONObject(new String(fileSystem.getBytes("project.json")));
            }
        }
        if (projectName.endsWith(".jclic")) {
            Document doc = fileSystem.getXMLDocument(projectName);
            System.gc();
            result = JClicProject.getJClicProject(doc.getRootElement(), rb, fileSystem, fullPath);
        }
        if (result != null) {
            if (json != null) {
                result.readJSON(json, false);
            }
            result.mediaBag.waitForAllImages();
        }
        return result;
    }

    public Document getDocument() {
        return new Document(this.getJDomElement());
    }

    public void saveDocument(OutputStream out) throws Exception {
        JDomUtility.saveDocument(out, this.getDocument());
    }

    public void saveZipDocument(OutputStream out, boolean includeMedia) throws Exception {
        ZipOutputStream zos = new ZipOutputStream(out);
        zos.putNextEntry(new ZipEntry(this.name + ".jclic"));
        this.saveDocument(zos);
        zos.closeEntry();
        if (includeMedia) {
            Set<String> set = Collections.synchronizedSet(new HashSet());
            for (MediaBagElement mbe : this.mediaBag.getElements()) {
                String fName;
                if (!mbe.saveFlag || (fName = mbe.getFileName()) == null || fName.length() <= 0) continue;
                set.add(fName);
            }
            for (String fName : set) {
                zos.putNextEntry(new ZipEntry(fName));
                zos.write(this.fileSystem.getBytes(fName));
                zos.closeEntry();
            }
        }
        zos.close();
        out.close();
    }

    public void saveZipDocumentPreservingZipContents(OutputStream out, ZipFileSystem zfs) throws Exception {
        ZipOutputStream zos = new ZipOutputStream(out);
        zos.putNextEntry(new ZipEntry(this.name + ".jclic"));
        this.saveDocument(zos);
        zos.closeEntry();
        String[] entries = zfs.getEntries(null);
        if (entries != null) {
            for (String entry : entries) {
                if (entry.endsWith(".jclic")) continue;
                zos.putNextEntry(new ZipEntry(entry));
                zos.write(zfs.getBytes(entry));
                zos.closeEntry();
            }
        }
        zos.close();
        out.close();
    }

    public void saveProject(String fileName) throws Exception {
        this.mediaBag.clearData();
        System.runFinalization();
        System.gc();
        String fn = this.fileSystem.getFullFileNamePath(fileName);
        FileOutputStream fos = this.fileSystem.createSecureFileOutputStream(fn, true);
        this.saveZipDocument(fos, true);
        fos.close();
        this.setFileSystem(FileSystem.createFileSystem(fn, this.bridge));
        this.setFullPath(fn);
    }

    public void setName(String newName) {
        this.name = StrUtils.secureString(newName, this.bridge.getMsg("UNNAMED"));
        this.name = new File(this.name).getName();
        int p = this.name.indexOf(46);
        if (p >= 0) {
            this.name = this.name.substring(0, p);
        }
        if (this.name.indexOf(32) >= 0) {
            this.name = this.name.replace(' ', '_');
        }
        if (this.name.length() < 1) {
            this.name = "NO_NAME";
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPublicName() {
        return this.settings.title;
    }

    public void realize(EventSounds parent, PlayStation ps) {
        if (this.skin == null && this.settings.skinFileName != null && this.settings.skinFileName.length() > 0) {
            this.skin = this.mediaBag.getSkinElement(this.settings.skinFileName, ps);
        }
        if (this.settings.eventSounds != null) {
            this.settings.eventSounds.setParent(parent);
            this.settings.eventSounds.realize(ps.getOptions(), this.mediaBag);
        }
        this.mediaBag.buildFonts();
    }

    public void end() {
        if (this.settings.eventSounds != null) {
            this.settings.eventSounds.close();
            this.settings.eventSounds = null;
        }
        this.mediaBag.clearData();
        this.mediaBag.clear();
        this.fileSystem.close();
        System.gc();
    }

    protected void finalize() throws Throwable {
        this.end();
        super.finalize();
    }

    public ResourceBridge getBridge() {
        return this.bridge;
    }

    public void setBridge(ResourceBridge bridge) {
        this.bridge = bridge;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public void setFileSystem(FileSystem fileSystem) {
        if (this.fileSystem != null && this.fileSystem != fileSystem) {
            this.fileSystem.close();
        }
        this.fileSystem = fileSystem;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    @Override
    public Editor getEditor(Editor parent) {
        return Editor.createEditor("edu.xtec.jclic.project.JClicProjectEditor", this, parent);
    }
}

