/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.media.AudioPlayer;
import edu.xtec.util.ExtendedByteArrayInputStream;
import edu.xtec.util.StreamIO;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.applet.AppletMpegSPIWorkaround;
import org.tritonus.applet.AppletVorbisSPIWorkaround;

public class JavaSoundAudioPlayer
implements AudioPlayer {
    private Clip clip;
    protected AudioInputStream ais;
    protected boolean isMpeg;
    protected boolean isOgg;
    protected boolean isWav;
    static final int INTERNAL_BUFFER_SIZE = 1024;
    static final int CHECK_BUFFER_SIZE = 96;
    static final int BIT_SAMPLE_SIZE = 16;
    static final boolean BIG_ENDIAN = true;

    @Override
    public boolean setDataSource(Object source) throws Exception {
        AudioFormat af;
        DataLine.Info info;
        this.close();
        InputStream is = null;
        AudioFileFormat m_audioFileFormat = null;
        if (source instanceof ExtendedByteArrayInputStream) {
            is = this.checkInputStream((InputStream)source, ((ExtendedByteArrayInputStream)source).getName());
        } else if (source instanceof InputStream) {
            is = this.checkInputStream((InputStream)source, null);
        } else if (source instanceof File) {
            is = this.checkInputStream(new FileInputStream((File)source), ((File)source).getName());
        } else {
            URL url = null;
            if (source instanceof URL) {
                url = (URL)source;
            } else if (source instanceof String) {
                url = new URL((String)source);
            }
            if (url != null) {
                is = this.checkInputStream(url.openStream(), source.toString());
            }
        }
        if (is != null) {
            if (this.isMpeg || !this.isWav && !this.isOgg) {
                try {
                    m_audioFileFormat = AppletMpegSPIWorkaround.getAudioFileFormat(is);
                    this.ais = AppletMpegSPIWorkaround.getAudioInputStream(is);
                    this.isMpeg = true;
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (UnsupportedAudioFileException ex) {
                    this.isMpeg = false;
                }
            }
            if (this.isOgg || !this.isMpeg && !this.isWav) {
                try {
                    m_audioFileFormat = AppletVorbisSPIWorkaround.getAudioFileFormat(is);
                    this.ais = AppletVorbisSPIWorkaround.getAudioInputStream(is);
                    this.isOgg = true;
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (UnsupportedAudioFileException ex) {
                    this.isOgg = false;
                }
            }
            if (this.isWav || !this.isMpeg && !this.isOgg) {
                m_audioFileFormat = AudioSystem.getAudioFileFormat(is);
                this.ais = AudioSystem.getAudioInputStream(is);
            }
        }
        if (this.ais != null && !AudioSystem.isLineSupported(info = new DataLine.Info(SourceDataLine.class, af = this.ais.getFormat(), 1024))) {
            AudioFormat sourceFormat = af;
            AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceFormat.getSampleRate(), 16, sourceFormat.getChannels(), sourceFormat.getChannels() * 2, sourceFormat.getSampleRate(), true);
            this.ais = this.isMpeg ? AppletMpegSPIWorkaround.getAudioInputStream(targetFormat, this.ais) : (this.isOgg ? AppletVorbisSPIWorkaround.getAudioInputStream(targetFormat, this.ais) : AudioSystem.getAudioInputStream(targetFormat, this.ais));
        }
        return this.ais != null;
    }

    public Clip getClip() throws Exception {
        if (this.clip == null && this.ais != null) {
            this.clip = (Clip)AudioSystem.getLine(new DataLine.Info(Clip.class, this.ais.getFormat(), 1024));
        }
        return this.clip;
    }

    @Override
    public void realize(String fileName, MediaBag mediaBag) throws Exception {
        if (fileName != null) {
            this.setDataSource(mediaBag.getMediaDataSource(fileName));
        }
        if (this.ais != null && this.getClip() != null) {
            this.clip.open(this.ais);
        }
    }

    @Override
    public void close() {
        if (this.clip != null && this.clip.isOpen()) {
            if (this.clip.isRunning()) {
                this.clip.stop();
            }
            this.clip.close();
        }
        this.clip = null;
        this.ais = null;
    }

    @Override
    public void play() {
        try {
            this.stop();
            if (this.getClip() != null) {
                this.clip.setFramePosition(0);
                this.clip.start();
            }
        }
        catch (Exception ex) {
            System.err.println("Error playing sound:\n" + ex);
        }
    }

    @Override
    public void stop() {
        if (this.clip != null && this.clip.isActive()) {
            this.clip.stop();
        }
    }

    protected InputStream checkInputStream(InputStream is, String name) throws Exception {
        String s;
        String string = s = name == null ? null : name.toLowerCase();
        if (s != null) {
            if (s.endsWith(".wav")) {
                this.isWav = true;
            } else if (s.endsWith(".ogg")) {
                this.isOgg = true;
            } else if (s.endsWith(".mp3")) {
                this.isMpeg = true;
            }
        }
        if (s == null || this.isWav) {
            if (!is.markSupported()) {
                byte[] data = StreamIO.readInputStream(is);
                is = new ByteArrayInputStream(data);
            }
            is.mark(96);
            byte[] b = new byte[96];
            is.read(b);
            is.reset();
            if (b[0] == 82 && b[1] == 73 && b[2] == 70 && b[3] == 70 && b[8] == 87 && b[9] == 65 && b[10] == 86 && b[11] == 69 && b[12] == 102 && b[13] == 109 && b[14] == 116 && b[15] == 32 && b[20] == 85 && b[21] == 0) {
                for (int p = 17; p < 90; ++p) {
                    if (b[p] != 100 || b[p + 1] != 97 || b[p + 2] != 116 || b[p + 3] != 97) continue;
                    int offset = p + 4 + 4;
                    is.skip(offset);
                    this.isWav = false;
                    this.isMpeg = true;
                    break;
                }
            }
        }
        return is;
    }
}

