/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.util.ExtendedByteArrayInputStream;
import edu.xtec.util.StreamIO;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.media.Duration;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class ByteDataSource
extends PullDataSource {
    protected ByteSourceStream[] pss = new ByteSourceStream[1];
    protected ContentDescriptor contentType;
    protected String fName;
    static Method getMimeTypeMethod;

    public ByteDataSource(ExtendedByteArrayInputStream is) throws IOException {
        this.init(is);
    }

    public ByteDataSource(InputStream is, String name) throws IOException {
        if (is instanceof ExtendedByteArrayInputStream) {
            this.init((ExtendedByteArrayInputStream)is);
        } else {
            this.init(new ExtendedByteArrayInputStream(StreamIO.readInputStream(is), name));
        }
    }

    public ByteDataSource(byte[] src, String name) throws IOException {
        this.init(new ExtendedByteArrayInputStream(src, name));
    }

    private void init(ExtendedByteArrayInputStream is) throws IOException {
        this.contentType = this.getContentDescriptor(is.getName());
        this.pss[0] = new ByteSourceStream(is, this.contentType);
        this.fName = null;
    }

    private ByteDataSource() {
    }

    public ByteDataSource duplicate() throws IOException {
        ByteDataSource result = new ByteDataSource();
        result.contentType = this.contentType;
        result.fName = this.fName;
        result.pss[0] = this.pss[0].duplicate();
        return result;
    }

    public ExtendedByteArrayInputStream getInputStream() {
        if (this.pss[0] != null) {
            return this.pss[0].inputStream;
        }
        return null;
    }

    public String getFName() {
        return this.fName;
    }

    public void setFName(String name) {
        this.fName = name;
    }

    public Object[] getControls() {
        return null;
    }

    public void connect() throws IOException {
    }

    public void disconnect() {
    }

    public void start() throws IOException {
    }

    public Time getDuration() {
        return Duration.DURATION_UNKNOWN;
    }

    public void stop() throws IOException {
    }

    public Object getControl(String str) {
        return null;
    }

    public String getContentType() {
        return this.contentType.toString();
    }

    public PullSourceStream[] getStreams() {
        return this.pss;
    }

    public ContentDescriptor getContentDescriptor(String fName) {
        String mimeType = null;
        if (fName != null) {
            int p = fName.lastIndexOf(46) + 1;
            String ext = (p > 0 && p < fName.length() ? fName.substring(p) : fName).toLowerCase();
            if (getMimeTypeMethod != null) {
                try {
                    mimeType = (String)getMimeTypeMethod.invoke(null, ext);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (mimeType == null) {
            mimeType = "unknown";
        }
        return new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName((String)mimeType));
    }

    static {
        try {
            Class<?> cl = null;
            if (ByteDataSource.class.getResource("/com/sun/media/MimeManager.class") != null && (cl = Class.forName("com.sun.media.MimeManager")) != null) {
                getMimeTypeMethod = cl.getMethod("getMimeType", String.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class ByteSourceStream
    implements PullSourceStream,
    Seekable {
        protected ExtendedByteArrayInputStream inputStream;
        ContentDescriptor contentType;

        public ByteSourceStream(ExtendedByteArrayInputStream in, ContentDescriptor type) throws IOException {
            this.inputStream = in;
            this.contentType = type;
        }

        public ByteSourceStream duplicate() throws IOException {
            return new ByteSourceStream(this.inputStream.duplicate(), this.contentType);
        }

        public ContentDescriptor getContentDescriptor() {
            return this.contentType;
        }

        public long getContentLength() {
            return this.inputStream.getCount();
        }

        public boolean willReadBlock() {
            return this.inputStream.eosReached();
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            return this.inputStream.read(buffer, offset, length);
        }

        public void close() throws IOException {
            this.inputStream.close();
        }

        public boolean endOfStream() {
            return this.inputStream.eosReached();
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String controlName) {
            return null;
        }

        public boolean isRandomAccess() {
            return true;
        }

        public long seek(long param) {
            try {
                return this.inputStream.seek(param);
            }
            catch (Exception ex) {
                return 0L;
            }
        }

        public long tell() {
            return this.inputStream.getPos();
        }
    }
}

