/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.fileSystem;

import edu.xtec.jclic.fileSystem.PCCFileSystem;
import edu.xtec.jclic.fileSystem.ZipFileSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.util.ExtendedByteArrayInputStream;
import edu.xtec.util.FileChooserForFiles;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.SimpleFileFilter;
import edu.xtec.util.StrUtils;
import edu.xtec.util.StreamIO;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;

public class FileSystem {
    public static final String FS = "/";
    public static final String WINFS = "\\";
    public static final char FSCH = '/';
    public static final char WINFSCH = '\\';
    protected static FileChooserForFiles fileChooser;
    private static final String FS_BAK = "/..";
    public static HashMap<String, String> altFileNames;
    public String root;
    protected boolean isURL = false;
    protected Boolean ISURL = this.isURL;
    protected ResourceBridge rb = null;
    private static final String FNAME_VALID_CHARS = "_-.0123456789abcdefghijklmnopqrstuvwxyz";
    public static final String FNAME_CONVERTIBLE_CHARS = "\u00e1\u00e0\u00e4\u00e2\u00e3\u00e9\u00e8\u00eb\u00ea\u00ed\u00ec\u00ef\u00ee\u00f3\u00f2\u00f6\u00f4\u00f5\u00fa\u00f9\u00fc\u00fb\u00f1\u00e7\u20ac\u00ba\u00aa\u00e5\u00e6\u00f8\u00fd\u00fe\u00ff\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c2\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9";
    private static final String FNAME_EQUIVALENT_CHARS = "aaaaaeeeeiiiiooooouuuunceoaaaoypyabgdezhtjklmnkoprsstufxpo";

    public FileSystem(ResourceBridge rb) {
        this.root = "";
        this.rb = rb;
    }

    public FileSystem(String rootPath, ResourceBridge rb) {
        this.root = FileSystem.stdFn(rootPath);
        this.rb = rb;
        if (this.root == null) {
            this.root = "";
        }
        if (this.root.length() > 0) {
            if (FileSystem.isStrUrl(this.root)) {
                this.isURL = true;
                this.ISURL = this.isURL;
                if (!this.root.endsWith(FS)) {
                    this.root = this.root + FS;
                }
                this.root = this.getCanonicalNameOf(this.root);
            } else {
                File f = new File(FileSystem.sysFn(this.root));
                String saveRoot = this.root;
                try {
                    this.root = FileSystem.stdFn(f.getCanonicalPath());
                }
                catch (Exception e) {
                    this.root = saveRoot;
                }
                if (!this.root.endsWith(FS)) {
                    this.root = this.root + FS;
                }
            }
        }
    }

    public FileSystem duplicate() throws Exception {
        return FileSystem.createFileSystem(this.root, this.rb);
    }

    protected void changeBase(String newRoot, String newFileName) throws Exception {
        File f = new File(FileSystem.sysFn(newRoot));
        String saveRoot = this.root;
        try {
            this.root = FileSystem.stdFn(f.getCanonicalPath());
        }
        catch (Exception e) {
            this.root = saveRoot;
        }
        if (!this.root.endsWith(FS)) {
            this.root = this.root + FS;
        }
    }

    public static String stdFn(String s) {
        return s == null ? s : s.replace('\\', '/');
    }

    public static String sysFn(String s) {
        String result = s;
        if (result != null && (result = FileSystem.stdFn(result).replace('/', File.separatorChar)).indexOf("%20") >= 0) {
            result = StrUtils.replace(result, "%20", " ");
        }
        return result;
    }

    public static FileSystem createFileSystem(String rootPath, String fileName, ResourceBridge rb) throws Exception {
        if (fileName == null) {
            return new FileSystem(rootPath, rb);
        }
        if (fileName.endsWith(".pcc")) {
            return PCCFileSystem.createPCCFileSystem(rootPath, fileName, rb);
        }
        if (fileName.endsWith(".zip")) {
            return ZipFileSystem.createZipFileSystem(rootPath, fileName, rb);
        }
        throw new Exception("unknown format " + fileName);
    }

    public static FileSystem createFileSystem(String fullPath, ResourceBridge rb) throws Exception {
        fullPath = FileSystem.getCanonicalNameOf(fullPath, null);
        String fileName = null;
        String rootPath = FileSystem.getPathPartOf(fullPath);
        if (fullPath.endsWith(".pcc") || fullPath.endsWith(".zip")) {
            fileName = FileSystem.getFileNameOf(fullPath);
        }
        return FileSystem.createFileSystem(rootPath, fileName, rb);
    }

    public String getFullFileNamePath(String fName) {
        if (fName == null || fName.length() == 0) {
            return this.root.length() > 0 ? this.root.substring(0, this.root.length() - 1) : this.root;
        }
        String result = this.getCanonicalNameOf(fName);
        if (!this.isURL) {
            File f = new File(FileSystem.sysFn(result));
            if (!f.isAbsolute()) {
                result = this.getCanonicalNameOf(this.root + result);
            }
        } else if (!FileSystem.isStrUrl(result)) {
            result = this.getCanonicalNameOf(this.root + result);
        }
        return result;
    }

    public String getRelativeFileNamePath(String fName) {
        String s = FileSystem.stdFn(fName);
        if (s == null || s.length() < this.root.length() || !s.substring(0, this.root.length()).equalsIgnoreCase(this.root)) {
            return s;
        }
        return s.substring(this.root.length());
    }

    public String getFullRoot() {
        return this.root;
    }

    public boolean isUrlBased() {
        return this.isURL;
    }

    public static boolean isStrUrl(String s) {
        return s != null && (s.startsWith("http:") || s.startsWith("https:") || s.startsWith("ftp:") || s.startsWith("mailto:"));
    }

    public String getUrl(String fileName) {
        String s = FileSystem.stdFn(fileName);
        if (s == null || FileSystem.isStrUrl(s) || s.startsWith("file:")) {
            return s;
        }
        if (s.charAt(1) != ':' && !s.startsWith(FS)) {
            s = this.getFullFileNamePath(s);
        }
        if (this.isURL) {
            return FileSystem.getCanonicalNameOf(s, this.ISURL);
        }
        return "file://" + FileSystem.sysFn(FileSystem.getCanonicalNameOf(s, this.ISURL));
    }

    public String getCanonicalNameOf(String fileName) {
        return FileSystem.getCanonicalNameOf(fileName, this.ISURL);
    }

    public static String getCanonicalNameOf(String fileName, Boolean isUrl) {
        int r;
        String fn = FileSystem.stdFn(fileName);
        boolean flagUrl = isUrl != null ? isUrl : FileSystem.isStrUrl(fn);
        String prefix = "";
        int cut = -1;
        if (fn.startsWith("file:")) {
            fn = fn.substring(5);
        }
        if (FileSystem.isStrUrl(fn)) {
            int k = fn.indexOf(64);
            if (k < 0) {
                k = 7;
            }
            cut = fn.indexOf(47, k);
        } else if (fn.length() > 2 && fn.charAt(1) == ':') {
            cut = fn.charAt(2) == '/' ? 2 : 1;
        } else if (fn.startsWith("//")) {
            int i = fn.indexOf(47, 2);
            cut = fn.indexOf(47, i + 1);
        } else if (fn.startsWith(FS)) {
            cut = 0;
        }
        if (cut >= 0) {
            prefix = fn.substring(0, cut + 1);
            fn = fn.substring(cut + 1);
        }
        while ((r = fn.indexOf(FS_BAK)) >= 0) {
            int p;
            for (p = r - 1; p >= 0 && fn.charAt(p) != '/'; --p) {
            }
            StringBuilder newfn = new StringBuilder();
            if (p >= 0) {
                newfn.append(fn.substring(0, p + 1));
            }
            if (r + 4 < fn.length()) {
                newfn.append(fn.substring(r + 4));
            }
            fn = newfn.substring(0);
        }
        return prefix + fn;
    }

    public static String getPathPartOf(String fullPath) {
        String s = FileSystem.stdFn(fullPath);
        int i = s.lastIndexOf(FS);
        return i < 0 ? "" : s.substring(0, i + 1);
    }

    public static String getFileNameOf(String fullPath) {
        String s = FileSystem.stdFn(fullPath);
        int i = s.lastIndexOf(FS);
        return i < 0 ? s : s.substring(i + 1);
    }

    public byte[] getBytes(String fileName) throws IOException {
        return StreamIO.readInputStream(this.getInputStream(fileName));
    }

    public Image getImageFile(String fName) throws Exception {
        return Toolkit.getDefaultToolkit().createImage(this.getBytes(fName));
    }

    public long getFileLength(String fName) throws IOException {
        long length;
        if (this.isURL) {
            URL url = new URL(this.getFullFileNamePath(fName).replace(" ", "%20"));
            URLConnection c = url.openConnection();
            length = c.getContentLength();
        } else {
            File f = new File(FileSystem.sysFn(this.getFullFileNamePath(fName)));
            length = f.length();
        }
        return length;
    }

    public boolean fileExists(String fName) {
        boolean result;
        try {
            if (this.isURL) {
                URL url = new URL(this.getFullFileNamePath(fName).replace(" ", "%20"));
                URLConnection c = url.openConnection();
                result = c.getContentLength() > 0;
            } else {
                File f = new File(FileSystem.sysFn(this.getFullFileNamePath(fName)));
                result = f.exists();
            }
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public boolean realFileExists(String fName) {
        return this.fileExists(fName);
    }

    public InputStream getInputStream(String fName) throws IOException {
        InputStream result;
        int length;
        if (this.isURL) {
            HttpURLConnection hc;
            int status;
            URL url = new URL(this.getFullFileNamePath(fName).replace(" ", "%20"));
            URLConnection c = url.openConnection();
            if (c instanceof HttpURLConnection && (status = (hc = (HttpURLConnection)c).getResponseCode()) != 200) {
                if (status < 300 || status > 308) {
                    throw new FileNotFoundException("HTTP error " + status + ": " + hc.getResponseMessage());
                }
                String redirectLocation = hc.getHeaderField("Location");
                if (redirectLocation == null || redirectLocation.trim().length() == 0) {
                    throw new UnknownServiceException("Redirect without 'Location'");
                }
                if (this.root.startsWith("http:") && redirectLocation.startsWith("https:")) {
                    this.root = "https:" + this.root.substring(5);
                }
                url = new URL(redirectLocation);
                c = url.openConnection();
            }
            length = c.getContentLength();
            result = c.getInputStream();
        } else {
            String alt;
            File f = new File(FileSystem.sysFn(this.getFullFileNamePath(fName)));
            if (!f.exists() && (alt = altFileNames.get(fName)) != null) {
                f = new File(FileSystem.sysFn(this.getFullFileNamePath(alt)));
            }
            length = (int)f.length();
            result = new FileInputStream(f);
        }
        if (result != null && this.rb != null) {
            result = this.rb.getProgressInputStream(result, length, fName);
        }
        return result;
    }

    public Object getMediaDataSource(String fName) throws Exception {
        if (this.isURL) {
            return this.getExtendedByteArrayInputStream(fName);
        }
        return new StringBuilder("file:").append(this.getFullFileNamePath(fName)).substring(0);
    }

    public ExtendedByteArrayInputStream getExtendedByteArrayInputStream(String fName) throws Exception {
        return new ExtendedByteArrayInputStream(this.getBytes(fName), fName);
    }

    public static Document getXMLDocument(InputStream is) throws Exception {
        Document doc = JDomUtility.getSAXBuilder().build(is);
        JDomUtility.clearNewLineElements(doc.getRootElement());
        return doc;
    }

    public Document getXMLDocument(String fName) throws Exception {
        Document doc = this.buildDoc(fName, JDomUtility.getSAXBuilder());
        JDomUtility.clearNewLineElements(doc.getRootElement());
        return doc;
    }

    protected Document buildDoc(String fName, SAXBuilder builder) throws Exception {
        return builder.build(this.getInputStream(fName));
    }

    public void close() {
    }

    protected void open() throws Exception {
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public static FileChooserForFiles getFileChooser(String root) {
        if (fileChooser == null) {
            fileChooser = new FileChooserForFiles();
            if (root != null) {
                fileChooser.setCurrentDirectory(new File(FileSystem.sysFn(root)));
            }
        }
        return fileChooser;
    }

    public String chooseFile(String defaultValue, boolean save, int[] filters, Options options, String titleKey, Component dlgOwner, boolean proposeMove) {
        String result = null;
        String[] files = this.chooseFiles(defaultValue, save, filters, options, titleKey, dlgOwner, proposeMove, false);
        if (files != null && files.length > 0) {
            result = files[0];
        }
        return result;
    }

    public String[] chooseFiles(String defaultValue, boolean save, int[] filters, Options options, String titleKey, Component dlgOwner, boolean proposeMove, boolean multiSelection) {
        String[] result;
        block22: {
            Messages msg;
            block23: {
                block24: {
                    result = null;
                    if (save) {
                        multiSelection = false;
                    }
                    if (options == null) break block22;
                    msg = options.getMessages();
                    if (!this.isURL) break block23;
                    if (!save) break block24;
                    msg.showErrorWarning(dlgOwner, "filesystem_saveURLerror", null);
                    break block22;
                }
                String s = msg.showInputDlg(dlgOwner, "filesystem_enterURL", "URL", "http://", titleKey != null ? titleKey : "filesystem_openURL", false);
                if (s == null) break block22;
                result = new String[]{s};
                break block22;
            }
            FileChooserForFiles chooser = FileSystem.getFileChooser(this.root);
            if (chooser != null) {
                chooser.setApproveButtonToolTipText(msg.get(save ? "FILE_SAVE_TOOLTIP" : "FILE_OPEN_TOOLTIP"));
                chooser.setDialogType(save ? 1 : 0);
                chooser.setApproveButtonText(msg.get(save ? "SAVE" : "OPEN"));
                chooser.setMultiSelectionEnabled(multiSelection);
                chooser.setDialogTitle(msg.get(titleKey != null ? titleKey : (save ? "FILE_SAVE" : "FILE_OPEN")));
                chooser.resetChoosableFileFilters();
                if (filters != null) {
                    chooser.setAcceptAllFileFilterUsed(false);
                    for (int i = 0; i < filters.length; ++i) {
                        if (i == filters.length - 1) {
                            chooser.setFileFilter(Utils.getFileFilter(filters[i], msg));
                            continue;
                        }
                        chooser.addChoosableFileFilter(Utils.getFileFilter(filters[i], msg));
                    }
                } else {
                    chooser.setAcceptAllFileFilterUsed(true);
                }
                String s = StrUtils.nullableString(defaultValue);
                boolean dummyFile = false;
                if (s == null) {
                    s = ".";
                    dummyFile = true;
                }
                chooser.directSetSelectedFile(new File(FileSystem.sysFn(this.getFullFileNamePath(s))));
                if (dummyFile) {
                    chooser.directSetSelectedFile(null);
                }
                boolean done = false;
                block3: while (!done) {
                    int retVal = save ? chooser.showSaveDialog(dlgOwner) : chooser.showOpenDialog(dlgOwner);
                    if (retVal == 0) {
                        File[] fileArray;
                        if (multiSelection) {
                            fileArray = chooser.getSelectedFiles();
                        } else {
                            File[] fileArray2 = new File[1];
                            fileArray = fileArray2;
                            fileArray2[0] = chooser.getSelectedFile();
                        }
                        File[] files = fileArray;
                        result = new String[files.length];
                        for (int i = 0; i < files.length; ++i) {
                            File f = files[i].getAbsoluteFile();
                            result[i] = this.getRelativeFileNamePath(FileSystem.stdFn(f.getAbsolutePath()));
                            if (save) {
                                javax.swing.filechooser.FileFilter filter = chooser.getFileFilter();
                                if (filter instanceof SimpleFileFilter) {
                                    f = ((SimpleFileFilter)filter).checkFileExtension(f);
                                    result[i] = this.getRelativeFileNamePath(FileSystem.stdFn(f.getAbsolutePath()));
                                }
                                done = msg.confirmOverwriteFile(dlgOwner, f, "yn") == 1;
                            } else {
                                String name;
                                File destFile;
                                done = msg.confirmReadableFile(dlgOwner, f);
                                if (done && proposeMove && this.root.length() > 0 && result[i].indexOf(FS) >= 0 && msg.showQuestionDlgObj(dlgOwner, new String[]{msg.get("filesystem_copyToRoot_1") + " " + result[i], msg.get("filesystem_copyToRoot_2"), msg.get("filesystem_copyToRoot_3"), msg.get("filesystem_copyToRoot_4")}, "CONFIRM", "yn") == 1 && msg.confirmOverwriteFile(dlgOwner, destFile = new File(FileSystem.sysFn(this.getFullFileNamePath(name = FileSystem.stdFn(f.getName())))), "yn") == 1) {
                                    try {
                                        FileOutputStream os = this.createSecureFileOutputStream(name, false);
                                        InputStream is = this.getInputStream(result[i]);
                                        if (StreamIO.writeStreamDlg(is, os, (int)f.length(), msg.get("filesystem_copyFile"), dlgOwner, options)) {
                                            result[i] = name;
                                        } else if (destFile.exists()) {
                                            destFile.delete();
                                        }
                                    }
                                    catch (Exception ex) {
                                        msg.showErrorWarning(dlgOwner, "ERROR", ex);
                                    }
                                }
                            }
                            if (!done) continue block3;
                        }
                        continue;
                    }
                    result = null;
                    done = true;
                }
            }
        }
        return result;
    }

    public FileOutputStream createSecureFileOutputStream(String fileName, boolean isZip) throws IOException {
        File file = new File(FileSystem.sysFn(this.getFullFileNamePath(fileName)));
        file.getParentFile().mkdirs();
        File tmp = File.createTempFile("tmp", ".tmp", file.getParentFile());
        SecureFileOutputStream result = new SecureFileOutputStream(tmp, file, isZip);
        return result;
    }

    public static void exploreFiles(String prefix, File f, List<String> v, char pathSep, FileFilter filter, int maxRecursion, int maxFiles) {
        File[] files = filter == null ? f.listFiles() : f.listFiles(filter);
        StringBuilder sb = new StringBuilder();
        for (File file : files) {
            sb.setLength(0);
            if (file.isDirectory()) {
                if (maxRecursion != 0) {
                    if (prefix != null) {
                        sb.append(prefix);
                    }
                    sb.append(file.getName()).append(pathSep);
                    FileSystem.exploreFiles(sb.substring(0), file, v, pathSep, filter, maxRecursion - 1, maxFiles);
                }
            } else {
                if (prefix != null) {
                    sb.append(prefix);
                }
                v.add(sb.append(file.getName()).substring(0));
            }
            if (maxFiles > 0 && v.size() >= maxFiles) break;
        }
    }

    public static String getValidFileName(String fn) {
        String result = null;
        if (fn != null) {
            StringBuilder sb = new StringBuilder();
            for (int n : fn.toCharArray()) {
                if (FNAME_VALID_CHARS.indexOf(n = Character.toLowerCase((char)n)) < 0) {
                    int p = FNAME_CONVERTIBLE_CHARS.indexOf(n);
                    n = p >= 0 ? (int)FNAME_EQUIVALENT_CHARS.charAt(p) : 95;
                }
                sb.append((char)n);
            }
            result = sb.substring(0);
        }
        return result;
    }

    static {
        altFileNames = new HashMap();
    }

    class SecureFileOutputStream
    extends FileOutputStream {
        boolean closed;
        boolean isZip;
        File tempFile;
        File destFile;

        private SecureFileOutputStream(File tempFile, File destFile, boolean isZip) throws FileNotFoundException {
            super(tempFile);
            this.tempFile = tempFile;
            this.destFile = destFile;
            this.isZip = isZip;
            this.closed = false;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (!this.closed) {
                this.closed = true;
                if (this.destFile != null) {
                    boolean renamed;
                    boolean isCurrentFs;
                    if (this.isZip) {
                        try {
                            ZipFile zip = new ZipFile(this.tempFile.getAbsolutePath());
                            Enumeration<? extends ZipEntry> entries = zip.entries();
                            while (entries.hasMoreElements()) {
                                ZipEntry en = entries.nextElement();
                                if (en.getName().length() >= 1 && (en.isDirectory() || en.getSize() >= 1L)) continue;
                                throw new IOException("ZIP file has invalid entries!");
                            }
                            zip.close();
                        }
                        catch (Exception ex) {
                            throw new IOException("Error writting ZIP file: " + ex.getMessage());
                        }
                    }
                    if (isCurrentFs = FileSystem.this.getFullRoot().equals(FileSystem.stdFn(this.destFile.getAbsolutePath()))) {
                        FileSystem.this.close();
                    }
                    if (this.destFile.exists()) {
                        this.destFile.delete();
                    }
                    if (!(renamed = this.tempFile.renameTo(this.destFile))) {
                        System.err.println("WARNING: Unable to rename " + this.tempFile + " to " + this.destFile.getName());
                    }
                    if (isCurrentFs) {
                        try {
                            if (!renamed) {
                                FileSystem.this.changeBase(this.tempFile.getParent(), this.tempFile.getName());
                            }
                            FileSystem.this.open();
                        }
                        catch (Exception ex) {
                            throw new IOException(ex.getMessage());
                        }
                    }
                }
            }
        }
    }
}

