/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.clic3;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.bags.ActivityBag;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.bags.ActivitySequenceJump;
import edu.xtec.jclic.bags.ConditionalJumpInfo;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.clic3.Clic3Pac;
import edu.xtec.jclic.clic3.TripleColor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.fileSystem.PCCFileSystem;
import edu.xtec.jclic.project.JClicProject;
import java.awt.Color;
import java.util.ArrayList;

public abstract class Clic3 {
    public static final int CLICVER = 120;
    public static final String CLICSTR = "CLIC120";
    protected static final String BLANK = "";
    protected static final String COMMA = ",";
    protected static final Color DEFAULT_BACK_COLOR = new Color(192, 192, 192);
    protected static final Color DEFAULT_COLOR_USUARI_0 = Color.blue;
    protected static final Color DEFAULT_COLOR_USUARI_1 = DEFAULT_BACK_COLOR;
    protected static final Color DEFAULT_COLOR_ERROR_0 = Color.white;
    protected static final Color DEFAULT_COLOR_ERROR_1 = Color.red;
    protected static final TripleColor DEFAULT_TRIPLE_COLOR = new TripleColor(Color.white, Color.black, Color.gray, false);
    public static final String[] extName = new String[]{"*.BMP", "*.GIF", "*.TXT", "*.PUZ", "*.SOP", "*.ASS", "*.CRW", "*.TXA", "*.PAC", "*.PCC", "*.P?C", "*.HLP", "*.MVB", "*.EXE", "*.MID", "*.WAV", "*.JPG", "*.PNG", ""};
    public static final int EXT_BMP = 0;
    public static final int EXT_GIF = 1;
    public static final int EXT_TXT = 2;
    public static final int EXT_PUZ = 3;
    public static final int EXT_SOP = 4;
    public static final int EXT_ASS = 5;
    public static final int EXT_CRW = 6;
    public static final int EXT_TXA = 7;
    public static final int EXT_PAC = 8;
    public static final int EXT_PCC = 9;
    public static final int EXT_PCG = 10;
    public static final int EXT_HLP = 11;
    public static final int EXT_MVB = 12;
    public static final int EXT_EXE = 13;
    public static final int EXT_MID = 14;
    public static final int EXT_WAV = 15;
    public static final int EXT_JPG = 16;
    public static final int EXT_PNG = 17;
    public static final int UNKNOWN_EXT = 18;
    public static final int NO_EXT = -1;
    protected static final int MAXCW = 20;
    protected static final int MAXCH = 20;
    protected static final int MAXGW = 21;
    protected static final int MAXGH = 10;
    public static final int NONE = 0;
    public static final int PUZZLE = 1;
    public static final int SOPA = 2;
    public static final int ASSOCIA = 3;
    public static final int CREUATS = 4;
    public static final int TEXTACT = 5;
    public static final int INTERC = 0;
    public static final int FORAT = 1;
    public static final int DOBLE = 2;
    public static final int MEMORY = 3;
    public static final int NORMAL = 0;
    public static final int ESPECIAL = 1;
    public static final int EXPLORA = 2;
    public static final int INFO = 3;
    public static final int IDENTIFICA = 4;
    public static final int ESCRIU = 5;
    public static final int FORATS = 0;
    public static final int COMPTEXT = 1;
    public static final int IDLLETRES = 2;
    public static final int IDPARAULES = 3;
    public static final int BPARAULES = 4;
    public static final int BPARAGRAFS = 5;
    public static final int AB = 0;
    public static final int BA = 1;
    public static final int AUB = 2;
    public static final int BUA = 3;
    public static final int DEF_TXTCASW = 140;
    public static final int DEF_TXTCASH = 100;
    public static final int DEF_CICLES = 30;
    public static final int NEGRE = 160;
    public static final char COMODI = '*';
    public static final char SEPARADOR = ';';
    public static final byte ENDDESC_BYTE = -121;
    public static final char ENDDESC = '\u2021';
    public static final char CHBLOCK = '\u008e';
    public static final char CHINC = '\u008f';
    public static final char SEP = '\u0090';
    private static final String[] strArray = new String[]{"FFFFFF", "000000", "808080", "C0C0C0", "0000FF", "00FF00", "FF0000"};
    private static final Color[] colorArray = new Color[]{Color.white, Color.black, Color.gray, DEFAULT_BACK_COLOR, Color.red, Color.green, Color.blue};
    private static int gcCounter = 0;
    public static final String ansiChars = "\u20ac\u0081\u201a\u0192\u201e\u2026\u2020\u2021\u02c6\u2030\u0160\u2039\u0152\u008d\u008e\u008f\u0090\u2018\u2019\u201c\u201d\u2022\u2013\u2014\u02dc\u2122\u0161\u203a\u0153\u009d\u009e\u0178";
    public static final String convertFileChars = "e__f______s_c_z__________ts_o_zy_icl_y_s_ca___r_o_23__p__10_423_aaaaaaaceeeeiiiidnooooox0uuuuy_baaaaaaaceeeeiiiionooooo_0uuuuy_y";
    public static final String validFileChars = ".:\\_!~0123456789abcdefghijklmnopqrstuvwxyz";

    public static int getExt(String fileName) {
        int i;
        if (fileName == null || fileName.length() == 0) {
            return 18;
        }
        int begExt = fileName.indexOf(32);
        if (begExt < 0) {
            begExt = fileName.length() - 1;
        }
        while (begExt > 0 && fileName.charAt(begExt) != '.') {
            --begExt;
        }
        if (begExt == 0 || fileName.length() - begExt < 4) {
            return 18;
        }
        String ext = "*" + fileName.substring(begExt, begExt + 4).toUpperCase();
        for (i = 0; i < 18 && !ext.equals(extName[i]); ++i) {
        }
        if (i == 16 || i == 17) {
            i = 1;
        }
        return i;
    }

    public static boolean isClic3Extension(int ext) {
        return ext == 3 || ext == 5 || ext == 4 || ext == 6 || ext == 7;
    }

    public static int parseIntX(String s) {
        return Clic3.parseIntX(s, 10);
    }

    public static int parseIntX(String s, int radix) {
        int v;
        try {
            v = Integer.parseInt(s, radix);
        }
        catch (NumberFormatException e) {
            v = 0;
        }
        return v;
    }

    protected static int correctColor(int color) {
        return (color & 0xFF) << 16 | color & 0xFF00 | (color & 0xFF0000) >> 16;
    }

    protected static Color strToColor(String st) {
        if (st == null) {
            return Color.black;
        }
        if (st.length() > 6) {
            st = st.substring(st.length() - 6);
        }
        for (int i = 0; i < strArray.length; ++i) {
            if (!st.equals(strArray[i])) continue;
            return colorArray[i];
        }
        return new Color(Clic3.correctColor(Clic3.parseIntX(st, 16)));
    }

    public static boolean copyArray(String[] dest, int indest, String[] source, int insource, int e, boolean upper) {
        int i = 0;
        int d = indest;
        int s = insource;
        while (i < e && (dest[d] = source[s]) != null) {
            if (upper) {
                dest[d] = dest[d].toUpperCase();
            }
            ++i;
            ++d;
            ++s;
        }
        return i == e;
    }

    public static void readPccFile(JClicProject project) throws Exception {
        if (!(project.getFileSystem() instanceof PCCFileSystem)) {
            throw new Exception("FileSystem is not PCCFileSystem!");
        }
        PCCFileSystem pccfs = (PCCFileSystem)project.getFileSystem();
        block4: for (int i = 0; i < pccfs.numFiles; ++i) {
            String name = pccfs.getEntryName(i);
            switch (Clic3.getExt(name)) {
                case 8: {
                    Clic3.addPacToSequence(project, name);
                    continue block4;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    Clic3.addActivityToBag(project, name);
                    continue block4;
                }
            }
        }
    }

    public static void addActivityToBag(JClicProject project, String name) throws Exception {
        ActivityBag ab = project.activityBag;
        String normalizedName = FileSystem.stdFn(name);
        if (ab.getElementByName(normalizedName) != null) {
            return;
        }
        Clic3Activity c3a = new Clic3Activity(project);
        try {
            c3a.load(normalizedName, project.getFileSystem().getBytes(normalizedName));
        }
        catch (Exception e) {
            System.err.println("Error loading " + normalizedName + "\n" + e);
            throw e;
        }
        switch (c3a.actMode) {
            case 3: {
                switch (c3a.puzMode) {
                    case 3: {
                        c3a.className = "edu.xtec.jclic.activities.panels.InformationScreen";
                        break;
                    }
                    case 0: {
                        c3a.className = "edu.xtec.jclic.activities.associations.SimpleAssociation";
                        break;
                    }
                    case 1: {
                        c3a.className = "edu.xtec.jclic.activities.associations.ComplexAssociation";
                        break;
                    }
                    case 4: {
                        c3a.className = "edu.xtec.jclic.activities.panels.Identify";
                        break;
                    }
                    case 2: {
                        c3a.className = "edu.xtec.jclic.activities.panels.Explore";
                        break;
                    }
                    case 5: {
                        c3a.className = "edu.xtec.jclic.activities.text.WrittenAnswer";
                    }
                }
                break;
            }
            case 1: {
                switch (c3a.puzMode) {
                    case 0: {
                        c3a.className = "edu.xtec.jclic.activities.puzzles.ExchangePuzzle";
                        break;
                    }
                    case 2: {
                        c3a.className = "edu.xtec.jclic.activities.puzzles.DoublePuzzle";
                        break;
                    }
                    case 3: {
                        c3a.className = "edu.xtec.jclic.activities.memory.MemoryGame";
                        break;
                    }
                    case 1: {
                        c3a.className = "edu.xtec.jclic.activities.puzzles.HolePuzzle";
                    }
                }
                break;
            }
            case 2: {
                c3a.className = "edu.xtec.jclic.activities.textGrid.WordSearch";
                break;
            }
            case 4: {
                c3a.className = "edu.xtec.jclic.activities.textGrid.CrossWord";
                break;
            }
            case 5: {
                switch (c3a.puzMode) {
                    case 0: {
                        c3a.className = "edu.xtec.jclic.activities.text.FillInBlanks";
                        break;
                    }
                    case 1: {
                        c3a.className = "edu.xtec.jclic.activities.text.Complete";
                        break;
                    }
                    case 2: 
                    case 3: {
                        c3a.className = "edu.xtec.jclic.activities.text.Identify";
                        break;
                    }
                    case 4: 
                    case 5: {
                        c3a.className = "edu.xtec.jclic.activities.text.Order";
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Clic3 activity!");
            }
        }
        ab.addActivity(Activity.getActivity(c3a, project));
        project.mediaBag.clearData();
        if (++gcCounter % 50 == 0) {
            System.gc();
        }
    }

    public static void addPacToSequence(JClicProject project, String name) throws Exception {
        String normalizedName = FileSystem.stdFn(name);
        if (project.activitySequence.getElementByTag(normalizedName, false) != null) {
            return;
        }
        FileSystem fs = project.getFileSystem();
        Clic3Pac c3p = new Clic3Pac();
        try {
            c3p.load(normalizedName, fs.getBytes(normalizedName));
        }
        catch (Exception e) {
            System.err.println("Error loading " + normalizedName + "\n" + e);
            throw e;
        }
        for (int i = 0; i < c3p.nActs; ++i) {
            ActivitySequenceElement ase = new ActivitySequenceElement(c3p.acts[i], c3p.lapToPass, c3p.noPassButtons ? 0 : 3);
            if (i == 0) {
                ase.backJump = new ActivitySequenceJump(1);
                ase.setTag(normalizedName);
                ase.setDescription(c3p.fileDesc != null && c3p.fileDesc.length() > 0 ? c3p.fileDesc : null);
            }
            if (i == c3p.nActs - 1) {
                ActivitySequenceJump asj = new ActivitySequenceJump(1);
                if (c3p.def && c3p.chDef != null && Clic3.getExt(c3p.chDef) == 8) {
                    asj.action = 0;
                    asj.sequence = fs.getCanonicalNameOf(c3p.chDef);
                    if (c3p.sup) {
                        asj.setConditionalJump(new ConditionalJumpInfo(0, fs.getCanonicalNameOf(c3p.chSup), c3p.supP, c3p.supTFlag ? c3p.supT : -1), true);
                    }
                    if (c3p.inf) {
                        asj.setConditionalJump(new ConditionalJumpInfo(0, fs.getCanonicalNameOf(c3p.chInf), c3p.infP, c3p.infTFlag ? c3p.infT : -1), false);
                    }
                }
                ase.fwdJump = asj;
            }
            project.activitySequence.add(ase);
        }
    }

    public static String bufferToString(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            return BLANK;
        }
        char[] result = new char[buffer.length];
        for (int i = 0; i < buffer.length; ++i) {
            int v = buffer[i] & 0xFF;
            result[i] = v < 128 || v >= 160 ? (char)v : ansiChars.charAt(v - 128);
        }
        return new String(result);
    }

    public static String[] dataToArray(byte[] data) {
        String[] array;
        ArrayList<String> v = new ArrayList<String>();
        int nLines = 0;
        int l = data.length;
        int i = 0;
        int j = 0;
        while (i < l) {
            while (j < l && data[j] != 13 && data[j] != 10) {
                ++j;
            }
            int l2 = j - i;
            if (l2 > 0) {
                byte[] buffer = new byte[l2];
                for (int k = 0; k < l2; ++k) {
                    buffer[k] = data[i + k];
                }
                v.add(Clic3.bufferToString(buffer));
            } else {
                v.add(BLANK);
            }
            ++nLines;
            if (j >= l || data[++j] == 10) {
                // empty if block
            }
            i = ++j;
        }
        if (nLines > 0) {
            array = new String[nLines];
            try {
                array = v.toArray(array);
            }
            catch (ArrayStoreException e) {
                array = null;
            }
        } else {
            array = null;
        }
        return array;
    }

    public static String validFileName(String name, boolean strict, boolean remember) {
        if (name == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int n : name.toCharArray()) {
            if (validFileChars.indexOf(n, strict ? 3 : 0) < 0) {
                int k;
                n = n >= 65 && n <= 90 ? (int)Character.toLowerCase((char)n) : (n == 47 ? 92 : ((k = ansiChars.indexOf(n)) >= 0 ? (int)convertFileChars.charAt(k) : 95));
            }
            sb.append((char)n);
        }
        String result = sb.substring(0);
        if (remember && !result.equals(name)) {
            FileSystem.altFileNames.put(result, name);
        }
        return result;
    }

    public static String validFileName(String name) {
        return Clic3.validFileName(name, false, true);
    }

    public static String pacNameToLowerCase(String s) {
        String l;
        String result = s;
        if (s != null && ((l = s.toLowerCase()).endsWith(".pac") || l.endsWith(".pcc"))) {
            result = l;
        }
        return result;
    }
}

