/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.shapers.Rectangular;
import edu.xtec.jclic.shapers.Shaper;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.jdom.Element;

public class ActiveBagContent
implements Domable {
    public Image img;
    public String imgName;
    public int ncw;
    public int nch;
    public double w;
    public double h;
    public boolean border;
    public BoxBase bb;
    protected Shaper shaper;
    protected ActiveBoxContent backgroundContent;
    protected ArrayList<ActiveBoxContent> activeBoxContentArray = new ArrayList(12);
    public int defaultIdValue = -1;
    public static final String ELEMENT_NAME = "cells";
    public static final String ROWS = "rows";
    public static final String COLUMNS = "columns";
    public static final String COLS = "cols";
    public static final String CELL_WIDTH = "cellWidth";
    public static final String CELL_HEIGHT = "cellHeight";
    public static final String BORDER = "border";
    public static final String IMAGE = "image";
    public static final String IDS = "ids";

    private ActiveBagContent() {
    }

    public ActiveBagContent(int ncw, int nch) {
        this.ncw = Math.max(1, ncw);
        this.nch = Math.max(1, nch);
        this.w = 20.0;
        this.h = 20.0;
    }

    public static ActiveBagContent initNew(int ncw, int nch, int firstChar) {
        return ActiveBagContent.initNew(ncw, nch, firstChar, false, false, 50, 30);
    }

    public static ActiveBagContent initNew(int ncw, int nch, int firstChar, boolean withIds, boolean withItems, int w, int h) {
        ActiveBagContent result = new ActiveBagContent(ncw, nch);
        result.w = w;
        result.h = h;
        result.setBoxBase(new BoxBase());
        result.border = true;
        char[] ch = null;
        if (firstChar > 0) {
            ch = new char[]{(char)firstChar};
        }
        for (int i = 0; i < nch; ++i) {
            for (int j = 0; j < ncw; ++j) {
                ActiveBoxContent ab = new ActiveBoxContent();
                if (ch != null) {
                    ab.setTextContent("");
                    ch[0] = (char)(ch[0] + '\u0001');
                } else {
                    ab.setTextContent("");
                }
                if (withIds) {
                    if (withItems) {
                        ab.id = j;
                        ab.item = i;
                    } else {
                        ab.id = i * ncw + j;
                    }
                }
                result.addActiveBoxContent(ab);
            }
        }
        return result;
    }

    public void checkCells() {
        block3: {
            int existingCells;
            int shaperCells;
            block2: {
                shaperCells = this.getShaper().getNumCells();
                existingCells = this.activeBoxContentArray.size();
                if (existingCells <= shaperCells) break block2;
                while (this.activeBoxContentArray.size() > shaperCells) {
                    this.activeBoxContentArray.remove(this.activeBoxContentArray.size() - 1);
                }
                break block3;
            }
            if (shaperCells <= existingCells) break block3;
            for (int i = existingCells; i < shaperCells; ++i) {
                ActiveBoxContent ab = this.getActiveBoxContent(i);
                ab.id = this.defaultIdValue;
            }
        }
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        if (this.ncw > 0 || this.nch > 0) {
            e.setAttribute(ROWS, Integer.toString(this.nch));
            e.setAttribute(COLS, Integer.toString(this.ncw));
        }
        if (this.imgName == null && (this.w != 0.0 || this.h != 0.0)) {
            e.setAttribute(CELL_WIDTH, Double.toString(this.w));
            e.setAttribute(CELL_HEIGHT, Double.toString(this.h));
        }
        e.setAttribute(BORDER, JDomUtility.boolString(this.border));
        if (this.imgName != null) {
            e.setAttribute(IMAGE, this.imgName);
        }
        if (this.bb != null) {
            e.addContent(this.bb.getJDomElement());
        }
        if (this.shaper != null) {
            e.addContent(this.shaper.getJDomElement());
        }
        switch (this.testCellContents()) {
            case 0: {
                break;
            }
            case 1: {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
                    sb.append(this.getActiveBoxContent((int)i).id).append(" ");
                }
                e.addContent(new Element(IDS).addContent(sb.substring(0).trim()));
                break;
            }
            default: {
                for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
                    e.addContent(this.getActiveBoxContent(i).getJDomElement());
                }
            }
        }
        return e;
    }

    public int testCellContents() {
        int result = 0;
        for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
            int r = this.getActiveBoxContent(i).testCellContents();
            if (r <= result) continue;
            result = r;
            if (r > 1) break;
        }
        return result;
    }

    public static ActiveBagContent getActiveBagContent(Element e, MediaBag mediaBag) throws Exception {
        ActiveBagContent abc = new ActiveBagContent();
        abc.setProperties(e, mediaBag);
        return abc;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        int n;
        Iterator itr;
        JDomUtility.checkName(e, ELEMENT_NAME);
        MediaBag mediaBag = (MediaBag)aux;
        int k = JDomUtility.getIntAttr(e, COLS, -1);
        if (k >= 0) {
            this.ncw = k;
            this.nch = JDomUtility.getIntAttr(e, ROWS, this.nch);
        } else {
            this.ncw = JDomUtility.getIntAttr(e, ROWS, this.ncw);
            this.nch = JDomUtility.getIntAttr(e, COLUMNS, this.nch);
        }
        this.activeBoxContentArray.ensureCapacity(Math.max(12, this.ncw * this.nch));
        this.w = JDomUtility.getDoubleAttr(e, CELL_WIDTH, this.w);
        this.h = JDomUtility.getDoubleAttr(e, CELL_HEIGHT, this.h);
        this.border = JDomUtility.getBoolAttr(e, BORDER, this.border);
        this.imgName = FileSystem.stdFn(e.getAttributeValue(IMAGE));
        Element child = e.getChild("style");
        if (child != null) {
            this.setBoxBase(BoxBase.getBoxBase(child));
        }
        if ((child = e.getChild("shaper")) != null) {
            this.setShaper(Shaper.getShaper(child));
        }
        if ((itr = e.getChildren("cell").iterator()).hasNext()) {
            while (itr.hasNext()) {
                child = (Element)itr.next();
                this.addActiveBoxContent(ActiveBoxContent.getActiveBoxContent(child, mediaBag));
            }
        } else {
            int[] v;
            child = e.getChild(IDS);
            if (child != null && (v = JDomUtility.stringToIntArray(child.getText())) != null) {
                for (int i = 0; i < v.length; ++i) {
                    this.getActiveBoxContent((int)i).id = v[i];
                }
            }
        }
        if (this.imgName != null && mediaBag != null && mediaBag.getProject().getBridge() != null) {
            this.setImgContent(mediaBag.getImageElement(this.imgName), true);
        }
        if ((n = this.activeBoxContentArray.size()) > 0) {
            int i;
            boolean empty = true;
            for (i = 0; i < n; ++i) {
                ActiveBoxContent bxc = this.getActiveBoxContent(i);
                if (bxc.id == -1 && bxc.item == -1 && bxc.isEmpty()) continue;
                empty = false;
                break;
            }
            if (empty) {
                for (i = 0; i < n; ++i) {
                    this.getActiveBoxContent((int)i).id = i;
                }
            }
        }
    }

    public static void listReferences(Element e, Map<String, String> map) {
        String s = e.getAttributeValue(IMAGE);
        if (s != null) {
            map.put(s, "media");
        }
        Iterator itr = e.getChildren("cell").iterator();
        while (itr.hasNext()) {
            ActiveBoxContent.listReferences((Element)itr.next(), map);
        }
    }

    public Shaper getShaper() {
        if (this.shaper == null) {
            this.setShaper(new Rectangular(this.ncw, this.nch));
        }
        return this.shaper;
    }

    public void setShaper(Shaper sh) {
        this.shaper = sh;
    }

    public void addActiveBoxContent(ActiveBoxContent ab) {
        this.activeBoxContentArray.add(ab);
        if (this.ncw == 0 || this.nch == 0) {
            this.ncw = 1;
            this.nch = 1;
        }
    }

    public ActiveBoxContent getActiveBoxContent(int i) {
        if (i >= this.activeBoxContentArray.size()) {
            for (int j = this.activeBoxContentArray.size(); j <= i; ++j) {
                this.activeBoxContentArray.add(new ActiveBoxContent());
            }
        }
        return this.activeBoxContentArray.get(i);
    }

    public ActiveBoxContent getActiveBoxContentWith(int id, int item) {
        ActiveBoxContent result = null;
        for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
            ActiveBoxContent abxcnt = this.activeBoxContentArray.get(i);
            if (abxcnt.id != id || abxcnt.item != item) continue;
            result = abxcnt;
            break;
        }
        return result;
    }

    public void deleteActiveBoxContentWith(int id, int item) {
        ActiveBoxContent abc = this.getActiveBoxContentWith(id, item);
        if (abc != null) {
            this.activeBoxContentArray.remove(abc);
            for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
                abc = this.activeBoxContentArray.get(i);
                if (abc.id != id || abc.item <= item) continue;
                --abc.item;
            }
        }
    }

    public void insertActiveBoxContentWith(int id, int item) {
        ActiveBoxContent abc = this.getActiveBoxContentWith(id, item);
        int index = this.activeBoxContentArray.indexOf(abc);
        for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
            abc = this.activeBoxContentArray.get(i);
            if (abc.id != id || abc.item < item) continue;
            ++abc.item;
        }
        abc = new ActiveBoxContent();
        abc.id = id;
        abc.item = item;
        this.activeBoxContentArray.add(index + 1, abc);
    }

    public int indexOf(ActiveBoxContent cnt) {
        int result = -1;
        for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
            if (this.activeBoxContentArray.get(i) != cnt) continue;
            result = i;
            break;
        }
        return result;
    }

    public void setActiveBoxContentAt(ActiveBoxContent ab, int index) {
        if (index >= 0) {
            this.getActiveBoxContent(index);
            this.activeBoxContentArray.set(index, ab);
        }
    }

    public void setImgContent(MediaBagElement mbe, boolean roundSizes) throws Exception {
        this.setImgContent(mbe, this.getShaper(), roundSizes);
    }

    public void setImgContent(MediaBagElement mbe, Shaper sh) throws Exception {
        this.setImgContent(mbe, sh, false);
    }

    public void setImgContent(MediaBagElement mbe, Shaper sh, boolean roundSizes) throws Exception {
        this.setShaper(sh);
        this.ncw = this.shaper.getNumColumns();
        this.nch = this.shaper.getNumRows();
        if (mbe != null) {
            this.img = mbe.getImage();
            this.imgName = mbe.getName();
            this.w = -1.0;
            this.h = -1.0;
            while (true) {
                this.w = (double)this.img.getWidth(null) / (double)this.ncw;
                this.h = (double)this.img.getHeight(null) / (double)this.nch;
                if (this.w >= 0.0 && this.h >= 0.0) break;
                Thread.sleep(50L);
            }
            if (roundSizes) {
                this.w = (int)this.w;
                this.h = (int)this.h;
            }
            if (this.w < 1.0 || this.h < 1.0) {
                throw new Exception("Invalid image!");
            }
        } else {
            this.img = null;
            this.imgName = null;
            this.w = Math.max(this.w, 10.0);
            this.h = Math.max(this.h, 10.0);
        }
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, this.w * (double)this.ncw, this.h * (double)this.nch);
        this.activeBoxContentArray.ensureCapacity(this.shaper.getNumCells());
        for (int i = 0; i < this.shaper.getNumCells(); ++i) {
            this.getActiveBoxContent(i).setImgContent(this.img, this.shaper.getShape(i, r));
        }
        if (this.shaper.hasRemainder()) {
            this.backgroundContent = new ActiveBoxContent();
            this.backgroundContent.setImgContent(this.img, this.shaper.getRemainderShape(r));
        }
    }

    public void setTextContent(String[] txt, int setNcw, int setNch) {
        this.ncw = Math.max(1, setNcw);
        this.nch = Math.max(1, setNch);
        int n = this.ncw * this.nch;
        this.activeBoxContentArray.ensureCapacity(n);
        for (int i = 0; i < n; ++i) {
            this.getActiveBoxContent(i).setTextContent(i >= txt.length || txt[i] == null ? "" : txt[i]);
        }
    }

    public boolean hasImg() {
        return this.img != null;
    }

    public double getTotalWidth() {
        return this.w * (double)this.ncw;
    }

    public double getTotalHeight() {
        return this.h * (double)this.nch;
    }

    public int getNumCells() {
        return this.activeBoxContentArray.size();
    }

    public boolean isEmpty() {
        return this.activeBoxContentArray.isEmpty();
    }

    public void prepareMedia(PlayStation ps) {
        for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
            this.getActiveBoxContent(i).prepareMedia(ps);
        }
        if (this.img != null && ps.getOptions().getBoolean("preDrawImages")) {
            Graphics g = ps.getComponent().getGraphics();
            g.drawImage(this.img, 0, 0, 0, 0, ps.getComponent());
        }
    }

    public void setBoxBase(BoxBase boxBase) {
        this.bb = boxBase;
    }

    public void setIds(int[] ids) {
        for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
            if (i >= ids.length) continue;
            this.getActiveBoxContent((int)i).id = ids[i];
        }
    }

    public void setAllIdsTo(int id) {
        for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
            this.getActiveBoxContent((int)i).id = id;
        }
    }

    public void avoidAllIdsNull(int maxId) {
        int i;
        boolean allIdsNull = true;
        int numCells = this.activeBoxContentArray.size();
        for (i = 0; i < numCells; ++i) {
            if (this.getActiveBoxContent((int)i).id == -1) continue;
            allIdsNull = false;
            break;
        }
        if (allIdsNull) {
            maxId = Math.max(1, maxId);
            for (i = 0; i < numCells; ++i) {
                this.getActiveBoxContent((int)i).id = i % maxId;
            }
        }
    }

    public void copyStyleTo(ActiveBagContent abc) {
        if (abc != null) {
            abc.setBoxBase(this.bb);
            abc.border = this.border;
        }
    }
}

