/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.automation.tagreplace;

import edu.xtec.jclic.activities.text.TargetMarker;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextTarget;
import edu.xtec.jclic.automation.ActiveBagContentKit;
import edu.xtec.jclic.automation.AutoContentProvider;
import edu.xtec.jclic.automation.TextActivityContentKit;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.StrUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.jdom.Element;

public class TagReplace
extends AutoContentProvider {
    public static final String DEFAULT_TAG_START = "[";
    public static final String DEFAULT_TAG_END = "]";
    public static final String DEFAULT_CHARSET = "UTF8";
    public String tagStart = "[";
    public String tagEnd = "]";
    public String mapFileName;
    public String fileCharset = "UTF8";
    private HashMap<String, String> map;
    public static final String TAG_START = "tagStart";
    public static final String TAG_END = "tagEnd";
    public static final String MAP_FN = "mapFn";
    public static final String MAP_CHARSET = "charset";

    @Override
    public Element getJDomElement() {
        Element e = super.getJDomElement();
        e.setAttribute(TAG_START, this.tagStart);
        e.setAttribute(TAG_END, this.tagEnd);
        if (this.mapFileName != null) {
            e.setAttribute(MAP_FN, this.mapFileName);
            e.setAttribute(MAP_CHARSET, this.fileCharset);
        }
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        this.tagStart = JDomUtility.getStringAttr(e, TAG_START, DEFAULT_TAG_START, false);
        this.tagEnd = JDomUtility.getStringAttr(e, TAG_END, DEFAULT_TAG_END, false);
        this.mapFileName = JDomUtility.getStringAttr(e, MAP_FN, null, false);
        this.fileCharset = JDomUtility.getStringAttr(e, MAP_CHARSET, DEFAULT_CHARSET, false);
        this.map = null;
    }

    public static boolean checkClient(Class cl) {
        return ActiveBagContentKit.Compatible.class.isAssignableFrom(cl) || TextActivityContentKit.Compatible.class.isAssignableFrom(cl);
    }

    @Override
    public boolean generateContent(Object kit, ResourceBridge rb) {
        boolean result = false;
        if (kit instanceof ActiveBagContentKit) {
            ActiveBagContentKit k = (ActiveBagContentKit)kit;
            result = this.generateContent(k.nRows, k.nCols, k.content, k.useIds, rb);
        } else if (kit instanceof TextActivityContentKit) {
            result = this.generateContent((TextActivityContentKit)kit);
        }
        return result;
    }

    protected boolean generateContent(TextActivityContentKit k) {
        boolean result = false;
        if (k.tad != null) {
            try {
                k.checkButtonText = this.filter(k.checkButtonText);
                k.prevScreenText = this.filter(k.prevScreenText);
                this.filterDoc(k.tad);
                result = true;
            }
            catch (BadLocationException ex) {
                System.err.println("Error processing text document: " + ex);
                return false;
            }
        }
        return result;
    }

    protected boolean generateContent(int nRows, int nCols, ActiveBagContent[] content, boolean useIds, ResourceBridge rb) {
        if (content == null || content.length < 1 || rb == null) {
            return false;
        }
        for (ActiveBagContent abc : content) {
            this.filterActiveBagContent(abc);
        }
        return true;
    }

    protected void filterActiveBagContent(ActiveBagContent abc) {
        if (abc != null) {
            for (int j = 0; j < abc.getNumCells(); ++j) {
                this.filterActiveBoxContent(abc.getActiveBoxContent(j));
            }
        }
    }

    protected void filterActiveBoxContent(ActiveBoxContent abx) {
        if (abx != null) {
            abx.text = this.filter(abx.text);
            abx.imgName = this.filter(abx.imgName);
            if (abx.mediaContent != null) {
                abx.mediaContent.mediaFileName = this.filter(abx.mediaContent.mediaFileName);
            }
        }
    }

    protected List<Object[]> locateTags(String src) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        if (src != null && this.map != null) {
            int pEnd;
            int pStart;
            int p = 0;
            while ((pStart = src.indexOf(this.tagStart, p)) >= 0 && (pEnd = src.indexOf(this.tagEnd, pStart + this.tagStart.length())) > pStart) {
                Object[] tagMark = new Object[4];
                tagMark[0] = new Integer(pStart);
                tagMark[1] = new Integer(pEnd + this.tagEnd.length() - pStart);
                String key = src.substring(pStart + this.tagStart.length(), pEnd);
                String value = this.map.get(key);
                if (value != null) {
                    tagMark[2] = value;
                    result.add(tagMark);
                }
                p = pEnd + this.tagEnd.length();
            }
        }
        return result;
    }

    protected String filter(String src) {
        String result = src;
        if (src != null) {
            StringBuilder sb = new StringBuilder();
            List<Object[]> tagMarks = this.locateTags(src);
            int p = 0;
            for (Object[] tagMark : tagMarks) {
                int pStart = (Integer)tagMark[0];
                int tagLength = (Integer)tagMark[1];
                String value = (String)tagMark[2];
                sb.append(src.substring(p, pStart));
                sb.append(value);
                p = pStart + tagLength;
            }
            sb.append(src.substring(p));
            result = sb.substring(0);
        }
        return result;
    }

    protected void filter(String[] strArray) {
        if (strArray != null) {
            for (int i = 0; i < strArray.length; ++i) {
                strArray[i] = this.filter(strArray[i]);
            }
        }
    }

    protected void filterDoc(TextActivityDocument tad) throws BadLocationException {
        if (tad != null) {
            Object[] tagMark;
            int i;
            String src = tad.getText(0, tad.getLength());
            List<Object[]> tagMarks = this.locateTags(src);
            int s = tagMarks.size();
            for (i = 0; i < s; ++i) {
                tagMark = tagMarks.get(i);
                tagMark[3] = tad.createPosition((Integer)tagMark[0]);
            }
            for (i = 0; i < s; ++i) {
                tagMark = tagMarks.get(i);
                Position position = (Position)tagMark[3];
                int pos = position.getOffset();
                int tagLength = (Integer)tagMark[1];
                String value = (String)tagMark[2];
                AttributeSet as = tad.getCharacterElement(pos).getAttributes();
                tad.getLogicalStyle(pos);
                tad.insertString(pos, value, as);
                tad.remove(pos + value.length(), tagLength);
            }
            this.filterActiveBagContent(tad.boxesContent);
            this.filterActiveBagContent(tad.popupsContent);
            if (tad.tmb != null) {
                for (TargetMarker tm : tad.tmb) {
                    TextTarget target = tm.target;
                    if (target == null) continue;
                    target.iniText = this.filter(target.iniText);
                    this.filter(target.answer);
                    this.filter(target.options);
                    this.filterActiveBoxContent(target.popupContent);
                }
            }
        }
    }

    @Override
    public void init(ResourceBridge rb, FileSystem fs) {
        if (fs != null && this.mapFileName != null) {
            try {
                InputStream is = fs.getInputStream(this.mapFileName);
                if (is != null) {
                    String line;
                    BufferedReader bfr = new BufferedReader(new InputStreamReader(is, this.fileCharset));
                    this.map = new HashMap();
                    while ((line = bfr.readLine()) != null) {
                        int p = line.indexOf(61);
                        if (p <= 0) continue;
                        String key = StrUtils.secureString(line.substring(0, p)).trim();
                        String value = StrUtils.secureString(line.substring(p + 1)).trim();
                        if (key.length() <= 0) continue;
                        this.map.put(key, value);
                    }
                }
            }
            catch (Exception ex) {
                System.err.println("Error initializing TagReplace: " + ex);
            }
        }
    }

    @Override
    public void innerListReferences(Map<String, String> map) throws Exception {
        if (this.mapFileName != null) {
            map.put(this.mapFileName, "external");
        }
    }
}

