/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.HelpActivityComponent;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.activities.text.BasicEvaluator;
import edu.xtec.jclic.activities.text.ComplexEvaluator;
import edu.xtec.jclic.activities.text.Evaluator;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextActivityPane;
import edu.xtec.jclic.activities.text.TextTarget;
import edu.xtec.jclic.automation.TextActivityContentKit;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.StrUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.jdom.Element;

public class TextActivityBase
extends Activity
implements TextActivityContentKit.Compatible {
    protected TextActivityDocument tad;
    protected StyleContext styleContext = new StyleContext();
    protected boolean hasCheckButton;
    protected String checkButtonText;
    protected boolean prevScreen;
    protected int prevScreenMaxTime;
    protected String prevScreenText;
    protected BoxBase prevScreenStyle;
    protected StyledDocument prevScreenDocument;
    public static final String CHECK_BUTTON = "checkButton";
    public static final String PREV_SCREEN = "prevScreen";
    public static final String TEXT = "text";

    public TextActivityBase(JClicProject project) {
        super(project);
        Style mas = this.styleContext.getStyle("default");
        if (mas != null) {
            StyleConstants.setFontFamily(mas, BoxBase.getDefaultFont().getFamily());
            StyleConstants.setBackground(mas, Color.white);
        }
        this.tad = new TextActivityDocument(this.styleContext);
        this.hasCheckButton = false;
        this.checkButtonText = "";
        this.prevScreen = false;
        this.prevScreenMaxTime = 0;
        this.prevScreenText = null;
        this.prevScreenDocument = null;
        this.prevScreenStyle = new BoxBase();
    }

    @Override
    public Element getJDomElement() {
        Element e = super.getJDomElement();
        if (this.hasCheckButton) {
            e.addContent(new Element(CHECK_BUTTON).setText(this.checkButtonText));
        }
        if (this.prevScreen) {
            Element child = new Element(PREV_SCREEN);
            if (this.prevScreenMaxTime > 0) {
                child.setAttribute("maxTime", Integer.toString(this.prevScreenMaxTime));
            }
            if (this.prevScreenText != null) {
                child.addContent(this.prevScreenStyle.getJDomElement());
                JDomUtility.setParagraphs(child, this.prevScreenText);
            }
            e.addContent(child);
        }
        try {
            e.addContent(this.tad.getJDomElement());
        }
        catch (Exception ex) {
            System.err.println("Error getting document contents!");
            return null;
        }
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        super.setProperties(e, aux);
        Element child = e.getChild(CHECK_BUTTON);
        if (child != null) {
            this.hasCheckButton = true;
            this.checkButtonText = child.getText();
        }
        if ((child = e.getChild(PREV_SCREEN)) != null) {
            this.prevScreen = true;
            this.prevScreenText = JDomUtility.getParagraphs(child);
            if (this.prevScreenText != null) {
                this.prevScreenStyle = BoxBase.getBoxBase(child.getChild("style"));
                this.prevScreenDocument = new DefaultStyledDocument();
                TextActivityDocument.boxBaseToStyledDocument(this.prevScreenStyle, this.prevScreenDocument);
                this.prevScreenDocument.insertString(0, this.prevScreenText, null);
            }
            this.prevScreenMaxTime = JDomUtility.getIntAttr(child, "maxTime", this.prevScreenMaxTime);
        }
        this.setTextActivityDocument(e.getChild("document"));
    }

    public void setTextActivityDocument(Element e) throws Exception {
        this.tad = TextActivityDocument.getTextActivityDocument(e, this);
    }

    @Override
    public void setProperties(Clic3Activity c3a) throws Exception {
        super.setProperties(c3a);
        this.setWindowSize(new Dimension(c3a.txtCW, c3a.txtCH));
        this.hasCheckButton = c3a.btCorregir;
        this.checkButtonText = c3a.txBtCorregir;
        if (c3a.avPrevHelp > 0) {
            this.prevScreen = true;
            this.prevScreenMaxTime = c3a.avTimePH;
            if (c3a.avPrevHelp == 2) {
                this.prevScreenText = c3a.txPrev;
                this.prevScreenStyle = c3a.getBoxBase(3);
            }
            this.messages[0] = new ActiveBoxContent();
            this.messages[0].setBoxBase(this.messages[1].bb);
            c3a.setActiveBoxTextContent(this.messages[0], c3a.initMessPrev);
        }
        this.tad.readClic3Data(c3a, this);
    }

    public void setStyleContext(StyleContext sc) {
        if (sc != null) {
            try {
                this.setTextActivityDocument(this.tad.getJDomElement(sc));
                this.styleContext = sc;
            }
            catch (Exception ex) {
                System.err.println("Error updating document styles:\n" + ex);
            }
        }
    }

    public StyleContext getStyleContext() {
        return this.styleContext;
    }

    protected Evaluator buildClic3Evaluator(Clic3Activity c3a, boolean complex) throws Exception {
        Element e = new Element("evaluator");
        String evaluatorClassName = complex ? ComplexEvaluator.class.getName() : BasicEvaluator.class.getName();
        e.setAttribute("class", evaluatorClassName);
        e.setAttribute("checkCase", JDomUtility.boolString(c3a.avMaj));
        e.setAttribute("checkAccents", JDomUtility.boolString(c3a.avAcc));
        e.setAttribute("checkPunctuation", JDomUtility.boolString(c3a.avPunt));
        e.setAttribute("checkDoubleSpaces", JDomUtility.boolString(c3a.avDblSpc));
        if (complex) {
            e.setAttribute("detail", JDomUtility.boolString(c3a.avLletra));
            e.setAttribute("checkSteps", Integer.toString(c3a.avScope));
            e.setAttribute("checkScope", Integer.toString(c3a.avMaxScope));
        }
        return Evaluator.getEvaluator(e, c3a.project);
    }

    @Override
    public int getMinNumActions() {
        return this.tad == null ? 0 : this.tad.tmb.size();
    }

    @Override
    public boolean prepareMedia(PlayStation ps) {
        if (!super.prepareMedia(ps)) {
            return false;
        }
        if (this.tad != null) {
            this.tad.boxesContent.prepareMedia(ps);
            this.tad.popupsContent.prepareMedia(ps);
        }
        return true;
    }

    @Override
    public boolean helpSolutionAllowed() {
        return true;
    }

    @Override
    public Activity.Panel getActivityPanel(PlayStation ps) {
        return new Panel(ps);
    }

    public TextActivityDocument getDocument() {
        return this.tad;
    }

    public class Panel
    extends Activity.Panel
    implements ActionListener {
        JScrollPane scrollPane;
        JButton checkButton;
        TextActivityPane pane;
        boolean showingPrevScreen;
        Timer prevScreenTimer;
        TextTarget.PopupTimer popupTimer;

        protected Panel(PlayStation ps) {
            super(ps);
            this.scrollPane = null;
            this.checkButton = null;
            this.pane = null;
            this.showingPrevScreen = false;
            this.prevScreenTimer = null;
            this.popupTimer = null;
            this.popupTimer = new TextTarget.PopupTimer(this);
        }

        @Override
        public void clear() {
            if (this.prevScreenTimer != null) {
                this.prevScreenTimer.stop();
                this.prevScreenTimer = null;
            }
        }

        @Override
        public void doLayout() {
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.checkButton != null && this.checkButton.isVisible()) {
                int hb = this.checkButton.getPreferredSize().height;
                this.checkButton.setBounds(0, h -= hb, w, hb);
            }
            if (this.scrollPane != null && this.pane != null) {
                if (this.pane.getBounds().isEmpty()) {
                    this.pane.setBounds(0, 0, w, h);
                }
                this.scrollPane.setBounds(0, 0, w, h);
            }
        }

        @Override
        public void buildVisualComponents() throws Exception {
            super.buildVisualComponents();
            if (TextActivityBase.this.acp != null) {
                TextActivityContentKit kit = new TextActivityContentKit(TextActivityBase.this.tad, TextActivityBase.this.checkButtonText, TextActivityBase.this.prevScreenText);
                if (TextActivityBase.this.acp.generateContent(kit, this.ps)) {
                    TextActivityBase.this.checkButtonText = kit.checkButtonText;
                    TextActivityBase.this.prevScreenText = kit.prevScreenText;
                }
            }
            if (TextActivityBase.this.prevScreen && TextActivityBase.this.prevScreenText != null) {
                TextActivityBase.this.prevScreenDocument = new DefaultStyledDocument();
                TextActivityDocument.boxBaseToStyledDocument(TextActivityBase.this.prevScreenStyle, TextActivityBase.this.prevScreenDocument);
                try {
                    TextActivityBase.this.prevScreenDocument.insertString(0, TextActivityBase.this.prevScreenText, null);
                }
                catch (Exception e) {
                    System.err.println("Error displaying initial screen:\n" + e);
                }
            }
            this.pane = this.buildPane();
            this.scrollPane = new JScrollPane(this.pane);
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.scrollPane.getVerticalScrollBar().setBorder(BorderFactory.createLineBorder(Color.darkGray, 1));
            this.add(this.scrollPane);
            if (TextActivityBase.this.hasCheckButton) {
                this.checkButton = new JButton(StrUtils.secureString(TextActivityBase.this.checkButtonText, " "));
                this.checkButton.setOpaque(false);
                this.checkButton.addActionListener(this);
                this.add(this.checkButton);
            }
            if (TextActivityBase.this.prevScreen && TextActivityBase.this.prevScreenMaxTime > 0) {
                this.prevScreenTimer = new Timer(1000 * TextActivityBase.this.prevScreenMaxTime, this);
                this.prevScreenTimer.setRepeats(false);
            }
        }

        protected TextActivityPane buildPane() {
            return new TextActivityPane(this);
        }

        @Override
        public void initActivity() throws Exception {
            if (TextActivityBase.this.prevScreen) {
                this.preInitActivity();
            } else {
                this.startActivity();
            }
        }

        @Override
        public void startActivity() throws Exception {
            super.initActivity();
            this.showingPrevScreen = false;
            this.setAndPlayMsg(1, 0);
            this.initDocument();
            if (this.checkButton != null) {
                this.checkButton.setVisible(true);
            }
            this.ps.playMsg();
            this.pane.requestFocus();
            this.playing = true;
        }

        public void preInitActivity() {
            if (TextActivityBase.this.messages[0] == null || !TextActivityBase.this.prevScreen) {
                return;
            }
            this.showingPrevScreen = true;
            if (this.checkButton != null) {
                this.checkButton.setVisible(false);
            }
            this.enableCounters(true, false, false);
            this.ps.setCounterValue(2, 0);
            this.ps.setMsg(TextActivityBase.this.messages[0]);
            this.pane.setEditable(false);
            this.pane.setStyledDocument(TextActivityBase.this.prevScreenDocument != null ? TextActivityBase.this.prevScreenDocument : TextActivityBase.this.tad);
            if (this.prevScreenTimer != null) {
                this.ps.setCountDown(2, TextActivityBase.this.prevScreenMaxTime);
                this.prevScreenTimer.start();
            }
            this.ps.playMsg();
        }

        protected void initDocument() throws Exception {
            if (TextActivityBase.this.tad != null) {
                if (this.pane.getDocument() != TextActivityBase.this.tad) {
                    this.pane.setStyledDocument(TextActivityBase.this.tad);
                }
                this.pane.setEnabled(true);
            }
        }

        @Override
        public void render(Graphics2D g2, Rectangle dirtyRegion) {
        }

        @Override
        public void requestFocus() {
            if (this.playing && this.pane != null) {
                this.pane.requestFocus();
            }
        }

        @Override
        public Dimension setDimension(Dimension desiredMaxSize) {
            return new Dimension(Math.min(desiredMaxSize.width, TextActivityBase.this.getWindowSize().width), Math.min(desiredMaxSize.height, TextActivityBase.this.getWindowSize().height));
        }

        @Override
        public void setCursor(Cursor cursor) {
            if (this.pane != null) {
                this.pane.setCursor(cursor);
            }
            super.setCursor(cursor);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.checkButton != null && e.getSource() == this.checkButton && this.playing) {
                this.doCheck(true);
            }
            if (this.prevScreenTimer != null && e.getSource() == this.prevScreenTimer && this.showingPrevScreen) {
                this.ps.startActivity(this);
            }
        }

        @Override
        public void forceFinishActivity() {
            if (this.playing) {
                this.doCheck(false);
            }
        }

        protected void doCheck(boolean fromButton) {
        }

        @Override
        public void showHelp() {
            if (!TextActivityBase.this.helpWindowAllowed() || this.pane == null) {
                return;
            }
            HelpActivityComponent hac = null;
            if (TextActivityBase.this.showSolution) {
                hac = new HelpActivityComponent(this){
                    TextActivityPane tap;
                    JScrollPane jsp;
                    {
                        this.tap = null;
                        this.jsp = null;
                    }

                    @Override
                    public void render(Graphics2D g2, Rectangle dirtyRegion) {
                    }

                    @Override
                    public void init() {
                        this.tap = Panel.this.buildPane();
                        try {
                            this.tap.setStyledDocument(TextActivityDocument.getTextActivityDocument(TextActivityBase.this.tad.getJDomElement(), TextActivityBase.this));
                        }
                        catch (Exception ex) {
                            this.tap.setStyledDocument(TextActivityBase.this.tad);
                        }
                        this.tap.setEditable(false);
                        this.jsp = new JScrollPane(this.tap);
                        this.jsp.setBorder(BorderFactory.createEmptyBorder());
                        this.jsp.getVerticalScrollBar().setBorder(BorderFactory.createLineBorder(Color.darkGray, 1));
                        this.add(this.jsp);
                        Dimension size = Panel.this.scrollPane.getBounds().getSize();
                        this.jsp.setBounds(0, 0, size.width, size.height);
                        if (this.tap.getBounds().isEmpty()) {
                            this.tap.setBounds(0, 0, size.width, size.height);
                        }
                        this.setPreferredSize(size);
                        this.setMaximumSize(size);
                        this.setMinimumSize(size);
                    }
                };
                hac.init();
            }
            if (this.ps.showHelp(hac, TextActivityBase.this.helpMsg)) {
                this.ps.reportNewAction(this.getActivity(), "HELP", null, null, false, -1);
            }
            if (hac != null) {
                hac.end();
            }
        }
    }
}

