/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.activities.text.ComplexEvaluator;
import edu.xtec.jclic.activities.text.Evaluator;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextActivityPane;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.Actions;
import edu.xtec.util.StrUtils;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.event.CaretEvent;
import javax.swing.text.BadLocationException;
import org.jdom.Element;

public class Complete
extends TextActivityBase {
    Evaluator ev;

    public Complete(JClicProject project) {
        super(project);
        this.ev = new ComplexEvaluator(project);
        this.hasCheckButton = true;
    }

    @Override
    public Element getJDomElement() {
        Element e = super.getJDomElement();
        e.addContent(this.ev.getJDomElement());
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        super.setProperties(e, aux);
        this.ev = Evaluator.getEvaluator(e.getChild("evaluator"), this.project);
    }

    @Override
    public void setProperties(Clic3Activity c3a) throws Exception {
        super.setProperties(c3a);
        ((ComplexEvaluator)this.ev).setProperties(c3a);
        this.hasCheckButton = true;
    }

    @Override
    public boolean needsKeyboard() {
        return true;
    }

    @Override
    public Activity.Panel getActivityPanel(PlayStation ps) {
        return new Panel(ps);
    }

    class Panel
    extends TextActivityBase.Panel {
        TextActivityDocument playDoc;
        boolean locked;
        int nActions;

        protected Panel(PlayStation ps) {
            super(Complete.this, ps);
            this.playDoc = null;
            this.locked = true;
            this.nActions = 0;
        }

        @Override
        protected void initDocument() throws Exception {
            this.nActions = 0;
            if (Complete.this.tad != null) {
                this.playing = false;
                this.playDoc = new TextActivityDocument(Complete.this.styleContext);
                Complete.this.tad.cloneDoc(this.playDoc, true, false, false);
                this.pane.setStyledDocument(this.playDoc);
                this.playDoc.attachTo(this.pane, this);
                this.pane.setEnabled(true);
                if (this.playDoc.tmb.size() > 0) {
                    this.pane.setEditable(true);
                    this.pane.requestFocus();
                    this.pane.getCaret().setVisible(true);
                    this.locked = false;
                } else {
                    this.locked = true;
                    this.pane.setEditable(false);
                    this.pane.getCaret().setVisible(false);
                }
            }
        }

        @Override
        protected TextActivityPane buildPane() {
            CompletePane cp = new CompletePane();
            cp.setActions();
            return cp;
        }

        @Override
        protected void doCheck(boolean fromButton) {
            String current;
            String match;
            if (this.playDoc == null || this.locked) {
                return;
            }
            try {
                match = StrUtils.trimEnding(Complete.this.tad.getText(0, Complete.this.tad.getLength()));
                current = StrUtils.trimEnding(this.playDoc.getText(0, this.playDoc.getLength()));
            }
            catch (BadLocationException e) {
                System.err.println("Error: unable to retrieve text:\n" + e);
                return;
            }
            byte[] result = Complete.this.ev.evalText(current, match);
            int score = 0;
            if (result != null) {
                int l = result.length;
                int i = 0;
                while (i < l) {
                    while (i < l && !this.playDoc.checkBooleanAttribute(i, "target")) {
                        ++i;
                    }
                    if (i >= l) continue;
                    ++this.nActions;
                    boolean actionOk = true;
                    int j = i;
                    while (i < l && this.playDoc.checkBooleanAttribute(i, "target")) {
                        ++i;
                    }
                    this.playDoc.setCharacterAttributes(j, i - j, Complete.this.styleContext.getStyle("target"), true);
                    for (int k = j; k < i; ++k) {
                        if (result[k] == 0) continue;
                        actionOk = false;
                        this.playDoc.setCharacterAttributes(k, 1, Complete.this.styleContext.getStyle("targetError"), false);
                    }
                    if (!actionOk) continue;
                    ++score;
                }
            }
            this.ps.setCounterValue(0, score);
            this.ps.setCounterValue(1, this.nActions);
            if (Evaluator.isOk(result)) {
                this.finishActivity(true);
            } else if (fromButton) {
                this.playEvent(4);
            }
        }

        @Override
        public void finishActivity(boolean result) {
            this.pane.setEditable(false);
            this.pane.setEnabled(false);
            super.finishActivity(result);
        }

        class CompletePane
        extends TextActivityPane {
            Action kitDeletePrevCharAction;
            AbstractAction deletePrevCharAction;
            Action kitDeleteNextCharAction;
            AbstractAction deleteNextCharAction;

            protected CompletePane() {
                super(Panel.this);
                this.kitDeletePrevCharAction = null;
                this.deletePrevCharAction = new AbstractAction("delete-previous"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (CompletePane.this.readyForActions() && CompletePane.this.kitDeletePrevCharAction != null) {
                            CompletePane.this.invalidateSelection();
                            int offset = CompletePane.this.getCaret().getDot() - 1;
                            if (offset > 0 && Panel.this.playDoc.checkBooleanAttribute(offset, "target")) {
                                CompletePane.this.kitDeletePrevCharAction.actionPerformed(e);
                            }
                        }
                    }
                };
                this.kitDeleteNextCharAction = null;
                this.deleteNextCharAction = new AbstractAction("delete-next"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (CompletePane.this.readyForActions() && CompletePane.this.kitDeleteNextCharAction != null) {
                            CompletePane.this.invalidateSelection();
                            int offset = CompletePane.this.getCaret().getDot();
                            if (offset >= 0 && offset < Panel.this.playDoc.getLength() && Panel.this.playDoc.checkBooleanAttribute(offset, "target")) {
                                CompletePane.this.kitDeleteNextCharAction.actionPerformed(e);
                            }
                        }
                    }
                };
            }

            @Override
            public boolean processMouse(MouseEvent e) {
                return super.processMouse(e) && e.getID() == 501 && Panel.this.playing && !Panel.this.locked;
            }

            protected void invalidateSelection() {
                int offset = this.getCaret().getDot();
                if (this.getCaret().getMark() != offset) {
                    this.getCaret().setDot(offset);
                }
            }

            @Override
            protected void fireCaretUpdate(CaretEvent e) {
                this.invalidateSelection();
                super.fireCaretUpdate(e);
            }

            @Override
            public void replaceSelection(String content) {
                this.invalidateSelection();
                if (content != null && content.length() > 0) {
                    char ch = content.charAt(0);
                    int offset = this.getCaret().getDot();
                    if (ch >= ' ' && ch != '\u007f') {
                        try {
                            Panel.this.playDoc.insertString(offset, new String(new char[]{ch}), Panel.this.playDoc.getTargetAttributeSet());
                        }
                        catch (BadLocationException ex) {
                            System.err.println("Text activity error:\n" + ex);
                        }
                    }
                }
            }

            @Override
            public void cut() {
                this.invalidateSelection();
            }

            @Override
            public void paste() {
                this.invalidateSelection();
            }

            boolean readyForActions() {
                return Panel.this.playing && !Panel.this.locked && this.isEditable() && this.isEnabled();
            }

            protected void setActions() {
                this.kitDeleteNextCharAction = this.getActionMap().get("delete-next");
                this.kitDeletePrevCharAction = this.getActionMap().get("delete-previous");
                Map<String, Object[]> actionKeys = Actions.getActionKeys(this);
                ActionMap am = new ActionMap();
                am.setParent(this.getActionMap());
                this.setActionMap(am);
                Actions.mapAction(this, actionKeys, this.deletePrevCharAction);
                Actions.mapAction(this, actionKeys, this.deleteNextCharAction);
            }
        }
    }
}

