/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.puzzles;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.HelpActivityComponent;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.automation.ActiveBagContentKit;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.ActiveBoxGrid;
import edu.xtec.jclic.boxes.BoxBag;
import edu.xtec.jclic.boxes.BoxConnector;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.JDomUtility;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jdom.Element;

public class ExchangePuzzle
extends Activity
implements ActiveBagContentKit.Compatible {
    public ExchangePuzzle(JClicProject project) {
        super(project);
        this.abc = new ActiveBagContent[1];
        this.dragCells = true;
    }

    @Override
    public void initNew() {
        super.initNew();
        this.abc[0] = ActiveBagContent.initNew(3, 2, 65);
    }

    @Override
    public Element getJDomElement() {
        if (this.abc[0] == null) {
            return null;
        }
        Element e = super.getJDomElement();
        e.addContent(this.abc[0].getJDomElement());
        Element ex = new Element("scramble");
        ex.setAttribute("times", Integer.toString(this.shuffles));
        e.addContent(ex);
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        super.setProperties(e, aux);
        Element child = e.getChild("cells");
        if (child != null) {
            this.abc[0] = ActiveBagContent.getActiveBagContent(child, this.project.mediaBag);
        }
        if (this.abc[0] == null) {
            throw new IllegalArgumentException("Puzzle without content!");
        }
        child = e.getChild("scramble");
        if (child != null) {
            this.shuffles = JDomUtility.getIntAttr(child, "times", this.shuffles);
        }
    }

    @Override
    public void setProperties(Clic3Activity c3a) throws Exception {
        super.setProperties(c3a);
        this.abc[0] = c3a.createActiveBagContent(0);
        this.abc[0].setBoxBase(c3a.getBoxBase(0));
        this.dragCells = true;
    }

    @Override
    public int getMinNumActions() {
        return this.abc[0] == null ? 0 : this.abc[0].getNumCells();
    }

    @Override
    public boolean helpSolutionAllowed() {
        return true;
    }

    @Override
    public boolean hasRandom() {
        return true;
    }

    @Override
    public boolean shuffleAlways() {
        return true;
    }

    @Override
    public Activity.Panel getActivityPanel(PlayStation ps) {
        return new Panel(ps);
    }

    class Panel
    extends Activity.Panel {
        ActiveBoxBag bg;

        protected Panel(PlayStation ps) {
            super(ps);
            this.bc = new BoxConnector(this);
        }

        @Override
        public void clear() {
            if (this.bg != null) {
                this.bg.end();
                this.bg = null;
            }
        }

        @Override
        public void buildVisualComponents() throws Exception {
            if (this.firstRun) {
                super.buildVisualComponents();
            }
            this.clear();
            if (ExchangePuzzle.this.abc[0] != null) {
                if (ExchangePuzzle.this.acp != null) {
                    ExchangePuzzle.this.acp.generateContent(new ActiveBagContentKit(ExchangePuzzle.this.abc[0].nch, ExchangePuzzle.this.abc[0].ncw, ExchangePuzzle.this.abc, false), this.ps);
                }
                this.bg = ActiveBoxGrid.createEmptyGrid(null, this, ExchangePuzzle.this.margin, ExchangePuzzle.this.margin, ExchangePuzzle.this.abc[0]);
                this.bg.setContent(ExchangePuzzle.this.abc[0]);
                this.bg.setVisible(true);
                this.invalidate();
            }
        }

        @Override
        public void initActivity() throws Exception {
            super.initActivity();
            if (!this.firstRun) {
                this.buildVisualComponents();
            }
            this.firstRun = false;
            this.setAndPlayMsg(1, 0);
            if (this.bg != null) {
                this.shuffle(new ActiveBoxBag[]{this.bg}, true, false);
                this.ps.setCounterValue(0, this.bg.countCellsAtEquivalentPlace(true));
                this.playing = true;
            }
        }

        @Override
        public void render(Graphics2D g2, Rectangle dirtyRegion) {
            if (this.bg != null) {
                this.bg.update(g2, dirtyRegion, this);
            }
            if (this.bc.active) {
                this.bc.update(g2, dirtyRegion, this);
            }
        }

        @Override
        public Dimension setDimension(Dimension preferredMaxSize) {
            if (this.bg == null || this.getSize().equals(preferredMaxSize)) {
                return preferredMaxSize;
            }
            return BoxBag.layoutSingle(preferredMaxSize, this.bg, ExchangePuzzle.this.margin);
        }

        @Override
        public void processMouse(MouseEvent e) {
            Point p = e.getPoint();
            if (this.playing) {
                switch (e.getID()) {
                    case 501: {
                        this.ps.stopMedia(1);
                        if (this.bc.active) {
                            ActiveBox bx1 = ExchangePuzzle.this.dragCells ? this.bc.getBox() : this.bg.findActiveBox(this.bc.origin);
                            this.bc.end();
                            ActiveBox bx2 = this.bg.findActiveBox(p);
                            if (bx1 != null && bx2 != null) {
                                String src = bx1.getDescription() + "(" + bx1.idOrder + ")";
                                String dest = "(" + bx2.idLoc + ")";
                                boolean ok = bx1.idOrder == bx2.idLoc;
                                bx1.exchangeLocation(bx2);
                                int cellsAtPlace = this.bg.countCellsAtEquivalentPlace(true);
                                this.ps.reportNewAction(this.getActivity(), "PLACE", src, dest, ok, cellsAtPlace);
                                if (ok && cellsAtPlace == this.bg.getNumCells()) {
                                    this.finishActivity(true);
                                } else {
                                    this.playEvent(ok ? 3 : 2);
                                }
                            }
                            this.repaint();
                            break;
                        }
                        ActiveBox bx1 = this.bg.findActiveBox(p);
                        if (bx1 == null) break;
                        if (ExchangePuzzle.this.dragCells) {
                            this.bc.begin(p, bx1);
                        } else {
                            this.bc.begin(p);
                        }
                        if (bx1.playMedia(this.ps)) break;
                        this.playEvent(1);
                        break;
                    }
                    case 503: 
                    case 506: {
                        this.bc.moveTo(p);
                    }
                }
            }
        }

        @Override
        public void showHelp() {
            if (!ExchangePuzzle.this.helpWindowAllowed() || this.bg == null) {
                return;
            }
            HelpActivityComponent hac = null;
            if (ExchangePuzzle.this.showSolution) {
                hac = new HelpActivityComponent(this){
                    ActiveBoxBag abb;
                    {
                        this.abb = null;
                    }

                    @Override
                    public void render(Graphics2D g2, Rectangle dirtyRegion) {
                        if (this.abb != null) {
                            this.abb.update(g2, dirtyRegion, this);
                        }
                    }

                    @Override
                    public void init() {
                        this.abb = ActiveBoxGrid.createEmptyGrid(null, this, 8.0, 8.0, ExchangePuzzle.this.abc[0]);
                        this.abb.setContent(ExchangePuzzle.this.abc[0]);
                        this.abb.setVisible(true);
                        Dimension size = Panel.this.bg.getBounds().getSize();
                        this.abb.setBounds(8.0, 8.0, size.width, size.height);
                        size.width += 16;
                        size.height += 16;
                        this.setPreferredSize(size);
                        this.setMaximumSize(size);
                        this.setMinimumSize(size);
                        Point p = (Point)this.getClientProperty("prefLoc");
                        if (p != null) {
                            p.translate((int)Panel.this.bg.x - 8, (int)Panel.this.bg.y - 8);
                        }
                    }

                    @Override
                    public void processMouse(MouseEvent e) {
                        ActiveBox bx;
                        if (this.abb != null && (bx = this.abb.findActiveBox(e.getPoint())) != null) {
                            bx.playMedia(Panel.this.ps);
                        }
                    }
                };
                hac.init();
            }
            if (this.ps.showHelp(hac, ExchangePuzzle.this.helpMsg)) {
                this.ps.reportNewAction(this.getActivity(), "HELP", null, null, false, this.bg.countCellsAtEquivalentPlace(true));
            }
            if (hac != null) {
                hac.end();
            }
        }
    }
}

