/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.puzzles;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.HelpActivityComponent;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.automation.ActiveBagContentKit;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.ActiveBoxGrid;
import edu.xtec.jclic.boxes.BoxBag;
import edu.xtec.jclic.boxes.BoxConnector;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.JDomUtility;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jdom.Element;

public class DoublePuzzle
extends Activity
implements ActiveBagContentKit.Compatible {
    public DoublePuzzle(JClicProject project) {
        super(project);
        this.abc = new ActiveBagContent[1];
        this.boxGridPos = 0;
        this.dragCells = true;
    }

    @Override
    public void initNew() {
        super.initNew();
        this.abc[0] = ActiveBagContent.initNew(3, 2, 65);
    }

    @Override
    public Element getJDomElement() {
        if (this.abc[0] == null) {
            return null;
        }
        Element e = super.getJDomElement();
        e.addContent(this.abc[0].getJDomElement());
        Element ex = new Element("scramble");
        ex.setAttribute("times", Integer.toString(this.shuffles));
        e.addContent(ex);
        ex = new Element("layout");
        ex.setAttribute("position", LAYOUT_NAMES[this.boxGridPos]);
        e.addContent(ex);
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        super.setProperties(e, aux);
        Element child = e.getChild("cells");
        if (child != null) {
            this.abc[0] = ActiveBagContent.getActiveBagContent(child, this.project.mediaBag);
        }
        if (this.abc[0] == null) {
            throw new IllegalArgumentException("Puzzle without data!");
        }
        child = e.getChild("scramble");
        if (child != null) {
            this.shuffles = JDomUtility.getIntAttr(child, "times", this.shuffles);
        }
        if ((child = e.getChild("layout")) != null) {
            this.boxGridPos = JDomUtility.getStrIndexAttr(child, "position", LAYOUT_NAMES, this.boxGridPos);
        }
    }

    @Override
    public void setProperties(Clic3Activity c3a) throws Exception {
        super.setProperties(c3a);
        this.abc[0] = c3a.createActiveBagContent(0);
        this.boxGridPos = c3a.graPos;
        this.abc[0].setBoxBase(c3a.getBoxBase(0));
        this.dragCells = true;
    }

    @Override
    public int getMinNumActions() {
        if (this.abc[0] == null) {
            return 0;
        }
        return this.abc[0].getNumCells();
    }

    @Override
    public boolean hasRandom() {
        return true;
    }

    @Override
    public boolean shuffleAlways() {
        return true;
    }

    @Override
    public boolean helpSolutionAllowed() {
        return true;
    }

    @Override
    public Activity.Panel getActivityPanel(PlayStation ps) {
        return new Panel(ps);
    }

    class Panel
    extends Activity.Panel {
        ActiveBoxBag bgA;
        ActiveBoxBag bgB;

        protected Panel(PlayStation ps) {
            super(ps);
            this.bc = new BoxConnector(this);
        }

        @Override
        public void clear() {
            if (this.bgA != null) {
                this.bgA.end();
                this.bgA = null;
            }
            if (this.bgB != null) {
                this.bgB.end();
                this.bgB = null;
            }
        }

        @Override
        public void buildVisualComponents() throws Exception {
            if (this.firstRun) {
                super.buildVisualComponents();
            }
            this.clear();
            if (DoublePuzzle.this.abc[0] != null) {
                if (DoublePuzzle.this.acp != null) {
                    DoublePuzzle.this.acp.generateContent(new ActiveBagContentKit(DoublePuzzle.this.abc[0].nch, DoublePuzzle.this.abc[0].ncw, DoublePuzzle.this.abc, false), this.ps);
                }
                this.bgA = ActiveBoxGrid.createEmptyGrid(null, this, DoublePuzzle.this.margin, DoublePuzzle.this.margin, DoublePuzzle.this.abc[0]);
                this.bgB = ActiveBoxGrid.createEmptyGrid(null, this, DoublePuzzle.this.margin, DoublePuzzle.this.margin, DoublePuzzle.this.abc[0]);
                this.bgA.setContent(DoublePuzzle.this.abc[0]);
                this.bgA.setVisible(true);
                this.bgB.setVisible(true);
                ActiveBox bgbA = this.bgA.getBackgroundActiveBox();
                ActiveBox bgbB = this.bgB.getBackgroundActiveBox();
                if (bgbA != null && bgbB != null) {
                    bgbB.exchangeContent(bgbA);
                }
                this.invalidate();
            }
        }

        @Override
        public void initActivity() throws Exception {
            super.initActivity();
            if (!this.firstRun) {
                this.buildVisualComponents();
            } else {
                this.firstRun = false;
            }
            this.setAndPlayMsg(1, 0);
            if (this.bgA != null && this.bgB != null) {
                this.shuffle(new ActiveBoxBag[]{this.bgA}, true, true);
                if (DoublePuzzle.this.useOrder) {
                    this.currentItem = this.bgA.getNextItem(-1);
                }
                this.playing = true;
            }
        }

        @Override
        public void render(Graphics2D g2, Rectangle dirtyRegion) {
            if (this.bgA != null) {
                this.bgA.update(g2, dirtyRegion, this);
            }
            if (this.bgB != null) {
                this.bgB.update(g2, dirtyRegion, this);
            }
            if (this.bc.active) {
                this.bc.update(g2, dirtyRegion, this);
            }
        }

        @Override
        public Dimension setDimension(Dimension preferredMaxSize) {
            if (this.bgA == null || this.bgB == null || this.getSize().equals(preferredMaxSize)) {
                return preferredMaxSize;
            }
            return BoxBag.layoutDouble(preferredMaxSize, this.bgA, this.bgB, DoublePuzzle.this.boxGridPos, DoublePuzzle.this.margin);
        }

        @Override
        public void processMouse(MouseEvent e) {
            Point p = e.getPoint();
            if (this.playing) {
                switch (e.getID()) {
                    case 501: {
                        this.ps.stopMedia(1);
                        if (this.bc.active) {
                            ActiveBox bx1 = DoublePuzzle.this.dragCells ? this.bc.getBox() : this.bgA.findActiveBox(this.bc.origin);
                            this.bc.end();
                            ActiveBox bx2 = this.bgB.findActiveBox(p);
                            if (bx1 != null && bx2 != null && bx2.isInactive()) {
                                boolean ok = false;
                                String src = bx1.getDescription() + " (" + bx1.idOrder + ")";
                                String dest = "(" + bx2.idOrder + ")";
                                if (bx1.getContent().isEquivalent(DoublePuzzle.this.abc[0].getActiveBoxContent(bx2.idOrder), true)) {
                                    ok = true;
                                    bx1.exchangeContent(bx2);
                                    bx1.setVisible(false);
                                    if (DoublePuzzle.this.useOrder) {
                                        this.currentItem = this.bgA.getNextItem(this.currentItem);
                                    }
                                }
                                int cellsAtPlace = this.bgA.countInactiveCells();
                                this.ps.reportNewAction(DoublePuzzle.this, "PLACE", src, dest, ok, cellsAtPlace);
                                if (ok && cellsAtPlace == this.bgA.getNumCells()) {
                                    this.finishActivity(true);
                                } else {
                                    this.playEvent(ok ? 3 : 2);
                                }
                            }
                            this.repaint();
                            break;
                        }
                        ActiveBox bx1 = this.bgA.findActiveBox(p);
                        if (bx1 == null || bx1.isInactive() || DoublePuzzle.this.useOrder && bx1.idOrder != this.currentItem) break;
                        if (DoublePuzzle.this.dragCells) {
                            this.bc.begin(p, bx1);
                        } else {
                            this.bc.begin(p);
                        }
                        if (bx1.playMedia(this.ps)) break;
                        this.playEvent(1);
                        break;
                    }
                    case 503: 
                    case 506: {
                        this.bc.moveTo(p);
                    }
                }
            }
        }

        @Override
        public void showHelp() {
            if (!DoublePuzzle.this.helpWindowAllowed() || this.bgA == null) {
                return;
            }
            HelpActivityComponent hac = null;
            if (DoublePuzzle.this.showSolution) {
                hac = new HelpActivityComponent(this){
                    ActiveBoxBag abb;
                    {
                        this.abb = null;
                    }

                    @Override
                    public void render(Graphics2D g2, Rectangle dirtyRegion) {
                        if (this.abb != null) {
                            this.abb.update(g2, dirtyRegion, this);
                        }
                    }

                    @Override
                    public void init() {
                        this.abb = ActiveBoxGrid.createEmptyGrid(null, this, 8.0, 8.0, DoublePuzzle.this.abc[0]);
                        this.abb.setContent(DoublePuzzle.this.abc[0]);
                        this.abb.setVisible(true);
                        Dimension size = Panel.this.bgA.getBounds().getSize();
                        this.abb.setBounds(8.0, 8.0, size.width, size.height);
                        size.width += 16;
                        size.height += 16;
                        this.setPreferredSize(size);
                        this.setMaximumSize(size);
                        this.setMinimumSize(size);
                        Point p = (Point)this.getClientProperty("prefLoc");
                        if (p != null) {
                            p.translate((int)Panel.this.bgA.x - 8, (int)Panel.this.bgA.y - 8);
                        }
                    }

                    @Override
                    public void processMouse(MouseEvent e) {
                        if (this.abb != null) {
                            switch (e.getID()) {
                                case 501: {
                                    ActiveBox bx = this.abb.findActiveBox(e.getPoint());
                                    if (bx == null) break;
                                    boolean m = bx.playMedia(Panel.this.ps);
                                    this.markBox(Panel.this.bgB.getActiveBox(bx.idLoc), false);
                                    if (m) break;
                                    Panel.this.playEvent(1);
                                    break;
                                }
                                case 502: {
                                    this.unmarkBox();
                                }
                            }
                        }
                    }
                };
                hac.init();
            }
            if (this.ps.showHelp(hac, DoublePuzzle.this.helpMsg)) {
                this.ps.reportNewAction(this.getActivity(), "HELP", null, null, false, this.bgA.countInactiveCells());
            }
            if (hac != null) {
                hac.end();
            }
        }
    }
}

