/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.panels;

import edu.xtec.jclic.activities.panels.MenuEditor;
import edu.xtec.jclic.activities.panels.MenuElement;
import edu.xtec.jclic.activities.panels.MenuElementEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.util.CustomListCellRenderer;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.SmallButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MenuElementEditorPanel
extends EditorPanel {
    private static List<ImageIcon> standardIcons;
    private List<ImageIcon> icons;
    private JButton btFindIcon;
    private JButton btFindProject;
    private JTextField captionText;
    private JTextField descText;
    private JComboBox<Object> iconCombo;
    private JPanel mainPanel;
    private JTextField projectText;

    public MenuElementEditorPanel(Options options) {
        super(options);
        MenuEditor.createActions(options);
        MenuElementEditor.createActions(options);
        this.buildIconList();
        this.initComponents();
        this.postInit(250, true, true);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        JLabel projectLabel = new JLabel();
        this.projectText = new JTextField();
        this.projectText.getDocument().addDocumentListener(this);
        this.btFindProject = new SmallButton(MenuElementEditor.findProjectAction);
        JLabel iconLabel = new JLabel();
        this.iconCombo = new JComboBox<ImageIcon>(new DefaultComboBoxModel<ImageIcon>(this.icons.toArray(new ImageIcon[this.icons.size()])));
        this.iconCombo.addActionListener(this);
        this.btFindIcon = new SmallButton(MenuElementEditor.findIconAction);
        JLabel captionLabel = new JLabel();
        this.captionText = new JTextField();
        this.captionText.getDocument().addDocumentListener(this);
        JLabel descLabel = new JLabel();
        this.descText = new JTextField();
        this.descText.getDocument().addDocumentListener(this);
        this.setPreferredSize(new Dimension(350, 300));
        this.setLayout(new BorderLayout());
        this.mainPanel.setOpaque(false);
        this.mainPanel.setLayout(new GridBagLayout());
        projectLabel.setText(this.options.getMsg("menuElement_dlg_project"));
        projectLabel.setToolTipText(this.options.getMsg("menuElement_dlg_project_tooltip"));
        projectLabel.setLabelFor(this.projectText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.mainPanel.add((Component)projectLabel, gridBagConstraints);
        this.projectText.setToolTipText(this.options.getMsg("menuElement_dlg_project_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)this.projectText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.mainPanel.add((Component)this.btFindProject, gridBagConstraints);
        iconLabel.setText(this.options.getMsg("menuElement_dlg_icon"));
        iconLabel.setToolTipText(this.options.getMsg("menuElement_dlg_icon_tooltip"));
        iconLabel.setLabelFor(this.iconCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.mainPanel.add((Component)iconLabel, gridBagConstraints);
        this.iconCombo.setToolTipText(this.options.getMsg("menuElement_dlg_icon_tooltip"));
        this.iconCombo.setRenderer(new CustomListCellRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.mainPanel.add(this.iconCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.btFindIcon, gridBagConstraints);
        captionLabel.setText(this.options.getMsg("edit_text"));
        captionLabel.setToolTipText(this.options.getMsg("menuElement_dlg_text_tooltip"));
        captionLabel.setLabelFor(this.captionText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.mainPanel.add((Component)captionLabel, gridBagConstraints);
        this.captionText.setToolTipText(this.options.getMsg("menuElement_dlg_text_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.mainPanel.add((Component)this.captionText, gridBagConstraints);
        descLabel.setText(this.options.getMsg("menuElement_dlg_description"));
        descLabel.setToolTipText(this.options.getMsg("menuElement_dlg_description_tooltip"));
        descLabel.setLabelFor(this.descText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.mainPanel.add((Component)descLabel, gridBagConstraints);
        this.descText.setToolTipText(this.options.getMsg("menuElement_dlg_description_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.mainPanel.add((Component)this.descText, gridBagConstraints);
        this.add((Component)this.mainPanel, "Center");
    }

    @Override
    public boolean checkIfEditorValid(Editor e) {
        return e instanceof MenuElementEditor;
    }

    @Override
    public void fillData() {
        MenuElement me = this.getMenuElement();
        this.captionText.setText(me == null ? "" : me.caption);
        this.projectText.setText(me == null ? "" : me.projectPath);
        this.descText.setText(me == null ? "" : me.description);
        if (this.getMeIcon() != null && !this.icons.contains(this.getMeIcon())) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.iconCombo.getModel();
            model.addElement(this.getMeIcon());
        }
        this.iconCombo.setSelectedItem(this.getMeIcon());
    }

    protected MenuElement getMenuElement() {
        if (this.editor == null) {
            return null;
        }
        return this.getMeEditor().getMenuElement();
    }

    @Override
    public void saveData() {
        MenuElement me = this.getMenuElement();
        if (me != null) {
            me.caption = this.captionText.getText();
            me.projectPath = this.projectText.getText();
            me.description = this.descText.getText();
            this.getMeEditor().meIcon = (ImageIcon)this.iconCombo.getSelectedItem();
            if (this.getMeIcon() != null) {
                me.icon = this.getMeIcon().getDescription();
            }
        }
    }

    @Override
    protected void setEditor(Editor e) {
        super.setEditor(e);
        if (e != null) {
            this.icons = new ArrayList<ImageIcon>(standardIcons);
            this.iconCombo.setModel(new DefaultComboBoxModel<ImageIcon>(this.icons.toArray(new ImageIcon[this.icons.size()])));
        }
    }

    @Override
    protected Icon getIcon() {
        return MenuElementEditor.getIcon();
    }

    protected MenuElementEditor getMeEditor() {
        return (MenuElementEditor)this.editor;
    }

    protected ImageIcon getMeIcon() {
        MenuElementEditor mee = this.getMeEditor();
        return mee == null ? null : mee.meIcon;
    }

    @Override
    protected String getTitle() {
        return this.options.getMsg("menuElement_dlg_title");
    }

    @Override
    protected void addActionsTo(Container cnt) {
        cnt.add(new SmallButton(MenuEditor.newMenuElementAction));
        cnt.add(new SmallButton(MenuEditor.newMenuAction));
        cnt.add(new SmallButton(Editor.moveUpAction));
        cnt.add(new SmallButton(Editor.moveDownAction));
        cnt.add(new SmallButton(Editor.copyAction));
        cnt.add(new SmallButton(Editor.cutAction));
        cnt.add(new SmallButton(Editor.pasteAction));
        cnt.add(new SmallButton(Editor.deleteAction));
    }

    protected void buildIconList() {
        if (standardIcons == null) {
            standardIcons = new ArrayList<ImageIcon>();
            for (int i = 0; i < 4; ++i) {
                String s = "ico0" + i + ".png";
                ImageIcon ii = ResourceManager.getImageIcon("icons/" + s);
                if (ii == null) continue;
                standardIcons.add(ii);
            }
        }
        this.icons = new ArrayList<ImageIcon>(standardIcons);
    }
}

