/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.panels;

import edu.xtec.jclic.activities.panels.MenuEditor;
import edu.xtec.jclic.activities.panels.MenuElement;
import edu.xtec.jclic.activities.panels.MenuElementEditorPanel;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorAction;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.project.ProjectLibrary;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class MenuElementEditor
extends Editor {
    protected static ImageIcon icon;
    protected ImageIcon meIcon;
    protected ProjectLibrary projectLibrary;
    public static EditorAction findProjectAction;
    public static EditorAction findIconAction;
    protected static boolean actionsCreated;

    public MenuElementEditor(MenuElement me) {
        super(me);
    }

    @Override
    protected void createChildren() {
        ProjectLibrary pl = this.getProjectLibrary();
        if (pl != null) {
            this.meIcon = this.getMenuElement().getIcon(pl.mediaBag);
        }
    }

    public MenuElement getMenuElement() {
        return (MenuElement)this.getUserObject();
    }

    public MenuEditor getMenuEditorParent() {
        MenuEditor result = null;
        if (this.getParent() != null && this.getParent() instanceof MenuEditor) {
            result = (MenuEditor)this.getParent();
        }
        return result;
    }

    @Override
    public Class getEditorPanelClass() {
        return MenuElementEditorPanel.class;
    }

    public ProjectLibrary getProjectLibrary() {
        if (this.projectLibrary != null) {
            return this.projectLibrary;
        }
        MenuEditor me = this.getMenuEditorParent();
        if (me != null) {
            this.projectLibrary = me.getProjectLibrary();
        }
        return this.projectLibrary;
    }

    @Override
    public String toString() {
        return this.getMenuElement().caption;
    }

    @Override
    public EditorPanel createEditorPanel(Options options) {
        return new MenuElementEditorPanel(options);
    }

    public static Icon getIcon() {
        if (icon == null) {
            icon = ResourceManager.getImageIcon("icons/miniclic.png");
        }
        return icon;
    }

    @Override
    public Icon getIcon(boolean leaf, boolean expanded) {
        return leaf ? MenuElementEditor.getIcon() : null;
    }

    @Override
    protected boolean canClone() {
        return true;
    }

    @Override
    protected Editor getClone() throws Exception {
        MenuElement me = MenuElement.getMenuElement(this.getMenuElement().getJDomElement());
        MenuElementEditor mee = (MenuElementEditor)me.getEditor(null);
        mee.projectLibrary = this.getProjectLibrary();
        mee.meIcon = this.meIcon;
        return mee;
    }

    @Override
    public void setActionsOwner() {
        this.allowPaste = true;
        this.allowCopy = true;
        this.allowDelete = true;
        this.allowCut = true;
        super.setActionsOwner();
        if (actionsCreated) {
            findProjectAction.setActionOwner(this);
            findIconAction.setActionOwner(this);
            boolean hasParent = this.getMenuEditorParent() != null;
            MenuEditor.newMenuAction.setActionOwner(hasParent ? this : null);
            MenuEditor.newMenuElementAction.setActionOwner(hasParent ? this : null);
        }
    }

    @Override
    public void clearActionsOwner() {
        super.clearActionsOwner();
        if (actionsCreated) {
            findProjectAction.setActionOwner(null);
            findIconAction.setActionOwner(null);
            MenuEditor.newMenuAction.setActionOwner(null);
            MenuEditor.newMenuElementAction.setActionOwner(null);
        }
    }

    protected void syncParentIndex() {
        MenuEditor me = this.getMenuEditorParent();
        if (me != null) {
            me.getMenu().menuElements.remove(this.getMenuElement());
            me.getMenu().menuElements.add(me.getIndex(this), this.getMenuElement());
        }
    }

    @Override
    public boolean moveUp(boolean updateSelection) {
        boolean result = super.moveUp(updateSelection);
        if (result) {
            this.syncParentIndex();
        }
        return result;
    }

    @Override
    public boolean moveDown(boolean updateSelection) {
        boolean result = super.moveDown(updateSelection);
        if (result) {
            this.syncParentIndex();
        }
        return result;
    }

    @Override
    public boolean delete(boolean updateSelection) {
        boolean result = false;
        this.getProjectLibrary();
        MenuEditor me = this.getMenuEditorParent();
        if (me != null && (result = super.delete(updateSelection))) {
            me.getMenu().menuElements.remove(this.getMenuElement());
        }
        return result;
    }

    @Override
    public boolean canBeParentOf(Editor e) {
        return false;
    }

    @Override
    public boolean canBeSiblingOf(Editor e) {
        return e instanceof MenuElementEditor || e instanceof MenuEditor;
    }

    public void findProject(Options options, Component dlgOwner) {
        MenuElement me = this.getMenuElement();
        ProjectLibrary pl = this.getProjectLibrary();
        if (pl != null) {
            int[] filters = new int[]{5, 4};
            String result = pl.getFileSystem().chooseFile(me.projectPath, false, filters, options, "edit_find_file", dlgOwner, false);
            if (result != null) {
                me.projectPath = result;
                this.fireEditorDataChanged(null);
            }
        }
    }

    public void findIcon(Options options, Component dlgOwner) {
        MenuElement me = this.getMenuElement();
        ProjectLibrary pl = this.getProjectLibrary();
        if (pl != null) {
            String result;
            int[] filters = new int[]{11, 8};
            String s = me.icon;
            if (s != null && s.startsWith("@")) {
                s = null;
            }
            if ((result = pl.getFileSystem().chooseFile(s == null ? me.projectPath : s, false, filters, options, "edit_find_image", dlgOwner, false)) != null) {
                ImageIcon ii = null;
                try {
                    ii = new ImageIcon(pl.getFileSystem().getImageFile(result));
                    if (ii.getIconWidth() > 32 || ii.getIconHeight() > 32) {
                        options.getMessages().showAlert(dlgOwner, "menuElement_err_iconTooLarge");
                        ii = null;
                    }
                }
                catch (Exception ex) {
                    System.err.println("Error reading image " + result + "\n" + ex);
                }
                if (ii != null) {
                    me.icon = result;
                    this.meIcon = me.getIcon(pl.mediaBag);
                    this.fireEditorDataChanged(null);
                }
            }
        }
    }

    public static void createActions(Options options) {
        MenuElementEditor.createBasicActions(options);
        if (!actionsCreated) {
            findProjectAction = new EditorAction("edit_find_file", "icons/file_open.gif", "edit_find_file", options){

                @Override
                protected void doAction(Editor e) {
                    if (e instanceof MenuElementEditor) {
                        ((MenuElementEditor)e).findProject(this.options, this.getComponentSrc());
                    }
                }
            };
            findIconAction = new EditorAction("edit_find_image", "icons/file_open.gif", "edit_find_image", options){

                @Override
                protected void doAction(Editor e) {
                    if (e instanceof MenuElementEditor) {
                        ((MenuElementEditor)e).findIcon(this.options, this.getComponentSrc());
                    }
                }
            };
            actionsCreated = true;
        }
    }

    static {
        actionsCreated = false;
    }
}

