/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.panels;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.activities.panels.MenuElement;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.StrUtils;
import edu.xtec.util.VFlowScrollPane;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jdom.Element;

public class Menu
extends Activity
implements Editable {
    protected ArrayList<MenuElement> menuElements;
    public static final int MAX_LABEL_LENGTH = 30;

    public Menu(JClicProject project) {
        super(project);
        this.includeInReports = false;
        this.reportActions = false;
        this.bActionsCounter = false;
        this.bScoreCounter = false;
        this.bTimeCounter = false;
        this.menuElements = new ArrayList();
    }

    @Override
    public String getPublicName() {
        return this.description;
    }

    @Override
    public Element getJDomElement() {
        Element e = super.getJDomElement();
        for (MenuElement el : this.menuElements) {
            e.addContent(el.getJDomElement());
        }
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        super.setProperties(e, aux);
        this.includeInReports = false;
        Iterator it = e.getChildren("menuElement").iterator();
        while (it.hasNext()) {
            this.menuElements.add(MenuElement.getMenuElement((Element)it.next()));
        }
    }

    public int getMenuElementCount() {
        return this.menuElements.size();
    }

    public MenuElement getMenuElement(int n) {
        if (n < 0 || n >= this.menuElements.size()) {
            return null;
        }
        return this.menuElements.get(n);
    }

    public void addMenuElement(MenuElement me) {
        this.menuElements.add(me);
    }

    @Override
    public int getMinNumActions() {
        return 0;
    }

    @Override
    public Editor getEditor(Editor parent) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, parent);
    }

    @Override
    public Activity.Panel getActivityPanel(PlayStation ps) {
        return new Panel(ps);
    }

    class Panel
    extends Activity.Panel
    implements ActionListener {
        VFlowScrollPane scrollPane;
        JPanel panel;

        protected Panel(PlayStation ps) {
            super(ps);
        }

        @Override
        public void buildVisualComponents() throws Exception {
            super.buildVisualComponents();
            this.panel = new JPanel();
            this.panel.setBackground(Menu.this.activityBgColor);
            this.panel.setLayout(new FlowLayout());
            this.scrollPane = new VFlowScrollPane(this.panel);
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.scrollPane.getVerticalScrollBar().setBorder(BorderFactory.createLineBorder(Color.darkGray, 1));
            this.addButtons();
            this.add(this.scrollPane);
        }

        public void addButtons() {
            this.panel.removeAll();
            for (int i = 0; i < Menu.this.menuElements.size(); ++i) {
                MenuElement me = Menu.this.getMenuElement(i);
                JButton button = new JButton();
                button.setIcon(me.getIcon(((Menu)Menu.this).project.mediaBag));
                if (me.caption != null) {
                    button.setText(StrUtils.getShortExpression(me.caption, 30));
                }
                if (me.description != null) {
                    button.setToolTipText(me.description);
                } else if (me.caption != null) {
                    button.setToolTipText(me.caption);
                }
                button.setHorizontalTextPosition(0);
                button.setVerticalTextPosition(3);
                button.setActionCommand(Integer.toString(i));
                button.addActionListener(this);
                this.panel.add(button);
            }
        }

        @Override
        public void doLayout() {
            this.scrollPane.setBounds(0, 0, this.getWidth(), this.getHeight());
        }

        @Override
        public void clear() {
        }

        @Override
        public Dimension setDimension(Dimension maxSize) {
            return maxSize;
        }

        @Override
        public void initActivity() throws Exception {
            super.initActivity();
            if (!this.firstRun) {
                this.buildVisualComponents();
            }
            this.firstRun = false;
            this.setAndPlayMsg(1, 0);
            this.playing = true;
        }

        @Override
        public void render(Graphics2D g2, Rectangle dirtyRegion) {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MenuElement me;
            int i;
            try {
                i = Integer.parseInt(ae.getActionCommand());
            }
            catch (NumberFormatException e) {
                return;
            }
            if (i >= 0 && (me = Menu.this.getMenuElement(i)) != null && (me.projectPath != null || me.sequence != null)) {
                MediaContent mc = new MediaContent();
                if ("@RETURN".equals(me.sequence)) {
                    mc.mediaType = 12;
                } else {
                    mc.mediaType = 8;
                    mc.mediaFileName = me.sequence;
                    mc.externalParam = me.projectPath;
                }
                this.ps.playMedia(mc, null);
            }
        }
    }
}

